/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lpg.runtime.IAst;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferenceValueParser;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferencesService
implements IPreferencesService {
    private IProject project = null;
    private String projectName = null;
    private String languageName = null;
    org.eclipse.core.runtime.preferences.IPreferencesService preferencesService = null;
    IEclipsePreferences preferencesRoot = null;
    private ProjectScope projectScope = null;
    private ConfigurationScope configurationScope = new ConfigurationScope();
    private InstanceScope instanceScope = new InstanceScope();
    private DefaultScope defaultScope = new DefaultScope();
    private static final Map<String, ConstantEvaluator> sConstantMap = new HashMap<String, ConstantEvaluator>();
    private static final Map<String, ParamEvaluator> sParamMap;
    public static final String[] levels;
    private List<IPreferencesService.IProjectSelectionListener> projectSelectionListeners = new ArrayList<IPreferencesService.IProjectSelectionListener>();

    public PreferencesService() {
        this.getPreferencesServiceAndRoot();
    }

    public PreferencesService(String projectName) {
        this();
        this.setProjectName(projectName);
    }

    public PreferencesService(IProject project) {
        this();
        this.setProject(project);
    }

    public PreferencesService(IProject project, String languageName) {
        this(project);
        this.setLanguageName(languageName);
    }

    private void getPreferencesServiceAndRoot() {
        this.preferencesService = Platform.getPreferencesService();
        this.preferencesRoot = this.preferencesService != null ? this.preferencesService.getRootNode() : null;
    }

    private static IProject getProjectFromName(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject(name);
        if (project.exists()) {
            return project;
        }
        return null;
    }

    public void setLanguageName(String languageName) {
        this.languageName = languageName;
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public void setProjectName(String projectName) {
        if (projectName != null && projectName.equals("")) {
            projectName = null;
        }
        this.projectName = projectName;
        this.project = PreferencesService.getProjectFromName(projectName);
        if (this.project != null) {
            ProjectScope oldProjectScope = this.projectScope;
            this.projectScope = new ProjectScope(this.project);
            this.toggleProject(oldProjectScope, this.projectScope, projectName);
        } else {
            this.projectScope = null;
        }
    }

    private void toggleProject(ProjectScope oldProjectScope, ProjectScope newProjectScope, String projectName) {
        IPreferencesService.ProjectSelectionEvent event = null;
        if (projectName == null) {
            event = new IPreferencesService.ProjectSelectionEvent(null, null);
        } else if (oldProjectScope == null && newProjectScope == null) {
            event = new IPreferencesService.ProjectSelectionEvent(null, null);
        } else if (oldProjectScope == null && newProjectScope != null) {
            event = new IPreferencesService.ProjectSelectionEvent(null, (Preferences)newProjectScope.getNode(projectName));
        } else if (oldProjectScope != null && newProjectScope == null) {
            event = new IPreferencesService.ProjectSelectionEvent((Preferences)oldProjectScope.getNode(projectName), null);
        } else if (oldProjectScope != null && newProjectScope != null) {
            event = new IPreferencesService.ProjectSelectionEvent((Preferences)oldProjectScope.getNode(projectName), (Preferences)newProjectScope.getNode(projectName));
        }
        this.fireProjectSelectionEvent(event);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProject(IProject project) {
        ProjectScope oldProjectScope = this.projectScope;
        this.project = project;
        if (project != null) {
            this.projectName = project.getName();
            this.projectScope = new ProjectScope(project);
        } else {
            this.projectName = null;
            this.projectScope = null;
        }
        this.toggleProject(oldProjectScope, this.projectScope, this.projectName);
    }

    public IProject getProject() {
        return this.project;
    }

    public IEclipsePreferences getPreferences(String level) {
        if (level == null) {
            throw new IllegalArgumentException("PreferencesService.getPreferences:  given level is null");
        }
        if (!this.isaPreferencesLevel(level)) {
            throw new IllegalArgumentException("PreferencesService.getPreferences:  given level is not valid (level = " + level);
        }
        IEclipsePreferences preferences = null;
        if (level.equals("project")) {
            if (this.projectScope != null && this.languageName != null) {
                preferences = this.projectScope.getNode(this.languageName);
            }
        } else if (level.equals("instance")) {
            preferences = this.instanceScope.getNode(this.languageName);
        } else if (level.equals("configuration")) {
            preferences = this.configurationScope.getNode(this.languageName);
        } else if (level.equals("default")) {
            preferences = this.defaultScope.getNode(this.languageName);
        }
        return preferences;
    }

    public void setPreferences(String level, IEclipsePreferences newPreferences) {
        if (level == null) {
            throw new IllegalArgumentException("PreferencesService.getPreferences:  given level is null");
        }
        if (!this.isaPreferencesLevel(level)) {
            throw new IllegalArgumentException("PreferencesService.getPreferences:  given level is not valid (level = " + level);
        }
        IEclipsePreferences node = this.clearPreferencesAtLevel(level);
        if (newPreferences == null) {
            return;
        }
        String[] keys = null;
        try {
            keys = newPreferences.keys();
        }
        catch (BackingStoreException e) {
            System.out.println("PreferencesService.setPreferences():  BackingStoreException getting keys; returning (note:  preferences for this node may have been cleared)");
            return;
        }
        for (int i = 0; i < keys.length; ++i) {
            String val = newPreferences.get(keys[i], null);
            node.put(keys[i], val);
        }
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            System.out.println("PreferencesService.setPreferences():  BackingStoreException flushing new preferences; returning (note:  preferences for this node may have been cleared and not set)");
            return;
        }
    }

    private IScopeContext[] specificProjectScope() {
        if (this.projectScope == null) {
            return new IScopeContext[0];
        }
        return new IScopeContext[]{this.getScopeForLevel("project")};
    }

    public boolean getBooleanPreference(String key) {
        return this.preferencesService.getBoolean(this.languageName, key, false, this.specificProjectScope());
    }

    public byte[] getByteArrayPreference(String key) {
        byte[] result = null;
        String[] lookupOrder = this.preferencesService.getLookupOrder(this.languageName, key);
        String[] levels = IPreferencesService.levels;
        block0: for (int i = 0; i < lookupOrder.length; ++i) {
            for (int j = 0; j < levels.length; ++j) {
                IScopeContext context;
                IEclipsePreferences node;
                String level = null;
                if (levels[j].startsWith(lookupOrder[i].toUpperCase()) && (result = (node = (context = this.getScopeForLevel(level = levels[j])).getNode(this.languageName)).getByteArray(key, new byte[0])).length != 0) break block0;
            }
        }
        return result;
    }

    public double getDoublePreference(String key) {
        return this.preferencesService.getDouble(this.languageName, key, 0.0, this.specificProjectScope());
    }

    public float getFloatPreference(String key) {
        return this.preferencesService.getFloat(this.languageName, key, 0.0f, this.specificProjectScope());
    }

    public int getIntPreference(String key) {
        return this.preferencesService.getInt(this.languageName, key, 0, this.specificProjectScope());
    }

    public long getLongPreference(String key) {
        return this.preferencesService.getLong(this.languageName, key, 0L, this.specificProjectScope());
    }

    public String getStringPreference(String key) {
        String result = this.preferencesService.getString(this.languageName, key, null, this.specificProjectScope());
        return this.performSubstitutions(result);
    }

    public String getRawStringPreference(String key) {
        String result = this.preferencesService.getString(this.languageName, key, null, this.specificProjectScope());
        return result;
    }

    public boolean getBooleanPreference(IProject project, String key) {
        return this.preferencesService.getBoolean(this.languageName, key, false, new IScopeContext[]{new ProjectScope(project)});
    }

    public byte[] getByteArrayPreference(IProject project, String key) {
        byte[] result = null;
        String[] lookupOrder = this.preferencesService.getLookupOrder(this.languageName, key);
        String[] levels = IPreferencesService.levels;
        block0: for (int i = 0; i < lookupOrder.length; ++i) {
            for (int j = 0; j < levels.length; ++j) {
                String level = null;
                if (!levels[j].startsWith(lookupOrder[i].toUpperCase())) continue;
                level = levels[j];
                IScopeContext context = null;
                context = level.equals("project") ? this.getScopeForProject(project) : this.getScopeForLevel(level);
                IEclipsePreferences node = context.getNode(this.languageName);
                result = node.getByteArray(key, new byte[0]);
                if (result.length != 0) break block0;
            }
        }
        return result;
    }

    public double getDoublePreference(IProject project, String key) {
        return this.preferencesService.getDouble(this.languageName, key, 0.0, new IScopeContext[]{new ProjectScope(project)});
    }

    public float getFloatPreference(IProject project, String key) {
        return this.preferencesService.getFloat(this.languageName, key, 0.0f, new IScopeContext[]{new ProjectScope(project)});
    }

    public int getIntPreference(IProject project, String key) {
        return this.preferencesService.getInt(this.languageName, key, 0, new IScopeContext[]{new ProjectScope(project)});
    }

    public long getLongPreference(IProject project, String key) {
        return this.preferencesService.getLong(this.languageName, key, 0L, new IScopeContext[]{new ProjectScope(project)});
    }

    public String getRawStringPreference(IProject project, String key) {
        return this.preferencesService.getString(this.languageName, key, null, new IScopeContext[]{new ProjectScope(project)});
    }

    public String getStringPreference(IProject project, String key) {
        String value = this.getRawStringPreference(project, key);
        String result = this.performSubstitutions(value, project);
        return result;
    }

    private static void initializeForTesting() {
        sConstantMap.clear();
        sConstantMap.put("workspaceLoc", new ConstantEvaluator(){

            public String getValue() {
                return "~/eclipse/workspace";
            }
        });
        sConstantMap.put("os", new ConstantEvaluator(){

            public String getValue() {
                return "macosx";
            }
        });
        sConstantMap.put("arch", new ConstantEvaluator(){

            public String getValue() {
                return "x86";
            }
        });
        sConstantMap.put("nl", new ConstantEvaluator(){

            public String getValue() {
                return "enUS";
            }
        });
        sConstantMap.put("ws", new ConstantEvaluator(){

            public String getValue() {
                return "mac";
            }
        });
        sParamMap.clear();
        sParamMap.put("pluginLoc", new ParamEvaluator(){

            public String getValue(String pluginID) {
                return "/System/Library/eclipse-3.3.2/plugins/" + pluginID;
            }
        });
        sParamMap.put("pluginResource", new ParamEvaluator(){

            public String getValue(String pluginResourceLoc) {
                int idx = pluginResourceLoc.indexOf(47);
                if (idx <= 0) {
                    return "<error in pluginResource specification: no plugin ID found: " + pluginResourceLoc + ">";
                }
                String pluginID = pluginResourceLoc.substring(0, idx);
                String resourcePath = pluginResourceLoc.substring(idx + 1);
                return "/System/Library/eclipse-3.3.2/plugins/" + pluginID + "/" + resourcePath;
            }
        });
        sParamMap.put("pluginVersion", new ParamEvaluator(){

            public String getValue(String pluginID) {
                return "1.0.0";
            }
        });
        sParamMap.put("projectLoc", new ParamEvaluator(){

            public String getValue(String projectName) {
                return "~/eclipse/workspace/" + projectName;
            }
        });
    }

    public static void main(String[] args) {
        PreferencesService.initializeForTesting();
        PreferencesService svc = new PreferencesService();
        String[][] testPairs = new String[][]{{"foo", "foo"}, {"${os}", "macosx"}, {"foo-${os}", "foo-macosx"}, {"${os}-bar", "macosx-bar"}, {"foo-${os}-bar", "foo-macosx-bar"}, {"${os}-${arch}", "macosx-x86"}, {"${os}${arch}", "macosxx86"}, {"${projectLoc:foo}", "~/eclipse/workspace/foo"}, {"${pluginResource:lpg.runtime/templates}", "/System/Library/eclipse-3.3.2/plugins/lpg.runtime/templates"}, {"${pluginResource:lpg.runtime/lpgexe/lpg-${os}_${arch}.exe}", "/System/Library/eclipse-3.3.2/plugins/lpg.runtime/lpgexe/lpg-macosx_x86.exe"}, {"\\$", "$"}, {"\\$abc", "$abc"}, {"\\$\\$", "$$"}, {"\\${blah\\}", "${blah}"}, {"\\a", "a"}, {"\\a\\b", "ab"}, {"\\a-\\b", "a-b"}, {"${blah", "Invalid preference: '${blah': unexpected end of string"}, {"$blah}", "Invalid preference: '$blah}': unexpected character 'b' at offset 1"}, {"${}", "Invalid preference: '${}': unexpected character '}' at offset 2"}, {"$", "Invalid preference: '$': unexpected end of string"}};
        int failedCount = 0;
        for (int i = 0; i < testPairs.length; ++i) {
            String input = testPairs[i][0];
            String expectedOutput = testPairs[i][1];
            String result = svc.performSubstitutions(input);
            System.out.println("Input  = '" + input + "'");
            System.out.println("Result = '" + result + "'");
            if (!expectedOutput.equals(result)) {
                System.err.println("Test failed: expected output '" + expectedOutput + "'!");
                ++failedCount;
            } else {
                System.out.println("Test passed.");
            }
            System.out.println();
        }
        if (failedCount > 0) {
            System.err.println("" + failedCount + " tests failed.");
        }
    }

    public String performSubstitutions(String value) {
        return this.performSubstitutions(value, null);
    }

    public String performSubstitutions(final String value, final IProject project) {
        if (value == null || value.length() == 0) {
            return value;
        }
        PreferenceValueParser parser = new PreferenceValueParser();
        PreferenceValueParser.ASTNode ast = parser.parser(value);
        if (ast == null) {
            return "Invalid preference: '" + value + "': " + parser.getErrorMessage();
        }
        final HashMap valueMap = new HashMap();
        ast.accept(new PreferenceValueParser.AbstractVisitor(){

            public void postVisit(IAst node) {
                if (node instanceof PreferenceValueParser.escapedChar) {
                    PreferenceValueParser.escapedChar ch = (PreferenceValueParser.escapedChar)node;
                    String nodeStr = this.nodeString(ch);
                    if (nodeStr.charAt(1) == '$') {
                        valueMap.put(node, nodeStr.substring(1));
                    } else {
                        valueMap.put(node, nodeStr);
                    }
                } else if (node instanceof PreferenceValueParser.simpleStringPrefixed) {
                    PreferenceValueParser.simpleStringPrefixed strPref = (PreferenceValueParser.simpleStringPrefixed)node;
                    String valString = this.nodeString((PreferenceValueParser.ASTNode)((Object)strPref.getvalStringNoSubst()));
                    valString = valString.replaceAll("\\\\\\$", "$").replace("\\\\}", "}");
                    if (strPref.getsubstPrefixed() != null) {
                        String result = valString + (String)valueMap.get(strPref.getsubstPrefixed());
                        valueMap.put(node, result);
                    } else {
                        valueMap.put(node, valString);
                    }
                } else if (node instanceof PreferenceValueParser.substPrefixed) {
                    PreferenceValueParser.substPrefixed subPref = (PreferenceValueParser.substPrefixed)node;
                    if (subPref.getsimpleStringPrefixed() != null) {
                        String result = (String)valueMap.get(subPref.getsubstitutionList()) + (String)valueMap.get(subPref.getsimpleStringPrefixed());
                        valueMap.put(node, result);
                    } else {
                        valueMap.put(node, valueMap.get(subPref.getsubstitutionList()));
                    }
                } else if (node instanceof PreferenceValueParser.substitutionList) {
                    PreferenceValueParser.substitutionList subList = (PreferenceValueParser.substitutionList)node;
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < subList.size(); ++i) {
                        sb.append((String)valueMap.get(subList.getsubstitutionAt(i)));
                    }
                    valueMap.put(node, sb.toString());
                } else if (node instanceof PreferenceValueParser.substitution) {
                    PreferenceValueParser.substitution sub = (PreferenceValueParser.substitution)node;
                    String id = this.nodeString(sub.getident());
                    PreferenceValueParser.optParameter parm = sub.getoptParameter();
                    if (parm != null) {
                        ParamEvaluator e = (ParamEvaluator)sParamMap.get(id);
                        String parmStr = (String)valueMap.get(parm.getvalue());
                        String parmVal = e != null ? e.getValue(parmStr) : "<no such preference: " + id + ">";
                        valueMap.put(node, parmVal);
                    } else if (sConstantMap.containsKey(id)) {
                        String constVal = ((ConstantEvaluator)sConstantMap.get(id)).getValue();
                        valueMap.put(node, constVal);
                    } else {
                        String refVal = project != null ? PreferencesService.this.getStringPreference(project, id) : PreferencesService.this.getStringPreference(id);
                        valueMap.put(node, refVal);
                    }
                }
            }

            public boolean preVisit(IAst element) {
                return true;
            }

            private String nodeString(PreferenceValueParser.ASTNode node) {
                return value.substring(node.leftIToken.getStartOffset(), node.rightIToken.getEndOffset() + 1);
            }

            public void unimplementedVisitor(String s) {
            }
        });
        String result = (String)valueMap.get(ast);
        return result;
    }

    public boolean getBooleanPreference(String level, String key) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        boolean result = node.getBoolean(key, false);
        return result;
    }

    public byte[] getByteArrayPreference(String level, String key) {
        IScopeContext context = this.getScopeForLevel(level);
        IEclipsePreferences node = context.getNode(this.languageName);
        byte[] result = node.getByteArray(key, new byte[0]);
        return result;
    }

    public double getDoublePreference(String level, String key) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        double result = node.getDouble(key, 0.0);
        return result;
    }

    public float getFloatPreference(String level, String key) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        float result = node.getFloat(key, 0.0f);
        return result;
    }

    public int getIntPreference(String level, String key) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        int result = node.getInt(key, 0);
        return result;
    }

    public long getLongPreference(String level, String key) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        long result = node.getLong(key, 0L);
        return result;
    }

    public String getStringPreference(String level, String key) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        String result = node.get(key, null);
        return this.performSubstitutions(result);
    }

    public String getRawStringPreference(String level, String key) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        String result = node.get(key, null);
        return result;
    }

    public boolean getBooleanPreferenceForProject(IProject project, String key) {
        IScopeContext scope = this.getScopeForProject(project);
        IEclipsePreferences node = scope.getNode(this.languageName);
        boolean result = node.getBoolean(key, false);
        return result;
    }

    public byte[] getByteArrayPreferenceForProject(IProject project, String key) {
        IScopeContext scope = this.getScopeForProject(project);
        IEclipsePreferences node = scope.getNode(this.languageName);
        byte[] result = node.getByteArray(key, new byte[0]);
        return result;
    }

    public double getDoublePreferenceForProject(IProject project, String key) {
        IScopeContext scope = this.getScopeForProject(project);
        IEclipsePreferences node = scope.getNode(this.languageName);
        double result = node.getDouble(key, 0.0);
        return result;
    }

    public float getFloatPreferenceForProject(IProject project, String key) {
        IScopeContext scope = this.getScopeForProject(project);
        IEclipsePreferences node = scope.getNode(this.languageName);
        float result = node.getFloat(key, 0.0f);
        return result;
    }

    public int getIntPreferenceForProject(IProject project, String key) {
        IScopeContext scope = this.getScopeForProject(project);
        IEclipsePreferences node = scope.getNode(this.languageName);
        int result = node.getInt(key, 0);
        return result;
    }

    public long getLongPreferenceForProject(IProject project, String key) {
        IScopeContext scope = this.getScopeForProject(project);
        IEclipsePreferences node = scope.getNode(this.languageName);
        long result = node.getLong(key, 0L);
        return result;
    }

    public String getStringPreferenceForProject(IProject project, String key) {
        IScopeContext scope = this.getScopeForProject(project);
        IEclipsePreferences node = scope.getNode(this.languageName);
        String result = node.get(key, null);
        return this.performSubstitutions(result, project);
    }

    public String getRawStringPreferenceForProject(IProject project, String key) {
        IScopeContext scope = this.getScopeForProject(project);
        IEclipsePreferences node = scope.getNode(this.languageName);
        String result = node.get(key, null);
        return result;
    }

    public void setBooleanPreference(String level, String key, boolean value) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        node.putBoolean(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            System.out.println("PreferencesService.setByteArrayPreference(String, String, boolean):  BackingStoreException");
            System.out.println("\tlevel = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setByteArrayPreference(String level, String key, byte[] value) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        node.putByteArray(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            System.out.println("PreferencesService.setByteArrayPreference(String, String, byte[]):  BackingStoreException");
            System.out.println("\tlevel = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setDoublePreference(String level, String key, double value) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        node.putDouble(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            System.out.println("PreferencesService.setDoublePreference(String, String, double):  BackingStoreException");
            System.out.println("\tlevel = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setFloatPreference(String level, String key, float value) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        node.putFloat(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            System.out.println("PreferencesService.setFloatPreference(String, String, float):  BackingStoreException");
            System.out.println("\tlevel = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setIntPreference(String level, String key, int value) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        node.putInt(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            System.out.println("PreferencesService.setIntPreference(String, String, int):  BackingStoreException");
            System.out.println("\tlevel = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setLongPreference(String level, String key, long value) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        node.putLong(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            System.out.println("PreferencesService.set\tLongPreference(String, String, long):  BackingStoreException");
            System.out.println("\tlevel = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setStringPreference(String level, String key, String value) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        node.put(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            System.out.println("PreferencesService.setStringPreference(String, String, String):  BackingStoreException");
            System.out.println("\tlevel = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public boolean getBooleanPreference(String languageName, String projectName, String level, String key, boolean def) {
        IEclipsePreferences node = this.getNodeForParameters("getBooleanPreference", languageName, level, projectName, key);
        return node.getBoolean(key, def);
    }

    public byte[] getByteArrayPreference(String languageName, String projectName, String level, String key, byte[] def) {
        IEclipsePreferences node = this.getNodeForParameters("getByteArrayPreference", languageName, level, projectName, key);
        return node.getByteArray(key, def);
    }

    public double getDoublePreference(String languageName, String projectName, String level, String key, double def) {
        IEclipsePreferences node = this.getNodeForParameters("getDoublePreference", languageName, level, projectName, key);
        return node.getDouble(key, def);
    }

    public float getFloatPreference(String languageName, String projectName, String level, String key, float def) {
        IEclipsePreferences node = this.getNodeForParameters("getFloatPreference", languageName, level, projectName, key);
        return node.getFloat(key, def);
    }

    public int getIntPreference(String languageName, String projectName, String level, String key, int def) {
        IEclipsePreferences node = this.getNodeForParameters("getIntPreference", languageName, level, projectName, key);
        return node.getInt(key, def);
    }

    public long getLongPreference(String languageName, String projectName, String level, String key, long def) {
        IEclipsePreferences node = this.getNodeForParameters("getLongPreference", languageName, level, projectName, key);
        return node.getLong(key, def);
    }

    public String getStringPreference(String languageName, String projectName, String level, String key, String def) {
        IEclipsePreferences node = this.getNodeForParameters("getStringPreference", languageName, level, projectName, key);
        return this.performSubstitutions(node.get(key, def), PreferencesService.getProjectFromName(projectName));
    }

    public String getRawStringPreference(String languageName, String projectName, String level, String key, String def) {
        IEclipsePreferences node = this.getNodeForParameters("getRawStringPreference", languageName, level, projectName, key);
        return node.get(key, def);
    }

    public void setBooleanPreference(String languageName, String projectName, String level, String key, boolean value) {
        IEclipsePreferences node = this.getNodeForParameters("setBooleanPreference", languageName, level, projectName, key);
        node.putBoolean(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            System.out.println("PreferencesService.setBooleanPreference(String, String, String, String, boolean):  BackingStoreException");
            System.out.println("\tlanguage = " + languageName + "; project = " + projectName + "; level = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setByteArrayPreference(String languageName, String projectName, String level, String key, byte[] value) {
        IEclipsePreferences node = this.getNodeForParameters("setByteArrayPreference", languageName, level, projectName, key);
        node.putByteArray(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            System.out.println("PreferencesService.setByteArrayPreference(String, String, String, String, byte[]):  BackingStoreException");
            System.out.println("\tlanguage = " + languageName + "; project = " + projectName + "; level = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setDoublePreference(String languageName, String projectName, String level, String key, double value) {
        IEclipsePreferences node = this.getNodeForParameters("setDoublePreference", languageName, level, projectName, key);
        node.putDouble(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            System.out.println("PreferencesService.setDoublePreference(String, String, String, String, double):  BackingStoreException");
            System.out.println("\tlanguage = " + languageName + "; project = " + projectName + "; level = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setFloatPreference(String languageName, String projectName, String level, String key, float value) {
        IEclipsePreferences node = this.getNodeForParameters("setFloatPreference", languageName, level, projectName, key);
        node.putFloat(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            System.out.println("PreferencesService.setFloatPreference(String, String, String, String, float):  BackingStoreException");
            System.out.println("\tlanguage = " + languageName + "; project = " + projectName + "; level = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setIntPreference(String languageName, String projectName, String level, String key, int value) {
        IEclipsePreferences node = this.getNodeForParameters("setIntPreference", languageName, level, projectName, key);
        node.putInt(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            System.out.println("PreferencesService.setIntPreference(String, String, String, String, int):  BackingStoreException");
            System.out.println("\tlanguage = " + languageName + "; project = " + projectName + "; level = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setLongPreference(String languageName, String projectName, String level, String key, long value) {
        IEclipsePreferences node = this.getNodeForParameters("setLongPreference", languageName, level, projectName, key);
        node.putLong(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            System.out.println("PreferencesService.setLongPreference(String, String, String, String, long):  BackingStoreException");
            System.out.println("\tlanguage = " + languageName + "; project = " + projectName + "; level = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setStringPreference(String languageName, String projectName, String level, String key, String value) {
        IEclipsePreferences node = this.getNodeForParameters("setStringPreference", languageName, level, projectName, key);
        node.put(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            System.out.println("PreferencesService.setStringPreference(String, String, String, String, String):  BackingStoreException");
            System.out.println("\tlanguage = " + languageName + "; project = " + projectName + "; level = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public IScopeContext getPreferencesScope(String level, IProject proj) {
        if (level.equals("configuration")) {
            return this.configurationScope;
        }
        if (level.equals("instance")) {
            return this.instanceScope;
        }
        if (level.equals("default")) {
            return this.defaultScope;
        }
        if (level.equals("project")) {
            return new ProjectScope(proj);
        }
        return null;
    }

    public void validateParameters(String methodName, String languageName, String level, String projectName, String key) {
        if (!this.isaPreferencesLevel(level)) {
            throw new IllegalArgumentException("PreferencesService." + methodName + ":  given level is not a valid preferences level:  " + level);
        }
        if (languageName == null || languageName.equals("")) {
            throw new IllegalArgumentException("PreferencesService." + methodName + ":  given language name is null or empty");
        }
        if (level.equals("project")) {
            if (projectName == null || projectName.equals("")) {
                throw new IllegalArgumentException("PreferencesService." + methodName + ":  level is 'project' but project name is null or empty");
            }
            IProject proj = PreferencesService.getProjectFromName(projectName);
            if (proj == null) {
                throw new IllegalArgumentException("PreferencesService." + methodName + ":  level is 'project' but project name '" + projectName + "' does not denote an existing project");
            }
        }
        if (key == null || key.equals("")) {
            throw new IllegalArgumentException("PreferencesService.setStringPreference:  key is null or empty");
        }
    }

    public IEclipsePreferences getNodeForParameters(String methodName, String languageName, String level, String projectName, String key) {
        this.validateParameters(methodName, languageName, level, projectName, key);
        IProject proj = PreferencesService.getProjectFromName(projectName);
        IScopeContext scope = this.getPreferencesScope(level, proj);
        if (scope == null) {
            throw new IllegalStateException("PreferencesService." + methodName + ":  unable to obtain valid preferences scope");
        }
        IEclipsePreferences node = scope.getNode(languageName);
        if (node == null) {
            throw new IllegalStateException("PreferencesService." + methodName + ":  unable to obtain valid preferences node");
        }
        return node;
    }

    public IEclipsePreferences clearPreferencesAtLevel(String level) {
        return this.clearPreferencesAtLevel(this.project, level);
    }

    public IEclipsePreferences clearPreferencesAtLevel(IProject project, String level) {
        if (level == null) {
            throw new IllegalArgumentException("PreferencesService.clearPreferencesAtLevel (with project):  given level is null");
        }
        if (!this.isaPreferencesLevel(level)) {
            throw new IllegalArgumentException("PreferencesService.clearPreferencesAtLevel (with project):  given level '" + level + "' is not a valid level");
        }
        if (project == null && level.equals("project")) {
            return null;
        }
        IEclipsePreferences node = null;
        try {
            if (level.equals("project") && this.projectScope != null) {
                node = this.projectScope.getNode(this.languageName);
            } else if (level.equals("instance")) {
                node = this.instanceScope.getNode(this.languageName);
            } else if (level.equals("configuration")) {
                node = this.configurationScope.getNode(this.languageName);
            } else if (level.equals("default")) {
                node = this.defaultScope.getNode(this.languageName);
            }
            if (node != null) {
                String[] keys = node.keys();
                for (int i = 0; i < keys.length; ++i) {
                    node.remove(keys[i]);
                }
                node.flush();
            }
        }
        catch (BackingStoreException e) {
            System.out.println("PreferencesService.setPreferences():  BackingStoreException clearing existing preferences; attempting to add new preferences anyway");
        }
        return node;
    }

    public String clearPreferenceAtLevel(String level, String key) {
        return this.clearPreferenceAtLevel(this.project, level, key);
    }

    public String clearPreferenceAtLevel(IProject project, String level, String key) {
        if (level == null) {
            throw new IllegalArgumentException("PreferencesService.clearPreferenceAtLevel (with project):  given level is null");
        }
        if (!this.isaPreferencesLevel(level)) {
            throw new IllegalArgumentException("PreferencesService.clearPreferenceAtLevel (with project):  given level '" + level + "' is not a valid level");
        }
        if (project == null && level.equals("project")) {
            throw new IllegalStateException("PreferencesService.clearPreferenceAtLevel (with project): given project is null when given level is 'project'");
        }
        IScopeContext context = null;
        context = level.equals("project") ? this.getScopeForProject(project) : this.getScopeForLevel(level);
        IEclipsePreferences node = context.getNode(this.languageName);
        if (node == null) {
            return null;
        }
        String preference = node.get(key, null);
        node.remove(key);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            System.err.println("PreferencesService.clearPreferenceAtLevel(..):  BackingStoreException trying to flush node with cleared preference;\n\tproject = " + project + "; level = " + level + "; key = " + key + "\n" + "\tclearing may not have a persistent effect");
        }
        return preference;
    }

    public int indexForLevel(String levelName) {
        for (int i = 0; i < levels.length; ++i) {
            if (!levels[i].equals(levelName)) continue;
            return i;
        }
        return -1;
    }

    public String getApplicableLevel(String key, String level) {
        return this.getApplicableLevel(this.project, key, level);
    }

    public String getApplicableLevel(IProject project, String key, String level) {
        int startIndex;
        if (level != null && !this.isaPreferencesLevel(level)) {
            throw new IllegalArgumentException("PreferencesService.getApplicableLevel (with project):  given level '" + level + "' is not a real level");
        }
        if (key == null) {
            throw new IllegalArgumentException("PreferencesService.getApplicableLevel (with project):  given key is null");
        }
        if (level != null && level.equals("project") && this.projectScope == null) {
            throw new IllegalStateException("PreferencesService.getApplicableLevel (with project):  node for project requested when project scope is null");
        }
        int n = level == null ? (project != null ? 0 : 1) : (startIndex = this.getIndexForLevel(level));
        if (startIndex == 0) {
            String[] keys;
            IScopeContext context = this.getScopeForProject(project);
            IEclipsePreferences node = context.getNode(this.languageName);
            try {
                keys = node.keys();
            }
            catch (BackingStoreException e) {
                keys = new String[]{};
            }
            for (int i = 0; i < keys.length; ++i) {
                if (!keys[i].equals(key)) continue;
                return "project";
            }
            ++startIndex;
        }
        for (int i = startIndex; i < levels.length; ++i) {
            String pref = this.getStringPreference(levels[i], key);
            if (pref == null) continue;
            return levels[i];
        }
        return null;
    }

    public boolean isDefault(String key, String level) {
        return this.isDefault(this.project, key, level);
    }

    public boolean isDefault(IProject project, String key, String level) {
        return "default".equals(this.getApplicableLevel(project, key, level));
    }

    public boolean isDefined(String key) {
        return this.isDefined(this.project, key);
    }

    public boolean isDefined(IProject project, String key) {
        return this.getApplicableLevel(project, key, null) != null;
    }

    public boolean isaPreferencesLevel(String possibleLevel) {
        for (int i = 0; i < levels.length; ++i) {
            if (!levels[i].equals(possibleLevel)) continue;
            return true;
        }
        return false;
    }

    public IEclipsePreferences getRootNode() {
        return this.preferencesService.getRootNode();
    }

    public IEclipsePreferences getNodeForLevel(String level) {
        if (level == null) {
            throw new IllegalArgumentException("PreferencesService.getNodeForLevel:  given level is null");
        }
        if (!this.isaPreferencesLevel(level)) {
            throw new IllegalArgumentException("PreferencesService.getNodeForLevel:  given level '" + level + "' is not a real level");
        }
        if (level.equals("project") && this.projectScope == null) {
            throw new IllegalStateException("PreferencesService.getNodeForLevel:  node for project requested when project scope is null");
        }
        IEclipsePreferences node = null;
        if (level.equals("project")) {
            node = this.projectScope.getNode(this.languageName);
        } else if (level.equals("instance")) {
            node = this.instanceScope.getNode(this.languageName);
        } else if (level.equals("configuration")) {
            node = this.configurationScope.getNode(this.languageName);
        } else if (level.equals("default")) {
            node = this.defaultScope.getNode(this.languageName);
        }
        return node;
    }

    public IEclipsePreferences[] getNodesForLevels() {
        if (this.languageName == null || this.languageName.equals("")) {
            throw new IllegalStateException("PreferencesService.getNodesForLevels:  language name is invalid (null or empty); no associated preferences nodes");
        }
        IEclipsePreferences[] nodes = new IEclipsePreferences[]{this.projectScope != null ? this.projectScope.getNode(this.languageName) : null, this.instanceScope.getNode(this.languageName), this.configurationScope.getNode(this.languageName), this.defaultScope.getNode(this.languageName)};
        return nodes;
    }

    public IScopeContext getScopeForLevel(String level) {
        if (!this.isaPreferencesLevel(level)) {
            throw new IllegalArgumentException("PreferencesService.getScopeForLevel:  level = '" + level + "' is not a valid level");
        }
        IScopeContext result = null;
        if (level.equals("project")) {
            if (this.projectScope == null) {
                return null;
            }
            return this.projectScope;
        }
        if (level.equals("instance")) {
            return this.instanceScope;
        }
        if (level.equals("configuration")) {
            return this.configurationScope;
        }
        if (level.equals("default")) {
            return this.defaultScope;
        }
        return result;
    }

    public IScopeContext getScopeForProject(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException("PreferencesService.getScopeForProject:  given project is null");
        }
        return new ProjectScope(project);
    }

    public IEclipsePreferences[] getNodesForLevels(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException("PreferencesService.getNodesForLevels:  given project is null");
        }
        IEclipsePreferences[] nodes = new IEclipsePreferences[]{new ProjectScope(project).getNode(this.languageName), this.instanceScope.getNode(this.languageName), this.configurationScope.getNode(this.languageName), this.defaultScope.getNode(this.languageName)};
        return nodes;
    }

    public IEclipsePreferences getNodeForProject(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException("PreferencesService.getNodeForProject:  given project is null");
        }
        return new ProjectScope(project).getNode(this.languageName);
    }

    public int getIndexForLevel(String level) {
        if (level == null) {
            return 0;
        }
        if (!this.isaPreferencesLevel(level)) {
            throw new IllegalArgumentException("PreferencesService.getIndexForLevel:  level = '" + level + "' is not a valid level");
        }
        if (level.equals("project")) {
            return 0;
        }
        if (level.equals("instance")) {
            return 1;
        }
        if (level.equals("configuration")) {
            return 2;
        }
        if (level.equals("default")) {
            return 3;
        }
        throw new IllegalStateException("PreferencesService.getIndexForLevel:  found no index to return for level = " + level);
    }

    public void addProjectSelectionListener(IPreferencesService.IProjectSelectionListener listener) {
        this.projectSelectionListeners.add(listener);
    }

    public void removeProjectSelectionListener(IPreferencesService.IProjectSelectionListener listener) {
        this.projectSelectionListeners.remove(listener);
    }

    protected void fireProjectSelectionEvent(final IPreferencesService.ProjectSelectionEvent event) {
        if (this.projectSelectionListeners == null || this.projectSelectionListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.projectSelectionListeners.size(); ++i) {
            final IPreferencesService.IProjectSelectionListener listener = this.projectSelectionListeners.get(i);
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.selection(event);
                }
            };
            Platform.run((ISafeRunnable)job);
        }
    }

    static {
        sConstantMap.put("workspaceLoc", new ConstantEvaluator(){

            public String getValue() {
                return ResourcesPlugin.getWorkspace().getRoot().getLocation().toPortableString();
            }
        });
        sConstantMap.put("os", new ConstantEvaluator(){

            public String getValue() {
                return Platform.getOS();
            }
        });
        sConstantMap.put("arch", new ConstantEvaluator(){

            public String getValue() {
                return Platform.getOSArch();
            }
        });
        sConstantMap.put("nl", new ConstantEvaluator(){

            public String getValue() {
                return Platform.getNL();
            }
        });
        sConstantMap.put("ws", new ConstantEvaluator(){

            public String getValue() {
                return Platform.getWS();
            }
        });
        sParamMap = new HashMap<String, ParamEvaluator>();
        sParamMap.put("pluginLoc", new ParamEvaluator(){

            public String getValue(String pluginID) {
                Bundle bundle = Platform.getBundle((String)pluginID);
                if (bundle == null) {
                    return "<no such plugin: " + pluginID + ">";
                }
                try {
                    String bundleLoc = FileLocator.toFileURL((URL)bundle.getEntry("")).getFile();
                    return bundleLoc;
                }
                catch (IOException e) {
                    return "<error determining location of plugin: " + pluginID + ">";
                }
            }
        });
        sParamMap.put("pluginResource", new ParamEvaluator(){

            public String getValue(String pluginResourceLoc) {
                int idx = pluginResourceLoc.indexOf(47);
                if (idx <= 0) {
                    return "<error in pluginResource specification: no plugin ID found: " + pluginResourceLoc + ">";
                }
                String pluginID = pluginResourceLoc.substring(0, idx);
                String resourcePath = pluginResourceLoc.substring(idx + 1);
                Bundle bundle = Platform.getBundle((String)pluginID);
                if (bundle == null) {
                    return "<no such plugin: " + pluginID + ">";
                }
                try {
                    Bundle[] fragments;
                    URL resourceEntry = bundle.getEntry(resourcePath);
                    if (resourceEntry == null && (fragments = Platform.getFragments((Bundle)bundle)) != null) {
                        Bundle bundleFrag;
                        for (int i = 0; i < fragments.length && (resourceEntry = (bundleFrag = fragments[i]).getEntry(resourcePath)) == null; ++i) {
                        }
                    }
                    if (resourceEntry == null) {
                        return "<error: no resource '" + resourcePath + "' in plugin " + pluginID + " or its fragments>";
                    }
                    String resourceLoc = FileLocator.toFileURL((URL)resourceEntry).getFile();
                    resourceLoc = new Path(resourceLoc).toPortableString();
                    return resourceLoc;
                }
                catch (IOException e) {
                    return "<error determining location of plugin: " + pluginID + ">";
                }
            }
        });
        sParamMap.put("pluginVersion", new ParamEvaluator(){

            public String getValue(String pluginID) {
                Bundle bundle = Platform.getBundle((String)pluginID);
                if (bundle == null) {
                    return "<no such plugin: " + pluginID + ">";
                }
                return (String)bundle.getHeaders().get("Bundle-Version");
            }
        });
        sParamMap.put("projectLoc", new ParamEvaluator(){

            public String getValue(String projectName) {
                IProject project = PreferencesService.getProjectFromName(projectName);
                if (project == null) {
                    return "<no such project: " + projectName + ">";
                }
                return project.getLocation().toPortableString();
            }
        });
        levels = new String[]{"project", "instance", "configuration", "default"};
    }

    private static interface ParamEvaluator {
        public String getValue(String var1);
    }

    private static interface ConstantEvaluator {
        public String getValue();
    }
}

