/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences.fields;

import java.io.File;
import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferencesTab;
import org.eclipse.imp.preferences.fields.FileFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;

public class DirectoryFieldEditor
extends FileFieldEditor {
    public DirectoryFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, int width, int strategy, Composite parent) {
        super(page, tab, service, level, name, labelText, width, strategy, parent);
    }

    public DirectoryFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, int width, Composite parent) {
        super(page, tab, service, level, name, labelText, width, parent);
    }

    public DirectoryFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, Composite parent) {
        super(page, tab, service, level, name, labelText, parent);
    }

    protected File getFile(File startingDirectory) {
        String dir;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
        if (startingDirectory != null) {
            dialog.setFilterPath(startingDirectory.getPath());
        }
        if ((dir = dialog.open()) != null && (dir = dir.trim()).length() > 0) {
            return new File(dir);
        }
        return null;
    }

    protected boolean doCheckState(String path) {
        String msg = null;
        if (this.emptyStringAllowed && path == null || path.length() == 0) {
            this.clearErrorMessage();
            return true;
        }
        File file = new File(path);
        boolean result = true;
        if (file.isDirectory()) {
            if (this.getEnforceAbsolute() && !file.isAbsolute()) {
                msg = JFaceResources.getString((String)"FileFieldEditor.errorMessage2");
            }
        } else {
            msg = "Path does not designate a valid directory";
        }
        if (msg != null) {
            this.setErrorMessage(this.getFieldMessagePrefix() + msg);
            result = false;
        } else {
            this.clearErrorMessage();
            result = true;
        }
        return result;
    }
}

