/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.WorkbenchMessages;

public class ListSelectionDialog
extends SelectionDialog {
    private Object inputElement;
    private ILabelProvider labelProvider;
    private IStructuredContentProvider contentProvider;
    CheckboxTableViewer listViewer;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    static String SELECT_ALL_TITLE = WorkbenchMessages.SelectionDialog_selectLabel;
    static String DESELECT_ALL_TITLE = WorkbenchMessages.SelectionDialog_deselectLabel;
    List<ISelectionValidator> validators = new ArrayList<ISelectionValidator>();
    List<ViewerFilter> filters = new ArrayList<ViewerFilter>();
    Label statusMessage;
    String errorMsg = null;

    public ListSelectionDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, String message) {
        super(parentShell);
        this.setTitle(WorkbenchMessages.ListSelection_title);
        this.inputElement = input;
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
        if (message != null) {
            this.setMessage(message);
        } else {
            this.setMessage(WorkbenchMessages.ListSelection_message);
        }
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(0x1000008, 128, true, false));
        Button selectButton = this.createButton(buttonComposite, 18, SELECT_ALL_TITLE, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListSelectionDialog.this.listViewer.setAllChecked(true);
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, 19, DESELECT_ALL_TITLE, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListSelectionDialog.this.listViewer.setAllChecked(false);
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    private void checkInitialSelections() {
        Iterator itemsToCheck = this.getInitialElementSelections().iterator();
        while (itemsToCheck.hasNext()) {
            this.listViewer.setChecked(itemsToCheck.next(), true);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.list_selection_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        this.createMessageArea(composite);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.listViewer.setContentProvider((IContentProvider)this.contentProvider);
        for (int i = 0; i < this.filters.size(); ++i) {
            this.listViewer.addFilter(this.filters.get(i));
        }
        this.addSelectionButtons(composite);
        this.initializeViewer();
        if (!this.getInitialElementSelections().isEmpty()) {
            this.checkInitialSelections();
        }
        Dialog.applyDialogFont((Control)composite);
        this.statusMessage = new Label(parent, 0);
        this.statusMessage.setLayoutData((Object)new GridData(768));
        this.statusMessage.setFont(parent.getFont());
        this.listViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ListSelectionDialog.this.validate();
            }
        });
        return composite;
    }

    protected CheckboxTableViewer getViewer() {
        return this.listViewer;
    }

    private void initializeViewer() {
        this.listViewer.setInput(this.inputElement);
    }

    protected void okPressed() {
        Object[] children = this.contentProvider.getElements(this.inputElement);
        if (children != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < children.length; ++i) {
                Object element = children[i];
                if (!this.listViewer.getChecked(element)) continue;
                list.add(element);
            }
            this.setResult(list);
        }
        this.validate();
        super.okPressed();
    }

    public void setValidator(ISelectionValidator validator) {
        this.validators = new ArrayList<ISelectionValidator>();
        if (validator != null) {
            this.validators.add(validator);
        }
    }

    public void addValdator(ISelectionValidator validator) {
        if (this.validators == null) {
            this.validators = new ArrayList<ISelectionValidator>();
        }
        this.validators.add(validator);
    }

    public void validate() {
        String errorMsg = null;
        boolean gotError = false;
        Object[] selections = null;
        selections = this.listViewer.getCheckedElements();
        block0: for (int j = 0; j < selections.length; ++j) {
            for (int i = 0; i < this.validators.size(); ++i) {
                errorMsg = this.validators.get(i).isValid(selections[j]);
                if (errorMsg == null || errorMsg.length() <= 0) continue;
                gotError = true;
                break block0;
            }
        }
        if (gotError) {
            this.statusMessage.setForeground(JFaceColors.getErrorText((Display)this.statusMessage.getDisplay()));
            this.statusMessage.setText(errorMsg);
            this.getOkButton().setEnabled(false);
        } else {
            this.statusMessage.setText("");
            errorMsg = null;
            this.getOkButton().setEnabled(true);
        }
    }

    public void addFilter(ViewerFilter filter) {
        this.filters.add(filter);
    }
}

