/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.ui.explorer;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.imp.model.ISourceFolder;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class OutputFolderFilter
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof ISourceFolder) {
            element = ((ISourceFolder)element).getResource();
        }
        if (element instanceof IFolder) {
            IFolder folder = (IFolder)element;
            IProject proj = folder.getProject();
            try {
                if (!proj.hasNature("org.eclipse.jdt.core.javanature")) {
                    return true;
                }
                IJavaProject jProject = JavaCore.create((IProject)folder.getProject());
                if (jProject == null || !jProject.exists()) {
                    return true;
                }
                IPath defaultOutputLocation = jProject.getOutputLocation();
                IPath folderPath = folder.getFullPath();
                if (defaultOutputLocation != null && defaultOutputLocation.equals(folderPath)) {
                    return false;
                }
                IClasspathEntry[] cpEntries = jProject.getRawClasspath();
                int length = cpEntries.length;
                for (int i = 0; i < length; ++i) {
                    IPath outputLocation = cpEntries[i].getOutputLocation();
                    if (outputLocation == null || !outputLocation.equals(folderPath)) continue;
                    return false;
                }
            }
            catch (CoreException ex) {
                return true;
            }
        }
        return true;
    }
}

