/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;

public class ExtensionUtils {
    public static IPluginModel getPluginModel(IProject project) {
        try {
            if (project == null) {
                return null;
            }
            IFile pluginXML = project.getFile("plugin.xml");
            if (!pluginXML.exists()) {
                return null;
            }
            return ExtensionUtils.getPluginModelForProject(project);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IPluginModel getPluginModelForProject(IProject project) {
        PluginModelManager pmm = PDECore.getDefault().getModelManager();
        IPluginModelBase[] wsPlugins = pmm.getWorkspaceModels();
        if (wsPlugins.length == 0) {
            return null;
        }
        for (int i = 0; i < wsPlugins.length; ++i) {
            String resourceLocation;
            String projName;
            String id;
            IPluginModelBase wsPlugin = wsPlugins[i];
            IPluginBase pmBase = wsPlugin.getPluginBase();
            if (pmBase == null || (id = pmBase.getId()) == null || (projName = project.getName()) == null || !(resourceLocation = pmBase.getModel().getUnderlyingResource().getLocation().toString()).endsWith(projName + "/META-INF/MANIFEST.MF")) continue;
            return (IPluginModel)wsPlugin;
        }
        return null;
    }
}

