/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.utils;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.imp.runtime.RuntimePlugin;

public class MarkerUtils {
    private MarkerUtils() {
    }

    public static int getMaxProblemMarkerSeverity(IResource res, int depth) {
        if (res == null || !res.isAccessible()) {
            return 0;
        }
        boolean hasWarnings = false;
        IMarker[] markers = null;
        try {
            markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, depth);
        }
        catch (CoreException e) {
            RuntimePlugin.getInstance().logException("Error obtaining markers on resource " + res.getName(), e);
        }
        if (markers == null) {
            return 0;
        }
        for (int i = 0; i < markers.length; ++i) {
            IMarker m = markers[i];
            int priority = m.getAttribute("severity", -1);
            if (priority == 1) {
                hasWarnings = true;
                continue;
            }
            if (priority != 2) continue;
            return 2;
        }
        return hasWarnings ? 1 : 0;
    }
}

