/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.imp.builder.ProjectNatureBase;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.wizards.NewProjectWizardFirstPage;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.wizards.ClassPathDetector;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NewProjectWizardSecondPage
extends JavaCapabilityConfigurationPage {
    private static final String FILENAME_PROJECT = ".project";
    private static final String FILENAME_CLASSPATH = ".classpath";
    private final NewProjectWizardFirstPage fFirstPage;
    private URI fCurrProjectLocation;
    private IProject fCurrProject;
    private boolean fKeepContent;
    private File fDotProjectBackup;
    private File fDotClasspathBackup;
    private Boolean fIsAutobuild = null;

    protected abstract ProjectNatureBase getProjectNature();

    protected IClasspathEntry createLanguageRuntimeEntry() {
        return null;
    }

    protected List<IClasspathEntry> createLanguageRuntimeEntries() {
        IClasspathEntry uniqueEntry = this.createLanguageRuntimeEntry();
        if (uniqueEntry != null) {
            return Arrays.asList(uniqueEntry);
        }
        return Collections.emptyList();
    }

    public NewProjectWizardSecondPage(NewProjectWizardFirstPage firstPage) {
        this.fFirstPage = firstPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performFinish(IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            monitor.beginTask("Creating project...", 3);
            if (this.fCurrProject == null) {
                this.updateProject((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(monitor, 2));
            String compliance = this.fFirstPage.getJRECompliance();
            if (compliance != null) {
                IJavaProject project = JavaCore.create((IProject)this.fCurrProject);
                Map options = project.getOptions(false);
                NewProjectWizardSecondPage.setComplianceOptions(options, compliance);
                project.setOptions(options);
            }
        }
        finally {
            monitor.done();
            this.fCurrProject = null;
            if (this.fIsAutobuild != null) {
                NewProjectWizardSecondPage.enableAutoBuild(this.fIsAutobuild);
                this.fIsAutobuild = null;
            }
        }
    }

    public static void setComplianceOptions(Map<String, String> map, String compliance) {
        if ("1.6".equals(compliance)) {
            map.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
            map.put("org.eclipse.jdt.core.compiler.source", "1.6");
            map.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
            map.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "error");
            map.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", "error");
        } else if ("1.5".equals(compliance)) {
            map.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
            map.put("org.eclipse.jdt.core.compiler.source", "1.5");
            map.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
            map.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "error");
            map.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", "error");
        } else if ("1.4".equals(compliance)) {
            map.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
            map.put("org.eclipse.jdt.core.compiler.source", "1.3");
            map.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
            map.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "warning");
            map.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", "warning");
        } else if ("1.3".equals(compliance)) {
            map.put("org.eclipse.jdt.core.compiler.compliance", "1.3");
            map.put("org.eclipse.jdt.core.compiler.source", "1.3");
            map.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
            map.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "ignore");
            map.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", "ignore");
        } else {
            throw new IllegalArgumentException("Unsupported compliance: " + compliance);
        }
    }

    public static boolean enableAutoBuild(boolean state) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        boolean isAutoBuilding = desc.isAutoBuilding();
        if (isAutoBuilding != state) {
            desc.setAutoBuilding(state);
            workspace.setDescription(desc);
        }
        return isAutoBuilding;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            IStatus status = this.changeToNewProject();
            if (status != null && !status.isOK()) {
                ErrorDialog.openError((Shell)this.getShell(), (String)"New Java Project", null, (IStatus)status);
            }
        } else {
            this.removeProject();
        }
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    private IStatus changeToNewProject() {
        this.fKeepContent = this.fFirstPage.getDetect();
        class UpdateRunnable
        implements IRunnableWithProgress {
            public IStatus infoStatus = Status.OK_STATUS;

            UpdateRunnable() {
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    if (NewProjectWizardSecondPage.this.fIsAutobuild == null) {
                        NewProjectWizardSecondPage.this.fIsAutobuild = NewProjectWizardSecondPage.enableAutoBuild(false);
                    }
                    this.infoStatus = NewProjectWizardSecondPage.this.updateProject(monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                catch (OperationCanceledException e) {
                    throw new InterruptedException();
                }
                finally {
                    monitor.done();
                }
            }
        }
        UpdateRunnable op = new UpdateRunnable();
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)op));
            return op.infoStatus;
        }
        catch (InvocationTargetException e) {
            String title = "New Java Project";
            String message = "An error occurred while creating project. Check log for details.";
            this.perform(e, this.getShell(), "New Java Project", "An error occurred while creating project. Check log for details.");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    protected void perform(CoreException e, Shell shell, String title, String message) {
        RuntimePlugin.getInstance().logException(message, e);
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
        } else {
            this.displayMessageDialog(e, e.getMessage(), shell, title, message);
        }
    }

    protected void perform(InvocationTargetException e, Shell shell, String title, String message) {
        Throwable target = e.getTargetException();
        if (target instanceof CoreException) {
            this.perform((CoreException)target, shell, title, message);
        } else {
            RuntimePlugin.getInstance().logException(message, e);
            if (e.getMessage() != null && e.getMessage().length() > 0) {
                this.displayMessageDialog(e, e.getMessage(), shell, title, message);
            } else {
                this.displayMessageDialog(e, target.getMessage(), shell, title, message);
            }
        }
    }

    private void displayMessageDialog(Throwable t, String exceptionMessage, Shell shell, String title, String message) {
        StringWriter msg = new StringWriter();
        if (message != null) {
            msg.write(message);
            msg.write("\n\n");
        }
        if (exceptionMessage == null || exceptionMessage.length() == 0) {
            msg.write("See the Error Log for more details.");
        } else {
            msg.write(exceptionMessage);
        }
        MessageDialog.openError((Shell)shell, (String)title, (String)msg.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final IStatus updateProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        Status result = new Status(0, "org.eclipse.imp.runtime", "Ok");
        this.fCurrProject = this.fFirstPage.getProjectHandle();
        this.fCurrProjectLocation = this.getProjectLocationURI();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("Initializing project...", 7);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            URI realLocation = this.fCurrProjectLocation;
            if (this.fCurrProjectLocation == null) {
                try {
                    URI rootLocation = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
                    realLocation = new URI(rootLocation.getScheme(), null, Path.fromPortableString((String)rootLocation.getPath()).append(this.fCurrProject.getName()).toString(), null);
                }
                catch (URISyntaxException e) {
                    Assert.isTrue((boolean)false, (String)"Can't happen");
                }
            }
            this.rememberExistingFiles(realLocation);
            try {
                NewProjectWizardSecondPage.createProject((IProject)this.fCurrProject, (URI)this.fCurrProjectLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 567) {
                    result = new Status(1, "org.eclipse.imp.runtime", MessageFormat.format("A problem occurred while creating the project from existing source:\n\n''{0}''\n\nThe corrupt project file will be replaced by a valid one.", e.getLocalizedMessage()));
                    this.deleteProjectFile(realLocation);
                    if (this.fCurrProject.exists()) {
                        this.fCurrProject.delete(true, null);
                    }
                    NewProjectWizardSecondPage.createProject((IProject)this.fCurrProject, (URI)this.fCurrProjectLocation, null);
                }
                throw e;
            }
            IClasspathEntry[] entries = null;
            IPath outputLocation = null;
            if (this.fFirstPage.getDetect()) {
                if (!this.fCurrProject.getFile(FILENAME_CLASSPATH).exists()) {
                    ClassPathDetector detector = new ClassPathDetector(this.fCurrProject, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    entries = detector.getClasspath();
                    outputLocation = detector.getOutputLocation();
                } else {
                    monitor.worked(2);
                }
            } else if (this.fFirstPage.isSrcBin()) {
                IFolder folder;
                IPreferenceStore store = PreferenceConstants.getPreferenceStore();
                Path srcPath = new Path(store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName"));
                Path binPath = new Path(store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"));
                if (srcPath.segmentCount() > 0) {
                    folder = this.fCurrProject.getFolder((IPath)srcPath);
                    NewProjectWizardSecondPage.createFolder(folder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                if (binPath.segmentCount() > 0 && !binPath.equals(srcPath)) {
                    folder = this.fCurrProject.getFolder((IPath)binPath);
                    NewProjectWizardSecondPage.createDerivedFolder(folder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                IPath projectPath = this.fCurrProject.getFullPath();
                ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
                cpEntries.add(JavaCore.newSourceEntry((IPath)projectPath.append((IPath)srcPath)));
                cpEntries.addAll(Arrays.asList(this.getDefaultClasspathEntry()));
                entries = cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
                outputLocation = projectPath.append((IPath)binPath);
            } else {
                IPath projectPath = this.fCurrProject.getFullPath();
                ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
                cpEntries.add(JavaCore.newSourceEntry((IPath)projectPath));
                cpEntries.addAll(Arrays.asList(this.getDefaultClasspathEntry()));
                entries = cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
                outputLocation = projectPath;
                monitor.worked(2);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.init(JavaCore.create((IProject)this.fCurrProject), outputLocation, entries, false);
            this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(monitor, 3));
            this.getProjectNature().addToProject(this.fCurrProject);
        }
        finally {
            monitor.done();
        }
        return result;
    }

    public static void createFolder(IFolder folder, boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                NewProjectWizardSecondPage.createFolder((IFolder)parent, force, local, null);
            }
            folder.create(force, local, monitor);
        }
    }

    public static void createDerivedFolder(IFolder folder, boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                NewProjectWizardSecondPage.createDerivedFolder((IFolder)parent, force, local, null);
            }
            folder.create(force ? 1025 : 1024, local, monitor);
        }
    }

    private URI getProjectLocationURI() throws CoreException {
        if (this.fFirstPage.isInWorkspace()) {
            return null;
        }
        return URIUtil.toURI((IPath)this.fFirstPage.getLocationPath());
    }

    private void deleteProjectFile(URI projectLocation) throws CoreException {
        IFileStore projectFile;
        IFileStore file = EFS.getStore((URI)projectLocation);
        if (file.fetchInfo().exists() && (projectFile = file.getChild(FILENAME_PROJECT)).fetchInfo().exists()) {
            projectFile.delete(0, null);
        }
    }

    private void rememberExistingFiles(URI projectLocation) throws CoreException {
        this.fDotProjectBackup = null;
        this.fDotClasspathBackup = null;
        IFileStore file = EFS.getStore((URI)projectLocation);
        if (file.fetchInfo().exists()) {
            IFileStore classpathFile;
            IFileStore projectFile = file.getChild(FILENAME_PROJECT);
            if (projectFile.fetchInfo().exists()) {
                this.fDotProjectBackup = this.createBackup(projectFile, "project-desc");
            }
            if ((classpathFile = file.getChild(FILENAME_CLASSPATH)).fetchInfo().exists()) {
                this.fDotClasspathBackup = this.createBackup(classpathFile, "classpath-desc");
            }
        }
    }

    private void restoreExistingFiles(URI projectLocation, IProgressMonitor monitor) throws CoreException {
        int ticks = ((this.fDotProjectBackup != null ? 1 : 0) + (this.fDotClasspathBackup != null ? 1 : 0)) * 2;
        monitor.beginTask("", ticks);
        try {
            IFileStore projectFile = EFS.getStore((URI)projectLocation).getChild(FILENAME_PROJECT);
            projectFile.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (this.fDotProjectBackup != null) {
                this.copyFile(this.fDotProjectBackup, projectFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 4, "Problem while restoring backup for .project", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        try {
            IFileStore classpathFile = EFS.getStore((URI)projectLocation).getChild(FILENAME_CLASSPATH);
            classpathFile.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (this.fDotClasspathBackup != null) {
                this.copyFile(this.fDotClasspathBackup, classpathFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 4, "Problem while restoring backup for .classpath", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private File createBackup(IFileStore source, String name) throws CoreException {
        try {
            File bak = File.createTempFile("eclipse-" + name, ".bak");
            this.copyFile(source, bak);
            return bak;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 4, MessageFormat.format("Problem while creating backup for ''{0}''", name), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void copyFile(IFileStore source, File target) throws IOException, CoreException {
        InputStream is = source.openInputStream(0, null);
        FileOutputStream os = new FileOutputStream(target);
        this.copyFile(is, os);
    }

    private void copyFile(File source, IFileStore target, IProgressMonitor monitor) throws IOException, CoreException {
        FileInputStream is = new FileInputStream(source);
        OutputStream os = target.openOutputStream(0, monitor);
        this.copyFile(is, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(InputStream is, OutputStream os) throws IOException {
        try {
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        finally {
            try {
                is.close();
            }
            finally {
                os.close();
            }
        }
    }

    private IClasspathEntry[] getDefaultClasspathEntry() {
        ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
        List<IClasspathEntry> langRuntimeCPEs = this.createLanguageRuntimeEntries();
        if (langRuntimeCPEs != null) {
            cpEntries.addAll(langRuntimeCPEs);
        }
        String compliance = this.fFirstPage.getJRECompliance();
        IVMInstall inst = this.findMatchingJREInstall(compliance);
        Path jreContainerPath = new Path(JavaRuntime.JRE_CONTAINER);
        if (inst != null) {
            IPath newPath = jreContainerPath.append(inst.getVMInstallType().getId()).append(inst.getName());
            IClasspathEntry jreCPE = JavaCore.newContainerEntry((IPath)newPath);
            cpEntries.add(jreCPE);
        } else {
            IClasspathEntry[] defaultJRELibrary = PreferenceConstants.getDefaultJRELibrary();
            for (int i = 0; i < defaultJRELibrary.length; ++i) {
                cpEntries.add(defaultJRELibrary[i]);
            }
        }
        return cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
    }

    private IVMInstall findMatchingJREInstall(String compliance) {
        IVMInstallType vmInstallType = JavaRuntime.getVMInstallTypes()[0];
        IVMInstall[] vmInstalls = vmInstallType.getVMInstalls();
        for (int i = 0; i < vmInstalls.length; ++i) {
            IVMInstall2 vmInstall2;
            String vmVers;
            if (!(vmInstalls[i] instanceof IVMInstall2) || !(vmVers = (vmInstall2 = (IVMInstall2)vmInstalls[i]).getJavaVersion()).startsWith(compliance)) continue;
            return vmInstalls[i];
        }
        return null;
    }

    private void removeProject() {
        if (this.fCurrProject == null || !this.fCurrProject.exists()) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                NewProjectWizardSecondPage.this.doRemoveProject(monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
        }
        catch (InvocationTargetException e) {
            String title = "Error Creating Java Project";
            String message = "An error occurred while removing a temporary project.";
            this.perform(e, this.getShell(), "Error Creating Java Project", "An error occurred while removing a temporary project.");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void doRemoveProject(IProgressMonitor monitor) throws InvocationTargetException {
        boolean noProgressMonitor;
        boolean bl = noProgressMonitor = this.fCurrProjectLocation == null;
        if (monitor == null || noProgressMonitor) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Removing project...", 3);
        try {
            try {
                URI projLoc = this.fCurrProject.getLocationURI();
                boolean removeContent = !this.fKeepContent && this.fCurrProject.isSynchronized(2);
                this.fCurrProject.delete(removeContent, false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                this.restoreExistingFiles(projLoc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            finally {
                NewProjectWizardSecondPage.enableAutoBuild(this.fIsAutobuild);
                this.fIsAutobuild = null;
            }
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        finally {
            monitor.done();
            this.fCurrProject = null;
            this.fKeepContent = false;
        }
    }

    protected void openResource(final IFile resource) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Display display;
                final IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (activePage != null && (display = NewProjectWizardSecondPage.this.getShell().getDisplay()) != null) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            try {
                                IDE.openEditor((IWorkbenchPage)activePage, (IFile)resource, (boolean)true);
                            }
                            catch (PartInitException e) {
                                RuntimePlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.imp.runtime", "Error opening editor on newly-created source file", (Throwable)e));
                            }
                        }
                    });
                }
            }
        });
    }
}

