/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.smapi;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.imp.smapi.LineElem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineMapBuilder {
    private static String LINE_INFO_COMMENT_PREFIX = "//#line ";
    private String fFileName;
    private List<LineElem> fLineElems;
    private Map<Integer, LineElem> fLineMap;

    public LineMapBuilder(String filename) {
        this.fFileName = filename;
        this.build();
    }

    public List<LineElem> get() {
        return this.fLineElems;
    }

    public Map<Integer, LineElem> getLineMap() {
        return this.fLineMap;
    }

    private void build() {
        this.fLineElems = new ArrayList<LineElem>();
        this.fLineMap = new HashMap<Integer, LineElem>();
        try {
            LineElem le;
            LineNumberReader ln = new LineNumberReader(new FileReader(this.fFileName + ".java"));
            String line = null;
            int origSrcLine = -1;
            int javaStart = -1;
            int javaEnd = -1;
            while ((line = ln.readLine()) != null) {
                if (line.startsWith(LINE_INFO_COMMENT_PREFIX)) {
                    if (origSrcLine != -1) {
                        le = new LineElem(origSrcLine, javaStart, javaEnd - javaStart);
                        this.fLineElems.add(le);
                        this.fLineMap.put(new Integer(origSrcLine), le);
                    }
                    origSrcLine = LineMapBuilder.getNumber(line);
                    javaEnd = javaStart = ln.getLineNumber() + 1;
                    continue;
                }
                if (origSrcLine == -1) continue;
                ++javaEnd;
            }
            if (origSrcLine != -1) {
                le = new LineElem(origSrcLine, javaStart, javaEnd - javaStart);
                this.fLineElems.add(le);
                this.fLineMap.put(new Integer(origSrcLine), le);
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private static int getNumber(String line) {
        String[] lines = line.split(LINE_INFO_COMMENT_PREFIX);
        return Integer.parseInt(lines[1]);
    }
}

