/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.smapi;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.imp.smapi.LineElem;

public class LineMapBuilder {
    static String LINE = "//#line ";
    String filename;
    ArrayList<LineElem> arraylist;
    Map<Integer, LineElem> map;

    public LineMapBuilder(String filename) {
        this.filename = filename;
        this.build();
    }

    public ArrayList get() {
        return this.arraylist;
    }

    public Map getLineMap() {
        return this.map;
    }

    private void build() {
        this.arraylist = new ArrayList();
        this.map = new HashMap<Integer, LineElem>();
        try {
            LineElem le;
            LineNumberReader ln = new LineNumberReader(new FileReader(this.filename + ".java"));
            String line = null;
            int origSrcLine = -1;
            int javaStart = -1;
            int javaEnd = -1;
            while ((line = ln.readLine()) != null) {
                if (line.startsWith(LINE)) {
                    if (origSrcLine != -1) {
                        le = new LineElem(origSrcLine, javaStart, javaEnd - javaStart);
                        this.arraylist.add(le);
                        this.map.put(new Integer(origSrcLine), le);
                    }
                    origSrcLine = LineMapBuilder.getNumber(line);
                    javaEnd = javaStart = ln.getLineNumber() + 1;
                    continue;
                }
                if (origSrcLine == -1) continue;
                ++javaEnd;
            }
            if (origSrcLine != -1) {
                le = new LineElem(origSrcLine, javaStart, javaEnd - javaStart);
                this.arraylist.add(le);
                this.map.put(new Integer(origSrcLine), le);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private static int getNumber(String line) {
        String[] lines = line.split(LINE);
        return Integer.parseInt(lines[1]);
    }
}

