/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.smapi;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.imp.smapi.LineElem;

public class SmapBuilder {
    public static String get(String filename, String pathPrefix, ArrayList elems, String fileExten) {
        String name = filename;
        boolean path = false;
        if (filename.indexOf("/") != -1) {
            name = filename.substring(filename.lastIndexOf("/") + 1);
            if (pathPrefix != null) {
                filename = filename.substring(pathPrefix.length() + 1);
            }
            filename = SmapBuilder.replaceAll(filename, File.separator);
            path = true;
        }
        String info = "SMAP\n";
        info = info + name + ".java\n";
        info = info + fileExten + "\n";
        info = info + "*S " + fileExten + "\n";
        info = info + "*F\n";
        if (path) {
            info = info + "+ ";
        }
        info = info + "1 " + name + "." + fileExten + "\n";
        if (path) {
            info = info + filename + "." + fileExten + "\n";
        }
        info = info + "*L\n";
        for (LineElem elem : elems) {
            info = info + elem.getOrigSrcStart() + "#1:" + elem.getJavaStart() + "," + elem.getIncr() + "\n";
        }
        info = info + "*E\n";
        return info;
    }

    static String replaceAll(String filename, String sep) {
        String ret = "";
        String[] names = filename.split("/");
        for (int i = 0; i < names.length; ++i) {
            ret = i == 0 ? names[0] : ret + sep + names[i];
        }
        return ret;
    }
}

