/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.smapifier.builder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.java.hosted.debug.BreakpointUtils;
import org.eclipse.imp.smapi.Main;
import org.eclipse.imp.smapifier.SmapiePlugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmapieBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.imp.smapifier.SmapieBuilder";
    private IProject fProject;
    private IJavaProject fJavaProject;
    private String fPathPrefix;
    private final DeltaVisitor fDeltaVisitor = new DeltaVisitor();
    private final ResourceVisitor fResourceVisitor = new ResourceVisitor();
    private IProgressMonitor fMonitor;
    private String fFileExten = "x10";

    public String getOrigExten() {
        return this.fFileExten;
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IResourceDelta delta;
        this.fProject = this.getProject();
        this.fJavaProject = JavaCore.create((IProject)this.fProject);
        this.fMonitor = monitor;
        this.fPathPrefix = this.fProject.getWorkspace().getRoot().getRawLocation() + this.fProject.getFullPath().toString();
        if (args.get("exten") != null) {
            this.fFileExten = (String)args.get("exten");
        }
        if ((delta = this.getDelta(this.fProject)) != null) {
            delta.accept((IResourceDeltaVisitor)this.fDeltaVisitor);
        } else {
            this.fProject.accept((IResourceVisitor)this.fResourceVisitor);
        }
        IProject[] ret = new IProject[]{this.fProject};
        this.refresh();
        return ret;
    }

    protected boolean processResource(IResource resource) {
        if (resource instanceof IFile) {
            IFile maybeSrcFile = (IFile)resource;
            if (!this.isSourceFile(maybeSrcFile)) {
                return false;
            }
            String srcFileLoc = maybeSrcFile.getRawLocation().toString();
            Set<IFile> classFiles = this.getClassFiles(maybeSrcFile);
            BreakpointUtils.resetJavaBreakpoints((IFile)maybeSrcFile);
            for (IFile classFile : classFiles) {
                Main.smapify((String)srcFileLoc, (String)this.fPathPrefix, (String)classFile.getRawLocation().toString());
            }
        }
        return true;
    }

    private boolean isSourceFile(IFile file) {
        String fileExten = file.getFileExtension();
        return fileExten != null && fileExten.equals(this.fFileExten);
    }

    private Set<IFile> getClassFiles(IFile srcFile) {
        IPath parentPath = srcFile.getParent().getFullPath();
        HashSet<IFile> ret = new HashSet<IFile>();
        try {
            IClasspathEntry[] entries = this.fJavaProject.getResolvedClasspath(true);
            for (int i = 0; i < entries.length; ++i) {
                IPath parentSrcPath;
                IPath parentFullPath;
                IResource parent;
                if (entries[i].getEntryKind() != 3 || srcFile.getFullPath().matchingFirstSegments(entries[i].getPath()) != entries[i].getPath().segmentCount()) continue;
                IPath out = entries[i].getOutputLocation();
                if (out == null) {
                    out = this.fJavaProject.getOutputLocation().removeFirstSegments(1);
                }
                if ((parent = this.fProject.findMember(parentFullPath = out.append(parentSrcPath = parentPath.removeFirstSegments(entries[i].getPath().segmentCount())))) == null) continue;
                IResource[] members = ((IContainer)parent).members();
                for (int j = 0; j < members.length; ++j) {
                    String name = members[j].getName();
                    if (!(members[j] instanceof IFile) || !this.classBelongsTo(srcFile, name)) continue;
                    ret.add((IFile)members[j]);
                }
            }
        }
        catch (JavaModelException e) {
            SmapiePlugin.getInstance().logException(e.getMessage(), e);
        }
        catch (CoreException e) {
            SmapiePlugin.getInstance().logException(e.getMessage(), e);
        }
        return ret;
    }

    private boolean classBelongsTo(IFile srcFile, String otherFileName) {
        if (!otherFileName.endsWith(".class")) {
            return false;
        }
        otherFileName = otherFileName.substring(0, otherFileName.indexOf("."));
        String fileName = srcFile.getFullPath().removeFileExtension().lastSegment();
        if (fileName.equals(otherFileName)) {
            return true;
        }
        return otherFileName.startsWith(fileName) && otherFileName.indexOf("$") == fileName.length();
    }

    protected boolean isBinaryFolder(IResource resource) {
        try {
            boolean projectIsSrcBin;
            IPath projPath = this.fProject.getFullPath();
            boolean bl = projectIsSrcBin = this.fJavaProject.getOutputLocation().matchingFirstSegments(projPath) == projPath.segmentCount();
            if (projectIsSrcBin) {
                return false;
            }
            IPath resourcePath = resource.getFullPath();
            if (resourcePath.equals(this.fJavaProject.getOutputLocation())) {
                return true;
            }
            IClasspathEntry[] cp = this.fJavaProject.getResolvedClasspath(true);
            for (int i = 0; i < cp.length; ++i) {
                if (cp[i].getEntryKind() != 3 || !resourcePath.equals(cp[i].getOutputLocation())) continue;
                return true;
            }
        }
        catch (JavaModelException e) {
            SmapiePlugin.getInstance().logException(e.getMessage(), e);
        }
        return false;
    }

    private void refresh() throws CoreException {
        for (IPath pathEntry : this.getProjectSrcPath()) {
            if (pathEntry.segmentCount() == 1) {
                this.fProject.refreshLocal(2, this.fMonitor);
                continue;
            }
            this.fProject.getWorkspace().getRoot().getFolder(pathEntry).refreshLocal(2, this.fMonitor);
        }
    }

    private List<IPath> getProjectSrcPath() throws JavaModelException {
        ArrayList<IPath> srcPath = new ArrayList<IPath>();
        IClasspathEntry[] classPath = this.fJavaProject.getResolvedClasspath(true);
        for (int i = 0; i < classPath.length; ++i) {
            IClasspathEntry e = classPath[i];
            if (e.getEntryKind() != 3) continue;
            srcPath.add(e.getPath());
        }
        if (srcPath.size() == 0) {
            srcPath.add(this.fProject.getLocation());
        }
        return srcPath;
    }

    private class ResourceVisitor
    implements IResourceVisitor {
        private ResourceVisitor() {
        }

        public boolean visit(IResource res) throws CoreException {
            return SmapieBuilder.this.processResource(res);
        }
    }

    private final class DeltaVisitor
    implements IResourceDeltaVisitor {
        private DeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta.getKind() == 2) {
                return false;
            }
            return SmapieBuilder.this.processResource(delta.getResource());
        }
    }
}

