/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.xform.pattern.parser;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.imp.xform.pattern.matching.IASTMatcher;
import org.eclipse.imp.xform.pattern.matching.MatchResult;
import org.eclipse.imp.xform.pattern.matching.Matcher;

public abstract class ASTAdapterBase
implements IASTMatcher {
    private static Object[] EMPTY = new Object[0];

    public final Object getValue(String attributeName, Object astNode) {
        if (attributeName.equals("kind")) {
            return this.getKind(astNode);
        }
        if (attributeName.equals("targetType")) {
            return this.getTargetType(astNode);
        }
        if (attributeName.equals("name")) {
            return this.getName(astNode);
        }
        return this.getChildByRole(attributeName, astNode);
    }

    protected Object getTargetType(Object astNode) {
        return null;
    }

    protected String getName(Object astNode) {
        return null;
    }

    protected Object getKind(Object astNode) {
        String name = astNode.getClass().getName();
        return name.substring(name.lastIndexOf(46));
    }

    protected Object getChildByRole(String roleName, Object astNode) {
        try {
            for (Class<?> clazz = astNode.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                try {
                    Field field = clazz.getDeclaredField(roleName);
                    if (field == null || (field.getModifiers() & 8) != 0) continue;
                    boolean save = field.isAccessible();
                    field.setAccessible(true);
                    Object result = field.get(astNode);
                    field.setAccessible(save);
                    return result;
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
            }
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        return null;
    }

    public Object[] getChildren(Object astNode) {
        return EMPTY;
    }

    public Object[] getFollowingAdjuncts(Object astNode) {
        return EMPTY;
    }

    public Object[] getPrecedingAdjuncts(Object astNode) {
        return EMPTY;
    }

    public boolean isInstanceOfType(Object astNode, String typeName) {
        return false;
    }

    public Set findAllMatches(Matcher matcher, Object astRoot) {
        return Collections.EMPTY_SET;
    }

    public MatchResult findNextMatch(Matcher matcher, Object astRoot, int offset) {
        return null;
    }

    public String getFile(Object astNode) {
        return null;
    }

    public int getOffset(Object astNode) {
        return 0;
    }

    public int getLength(Object astNode) {
        return 0;
    }

    public String lookupSimpleNodeType(String simpleName) {
        return null;
    }

    public boolean isSubTypeOf(String maybeSuper, String maybeSub) {
        try {
            return Class.forName(maybeSuper).isAssignableFrom(Class.forName(maybeSuper));
        }
        catch (ClassNotFoundException e) {
            assert (false) : e.getMessage();
            return false;
        }
    }

    public String getTypeOf(Object astNode) {
        return null;
    }

    public Object construct(String qualName, Object[] children) throws IllegalArgumentException {
        return null;
    }

    public Object construct(String qualName, Object[] children, Map attribs) throws IllegalArgumentException {
        return null;
    }

    public Object getChildAtPosition(int pos, Object astNode) {
        int idx;
        Stack<Field[]> fieldStack = new Stack<Field[]>();
        Stack<Integer> instanceFieldCounts = new Stack<Integer>();
        for (Class<?> clazz = astNode.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] declaredFields = clazz.getDeclaredFields();
            fieldStack.push(declaredFields);
            int count = 0;
            for (int i = 0; i < declaredFields.length; ++i) {
                if ((declaredFields[i].getModifiers() & 8) == 0) continue;
                ++count;
            }
            instanceFieldCounts.push(count);
        }
        Field[] fields = (Field[])fieldStack.pop();
        int instFieldCount = (Integer)instanceFieldCounts.pop();
        for (idx = pos; idx >= instFieldCount; idx -= instFieldCount) {
            fields = (Field[])fieldStack.pop();
            instFieldCount = (Integer)instanceFieldCounts.pop();
        }
        for (int i = 0; i < fields.length; ++i) {
            if ((fields[i].getModifiers() & 8) == 0 || idx-- != 0) continue;
            return fields[i];
        }
        throw new IllegalArgumentException("Invalid child index " + pos + " for type " + astNode.getClass().getName());
    }

    public String getChildRoleAtPosition(int pos, String qualNodeType) {
        try {
            return Class.forName(qualNodeType).getFields()[pos].getName();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public int getPositionOfChildRole(String roleName, String qualNodeType) {
        try {
            Class<?> clazz = Class.forName(qualNodeType);
            Field[] fields = clazz.getFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().equals(roleName)) continue;
                return i;
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        if (roleName.equals("kind") || roleName.equals("targetType")) {
            throw new IllegalArgumentException(roleName);
        }
        return -1;
    }

    public boolean isMetaVariable(Object astNode) {
        return false;
    }

    public String getMetaVariableName(Object astNode) {
        return null;
    }

    public boolean isList(Object astNode) {
        return false;
    }
}

