/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.releng;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.imp.releng.ReleaseTool;
import org.eclipse.imp.releng.WorkbenchReleaseTool;
import org.eclipse.imp.releng.metadata.FeatureInfo;
import org.eclipse.imp.releng.metadata.PluginInfo;
import org.eclipse.imp.releng.metadata.UpdateSiteInfo;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.internal.wizards.NewWizardRegistry;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class DashboardView
extends ViewPart {
    private FormToolkit fToolkit;
    private ScrolledForm fForm;
    private ReleaseTool fReleaseTool = new WorkbenchReleaseTool();
    private FontData EXPLANATION_FONT_DATA = new FontData("default", 12, 2);
    private Font fExplanationFont;
    private UpdateSiteInfo fSelectedSite;
    private FeatureInfo fSelectedFeature;
    private Table fFeatureTable;
    private Table fPluginTable;

    public DashboardView() {
        this.fReleaseTool.collectMetaData(true);
    }

    public void setReleaseTool(ReleaseTool tool) {
        this.fReleaseTool = tool;
    }

    public void createPartControl(Composite parent) {
        this.fToolkit = new FormToolkit(parent.getDisplay());
        this.fToolkit.setBorderStyle(2048);
        this.fExplanationFont = new Font((Device)parent.getDisplay(), this.EXPLANATION_FONT_DATA);
        this.fForm = this.fToolkit.createScrolledForm(parent);
        this.fForm.setText("IMP Release Engineering");
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        this.fForm.getBody().setLayout((Layout)layout);
        this.createUpdateSiteSection();
        this.createFeatureListSection();
        this.createPluginListSection();
        Button saveButton = this.fToolkit.createButton(this.fForm.getBody(), "Save (TBD)", 8);
        saveButton.setLayoutData((Object)new TableWrapData(2, 128, 1, 1));
        saveButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println("hey!");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button revertButton = this.fToolkit.createButton(this.fForm.getBody(), "Revert (TBD)", 8);
        revertButton.setLayoutData((Object)new TableWrapData(2, 128, 1, 1));
        revertButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println("wha?");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void populatePluginsTable() {
        this.fPluginTable.removeAll();
        for (PluginInfo pluginInfo : this.fSelectedFeature.fPluginInfos) {
            TableItem ti = new TableItem(this.fPluginTable, 0);
            ti.setText(0, pluginInfo.fPluginID);
        }
        for (int i = 0; i < this.fPluginTable.getColumnCount(); ++i) {
            this.fPluginTable.getColumn(i).pack();
        }
        this.fPluginTable.pack();
    }

    private void createPluginListSection() {
        Section pluginsSection = this.fToolkit.createSection(this.fForm.getBody(), 466);
        pluginsSection.setText("Feature Plugins");
        pluginsSection.setDescription("The set of plugins included in the selected feature");
        pluginsSection.setLayoutData((Object)new TableWrapData(128, 128, 1, 2));
        Composite pluginsClient = this.fToolkit.createComposite((Composite)pluginsSection);
        TableWrapLayout pluginsLayout = new TableWrapLayout();
        pluginsLayout.numColumns = 2;
        pluginsLayout.verticalSpacing = 3;
        pluginsClient.setLayout((Layout)pluginsLayout);
        pluginsSection.setClient((Control)pluginsClient);
        this.fPluginTable = this.fToolkit.createTable(pluginsClient, 0);
        TableColumn pluginIDCol = new TableColumn(this.fPluginTable, 16384);
        pluginIDCol.setText("Plugin ID");
        TableViewer pluginTableViewer = new TableViewer(this.fPluginTable);
        this.populatePluginsTable();
        this.fPluginTable.setHeaderVisible(true);
        this.fPluginTable.setLinesVisible(true);
        Composite buttonComposite = this.fToolkit.createComposite(pluginsClient);
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        Button newPluginButton = this.fToolkit.createButton(buttonComposite, "New Plugin...", 8);
        newPluginButton.setToolTipText("Start the wizard to create a new plugin project.");
        this.addWizardRunner(newPluginButton, "org.eclipse.pde.ui.NewProjectWizard");
        Text t = this.fToolkit.createText(buttonComposite, "Start the wizard to create a new plugin project.", 10);
        t.setFont(this.fExplanationFont);
        t.setSize(250, this.EXPLANATION_FONT_DATA.getHeight() + 2);
        Button addPluginButton = this.fToolkit.createButton(buttonComposite, "Add Plugin... (TBD)", 8);
        addPluginButton.setToolTipText("Add an existing plugin to the given feature.");
        addPluginButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
            }
        });
        t = this.fToolkit.createText(buttonComposite, "Add an existing plugin to the given feature.", 10);
        t.setFont(this.fExplanationFont);
        t.setSize(250, this.EXPLANATION_FONT_DATA.getHeight() + 2);
    }

    private void createFeatureListSection() {
        Section featuresSection = this.fToolkit.createSection(this.fForm.getBody(), 466);
        featuresSection.setText("Update Site Features");
        featuresSection.setDescription("The set of features included in the selected update site");
        featuresSection.setLayoutData((Object)new TableWrapData(128, 128, 1, 2));
        Composite featuresClient = this.fToolkit.createComposite((Composite)featuresSection);
        TableWrapLayout featuresLayout = new TableWrapLayout();
        featuresLayout.numColumns = 2;
        featuresLayout.verticalSpacing = 3;
        featuresClient.setLayout((Layout)featuresLayout);
        featuresSection.setClient((Control)featuresClient);
        this.fFeatureTable = this.fToolkit.createTable(featuresClient, 0);
        TableColumn featureIDCol = new TableColumn(this.fFeatureTable, 16384);
        featureIDCol.setText("Feature ID");
        TableViewer featureTableViewer = new TableViewer(this.fFeatureTable);
        this.populateFeaturesTable();
        this.fFeatureTable.setHeaderVisible(true);
        this.fFeatureTable.setLinesVisible(true);
        this.fFeatureTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DashboardView.this.fSelectedFeature = (FeatureInfo)e.item.getData();
                DashboardView.this.populatePluginsTable();
            }
        });
        Composite buttonComposite = this.fToolkit.createComposite(featuresClient);
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        Button newFeatureButton = this.fToolkit.createButton(buttonComposite, "New Feature...", 8);
        this.addWizardRunner(newFeatureButton, "org.eclipse.pde.ui.NewFeatureProjectWizard");
        newFeatureButton.setToolTipText("Start the wizard for creating a new feature project.");
        Text t = this.fToolkit.createText(buttonComposite, "Start the wizard for creating a new feature project.", 10);
        t.setFont(this.fExplanationFont);
        t.setSize(250, this.EXPLANATION_FONT_DATA.getHeight() + 2);
        Button incrementVersionsButton = this.fToolkit.createButton(buttonComposite, "Increment Feature Versions...", 8);
        incrementVersionsButton.setToolTipText("Examines the files contributing to each feature to determine whether changes warrant increasing the version #.");
        incrementVersionsButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DashboardView.this.fReleaseTool.incrementVersions();
            }
        });
        t = this.fToolkit.createText(buttonComposite, "Examines the files contributing to each feature to\ndetermine whether changes warrant increasing the\nversion #.", 10);
        t.setFont(this.fExplanationFont);
        t.setSize(250, this.EXPLANATION_FONT_DATA.getHeight() + 2);
        Button addFeatureButton = this.fToolkit.createButton(buttonComposite, "Add Feature...", 8);
        addFeatureButton.setToolTipText("Add an existing feature to the set of features published on a given update site.");
        addFeatureButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                List<FeatureInfo> featureInfos = DashboardView.this.fReleaseTool.selectFeatureInfos();
                for (FeatureInfo info : featureInfos) {
                    ((DashboardView)DashboardView.this).fSelectedSite.fFeatureRefs.add(new UpdateSiteInfo.FeatureRef(info.fFeatureID, info.fFeatureVersion, info.getURL(), DashboardView.this.findCategoryFor(info, DashboardView.this.fSelectedSite)));
                }
                DashboardView.this.populateFeaturesTable();
                DashboardView.this.fReleaseTool.rewriteUpdateSiteManifests(Collections.singletonList(DashboardView.this.fSelectedSite));
            }
        });
        t = this.fToolkit.createText(buttonComposite, "Examines the files contributing to each feature to\ndetermine whether changes warrant increasing the\nversion #.", 10);
        t.setFont(this.fExplanationFont);
        t.setSize(250, this.EXPLANATION_FONT_DATA.getHeight() + 2);
        Button updateFeatureProjectSetsButton = this.fToolkit.createButton(buttonComposite, "Update the Feature Project Set...", 8);
        updateFeatureProjectSetsButton.setToolTipText("Update the Team Project Set listing the plugin projects that belong to the feature using information from the feature manifest.");
        updateFeatureProjectSetsButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DashboardView.this.fReleaseTool.updateFeatureProjectSets();
            }
        });
        t = this.fToolkit.createText(buttonComposite, "Update the Team Project Set listing the plugin projects\nthat belong to the feature using information from the\nfeature manifest.", 10);
        t.setFont(this.fExplanationFont);
        t.setSize(250, this.EXPLANATION_FONT_DATA.getHeight() + 2);
        Button updateAllFeatureProjectSetsButton = this.fToolkit.createButton(buttonComposite, "Update All Feature Project Sets...", 8);
        updateAllFeatureProjectSetsButton.setToolTipText("Update the Team Project Sets for all known features.");
        updateAllFeatureProjectSetsButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DashboardView.this.fReleaseTool.updateFeatureProjectSets();
            }
        });
        t = this.fToolkit.createText(buttonComposite, "Update the Team Project Sets for all known features.", 10);
        t.setFont(this.fExplanationFont);
        t.setSize(250, this.EXPLANATION_FONT_DATA.getHeight() + 2);
        Button tagFeaturesButton = this.fToolkit.createButton(buttonComposite, "Tag Feature Versions...", 8);
        tagFeaturesButton.setToolTipText("Tags the current versions of all files in projects in selected features with that feature's version #.");
        tagFeaturesButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DashboardView.this.fReleaseTool.tagFeatures();
            }
        });
        t = this.fToolkit.createText(buttonComposite, "Tags the current versions of all files in projects in\nselected features with that feature's version #.", 10);
        t.setFont(this.fExplanationFont);
        buttonComposite.pack();
    }

    protected String findCategoryFor(FeatureInfo info, UpdateSiteInfo siteInfo) {
        for (UpdateSiteInfo.FeatureRef featureRef : siteInfo.fFeatureRefs) {
            if (!featureRef.getID().equals(info.fFeatureID)) continue;
            return featureRef.getCategory();
        }
        return siteInfo.fCategories.get(0).getName();
    }

    private void populateFeaturesTable() {
        this.fFeatureTable.removeAll();
        HashSet<FeatureInfo> features = new HashSet<FeatureInfo>();
        for (UpdateSiteInfo.FeatureRef featureRef : this.fSelectedSite.fFeatureRefs) {
            features.add(this.fReleaseTool.findFeatureInfo(featureRef.getID()));
        }
        for (FeatureInfo featureInfo : features) {
            TableItem ti = new TableItem(this.fFeatureTable, 0);
            ti.setText(0, featureInfo.fFeatureID);
            ti.setData((Object)featureInfo);
        }
        this.fSelectedFeature = (FeatureInfo)features.iterator().next();
        for (int i = 0; i < this.fFeatureTable.getColumnCount(); ++i) {
            this.fFeatureTable.getColumn(i).pack();
        }
        this.fFeatureTable.pack();
    }

    private void createUpdateSiteSection() {
        Section siteSection = this.fToolkit.createSection(this.fForm.getBody(), 466);
        siteSection.setText("Update Sites");
        siteSection.setDescription("Set of workspace update site projects");
        siteSection.setLayoutData((Object)new TableWrapData(128, 128, 1, 2));
        Composite siteSectionClient = this.fToolkit.createComposite((Composite)siteSection);
        TableWrapLayout siteSectLayout = new TableWrapLayout();
        siteSectionClient.setLayout((Layout)siteSectLayout);
        siteSectLayout.numColumns = 3;
        siteSectLayout.verticalSpacing = 3;
        siteSectionClient.setLayout((Layout)siteSectLayout);
        siteSection.setClient((Control)siteSectionClient);
        Table siteTable = this.fToolkit.createTable(siteSectionClient, 0);
        TableColumn siteNameCol = new TableColumn(siteTable, 16384);
        siteNameCol.setText("Site name");
        TableViewer siteTableViewer = new TableViewer(siteTable);
        for (UpdateSiteInfo siteInfo : this.fReleaseTool.fUpdateSiteInfos) {
            TableItem ti = new TableItem(siteTable, 0);
            ti.setText(0, siteInfo.fProject.getName());
            ti.setData((Object)siteInfo);
        }
        this.fSelectedSite = this.fReleaseTool.fUpdateSiteInfos.get(0);
        siteTable.setHeaderVisible(true);
        siteTable.setLinesVisible(true);
        siteTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DashboardView.this.fSelectedSite = (UpdateSiteInfo)e.item.getData();
                DashboardView.this.populateFeaturesTable();
            }
        });
        siteNameCol.pack();
        siteTable.pack();
        Composite buttonComposite = this.fToolkit.createComposite(siteSectionClient);
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        Button newSiteButton = this.fToolkit.createButton(buttonComposite, "New Site...", 8);
        this.addWizardRunner(newSiteButton, "org.eclipse.pde.ui.NewSiteProjectWizard");
        newSiteButton.setToolTipText("Start the wizard for creating a new update site project.");
        Text t = this.fToolkit.createText(buttonComposite, "Start the wizard for creating a new update site project.", 10);
        t.setFont(this.fExplanationFont);
        Button updateSiteContentsButton = this.fToolkit.createButton(buttonComposite, "Update the Site Manifest...", 8);
        updateSiteContentsButton.setToolTipText("Updates each update site manifest by adding the latest (workspace) version of each feature that belongs to the site.");
        updateSiteContentsButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DashboardView.this.fReleaseTool.updateUpdateSites();
            }
        });
        t = this.fToolkit.createText(buttonComposite, "Updates each update site manifest by adding the latest\n(workspace) version of each feature that\nbelongs to the site.", 10);
        t.setFont(this.fExplanationFont);
        Button updateUpdateSiteProjectSetButton = this.fToolkit.createButton(buttonComposite, "Update the Site Project Set...", 8);
        updateUpdateSiteProjectSetButton.setToolTipText("Updates the site's Team Project Set (features.psf) to include all feature projects published on the update site.");
        updateUpdateSiteProjectSetButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DashboardView.this.fReleaseTool.writeSiteFeatureSet(DashboardView.this.fSelectedSite);
            }
        });
        t = this.fToolkit.createText(buttonComposite, "Updates the site's Team Project Set (features.psf) to\ninclude all feature projects published on the\nupdate site.", 10);
        t.setFont(this.fExplanationFont);
        Button updateAllUpdateSiteProjectSetsButton = this.fToolkit.createButton(buttonComposite, "Update All Site Project Sets...", 8);
        updateAllUpdateSiteProjectSetsButton.setToolTipText("Updates all update site projects' Team Project Sets.");
        updateAllUpdateSiteProjectSetsButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DashboardView.this.fReleaseTool.writeAllSiteFeatureSets();
            }
        });
        t = this.fToolkit.createText(buttonComposite, "Updates all update site projects' Team Project Sets.", 10);
        t.setFont(this.fExplanationFont);
    }

    private void addWizardRunner(Button button, final String wizardID) {
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    DashboardView.this.runNewWizard(wizardID);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        });
    }

    public void setFocus() {
        this.fForm.setFocus();
    }

    public void dispose() {
        this.fToolkit.dispose();
        this.fExplanationFont.dispose();
        super.dispose();
    }

    private void runNewWizard(String wizardID) throws CoreException {
        IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        String newSiteWizardID = wizardID;
        NewWizardRegistry reg = NewWizardRegistry.getInstance();
        IWizardDescriptor wd = reg.findWizard(newSiteWizardID);
        IWorkbenchWizard wizard = wd.createWizard();
        WizardDialog wizDialog = new WizardDialog(win.getShell(), (IWizard)wizard);
        wizDialog.open();
    }
}

