/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.releng.dialogs;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfirmDirtyFilesDialog
extends Dialog {
    private final Set<IFile> fFiles;
    private final int PATH_COL = 0;
    private final int FILE_COL = 1;

    public ConfirmDirtyFilesDialog(Shell shell, Set<IFile> files) {
        super(shell);
        this.fFiles = files;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Confirm dirty files");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Proceed with dirty files", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Table table = new Table(area, 0);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn pathCol = new TableColumn(table, 2048);
        pathCol.setText("Path");
        pathCol.setResizable(true);
        TableColumn fileCol = new TableColumn(table, 2048);
        fileCol.setText("File");
        fileCol.setResizable(true);
        TableViewer viewer = new TableViewer(table);
        for (IFile file : this.fFiles) {
            TableItem ti = new TableItem(table, 0);
            IPath path = file.getLocation();
            ti.setText(0, path.removeLastSegments(1).toPortableString());
            ti.setText(1, path.lastSegment());
        }
        pathCol.pack();
        fileCol.pack();
        return area;
    }
}

