/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.releng.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.imp.releng.metadata.UpdateSiteInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfirmUpdateSitesDialog
extends Dialog {
    private final List<UpdateSiteInfo> fAllSiteInfos;
    private final List<UpdateSiteInfo> fSiteInfos = new ArrayList<UpdateSiteInfo>();

    public ConfirmUpdateSitesDialog(Shell shell, List<UpdateSiteInfo> allSiteInfos) {
        super(shell);
        this.fAllSiteInfos = allSiteInfos;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Confirm update sites to process");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Proceed", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        for (final UpdateSiteInfo site : this.fAllSiteInfos) {
            Button siteButton = new Button(area, 32);
            siteButton.setText(site.fManifestFile.getProject().getName());
            siteButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (((Button)e.widget).getSelection()) {
                        ConfirmUpdateSitesDialog.this.fSiteInfos.add(site);
                    } else {
                        ConfirmUpdateSitesDialog.this.fSiteInfos.remove(site);
                    }
                }
            });
        }
        return area;
    }

    public List<UpdateSiteInfo> getSites() {
        return this.fSiteInfos;
    }
}

