/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.releng;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.imp.releng.ConfirmChangedFilesDialog;
import org.eclipse.imp.releng.ReleaseEngineeringPlugin;
import org.eclipse.imp.releng.ReleaseTool;
import org.eclipse.imp.releng.WorkbenchReleaseTool;
import org.eclipse.imp.releng.dialogs.SelectFeatureInfosDialog;
import org.eclipse.imp.releng.metadata.FeatureInfo;
import org.eclipse.imp.releng.metadata.PluginInfo;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyrightAdder {
    private ReleaseTool fReleaseTool = new WorkbenchReleaseTool();
    private Map<String, ICopyrightAdder> fExtensionMap = new HashMap<String, ICopyrightAdder>();
    private final Set<IFolder> fSrcRoots;
    private final List<IFile> fChangedFiles;
    private CompositeChange fTopChange;
    private int fModCount;

    public CopyrightAdder() {
        LPGEPLCopyrightAdder lpgAdder = new LPGEPLCopyrightAdder();
        this.fExtensionMap.put("g", lpgAdder);
        this.fExtensionMap.put("gi", lpgAdder);
        this.fExtensionMap.put("java", new JavaEPLCopyrightAdder());
        this.fSrcRoots = new HashSet<IFolder>();
        this.fChangedFiles = new ArrayList<IFile>();
        this.fModCount = 0;
    }

    public void addCopyrightTo(IResource resource) {
        this.computeChangeForCopyrights(resource);
        ReleaseTool.doPerformChange(this.fTopChange, "Adding copyright notices", this.fChangedFiles);
        ReleaseEngineeringPlugin.getMsgStream().println("Modified " + this.fModCount + " files.");
    }

    public CompositeChange computeChangeForCopyrights(IResource resource) {
        this.fChangedFiles.clear();
        this.fTopChange = new CompositeChange("Copyright additions");
        if (resource instanceof IFile) {
            this.processFile((IFile)resource, this.fTopChange);
        } else if (resource instanceof IFolder) {
            this.fSrcRoots.clear();
            this.fSrcRoots.add((IFolder)resource);
            this.traverseSrcRootsAddCopyrights(this.fTopChange);
        }
        return this.fTopChange;
    }

    public void addCopyrights() {
        this.fReleaseTool.collectMetaData(true);
        this.fChangedFiles.clear();
        this.fTopChange = new CompositeChange("Copyright additions");
        this.fSrcRoots.clear();
        List<FeatureInfo> featureInfos = this.fReleaseTool.getFeatureInfos();
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        SelectFeatureInfosDialog sfid = new SelectFeatureInfosDialog(shell, featureInfos);
        if (sfid.open() != 0) {
            return;
        }
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        HashSet<IProject> projects = new HashSet<IProject>();
        for (FeatureInfo featureInfo : sfid.getSelectedFeatures()) {
            for (PluginInfo plugin : featureInfo.fPluginInfos) {
                projects.add(wsRoot.getProject(plugin.fProjectName));
            }
        }
        this.collectProjectSourceRoots(projects);
        this.fModCount = 0;
        this.traverseSrcRootsAddCopyrights(this.fTopChange);
        if (this.fTopChange.getChildren().length == 0) {
            MessageDialog.openInformation((Shell)shell, (String)"No changes needed", (String)"No source files lack a copyright notice.");
            return;
        }
        ConfirmChangedFilesDialog d = new ConfirmChangedFilesDialog(shell, this.fTopChange);
        if (d.open() == 0) {
            ReleaseTool.doPerformChange(this.fTopChange, "Adding copyright notices", this.fChangedFiles);
            ReleaseEngineeringPlugin.getMsgStream().println("Modified " + this.fModCount + " files.");
        }
    }

    private void traverseSrcRootsAddCopyrights(CompositeChange topChange) {
        final HashMap<Object, CompositeChange> resource2Change = new HashMap<Object, CompositeChange>();
        for (IFolder srcRoot : this.fSrcRoots) {
            IProject project = srcRoot.getProject();
            if (!resource2Change.containsKey(project)) {
                CompositeChange projChange = new CompositeChange("Project " + project.getName());
                topChange.add((Change)projChange);
                resource2Change.put(project, projChange);
            }
            CompositeChange folderChange = new CompositeChange(srcRoot.getName());
            resource2Change.put(srcRoot, folderChange);
            try {
                srcRoot.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (resource.isDerived()) {
                            return false;
                        }
                        if (resource instanceof IFile) {
                            CopyrightAdder.this.processFile((IFile)resource, (CompositeChange)resource2Change.get(resource.getParent()));
                        } else if (resource instanceof IFolder) {
                            ReleaseEngineeringPlugin.getMsgStream().println("  Scanning folder " + resource.getLocation().toPortableString());
                            CompositeChange newComp = new CompositeChange(resource.getName());
                            resource2Change.put(resource, newComp);
                            ((CompositeChange)resource2Change.get(resource.getParent())).add((Change)newComp);
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                this.logError((Exception)((Object)e));
                e.printStackTrace();
            }
        }
        this.pruneEmptyChanges((Change)this.fTopChange);
    }

    private void pruneEmptyChanges(Change change) {
        if (change instanceof CompositeChange) {
            CompositeChange compositeChange = (CompositeChange)change;
            for (Change child : compositeChange.getChildren()) {
                this.pruneEmptyChanges(child);
            }
            if (compositeChange.getChildren().length == 0) {
                ((CompositeChange)compositeChange.getParent()).remove((Change)compositeChange);
            }
        }
    }

    private void processFile(IFile file, CompositeChange parentChange) {
        String fileExtension = file.getFileExtension();
        if (this.fExtensionMap.containsKey(fileExtension)) {
            ICopyrightAdder copyrightAdder = this.fExtensionMap.get(fileExtension);
            this.addCopyright(copyrightAdder, file, parentChange);
        }
    }

    private void addCopyright(ICopyrightAdder copyrightAdder, IFile file, CompositeChange parentChange) {
        try {
            InputStream is = file.getContents();
            String origCont = CopyrightAdder.getFileContents(new InputStreamReader(is));
            String newCont = copyrightAdder.addCopyright(origCont);
            if (newCont.equals(origCont)) {
                return;
            }
            ReleaseEngineeringPlugin.getMsgStream().println("        File " + file.getName() + " needs a copyright notice.");
            ++this.fModCount;
            TextFileChange tfc = new TextFileChange("Add copyright to " + file.getName(), file);
            long curFileLength = new File(file.getLocation().toOSString()).length();
            tfc.setEdit((TextEdit)new MultiTextEdit());
            tfc.addEdit((TextEdit)new ReplaceEdit(0, (int)curFileLength, newCont));
            this.fChangedFiles.add(file);
            parentChange.add((Change)tfc);
        }
        catch (CoreException e) {
            this.logError((Exception)((Object)e));
            e.printStackTrace();
        }
    }

    private void collectProjectSourceRoots(Set<IProject> projectsToModify) {
        IWorkspaceRoot wsRoot = this.fReleaseTool.fWSRoot;
        for (IProject project : projectsToModify) {
            ReleaseEngineeringPlugin.getMsgStream().println("Collecting source folders for " + project.getName());
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (!javaProject.exists()) {
                ReleaseEngineeringPlugin.getMsgStream().println("Project " + javaProject.getElementName() + " does not exist!");
                continue;
            }
            try {
                IClasspathEntry[] cpe = javaProject.getResolvedClasspath(true);
                for (int j = 0; j < cpe.length; ++j) {
                    IClasspathEntry entry = cpe[j];
                    if (entry.getEntryKind() != 3) continue;
                    if (entry.getPath().segmentCount() == 1) {
                        ReleaseEngineeringPlugin.getMsgStream().println("*** Ignoring source path entry " + entry.getPath().toPortableString() + " because it's at a project root.");
                        continue;
                    }
                    this.fSrcRoots.add(wsRoot.getFolder(entry.getPath()));
                }
            }
            catch (JavaModelException e) {
                ReleaseEngineeringPlugin.getMsgStream().println("Exception encountered while traversing resources:\n  " + e.getMessage());
                this.logError((Exception)((Object)e));
            }
        }
    }

    public static String getFileContents(Reader reader) {
        StringBuilder sb = new StringBuilder(4096);
        char[] buff = new char[4096];
        while (true) {
            int len;
            try {
                len = reader.read(buff);
            }
            catch (IOException e) {
                break;
            }
            if (len < 0) break;
            sb.append(buff, 0, len);
        }
        return sb.toString();
    }

    private void logError(Exception e) {
        Status status = new Status(4, "org.eclipse.imp.releng", 0, e.getMessage(), (Throwable)e);
        ReleaseEngineeringPlugin.getInstance().getLog().log((IStatus)status);
    }

    private class LPGEPLCopyrightAdder
    implements ICopyrightAdder {
        private final Pattern COPYRIGHT_PATTERN = Pattern.compile("%Notice\n/.\n////////////////////////////////////////////////////////////////////////////////\n// Copyright (c) [0-9]+ IBM Corporation.\n// All rights reserved. This program and the accompanying materials\n// are made available under the terms of the Eclipse Public License v1.0\n// which accompanies this distribution, and is available at\n// http://www.eclipse.org/legal/epl-v10.html\n//\n//Contributors:\n(//.*\n)+\n////////////////////////////////////////////////////////////////////////////////\n./\n%End\n\n");
        private static final String COPYRIGHT_NOTICE = "%Notice\n/.\n////////////////////////////////////////////////////////////////////////////////\n// Copyright (c) 2007 IBM Corporation.\n// All rights reserved. This program and the accompanying materials\n// are made available under the terms of the Eclipse Public License v1.0\n// which accompanies this distribution, and is available at\n// http://www.eclipse.org/legal/epl-v10.html\n//\n//Contributors:\n//    Philippe Charles (pcharles@us.ibm.com) - initial API and implementation\n\n////////////////////////////////////////////////////////////////////////////////\n./\n%End\n\n";
        private static final String OLD_COPYRIGHT_NOTICE = "%Notice\r\n/.\r\n// (C) Copyright IBM Corporation 2007\r\n// \r\n// This file is part of the Eclipse IMP.\r\n./\r\n%End\r\n\r\n";
        private final int OLD_COPYRIGHT_LENGTH = "%Notice\r\n/.\r\n// (C) Copyright IBM Corporation 2007\r\n// \r\n// This file is part of the Eclipse IMP.\r\n./\r\n%End\r\n\r\n".length();
        private final Pattern RULES_PATTERN = Pattern.compile("^\\s*%[Rr][Uu][Ll][Ee][Ss]");

        private LPGEPLCopyrightAdder() {
        }

        public String removeOldCopyright(String src) {
            int oldStart = src.indexOf(OLD_COPYRIGHT_NOTICE);
            if (oldStart < 0) {
                return src;
            }
            if (oldStart == 0) {
                return src.substring(this.OLD_COPYRIGHT_LENGTH);
            }
            String prefix = src.substring(0, oldStart);
            String suffix = src.substring(oldStart + this.OLD_COPYRIGHT_LENGTH);
            return prefix + suffix;
        }

        public String addCopyright(String src) {
            Matcher cm = this.COPYRIGHT_PATTERN.matcher(src);
            if (cm.find()) {
                return src;
            }
            src = this.removeOldCopyright(src);
            Matcher rm = this.RULES_PATTERN.matcher(src);
            int rulesLoc = -1;
            if (rm.find()) {
                rulesLoc = rm.start();
            }
            if (rulesLoc < 0) {
                rulesLoc = src.indexOf("$Rules");
            }
            if (rulesLoc < 0) {
                rulesLoc = 0;
            }
            return src.substring(0, rulesLoc) + COPYRIGHT_NOTICE + src.substring(rulesLoc);
        }
    }

    private class JavaEPLCopyrightAdder
    implements ICopyrightAdder {
        private Pattern COPYRIGHT_PATTERN = Pattern.compile("/\\*.*\n\\s*\\* Copyright \\(c\\) [0-9]+ IBM Corporation.\n\\s*\\* All rights reserved. This program and the accompanying materials\n\\s*\\* are made available under the terms of the Eclipse Public License v1.0\n\\s*\\* which accompanies this distribution, and is available at\n\\s*\\* http://www.eclipse.org/legal/epl-v10.html\n\\s*\\*\n\\s*\\* Contributors:\n(\\s*\\*.*\n)+\\s*\\*?\n.*\\*/\n");
        private static final String COPYRIGHT_NOTICE = "/*******************************************************************************\n* Copyright (c) 2008 IBM Corporation.\n* All rights reserved. This program and the accompanying materials\n* are made available under the terms of the Eclipse Public License v1.0\n* which accompanies this distribution, and is available at\n* http://www.eclipse.org/legal/epl-v10.html\n*\n* Contributors:\n*    Robert Fuhrer (rfuhrer@watson.ibm.com) - initial API and implementation\n*\n*******************************************************************************/\n\n";
        private static final String OLD_COPYRIGHT_NOTICE = "/*\r\n * (C) Copyright IBM Corporation 2007\r\n * \r\n * This file is part of the Eclipse IMP.\r\n */\r\n";
        private final int OLD_COPYRIGHT_LENGTH = "/*\r\n * (C) Copyright IBM Corporation 2007\r\n * \r\n * This file is part of the Eclipse IMP.\r\n */\r\n".length();

        private JavaEPLCopyrightAdder() {
        }

        public String removeOldCopyright(String src) {
            int oldStart = src.indexOf(OLD_COPYRIGHT_NOTICE);
            if (oldStart < 0) {
                return src;
            }
            if (oldStart == 0) {
                return src.substring(this.OLD_COPYRIGHT_LENGTH);
            }
            String prefix = src.substring(0, oldStart);
            String suffix = src.substring(oldStart + this.OLD_COPYRIGHT_LENGTH);
            return prefix + suffix;
        }

        public String addCopyright(String src) {
            Matcher m = this.COPYRIGHT_PATTERN.matcher(src);
            if (m.find()) {
                return src;
            }
            src = this.removeOldCopyright(src);
            return COPYRIGHT_NOTICE + src;
        }
    }

    private static interface ICopyrightAdder {
        public String addCopyright(String var1);
    }
}

