/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.releng;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.imp.releng.ReleaseEngineeringPlugin;
import org.eclipse.imp.releng.WorkbenchReleaseTool;
import org.eclipse.imp.releng.actions.VersionScanner;
import org.eclipse.imp.releng.metadata.FeatureInfo;
import org.eclipse.imp.releng.metadata.FileVersionMap;
import org.eclipse.imp.releng.metadata.PluginInfo;
import org.eclipse.imp.releng.metadata.UpdateSiteInfo;
import org.eclipse.imp.releng.utils.Pair;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileHistory;
import org.eclipse.team.core.history.provider.FileHistoryProvider;
import org.eclipse.team.core.history.provider.FileRevision;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.CVSWorkspaceSubscriber;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.progress.IProgressService;
import org.tigris.subversion.subclipse.core.ISVNLocalFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.commands.BranchTagCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReleaseTool {
    protected IWorkspaceRoot fWSRoot = ResourcesPlugin.getWorkspace().getRoot();
    protected final List<FeatureInfo> fFeatureInfos = new ArrayList<FeatureInfo>();
    protected final List<PluginInfo> fPluginInfos = new ArrayList<PluginInfo>();
    protected final Set<String> fExclusions = new HashSet<String>();
    protected final List<UpdateSiteInfo> fUpdateSiteInfos = new ArrayList<UpdateSiteInfo>();
    protected boolean fCanProceed;
    private Comparator<IFile> fFileComparator = new Comparator<IFile>(){

        @Override
        public int compare(IFile o1, IFile o2) {
            return o1.getLocation().toPortableString().compareTo(o2.getLocation().toPortableString());
        }
    };
    private boolean fTemporarilySuppressAutoBuild = true;
    public static final String CVS_UPDATE_SITE_PROVIDER = "org.eclipse.team.cvs.core.cvsnature";
    public static final String SVN_UPDATE_SITE_PROVIDER = "org.tigris.subversion.subclipse.core.svnnature";
    public static final String IMP_UPDATE_SITE_PROJECT = "org.eclipse.imp.update";
    public static final String IMP_REPO_SERVER = "dev.eclipse.org";
    public static final String IMP_REPO_PATH = "/svnroot/technology/org.eclipse.imp";
    public static final String IMP_UPDATE_SITE_REF = "0.9.3,https://dev.eclipse.org/svnroot/technology/org.eclipse.imp/org.eclipse.imp.update/trunk,org.eclipse.imp.update";

    public List<FeatureInfo> getFeatureInfos() {
        return this.fFeatureInfos;
    }

    public void saveFeatureProjectSets(List<FeatureInfo> selectedFeatures) {
        for (FeatureInfo fi : selectedFeatures) {
            HashMap<String, Set<String>> repoRefMap = new HashMap<String, Set<String>>();
            for (PluginInfo pi : fi.fPluginInfos) {
                IProject pluginProject = this.fWSRoot.getProject(pi.fProjectName);
                if (pluginProject == null || !pluginProject.exists()) {
                    ReleaseEngineeringPlugin.getMsgStream().println("Unable to open project for plugin ID " + pi.fPluginID + "; ignoring.");
                    continue;
                }
                Pair<String, String> repoDesc = this.getRepoRefForProject(pluginProject);
                ReleaseTool.addMapEntry(repoDesc.first, repoDesc.second, repoRefMap);
            }
            IProject featureProject = fi.fProject;
            this.writeProjectSet(repoRefMap, featureProject, "plugins.psf");
        }
    }

    public void writeProjectSet(Map<String, Set<String>> repoRefMap, IProject hostProject, String fileName) {
        String psfContents = this.projectSetFor(repoRefMap);
        IFile psf = hostProject.getFile(fileName);
        ByteArrayInputStream is = new ByteArrayInputStream(psfContents.getBytes());
        try {
            if (!psf.exists()) {
                psf.create((InputStream)is, true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                psf.setContents((InputStream)is, 0, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            this.postError("Unable to write team project set file for " + hostProject.getName() + ": " + e.getMessage(), (Exception)((Object)e));
        }
    }

    protected void postError(String errorMsg, Exception e) {
        System.err.println(errorMsg);
    }

    public Pair<String, String> getRepoRefForProject(IProject project) {
        RepositoryProvider repoProvider = RepositoryProvider.getProvider((IProject)project);
        String repoTypeID = repoProvider.getID();
        RepositoryProviderType repoType = RepositoryProviderType.getProviderType((String)repoTypeID);
        ProjectSetCapability projectSetCapability = repoType.getProjectSetCapability();
        ProjectSetSerializationContext context = new ProjectSetSerializationContext();
        try {
            String repoRef = projectSetCapability.asReference(new IProject[]{project}, context, (IProgressMonitor)new NullProgressMonitor())[0];
            return new Pair<String, String>(repoTypeID, repoRef);
        }
        catch (TeamException e) {
            ReleaseEngineeringPlugin.getMsgStream().println("Unable to compute repository reference for project " + project.getName());
            return null;
        }
    }

    public static <K, V> void addMapEntry(K key, V value, Map<K, Set<V>> map) {
        Set<V> values = map.get(key);
        if (values == null) {
            values = new HashSet<V>();
            map.put(key, values);
        }
        values.add(value);
    }

    protected String projectSetFor(Map<String, Set<String>> repoRefMap) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.nl(sb);
        sb.append("<psf version=\"2.0\">");
        this.nl(sb);
        for (String repoTypeID : repoRefMap.keySet()) {
            TreeSet repoRefs = new TreeSet(repoRefMap.get(repoTypeID));
            sb.append("    <provider id=\"" + repoTypeID + "\">");
            this.nl(sb);
            for (String repoRef : repoRefs) {
                sb.append("        <project reference=\"" + repoRef + "\"/>");
                this.nl(sb);
            }
            sb.append("    </provider>");
            this.nl(sb);
        }
        sb.append("</psf>");
        this.nl(sb);
        return sb.toString();
    }

    protected void nl(StringBuilder sb) {
        sb.append("\n");
    }

    public void incrementVersions() {
        this.fCanProceed = true;
        this.collectMetaData(false);
        if (this.fFeatureInfos.size() == 0) {
            return;
        }
        this.collectVersionInfo();
        if (!this.fCanProceed) {
            ReleaseEngineeringPlugin.getMsgStream().println("*** Errors encountered; will not rewrite files.");
            return;
        }
        this.computeNewVersions();
        if (this.confirmChanges()) {
            this.performAllChanges();
        }
    }

    public void collectMetaData(boolean allFeatures) {
        this.fUpdateSiteInfos.clear();
        this.fFeatureInfos.clear();
        this.fPluginInfos.clear();
        this.fExclusions.clear();
        this.fCanProceed = true;
        this.collectFeatures(allFeatures);
        this.collectUpdateSites();
        if (this.fFeatureInfos.size() == 0) {
            return;
        }
        this.collectPluginsFromFeatures();
        this.collectExclusions();
    }

    private void collectVersionInfo() {
        this.readOldPluginVersionMaps();
        this.buildNewPluginVersionMaps();
        this.scanPluginsForDiffs();
    }

    private void computeNewVersions() {
        this.incrementPluginInfoVersions();
        this.incrementFeatureVersions();
        this.fixupFeatureRequires();
    }

    private void performAllChanges() {
        ArrayList<IFile> changedFiles = new ArrayList<IFile>();
        ArrayList<TextFileChange> changes = new ArrayList<TextFileChange>();
        this.writeNewPluginVersionMaps(changedFiles);
        this.rewriteFeatureManifests(changes, changedFiles);
        this.rewritePluginManifests(changes, changedFiles);
        ReleaseTool.doPerformChange(changes, "Version edits", changedFiles);
    }

    private void setVCTags() {
        for (PluginInfo pi : this.fPluginInfos) {
            IProject project = this.fWSRoot.getProject(pi.fProjectName);
            if (!RepositoryProvider.isShared((IProject)project) && !this.confirmShareProject(project)) continue;
        }
    }

    protected abstract boolean confirmShareProject(IProject var1);

    private boolean confirmChanges() {
        Comparator<PluginInfo> pluginInfoComparator = new Comparator<PluginInfo>(){

            @Override
            public int compare(PluginInfo arg0, PluginInfo arg1) {
                return arg0.fPluginID.compareTo(arg1.fPluginID);
            }
        };
        TreeSet<PluginInfo> changedPlugins = new TreeSet<PluginInfo>(pluginInfoComparator);
        for (PluginInfo pi : this.fPluginInfos) {
            if (!pi.getChangeState().isChange()) continue;
            changedPlugins.add(pi);
        }
        TreeSet<PluginInfo> unchangedPlugins = new TreeSet<PluginInfo>(pluginInfoComparator);
        unchangedPlugins.addAll(this.fPluginInfos);
        unchangedPlugins.removeAll(changedPlugins);
        return this.doConfirm(changedPlugins, unchangedPlugins);
    }

    protected abstract boolean doConfirm(Set<PluginInfo> var1, Set<PluginInfo> var2);

    private void collectFeatures(boolean allFeatures) {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        Set<IProject> allFeatureProjects = this.collectAllFeatureProjects(wsRoot);
        Set<IProject> selectedProjects = allFeatures ? allFeatureProjects : this.selectFeatureProjects(allFeatureProjects);
        for (IProject project : selectedProjects) {
            try {
                IFile manifestFile = project.getFile("feature.xml");
                this.fFeatureInfos.add(new FeatureInfo(project, manifestFile));
            }
            catch (ParserConfigurationException e) {
                ReleaseEngineeringPlugin.logError(e);
            }
            catch (SAXException e) {
                ReleaseEngineeringPlugin.logError(e);
            }
            catch (IOException e) {
                ReleaseEngineeringPlugin.logError(e);
            }
        }
    }

    protected Set<IProject> selectFeatureProjects(Set<IProject> allFeatureProjects) {
        return allFeatureProjects;
    }

    protected List<FeatureInfo> selectFeatureInfos() {
        return this.fFeatureInfos;
    }

    protected Set<IProject> collectAllFeatureProjects(IWorkspaceRoot wsRoot) {
        TreeSet<IProject> result = new TreeSet<IProject>(new Comparator<IProject>(){

            @Override
            public int compare(IProject arg0, IProject arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        IProject[] allProjects = wsRoot.getProjects();
        for (int i = 0; i < allProjects.length; ++i) {
            IProject proj = allProjects[i];
            if (!proj.exists((IPath)new Path("feature.xml"))) continue;
            result.add(proj);
        }
        return result;
    }

    private void collectPluginsFromFeatures() {
        for (FeatureInfo fi : this.fFeatureInfos) {
            fi.collectPlugins(this);
        }
        for (PluginInfo pi : this.fPluginInfos) {
            this.fCanProceed = this.fCanProceed && pi.pluginOk();
        }
    }

    private void collectUpdateSites() {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        for (IProject project : wsRoot.getProjects()) {
            try {
                IFile manifestFile = project.getFile("site.xml");
                if (!manifestFile.exists()) continue;
                this.fUpdateSiteInfos.add(new UpdateSiteInfo(project, manifestFile));
            }
            catch (ParserConfigurationException e) {
                ReleaseEngineeringPlugin.logError(e);
            }
            catch (SAXException e) {
                ReleaseEngineeringPlugin.logError(e);
            }
            catch (IOException e) {
                ReleaseEngineeringPlugin.logError(e);
            }
        }
    }

    private void collectExclusions() {
        this.fExclusions.add("com.ibm.wala.shrike");
        this.fExclusions.add("polyglot");
    }

    private void incrementFeatureVersions() {
        ReleaseEngineeringPlugin.getMsgStream().println("***");
        for (FeatureInfo fi : this.fFeatureInfos) {
            String featureID = fi.fFeatureID;
            String oldFeatureVersion = fi.fFeatureVersion;
            String newFeatureVersion = this.incrementVersionRelease(oldFeatureVersion);
            fi.setNewVersion(newFeatureVersion);
            ReleaseEngineeringPlugin.getMsgStream().println("Feature " + featureID + " new version #: " + newFeatureVersion);
            for (Node plugin : fi.fPlugins) {
                String pluginID = this.getPluginIDNode(plugin);
                Node pluginVersionNode = this.getPluginVersionNode(plugin);
                String pluginVersion = pluginVersionNode.getNodeValue();
                PluginInfo pi = this.findPluginInfo(pluginID);
                String newPluginVersion = pi.fPluginNewVersion;
                if (this.fExclusions.contains(pluginID)) {
                    ReleaseEngineeringPlugin.getMsgStream().println("   Plugin " + pluginID + " excluded; using same version #: " + pluginVersion);
                    pi.fPluginNewVersion = newPluginVersion = pluginVersion;
                } else {
                    ReleaseEngineeringPlugin.getMsgStream().println("   Plugin " + pluginID + " new version #: " + newPluginVersion);
                }
                pluginVersionNode.setNodeValue(newPluginVersion);
            }
        }
    }

    private Node getPluginVersionNode(Node plugin) {
        return plugin.getAttributes().getNamedItem("version");
    }

    private String getPluginIDNode(Node plugin) {
        return plugin.getAttributes().getNamedItem("id").getNodeValue();
    }

    public void addPlugin(PluginInfo pluginInfo) {
        this.fPluginInfos.add(pluginInfo);
    }

    public List<PluginInfo> getPluginInfos() {
        return this.fPluginInfos;
    }

    protected PluginInfo findPluginInfo(String pluginID) {
        for (PluginInfo pi : this.fPluginInfos) {
            if (!pi.fPluginID.equals(pluginID)) continue;
            return pi;
        }
        return null;
    }

    private void incrementPluginInfoVersions() {
        for (PluginInfo pi : this.fPluginInfos) {
            if (pi.getChangeState().isChange()) {
                pi.fPluginNewVersion = this.incrementVersionRelease(pi.fPluginVersion);
                if (pi.fNewMap == null) continue;
                pi.fNewMap.setVersion(pi.fManifest, this.incrementFileVersion(pi.fNewMap.getVersion(pi.fManifest)));
                continue;
            }
            pi.fPluginNewVersion = pi.fPluginVersion;
        }
    }

    protected String incrementFileVersion(String version) {
        StringTokenizer st = new StringTokenizer(version, ".");
        ArrayList<Integer> versionComps = new ArrayList<Integer>();
        while (st.hasMoreTokens()) {
            versionComps.add(Integer.parseInt(st.nextToken()));
        }
        int last = versionComps.size() - 1;
        versionComps.set(last, (Integer)versionComps.get(last) + 1);
        StringBuilder sb = new StringBuilder();
        for (Integer comp : versionComps) {
            sb.append('.');
            sb.append(comp);
        }
        return sb.toString().substring(1);
    }

    protected String incrementVersionRelease(String version) {
        StringTokenizer st = new StringTokenizer(version, ".");
        return st.nextToken() + "." + st.nextToken() + "." + (Integer.parseInt(st.nextToken()) + 1);
    }

    private void fixupFeatureRequires() {
        for (FeatureInfo fi : this.fFeatureInfos) {
            Document manifestDoc = fi.fManifestDoc;
            Node featureNode = manifestDoc.getChildNodes().item(0);
            String featureVersion = featureNode.getAttributes().getNamedItem("version").getNodeValue();
            ReleaseEngineeringPlugin.getMsgStream().println("Processing feature " + featureNode.getAttributes().getNamedItem("id") + " version " + featureVersion + " from " + fi.fManifestFile.getLocation().toPortableString());
            Set<Node> featureRequires = ReleaseTool.getChildNodesNamed("requires", featureNode);
            for (Node required : featureRequires) {
                Set<Node> imports = ReleaseTool.getChildNodesNamed("import", required);
                for (Node imprt : imports) {
                    if (imprt.getAttributes().getNamedItem("feature") == null) continue;
                    String requiredFeatureID = imprt.getAttributes().getNamedItem("feature").getNodeValue();
                    Node requiredFeature = this.findFeature(requiredFeatureID);
                    if (this.fExclusions.contains(requiredFeatureID) || requiredFeature == null) continue;
                    String requiredFeatureVersion = requiredFeature.getChildNodes().item(0).getAttributes().getNamedItem("version").getNodeValue();
                    imprt.getAttributes().getNamedItem("version").setNodeValue(requiredFeatureVersion);
                }
            }
        }
    }

    public FeatureInfo findFeatureInfo(String featureID) {
        for (FeatureInfo fi : this.fFeatureInfos) {
            if (!fi.fFeatureID.equals(featureID)) continue;
            return fi;
        }
        return null;
    }

    protected Node findFeature(String featureID) {
        FeatureInfo fi = this.findFeatureInfo(featureID);
        if (fi != null) {
            return fi.fManifestDoc;
        }
        return null;
    }

    private void readOldPluginVersionMaps() {
        for (PluginInfo pi : this.fPluginInfos) {
            IProject project = this.fWSRoot.getProject(pi.fProjectName);
            FileVersionMap fvMap = new FileVersionMap(project, pi.fPluginID, pi.fPluginVersion);
            if (fvMap.isEmpty()) {
                ReleaseEngineeringPlugin.getMsgStream().println("No existing version map file for " + project.getName() + "; presumably a previously-unreleased project?");
            }
            pi.fCurMap = fvMap;
        }
    }

    private void buildNewPluginVersionMaps() {
        VersionScanner scanner = new VersionScanner();
        TreeSet<IFile> dirtyFiles = new TreeSet<IFile>(this.fFileComparator);
        for (PluginInfo pi : this.fPluginInfos) {
            IProject pluginProject = this.fWSRoot.getProject(pi.fProjectName);
            if (pluginProject == null) continue;
            FileVersionMap fileVersionMap = new FileVersionMap(pluginProject, pi.fPluginID, this.incrementVersionRelease(pi.fPluginVersion));
            RepositoryProvider repoProvider = RepositoryProvider.getProvider((IProject)pluginProject);
            if (repoProvider == null) continue;
            IFileHistoryProvider fileHistProvider = repoProvider.getFileHistoryProvider();
            if (fileHistProvider == null) {
                if (!(repoProvider instanceof SVNTeamProvider)) continue;
                fileHistProvider = new SubclipseFileHistoryProvider(pluginProject);
            }
            List<IPath> buildItems = this.readBuildProperties(pluginProject);
            dirtyFiles.addAll(scanner.scanSrcFolders(pluginProject, fileHistProvider, fileVersionMap));
            dirtyFiles.addAll(scanner.checkFile("plugin.xml", pluginProject, fileHistProvider, fileVersionMap));
            dirtyFiles.addAll(scanner.scanFolder("icons", pluginProject, fileHistProvider, fileVersionMap));
            dirtyFiles.addAll(scanner.scanFolder("templates", pluginProject, fileHistProvider, fileVersionMap));
            for (IPath path : buildItems) {
                if (pluginProject.getFolder(path).exists()) {
                    dirtyFiles.addAll(scanner.scanFolder(path.toPortableString(), pluginProject, fileHistProvider, fileVersionMap));
                    continue;
                }
                if (!pluginProject.getFile(path).exists()) continue;
                dirtyFiles.addAll(scanner.checkFile(path.toPortableString(), pluginProject, fileHistProvider, fileVersionMap));
            }
            pi.fNewMap = fileVersionMap;
        }
        this.fCanProceed = this.fCanProceed && this.confirmDirtyFiles(dirtyFiles);
    }

    protected boolean confirmDirtyFiles(Set<IFile> dirtyFiles) {
        if (dirtyFiles.isEmpty()) {
            return true;
        }
        MessageConsoleStream msgStream = ReleaseEngineeringPlugin.getMsgStream();
        msgStream.println("*** Dirty files: ***");
        for (IFile file : dirtyFiles) {
            msgStream.println("  " + file.getLocation().toPortableString());
        }
        return false;
    }

    private List<IPath> readBuildProperties(IProject pluginProject) {
        ArrayList<IPath> buildItems = new ArrayList<IPath>();
        try {
            String buildProperties = ReleaseTool.getFileContents(new InputStreamReader(pluginProject.getFile("build.properties").getContents()));
            List<String> stanzas = this.coalesceStanzas(buildProperties.split("\n"));
            for (String stanza : stanzas) {
                String[] paths;
                if (!stanza.startsWith("bin.includes")) continue;
                for (String path : paths = stanza.substring(stanza.indexOf(61) + 1).trim().split(",")) {
                    if (path.equals(".") || path.equals("bin/")) continue;
                    buildItems.add((IPath)new Path(path));
                }
            }
        }
        catch (CoreException e) {
            ReleaseEngineeringPlugin.logError((Exception)((Object)e));
        }
        return buildItems;
    }

    private List<String> coalesceStanzas(String[] stanzas) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < stanzas.length; ++i) {
            String stanza = stanzas[i].trim();
            if (stanza.endsWith(",\\") || stanza.endsWith(",\\")) {
                stanzas[i + 1] = stanza.replaceAll(",\\\\", ",") + stanzas[i + 1].trim();
                continue;
            }
            result.add(stanza);
        }
        return result;
    }

    private void scanPluginsForDiffs() {
        for (PluginInfo pi : this.fPluginInfos) {
            FileVersionMap oldMap = pi.fCurMap;
            FileVersionMap newMap = pi.fNewMap;
            if (this.fExclusions.contains(pi.fPluginID)) continue;
            if (oldMap == null || oldMap.getAllFiles().isEmpty()) {
                ReleaseEngineeringPlugin.getMsgStream().println("Plugin " + pi.fPluginID + " presumably previously unreleased; will build fresh version map.");
                pi.updateReason(PluginInfo.NewPluginChange.getInstance());
                continue;
            }
            Set<IFile> oldFiles = oldMap.getAllFilesSorted();
            for (IFile f : oldFiles) {
                if (newMap.getVersion(f) == null) {
                    ReleaseEngineeringPlugin.getMsgStream().println("Plugin " + pi.fPluginID + " changed due to changed/deleted file " + f.getFullPath().toPortableString());
                    pi.updateReason(new PluginInfo.FileDeleted(f.getFullPath()));
                    continue;
                }
                if (oldMap.getVersion(f).equals(newMap.getVersion(f))) continue;
                ReleaseEngineeringPlugin.getMsgStream().println("Plugin " + pi.fPluginID + " changed due to changed/deleted file " + f.getFullPath().toPortableString());
                pi.updateReason(new PluginInfo.FileChange(f.getFullPath()));
            }
            for (IFile newF : newMap.getAllFilesSorted()) {
                if (oldFiles.contains(newF)) continue;
                ReleaseEngineeringPlugin.getMsgStream().println("Plugin " + pi.fPluginID + " changed due to new file " + newF.getFullPath().toPortableString());
                pi.updateReason(new PluginInfo.FileAdded(newF.getFullPath()));
                break;
            }
            if (pi.getChangeState().isChange()) continue;
            ReleaseEngineeringPlugin.getMsgStream().println("Plugin " + pi.fPluginID + " unchanged.");
        }
    }

    private void writeNewPluginVersionMaps(List<IFile> changedFiles) {
        for (PluginInfo pi : this.fPluginInfos) {
            FileVersionMap newMap;
            IProject pluginProject;
            if (!pi.getChangeState().isChange() || (pluginProject = this.fWSRoot.getProject(pi.fProjectName)) == null || (newMap = pi.fNewMap) == null) continue;
            changedFiles.add(newMap.writeMap());
        }
    }

    protected void rewriteFeatureManifest(FeatureInfo featureInfo) {
        ArrayList<IFile> changedFiles = new ArrayList<IFile>();
        ArrayList<TextFileChange> changes = new ArrayList<TextFileChange>();
        try {
            this.rewriteFeatureManifest(featureInfo, changes, changedFiles);
            ReleaseTool.doPerformChange(changes, "Feature manifest edits", changedFiles);
        }
        catch (IOException e) {
            ReleaseEngineeringPlugin.logError(e);
        }
    }

    private void rewriteFeatureManifest(FeatureInfo fi, List<TextFileChange> changes, List<IFile> changedFiles) throws IOException {
        ReleaseEngineeringPlugin.getMsgStream().println("Rewriting feature manifest " + fi.fManifestFile.getLocation().toPortableString());
        try {
            Document manifestDoc = fi.fManifestDoc;
            DOMSource source = new DOMSource(manifestDoc);
            StringWriter strWriter = new StringWriter();
            StreamResult result = new StreamResult(strWriter);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("encoding", "ISO-8859-1");
            serializer.setOutputProperty("indent", "yes");
            serializer.transform(source, result);
            TextFileChange tfc = new TextFileChange("Version increment for " + fi.fFeatureID, fi.fManifestFile);
            long curFileLength = new File(fi.fManifestFile.getLocation().toOSString()).length();
            tfc.setEdit((TextEdit)new MultiTextEdit());
            tfc.addEdit((TextEdit)new ReplaceEdit(0, (int)curFileLength, strWriter.toString()));
            changedFiles.add(fi.fManifestFile);
            changes.add(tfc);
        }
        catch (TransformerConfigurationException e) {
            ReleaseEngineeringPlugin.logError(e);
        }
        catch (TransformerException e) {
            ReleaseEngineeringPlugin.logError(e);
        }
    }

    protected void rewriteFeatureManifests(List<TextFileChange> changes, List<IFile> changedFiles) {
        for (FeatureInfo fi : this.fFeatureInfos) {
            try {
                this.rewriteFeatureManifest(fi, changes, changedFiles);
            }
            catch (IOException io) {
                ReleaseEngineeringPlugin.logError(io);
            }
        }
    }

    private void rewritePluginManifests(List<TextFileChange> changes, List<IFile> changedFiles) {
        for (PluginInfo pi : this.fPluginInfos) {
            IFile manifest = pi.fManifest;
            ReleaseEngineeringPlugin.getMsgStream().println("Rewriting plugin manifest " + manifest.getLocation().toPortableString());
            TextFileChange tfc = new TextFileChange("Version increment for " + pi.fPluginID, manifest);
            File file = new File(manifest.getLocation().toOSString());
            long curFileLength = file.length();
            try {
                Pattern versionPattern = Pattern.compile("Bundle-Version: [0-9a-zA-Z]+(\\.[0-9a-zA-Z]+)*");
                String newVersionDecl = "Bundle-Version: " + pi.fPluginNewVersion;
                String oldContents = ReleaseTool.getFileContents(new FileReader(file));
                Matcher versionMatcher = versionPattern.matcher(oldContents);
                String newContents = versionMatcher.replaceFirst(newVersionDecl);
                tfc.setEdit((TextEdit)new MultiTextEdit());
                tfc.addEdit((TextEdit)new ReplaceEdit(0, (int)curFileLength, newContents));
                changes.add(tfc);
                changedFiles.add(manifest);
            }
            catch (FileNotFoundException fnf) {
                ReleaseEngineeringPlugin.logError(fnf);
            }
        }
    }

    protected static void doPerformChange(List<TextFileChange> changes, String editName, List<IFile> changedFiles) {
        ReleaseTool.doPerformChange(new CompositeChange(editName, changes.toArray(new Change[changes.size()])), editName, changedFiles);
    }

    protected static void doPerformChange(CompositeChange change, String editName, List<IFile> changedFiles) {
        change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
        PerformChangeOperation changeOp = new PerformChangeOperation((Change)change);
        try {
            changeOp.setUndoManager(RefactoringCore.getUndoManager(), editName);
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)changeOp, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ReleaseEngineeringPlugin.logError((Exception)((Object)e));
        }
        for (IFile f : changedFiles) {
            try {
                f.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                ReleaseEngineeringPlugin.logError((Exception)((Object)e));
            }
        }
    }

    public void updateFeatureProjectSets() {
        this.collectMetaData(false);
        List<FeatureInfo> selectedFeatures = this.fFeatureInfos;
        this.saveFeatureProjectSets(selectedFeatures);
    }

    public void writeSiteFeatureSet(UpdateSiteInfo siteInfo) {
        HashMap<String, Set<String>> repoRefMap = new HashMap<String, Set<String>>();
        for (UpdateSiteInfo.FeatureRef feature : siteInfo.fFeatureRefs) {
            Pair<String, String> repoDesc = this.getRepoRefForProject(feature.findProject());
            WorkbenchReleaseTool.addMapEntry(repoDesc.first, repoDesc.second, repoRefMap);
        }
        this.writeProjectSet(repoRefMap, siteInfo.fProject, "features.psf");
    }

    public void writeAllSiteFeatureSets() {
        for (UpdateSiteInfo siteInfo : this.fUpdateSiteInfos) {
            this.writeSiteFeatureSet(siteInfo);
        }
    }

    public void updateUpdateSites() {
        this.collectMetaData(true);
        if (this.fFeatureInfos.size() == 0) {
            return;
        }
        List<UpdateSiteInfo> sites = this.confirmUpdateSites();
        if (!sites.isEmpty() && this.addLatestFeaturesToUpdateSites(sites)) {
            this.rewriteUpdateSiteManifests(sites);
        } else {
            this.confirmNoSiteUpdates();
        }
    }

    protected abstract void confirmNoSiteUpdates();

    private boolean addLatestFeaturesToUpdateSites(List<UpdateSiteInfo> sites) {
        boolean anyChanges = false;
        for (UpdateSiteInfo site : sites) {
            HashSet<String> featureIDs = new HashSet<String>();
            for (UpdateSiteInfo.FeatureRef featRef : site.fFeatureRefs) {
                featureIDs.add(featRef.getID());
            }
            for (String featureID : featureIDs) {
                boolean change = site.addFeatureIfMissing(this.findFeatureInfo(featureID));
                anyChanges = anyChanges || change;
            }
        }
        return anyChanges;
    }

    protected abstract List<UpdateSiteInfo> confirmUpdateSites();

    protected void rewriteUpdateSiteManifests(List<UpdateSiteInfo> sites) {
        ArrayList<IFile> changedFiles = new ArrayList<IFile>();
        ArrayList<TextFileChange> changes = new ArrayList<TextFileChange>();
        for (UpdateSiteInfo site : sites) {
            site.rewriteManifest(changes, changedFiles);
        }
        ReleaseTool.doPerformChange(changes, "Update site edits", changedFiles);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Map<String, Set<String>> readProjectSet(IFile projectSetFile) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document featureSetDoc = docBuilder.parse(new File(projectSetFile.getLocation().toOSString()));
            Node psfNode = featureSetDoc.getFirstChild();
            NodeList providers = psfNode.getChildNodes();
            for (int i = 0; i < providers.getLength(); ++i) {
                Node provider = providers.item(i);
                if (!"provider".equals(provider.getNodeName())) continue;
                String providerType = provider.getAttributes().getNamedItem("id").getNodeValue();
                NodeList projects = provider.getChildNodes();
                for (int j = 0; j < projects.getLength(); ++j) {
                    Node project = projects.item(j);
                    if (!"project".equals(project.getNodeName())) continue;
                    String projectRef = project.getAttributes().getNamedItem("reference").getNodeValue();
                    ReleaseTool.addMapEntry(providerType, projectRef, result);
                }
            }
            return result;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return result;
        }
        catch (IOException e) {
            if (!(e instanceof FileNotFoundException)) return result;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<FeatureInfo> readUpdateFeatureInfos(UpdateSiteInfo siteInfo) {
        IProject updateProject = siteInfo.fProject;
        IFile featureSetFile = updateProject.getFile("features.psf");
        Map<String, Set<String>> providerToProjectRefs = this.readProjectSet(featureSetFile);
        ArrayList<FeatureInfo> result = new ArrayList<FeatureInfo>();
        for (Set<String> projectRefs : providerToProjectRefs.values()) {
            for (String projectRef : projectRefs) {
                String projectName = projectRef.substring(projectRef.lastIndexOf(44) + 1);
                if (projectName.endsWith(".feature")) {
                    projectName = projectName.substring(0, projectName.lastIndexOf(".feature"));
                }
                result.add(this.findFeatureInfo(projectName));
            }
        }
        return result;
    }

    protected static List<IFileRevision> getRevisionsSinceLastRelease(IFile file, PluginInfo pi, IFileHistoryProvider histProvider) {
        ArrayList<IFileRevision> result = new ArrayList<IFileRevision>();
        IFileHistory fileHistory = histProvider.getFileHistoryFor((IResource)file, 0, (IProgressMonitor)new NullProgressMonitor());
        IFileRevision[] revs = fileHistory.getFileRevisions();
        String curRev = pi.fCurMap.getVersion(file);
        String wsRev = histProvider.getWorkspaceFileRevision((IResource)file).getContentIdentifier();
        for (int i = 0; i < revs.length; ++i) {
            IFileRevision rev = revs[i];
            String revID = rev.getContentIdentifier();
            if (curRev != null && (ReleaseTool.compareRevs(curRev, revID) >= 0 || ReleaseTool.compareRevs(revID, wsRev) > 0)) continue;
            result.add(rev);
        }
        return result;
    }

    protected static int compareRevs(String revA, String revB) {
        String[] revAComps = revA.split("\\.");
        String[] revBComps = revB.split("\\.");
        for (int i = 0; i < Math.min(revAComps.length, revBComps.length); ++i) {
            int comp = Integer.valueOf(revAComps[i]).compareTo(Integer.valueOf(revBComps[i]));
            if (comp < 0) {
                return -1;
            }
            if (comp <= 0) continue;
            return 1;
        }
        if (revAComps.length < revBComps.length) {
            return -1;
        }
        if (revAComps.length > revBComps.length) {
            return 1;
        }
        return 0;
    }

    protected boolean isDirty(IFile file) {
        try {
            return ReleaseTool.getCVSSubscriber().isDirty((IResource)file, null);
        }
        catch (CVSException e) {
            return false;
        }
    }

    public abstract boolean retrieveFeatures(boolean var1);

    public abstract boolean retrievePlugins(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getProjectsFromRefs(Map<String, Set<String>> projectRefs, IProgressMonitor monitor) {
        MessageConsoleStream msgStream = ReleaseEngineeringPlugin.getMsgStream();
        monitor.beginTask("Retrieving projects", this.collectSetsFromMap(projectRefs).size());
        try {
            for (String providerTypeID : projectRefs.keySet()) {
                RepositoryProviderType repoType = RepositoryProviderType.getProviderType((String)providerTypeID);
                ProjectSetCapability projectSetCapability = repoType.getProjectSetCapability();
                ArrayList sortedProjectRefs = new ArrayList();
                sortedProjectRefs.addAll(projectRefs.get(providerTypeID));
                Collections.sort(sortedProjectRefs);
                for (String projectRef : sortedProjectRefs) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    String projectName = projectSetCapability.getProject(projectRef);
                    monitor.subTask("Retrieving " + projectName);
                    try {
                        projectSetCapability.addToWorkspace(new String[]{projectRef}, new ProjectSetSerializationContext(), monitor);
                    }
                    catch (TeamException e) {
                        msgStream.println("Exception encountered while retrieving " + projectName);
                    }
                    monitor.worked(1);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void retrieveProjectsWithProgress(final Map<String, Set<String>> projectRefs) {
        IWorkspace workspace = this.fWSRoot.getWorkspace();
        IWorkspaceDescription wsDesc = workspace.getDescription();
        boolean wasAutoBuilding = wsDesc.isAutoBuilding();
        if (this.fTemporarilySuppressAutoBuild && wasAutoBuilding) {
            this.setAutoBuilding(false, workspace, wsDesc);
        }
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ReleaseTool.this.getProjectsFromRefs(projectRefs, monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            this.postError("Exception encountered while retrieving projects: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.fTemporarilySuppressAutoBuild && wasAutoBuilding) {
            this.setAutoBuilding(wasAutoBuilding, workspace, wsDesc);
        }
    }

    private void setAutoBuilding(boolean b, IWorkspace workspace, IWorkspaceDescription wsDesc) {
        wsDesc.setAutoBuilding(b);
        try {
            workspace.setDescription(wsDesc);
        }
        catch (CoreException e) {
            // empty catch block
        }
    }

    public void retrieveProject(String projectRef, String providerType) {
        HashMap<String, Set<String>> projectRefs = new HashMap<String, Set<String>>();
        projectRefs.put(providerType, Collections.singleton(projectRef));
        this.retrieveProjectsWithProgress(projectRefs);
    }

    protected String projectNameFromProjectRef(String projectRef, ProjectSetCapability projectSetCapability) {
        String projectName = projectSetCapability.getProject(projectRef);
        if (projectName == null) {
            projectName = projectRef.substring(projectRef.lastIndexOf(44) + 1);
        }
        return projectName;
    }

    protected <K, V> List<V> collectSetsFromMap(Map<K, Set<V>> map) {
        ArrayList<V> result = new ArrayList<V>();
        for (Set<V> s : map.values()) {
            result.addAll(s);
        }
        return result;
    }

    protected <K, V> void mergeMapInto(Map<K, Set<V>> src, Map<K, Set<V>> dest) {
        for (K key : src.keySet()) {
            for (V value : src.get(key)) {
                ReleaseTool.addMapEntry(key, value, dest);
            }
        }
    }

    protected List<String> collectProjectNamesFromProviderMap(Map<String, Set<String>> map) {
        ArrayList<String> result = new ArrayList<String>();
        for (String providerTypeID : map.keySet()) {
            RepositoryProviderType repoType = RepositoryProviderType.getProviderType((String)providerTypeID);
            ProjectSetCapability projectSetCapability = repoType.getProjectSetCapability();
            for (String projectRef : map.get(providerTypeID)) {
                String projectName = this.projectNameFromProjectRef(projectRef, projectSetCapability);
                result.add(projectName);
            }
        }
        Collections.sort(result);
        return result;
    }

    public void tagFeatures() {
        this.collectMetaData(true);
        List<FeatureInfo> featureInfos = this.selectFeatureInfos();
        final Map<IProject, String> projectTagMap = this.collectProjectTags(featureInfos);
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ReleaseTool.this.tagFeatureProjects(projectTagMap, monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            this.postError("Exception encountered while retrieving projects: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            this.postError("Exception encountered while retrieving projects: " + e.getMessage(), e);
        }
    }

    private Map<IProject, String> collectProjectTags(List<FeatureInfo> featureInfos) {
        HashMap<IProject, String> result = new HashMap<IProject, String>();
        for (FeatureInfo featureInfo : featureInfos) {
            String featureID = featureInfo.fFeatureID;
            String featureVersion = featureInfo.fFeatureVersion;
            IProject project = featureInfo.fProject;
            RepositoryProvider repoProvider = RepositoryProvider.getProvider((IProject)project);
            String featureTag = repoProvider.getID().contains("subclipse") ? featureVersion : featureID.replace('.', '-') + "_" + featureVersion.replace('.', '_');
            result.put(project, featureTag);
            Set<PluginInfo> plugins = featureInfo.fPluginInfos;
            for (PluginInfo pluginInfo : plugins) {
                IProject pluginProject = this.fWSRoot.getProject(pluginInfo.fProjectName);
                if (pluginProject == null) {
                    this.postError("Unable to find project for plugin " + pluginInfo.fPluginID, null);
                    continue;
                }
                String pluginVersion = pluginInfo.fPluginVersion;
                String pluginTag = repoProvider.getID().contains("subclipse") ? pluginVersion : featureID.replace('.', '-') + "_" + featureVersion.replace('.', '_');
                result.put(pluginProject, pluginTag);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tagFeatureProjects(Map<IProject, String> projectTagMap, IProgressMonitor progress) {
        int scale = projectTagMap.keySet().size();
        progress.beginTask(null, 100 * scale);
        for (IProject project : projectTagMap.keySet()) {
            String projectTag = projectTagMap.get(project);
            RepositoryProvider repoProvider = RepositoryProvider.getProvider((IProject)project);
            if (repoProvider.getID().contains("subclipse")) {
                try {
                    SVNTeamProvider svnProvider = (SVNTeamProvider)repoProvider;
                    SVNWorkspaceRoot svnRoot = svnProvider.getSVNWorkspaceRoot();
                    SVNUrl projTrunkURL = SVNWorkspaceRoot.getSVNFolderFor((IContainer)project).getUrl();
                    SVNUrl projTagURL = projTrunkURL.getParent().appendPath("/tags/release-" + projectTag);
                    BranchTagCommand tagCmd = new BranchTagCommand(svnRoot, new IResource[]{project}, new SVNUrl[]{projTrunkURL}, projTagURL, "tagged for latest release", true, SVNRevision.HEAD);
                    tagCmd.run((IProgressMonitor)new SubProgressMonitor(progress, 1));
                    continue;
                }
                catch (TeamException e) {
                    MessageConsoleStream msgStream = ReleaseEngineeringPlugin.getMsgStream();
                    msgStream.println(e.getMessage());
                    StackTraceElement[] st = e.getStackTrace();
                    for (int i = 0; i < st.length; ++i) {
                        msgStream.println(st[i].toString());
                    }
                    continue;
                }
            }
            HashSet localOptions = new HashSet();
            Command.LocalOption[] commandOptions = localOptions.toArray(new Command.LocalOption[localOptions.size()]);
            commandOptions = Command.DO_NOT_RECURSE.removeFrom(commandOptions);
            CVSTag tag = new CVSTag(projectTag, 2);
            CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)project);
            String[] arguments = this.getStringArguments(new IResource[]{project});
            Session s = null;
            try {
                CVSWorkspaceRoot root = provider.getCVSWorkspaceRoot();
                s = new Session(root.getRemoteLocation(), root.getLocalRoot());
                s.open(this.subMonitorFor(progress, 20), true);
                IStatus status = Command.TAG.execute(s, Command.NO_GLOBAL_OPTIONS, commandOptions, tag, arguments, null, this.subMonitorFor(progress, 80));
                if (status.getSeverity() == 0) continue;
                System.err.println("Tag command execution finished: " + status.getMessage());
                IStatus[] children = status.getChildren();
                if (children == null || children.length <= 0) continue;
                for (int i = 0; i < children.length; ++i) {
                    System.err.println(children[i].getMessage());
                }
            }
            catch (CVSException e) {
                e.printStackTrace();
            }
            finally {
                if (s == null) continue;
                s.close();
            }
        }
        progress.done();
    }

    private IProgressMonitor subMonitorFor(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        return new SubProgressMonitor(monitor, ticks);
    }

    protected String[] getStringArguments(IResource[] resources) {
        ArrayList<String> arguments = new ArrayList<String>(resources.length);
        for (int i = 0; i < resources.length; ++i) {
            IPath cvsPath = resources[i].getFullPath().removeFirstSegments(1);
            if (cvsPath.segmentCount() == 0) {
                arguments.add(".");
                continue;
            }
            arguments.add(cvsPath.toString());
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    private static CVSWorkspaceSubscriber getCVSSubscriber() {
        return CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber();
    }

    public static Set<Node> getChildNodesNamed(String name, Node parent) {
        HashSet<Node> result = new HashSet<Node>();
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals(name)) continue;
            result.add(child);
        }
        return result;
    }

    public static String getFileContents(Reader reader) {
        StringBuilder sb = new StringBuilder(4096);
        char[] buff = new char[4096];
        while (true) {
            int len;
            try {
                len = reader.read(buff);
            }
            catch (IOException e) {
                break;
            }
            if (len < 0) break;
            sb.append(buff, 0, len);
        }
        return sb.toString();
    }

    public UpdateSiteInfo findSiteByName(String name) {
        for (UpdateSiteInfo siteInfo : this.fUpdateSiteInfos) {
            if (!siteInfo.fProject.getName().equals(name)) continue;
            return siteInfo;
        }
        return null;
    }

    public abstract void updateFeatureList();

    public class SubclipseFileHistoryProvider
    extends FileHistoryProvider
    implements IFileHistoryProvider {
        private final IProject fProject;

        public SubclipseFileHistoryProvider(IProject project) {
            this.fProject = project;
        }

        public IFileHistory getFileHistoryFor(IResource resource, int flags, IProgressMonitor monitor) {
            return new SubclipseFileHistory(resource);
        }

        public IFileHistory getFileHistoryFor(IFileStore store, int flags, IProgressMonitor monitor) {
            IFile file = this.fProject.getFile(store.fetchInfo().getName());
            return new SubclipseFileHistory((IResource)file);
        }

        public IFileRevision getWorkspaceFileRevision(IResource resource) {
            return this.getFileHistoryFor(resource, 0, null).getFileRevisions()[0];
        }
    }

    private class SubclipseFileHistory
    extends FileHistory {
        protected IFileRevision[] revisions;

        public SubclipseFileHistory(IResource svnRsrc) {
            ISVNLocalFile f = SVNWorkspaceRoot.getSVNFileFor((IFile)((IFile)svnRsrc));
            try {
                ISVNRemoteResource latestRsrc = SVNWorkspaceRoot.getLatestResourceFor((IResource)svnRsrc);
                final ISVNRemoteFile latestRemote = (ISVNRemoteFile)latestRsrc;
                final SVNRevision.Number revNum = latestRemote.getLastChangedRevision();
                this.revisions = new IFileRevision[]{new FileRevision(){

                    public String getContentIdentifier() {
                        return revNum.toString();
                    }

                    public String getAuthor() {
                        return latestRemote.getAuthor();
                    }

                    public String getName() {
                        return revNum.toString();
                    }

                    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
                        return null;
                    }

                    public boolean isPropertyMissing() {
                        return false;
                    }

                    public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
                        return this;
                    }
                }};
            }
            catch (SVNException e) {
                e.printStackTrace();
            }
        }

        public IFileRevision[] getContributors(IFileRevision revision) {
            return new IFileRevision[0];
        }

        public IFileRevision getFileRevision(String id) {
            IFileRevision[] revisions = this.getFileRevisions();
            for (int i = 0; i < revisions.length; ++i) {
                if (!revisions[i].getContentIdentifier().equals(id)) continue;
                return revisions[i];
            }
            return null;
        }

        public IFileRevision[] getFileRevisions() {
            return this.revisions;
        }

        public IFileRevision[] getTargets(IFileRevision revision) {
            return new IFileRevision[0];
        }
    }
}

