/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.releng;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.IAntClasspathEntry;
import org.eclipse.ant.core.Task;
import org.eclipse.ant.internal.core.AntClasspathEntry;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchShortcut;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.imp.releng.ReleaseEngineeringPlugin;
import org.eclipse.imp.releng.ReleaseTool;
import org.eclipse.imp.releng.dialogs.ConfirmChangedPluginsDialog;
import org.eclipse.imp.releng.dialogs.ConfirmDirtyFilesDialog;
import org.eclipse.imp.releng.dialogs.ConfirmProjectRetrievalDialog;
import org.eclipse.imp.releng.dialogs.ConfirmUpdateSitesDialog;
import org.eclipse.imp.releng.dialogs.FeatureSetDialog;
import org.eclipse.imp.releng.dialogs.SelectFeatureInfosDialog;
import org.eclipse.imp.releng.dialogs.SelectFeatureProjectsDialog;
import org.eclipse.imp.releng.metadata.FeatureInfo;
import org.eclipse.imp.releng.metadata.PluginInfo;
import org.eclipse.imp.releng.metadata.UpdateSiteInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsoleStream;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkbenchReleaseTool
extends ReleaseTool {
    private static final List<TemplateInfo> sPluginTemplates = new ArrayList<TemplateInfo>();
    private static final List<TemplateInfo> sFeatureTemplates = new ArrayList<TemplateInfo>();
    private static final List<TemplateInfo> sUpdateTemplates = new ArrayList<TemplateInfo>();

    public static void dumpRecentRevisionsInfo(PluginInfo pi, MessageConsoleStream mcs, IFileHistoryProvider histProvider, PluginInfo.ResourceChange rc, IFile file) {
        List<IFileRevision> recentRevs = WorkbenchReleaseTool.getRevisionsSinceLastRelease(file, pi, histProvider);
        mcs.println(rc.getPath().toPortableString() + ": " + rc.getType());
        for (IFileRevision rev : recentRevs) {
            mcs.println("  " + rev.getContentIdentifier() + ": " + rev.getAuthor() + ": " + rev.getComment());
        }
    }

    protected Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    @Override
    protected void postError(String errorMsg, Exception e) {
        MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)errorMsg);
        ReleaseEngineeringPlugin.getMsgStream().println(errorMsg);
    }

    @Override
    protected Set<IProject> selectFeatureProjects(Set<IProject> allFeatureProjects) {
        HashSet<IProject> selectedFeatureProjects = new HashSet<IProject>();
        SelectFeatureProjectsDialog featureDialog = new SelectFeatureProjectsDialog(this.getShell(), allFeatureProjects, selectedFeatureProjects);
        if (featureDialog.open() == 0) {
            return selectedFeatureProjects;
        }
        return Collections.emptySet();
    }

    @Override
    protected List<FeatureInfo> selectFeatureInfos() {
        SelectFeatureInfosDialog featureDialog = new SelectFeatureInfosDialog(this.getShell(), this.fFeatureInfos);
        if (featureDialog.open() == 0) {
            return featureDialog.getSelectedFeatures();
        }
        return Collections.emptyList();
    }

    public void run() {
        Shell shell = this.getShell();
        Dialog d = new Dialog(shell){

            protected Control createDialogArea(Composite parent) {
                Composite area = (Composite)super.createDialogArea(parent);
                GridLayout grid = new GridLayout(3, true);
                area.setLayout((Layout)grid);
                Button saveFeatureProjectSetsButton = new Button(area, 8);
                saveFeatureProjectSetsButton.setText("Save Feature Project Sets...");
                Button checkOutButton = new Button(area, 8);
                checkOutButton.setText("Check out...");
                return area;
            }
        };
        d.open();
    }

    @Override
    protected boolean doConfirm(Set<PluginInfo> changedPlugins, Set<PluginInfo> unchangedPlugins) {
        Shell shell = this.getShell();
        if (changedPlugins.isEmpty()) {
            MessageDialog.openInformation((Shell)shell, (String)"No plugins to release", (String)"No plugins in the selected features have any changes to release!");
            return false;
        }
        ConfirmChangedPluginsDialog confirmDialog = new ConfirmChangedPluginsDialog(shell, changedPlugins, unchangedPlugins);
        return confirmDialog.open() == 0;
    }

    @Override
    protected boolean confirmDirtyFiles(Set<IFile> dirtyFiles) {
        if (dirtyFiles.isEmpty()) {
            return true;
        }
        Shell shell = this.getShell();
        ConfirmDirtyFilesDialog d = new ConfirmDirtyFilesDialog(shell, dirtyFiles);
        return d.open() == 0;
    }

    private void showDetails(PluginInfo pi) {
        MessageConsoleStream mcs = ReleaseEngineeringPlugin.getMsgStream();
        List<PluginInfo.ChangeReason> changes = pi.getAllChanges();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject proj = wsRoot.getProject(pi.fProjectName);
        IFileHistoryProvider histProvider = RepositoryProvider.getProvider((IProject)proj).getFileHistoryProvider();
        for (PluginInfo.ChangeReason change : changes) {
            if (change instanceof PluginInfo.ResourceChange) {
                PluginInfo.ResourceChange rc = (PluginInfo.ResourceChange)change;
                IFile file = (IFile)wsRoot.findMember(rc.getPath());
                WorkbenchReleaseTool.dumpRecentRevisionsInfo(pi, mcs, histProvider, rc, file);
                continue;
            }
            mcs.println(change.toString());
        }
        try {
            mcs.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected List<UpdateSiteInfo> confirmUpdateSites() {
        Shell shell = this.getShell();
        if (this.fUpdateSiteInfos.isEmpty()) {
            MessageDialog.openInformation((Shell)shell, (String)"Nothing to update", (String)"No update sites found!");
        } else {
            ConfirmUpdateSitesDialog confirmDialog = new ConfirmUpdateSitesDialog(shell, this.fUpdateSiteInfos);
            if (confirmDialog.open() == 0) {
                return confirmDialog.getSites();
            }
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    protected void confirmNoSiteUpdates() {
        Shell shell = this.getShell();
        MessageDialog.openWarning((Shell)shell, (String)"Nothing to update", (String)"No update sites need updating");
    }

    @Override
    public void updateFeatureList() {
        this.collectMetaData(true);
        if (this.fFeatureInfos.size() == 0) {
            return;
        }
        FeatureSetDialog d = new FeatureSetDialog(this.getShell(), this.fUpdateSiteInfos, this);
        d.open();
    }

    @Override
    protected boolean confirmShareProject(IProject project) {
        return false;
    }

    @Override
    public boolean retrieveFeatures(boolean anonAccess) {
        this.collectMetaData(true);
        ConfirmUpdateSitesDialog d = new ConfirmUpdateSitesDialog(this.getShell(), this.fUpdateSiteInfos);
        if (d.open() != 0) {
            return false;
        }
        List<UpdateSiteInfo> sites = d.getSites();
        return this.retrieveFeatures(sites, anonAccess);
    }

    public boolean retrieveFeatures(List<UpdateSiteInfo> sites, boolean anonAccess) {
        HashMap<String, Set<String>> featureProjectMap = new HashMap<String, Set<String>>();
        for (UpdateSiteInfo siteInfo : sites) {
            IProject updateProject = siteInfo.fProject;
            IFile featureSetFile = updateProject.getFile(anonAccess ? "featuresAnon.psf" : "features.psf");
            Map<String, Set<String>> providerToRefs = this.readProjectSet(featureSetFile);
            this.mergeMapInto(providerToRefs, featureProjectMap);
        }
        List<String> allProjects = this.collectProjectNamesFromProviderMap(featureProjectMap);
        ConfirmProjectRetrievalDialog cprd = new ConfirmProjectRetrievalDialog(this.getShell(), allProjects);
        if (cprd.open() == 0) {
            this.retrieveProjectsWithProgress(featureProjectMap);
            return true;
        }
        return false;
    }

    @Override
    public boolean retrievePlugins(boolean anonAccess) {
        this.collectMetaData(true);
        if (this.fFeatureInfos.size() == 0) {
            return false;
        }
        SelectFeatureInfosDialog d = new SelectFeatureInfosDialog(this.getShell(), this.fFeatureInfos);
        if (d.open() != 0) {
            return false;
        }
        List<FeatureInfo> featureInfos = d.getSelectedFeatures();
        return this.retrievePlugins(featureInfos, anonAccess);
    }

    public boolean retrievePlugins(List<FeatureInfo> featureInfos, boolean anonAccess) {
        HashMap<String, Set<String>> pluginProjectRefs = new HashMap<String, Set<String>>();
        for (FeatureInfo featureInfo : featureInfos) {
            IProject featureProject = featureInfo.fProject;
            IFile projectSetFile = featureProject.getFile(anonAccess ? "pluginsAnon.psf" : "plugins.psf");
            Map<String, Set<String>> providerToRefs = this.readProjectSet(projectSetFile);
            this.mergeMapInto(providerToRefs, pluginProjectRefs);
            IFile extraProjectSetFile = featureProject.getFile(anonAccess ? "extraProjectsAnon.psf" : "extraProjects.psf");
            if (!extraProjectSetFile.exists()) continue;
            Map<String, Set<String>> extraProviderToRefs = this.readProjectSet(extraProjectSetFile);
            this.mergeMapInto(extraProviderToRefs, pluginProjectRefs);
        }
        List<String> allProjects = this.collectProjectNamesFromProviderMap(pluginProjectRefs);
        ConfirmProjectRetrievalDialog cprd = new ConfirmProjectRetrievalDialog(this.getShell(), allProjects);
        if (cprd.open() == 0) {
            this.retrieveProjectsWithProgress(pluginProjectRefs);
            return true;
        }
        return false;
    }

    public void buildRelease() {
        this.collectMetaData(true);
        ConfirmUpdateSitesDialog d = new ConfirmUpdateSitesDialog(this.getShell(), this.fUpdateSiteInfos);
        if (d.open() != 0) {
            return;
        }
        AntCorePreferences acp = AntCorePlugin.getPlugin().getPreferences();
        this.maybeCreateImpAntClasspathEntry(acp);
        this.maybeCreateImpForTaskEntry(acp);
        List<UpdateSiteInfo> sites = d.getSites();
        for (UpdateSiteInfo updateSiteInfo : sites) {
            IFile buildScript = updateSiteInfo.fProject.getFile("exportUpdate.xml");
            if (!buildScript.exists()) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Unable to find build script", (String)("The build script exportUpdate.xml does not exist in project " + updateSiteInfo.fProject.getName()));
            }
            AntLaunchShortcut als = new AntLaunchShortcut();
            als.setShowDialog(false);
            als.launch(buildScript, "run", "build.update.zip");
        }
    }

    private void maybeCreateImpAntClasspathEntry(AntCorePreferences acp) {
        IAntClasspathEntry[] addlCPEntries = acp.getAdditionalClasspathEntries();
        for (int i = 0; i < addlCPEntries.length; ++i) {
            IAntClasspathEntry entry = addlCPEntries[i];
            if (!entry.getEntryURL().getPath().contains("ant-imp.jar")) continue;
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)"Ant configuration missing classpath entry for 'for' task", (String)"Add the necessary classpath entry?")) {
            return;
        }
        try {
            IAntClasspathEntry[] newEntries = new IAntClasspathEntry[addlCPEntries.length + 1];
            Bundle relengBundle = Platform.getBundle((String)"org.eclipse.imp.releng");
            URL jarLoc = FileLocator.toFileURL((URL)FileLocator.find((Bundle)relengBundle, (IPath)new Path("ant-imp.jar"), null));
            System.arraycopy(addlCPEntries, 0, newEntries, 0, addlCPEntries.length);
            newEntries[addlCPEntries.length] = new AntClasspathEntry(jarLoc);
            acp.setAdditionalClasspathEntries(newEntries);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void maybeCreateImpForTaskEntry(AntCorePreferences acp) {
        List allTasks = acp.getTasks();
        for (Task task : allTasks) {
            if (!task.getTaskName().equals("for")) continue;
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)"Ant configuration missing necessary task entry", (String)"Add the necessary entry for the 'for' task?")) {
            return;
        }
        Task newTask = new Task();
        newTask.setClassName("org.eclipse.imp.ant.ForTask");
        newTask.setTaskName("for");
        acp.setCustomTasks(new Task[]{newTask});
    }

    public void addReleaseScripts() {
        this.collectMetaData(true);
        if (this.fFeatureInfos.size() == 0) {
            return;
        }
        Bundle relengBundle = ReleaseEngineeringPlugin.getInstance().getBundle();
        List<UpdateSiteInfo> updateSites = this.confirmUpdateSites();
        NullProgressMonitor monitor = new NullProgressMonitor();
        for (UpdateSiteInfo updateSiteInfo : updateSites) {
            HashMap<String, String> updateSubs = new HashMap<String, String>();
            StringBuilder sb = new StringBuilder();
            for (UpdateSiteInfo.FeatureRef featRef : updateSiteInfo.fFeatureRefs) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(featRef.getID());
            }
            String featureNames = sb.toString();
            updateSubs.put("%%UPDATE_PROJ_NAME%%", updateSiteInfo.fProject.getName());
            updateSubs.put("%%FEATURE_NAME_LIST%%", featureNames);
            for (TemplateInfo updateTemplate : sUpdateTemplates) {
                this.instantiateTemplate(updateTemplate.getTemplateName(), "updateTemplates/", updateSiteInfo.fProject, updateTemplate.getDestPath(), updateSubs, relengBundle, (IProgressMonitor)monitor);
            }
            for (UpdateSiteInfo.FeatureRef featureRef : updateSiteInfo.fFeatureRefs) {
                FeatureInfo featureInfo = this.findFeatureInfo(featureRef.getID());
                HashMap<String, String> featureSubs = new HashMap<String, String>();
                featureSubs.put("%%FEATURE_ID%%", featureRef.getID());
                featureSubs.put("%%FEATURE_PROJ_NAME%%", featureInfo.fProject.getName());
                featureSubs.putAll(updateSubs);
                for (TemplateInfo featureTemplate : sFeatureTemplates) {
                    this.instantiateTemplate(featureTemplate.getTemplateName(), "featureTemplates/", featureInfo.fProject, featureTemplate.getDestPath(), featureSubs, relengBundle, (IProgressMonitor)monitor);
                }
                for (PluginInfo pluginInfo : featureInfo.fPluginInfos) {
                    IProject pluginProject = pluginInfo.fManifest.getProject();
                    HashMap<String, String> pluginSubs = new HashMap<String, String>();
                    pluginSubs.put("%%PLUGIN_ID%%", pluginInfo.fPluginID);
                    pluginSubs.putAll(featureSubs);
                    for (TemplateInfo pluginTemplate : sPluginTemplates) {
                        this.instantiateTemplate(pluginTemplate.getTemplateName(), "pluginTemplates/", pluginProject, pluginTemplate.getDestPath(), pluginSubs, relengBundle, (IProgressMonitor)monitor);
                    }
                }
            }
        }
    }

    private void instantiateTemplate(String templateName, String templatePath, IProject destProject, String destPath, Map<String, String> substitutions, Bundle relengBundle, IProgressMonitor monitor) {
        try {
            URL localURL = FileLocator.toFileURL((URL)FileLocator.find((Bundle)relengBundle, (IPath)new Path(templatePath + templateName), null));
            String path = localURL.getPath();
            FileInputStream fis = new FileInputStream(path);
            DataInputStream is = new DataInputStream(fis);
            byte[] bytes = new byte[fis.available()];
            is.readFully(bytes);
            is.close();
            fis.close();
            String templateSrc = new String(bytes);
            String substSrc = WorkbenchReleaseTool.performSubstitutions(templateSrc, substitutions);
            IFile destFile = destProject.getFile((IPath)new Path(destPath + templateName));
            if (destFile.exists()) {
                destFile.setContents((InputStream)new ByteArrayInputStream(substSrc.getBytes()), true, true, monitor);
            } else {
                if (destPath.length() > 0) {
                    WorkbenchReleaseTool.createSubFolders(destPath, destProject, monitor);
                }
                destFile.create((InputStream)new ByteArrayInputStream(substSrc.getBytes()), true, monitor);
            }
        }
        catch (IOException e) {
            ReleaseEngineeringPlugin.getMsgStream().println(e.getMessage());
        }
        catch (CoreException e) {
            ReleaseEngineeringPlugin.getMsgStream().println(e.getMessage());
        }
    }

    public static String performSubstitutions(String contents, Map<String, String> replacements) {
        StringBuffer buffer = new StringBuffer(contents);
        for (String key : replacements.keySet()) {
            String value = replacements.get(key);
            if (value == null) continue;
            WorkbenchReleaseTool.replace(buffer, key, value);
        }
        return buffer.toString();
    }

    public static void replace(StringBuffer sb, String target, String substitute) {
        int index = sb.indexOf(target);
        while (index != -1) {
            sb.replace(index, index + target.length(), substitute);
            index = sb.indexOf(target);
        }
    }

    public static void createSubFolders(String folder, IProject project, IProgressMonitor monitor) throws CoreException {
        String[] subFolderNames = folder.split("[\\" + File.separator + "\\/]");
        String subFolderStr = "";
        for (int i = 0; i < subFolderNames.length; ++i) {
            String childPath = subFolderStr + "/" + subFolderNames[i];
            Path subFolderPath = new Path(childPath);
            IFolder subFolder = project.getFolder((IPath)subFolderPath);
            if (!subFolder.exists()) {
                subFolder.create(true, true, monitor);
            }
            subFolderStr = childPath;
        }
    }

    static {
        sPluginTemplates.add(new TemplateInfo("exportPlugin.xml", ""));
        sFeatureTemplates.add(new TemplateInfo("buildCommon.xml", ""));
        sFeatureTemplates.add(new TemplateInfo("exportFeature.xml", ""));
        sUpdateTemplates.add(new TemplateInfo("buildCommon.xml", ""));
        sUpdateTemplates.add(new TemplateInfo("buildFeatureCommon.xml", ""));
        sUpdateTemplates.add(new TemplateInfo("buildPluginCommon.xml", ""));
        sUpdateTemplates.add(new TemplateInfo("exportUpdate.xml", ""));
    }

    private static class TemplateInfo {
        private final String fTemplateName;
        private final String fDestPath;

        public TemplateInfo(String templateName, String destPath) {
            this.fTemplateName = templateName;
            this.fDestPath = destPath;
        }

        public String getTemplateName() {
            return this.fTemplateName;
        }

        public String getDestPath() {
            return this.fDestPath;
        }
    }
}

