/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.releng.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.imp.releng.ReleaseTool;
import org.eclipse.imp.releng.metadata.FeatureInfo;
import org.eclipse.imp.releng.metadata.UpdateSiteInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureSetDialog
extends Dialog {
    private final List<UpdateSiteInfo> fSites;
    private static final int FEATURE_ID_COLUMN = 0;
    private static final String FEATURE_ID_PROPERTY = "featureID";
    private List<String> fValidFeatures = new ArrayList<String>();
    private UpdateSiteInfo fSite;
    private List<FeatureTableItem> fItems = new ArrayList<FeatureTableItem>();
    private Combo fSiteCombo;
    private TableViewer fTableViewer;
    private final ReleaseTool fReleaseTool;

    public FeatureSetDialog(Shell shell, List<UpdateSiteInfo> sites, ReleaseTool releaseTool) {
        super(shell);
        this.fSites = sites;
        this.fReleaseTool = releaseTool;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button proceedButton = this.createButton(parent, 0, "Proceed", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        proceedButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                for (int i = 0; i < FeatureSetDialog.this.fItems.size(); ++i) {
                    FeatureTableItem item = (FeatureTableItem)FeatureSetDialog.this.fItems.get(i);
                    FeatureSetDialog.this.fSite.addFeatureIfMissing(FeatureSetDialog.this.fReleaseTool.findFeatureInfo(item.fFeatureId));
                }
                FeatureSetDialog.this.fReleaseTool.writeSiteFeatureSet(FeatureSetDialog.this.fSite);
            }
        });
    }

    private void createCellEditor(final TableViewer tableViewer) {
        Table table = tableViewer.getTable();
        tableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                if (FeatureSetDialog.FEATURE_ID_PROPERTY.equals(property)) {
                    return FeatureSetDialog.this.fValidFeatures.indexOf(((FeatureTableItem)element).fFeatureId);
                }
                return -1;
            }

            public void modify(Object element, String property, Object value) {
                int idx;
                TableItem tableItem = (TableItem)element;
                FeatureTableItem data = (FeatureTableItem)tableItem.getData();
                if (FeatureSetDialog.FEATURE_ID_PROPERTY.equals(property) && (idx = ((Integer)value).intValue()) >= 0) {
                    data.setName((String)FeatureSetDialog.this.fValidFeatures.get(idx));
                }
                tableViewer.refresh((Object)data);
            }
        });
        ComboBoxCellEditor featureEditor = new ComboBoxCellEditor((Composite)table, this.fValidFeatures.toArray(new String[this.fValidFeatures.size()]));
        tableViewer.setCellEditors(new CellEditor[]{featureEditor});
        tableViewer.setColumnProperties(new String[]{FEATURE_ID_PROPERTY});
    }

    protected Point getInitialSize() {
        return new Point(500, 350);
    }

    protected Control createDialogArea(Composite parent) {
        final Composite area = (Composite)super.createDialogArea(parent);
        this.fSiteCombo = new Combo(area, 12);
        for (UpdateSiteInfo site : this.fSites) {
            this.fSiteCombo.add(site.fProject.getName());
        }
        Composite featureListArea = new Composite(area, 0);
        RowLayout featureListLayout = new RowLayout(256);
        featureListLayout.fill = true;
        featureListLayout.pack = true;
        featureListArea.setLayout((Layout)featureListLayout);
        Composite featureTableArea = new Composite(featureListArea, 0);
        RowLayout featureTableLayout = new RowLayout(512);
        featureTableArea.setLayout((Layout)featureTableLayout);
        Label featureLabel = new Label(featureTableArea, 0);
        featureLabel.setText("Features:");
        final Table table = new Table(featureTableArea, 0);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        final TableColumn featureCol = new TableColumn(table, 2048);
        featureCol.setText("Feature");
        featureCol.setResizable(true);
        for (FeatureInfo fi : this.fReleaseTool.getFeatureInfos()) {
            this.fValidFeatures.add(fi.fFeatureID);
        }
        this.fTableViewer = new TableViewer(table);
        this.createCellEditor(this.fTableViewer);
        this.createLabelProvider();
        this.fSiteCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int idx = ((Combo)e.widget).getSelectionIndex();
                FeatureSetDialog.this.fSite = (UpdateSiteInfo)FeatureSetDialog.this.fSites.get(idx);
                table.removeAll();
                List<FeatureInfo> features = FeatureSetDialog.this.fReleaseTool.readUpdateFeatureInfos(FeatureSetDialog.this.fSite);
                for (FeatureInfo feature : features) {
                    FeatureTableItem item = new FeatureTableItem(feature.fFeatureID);
                    FeatureSetDialog.this.fItems.add(item);
                    FeatureSetDialog.this.fTableViewer.add((Object)item);
                }
                featureCol.pack();
                table.pack();
                area.pack();
                FeatureSetDialog.this.getShell().pack();
            }
        });
        this.createButtonArea(featureListArea, table);
        return area;
    }

    private void createButtonArea(final Composite featureListArea, final Table table) {
        Composite opButtonArea = new Composite(featureListArea, 0);
        RowLayout opButtonLayout = new RowLayout(512);
        opButtonArea.setLayout((Layout)opButtonLayout);
        Button addFeatureButton = new Button(opButtonArea, 8);
        addFeatureButton.setText("Add");
        addFeatureButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FeatureTableItem item = new FeatureTableItem("");
                FeatureSetDialog.this.fItems.add(item);
                FeatureSetDialog.this.fTableViewer.add((Object)item);
                featureListArea.pack();
                table.pack();
                FeatureSetDialog.this.getShell().pack();
            }
        });
        Button removeFeatureButton = new Button(opButtonArea, 8);
        removeFeatureButton.setText("Remove");
        removeFeatureButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                for (int i = 0; i < FeatureSetDialog.this.fItems.size(); ++i) {
                    FeatureSetDialog.this.fTableViewer.remove(FeatureSetDialog.this.fItems.get(i));
                }
            }
        });
    }

    private void createLabelProvider() {
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return ((FeatureTableItem)element).getName();
                    }
                }
                return "";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    static class FeatureTableItem {
        String fFeatureId;

        public FeatureTableItem(String featureID) {
            this.fFeatureId = featureID;
        }

        public String getName() {
            return this.fFeatureId;
        }

        public void setName(String name) {
            this.fFeatureId = name;
        }
    }
}

