/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.releng;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ReleaseEngineeringPlugin
extends AbstractUIPlugin {
    private static ReleaseEngineeringPlugin plugin;
    public static final String kPluginID = "org.eclipse.imp.releng";
    private MessageConsoleStream fInfoStream;
    private MessageConsoleStream fErrorStream;
    private static final String RELEASE_CONSOLE = "Release Engineering";

    public static ReleaseEngineeringPlugin getInstance() {
        return plugin;
    }

    public ReleaseEngineeringPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        MessageConsole myConsole = this.findConsole();
        this.fInfoStream = myConsole.newMessageStream();
        this.fErrorStream = myConsole.newMessageStream();
        this.fErrorStream.setColor(PlatformUI.getWorkbench().getDisplay().getSystemColor(3));
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    private MessageConsole findConsole() {
        MessageConsole myConsole = null;
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] consoles = consoleManager.getConsoles();
        for (int i = 0; i < consoles.length; ++i) {
            IConsole console = consoles[i];
            if (!console.getName().equals(RELEASE_CONSOLE)) continue;
            myConsole = (MessageConsole)console;
        }
        if (myConsole == null) {
            myConsole = new MessageConsole(RELEASE_CONSOLE, null);
            consoleManager.addConsoles(new IConsole[]{myConsole});
        }
        consoleManager.showConsoleView(myConsole);
        return myConsole;
    }

    public static MessageConsoleStream getMsgStream() {
        return ReleaseEngineeringPlugin.getInstance().fInfoStream;
    }

    public static MessageConsoleStream getErrorStream() {
        return ReleaseEngineeringPlugin.getInstance().fErrorStream;
    }

    public static void logError(Exception e) {
        Status status = new Status(4, kPluginID, 0, e.getMessage(), (Throwable)e);
        ReleaseEngineeringPlugin.getInstance().getLog().log((IStatus)status);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)kPluginID, (String)path);
    }
}

