/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.releng.metadata;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.imp.releng.ReleaseEngineeringPlugin;
import org.eclipse.imp.releng.metadata.FeatureInfo;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateSiteInfo {
    public final IProject fProject;
    public final IFile fManifestFile;
    public Document fManifestDoc;
    public Set<Node> fFeatureNodes = new HashSet<Node>();
    public List<FeatureRef> fFeatureRefs = new ArrayList<FeatureRef>();
    public String fURL;
    public String fDescription;
    public List<CategoryDef> fCategories = new ArrayList<CategoryDef>();

    public UpdateSiteInfo(IProject project, IFile manifestFile) throws ParserConfigurationException, SAXException, IOException {
        this.fProject = project;
        this.fManifestFile = manifestFile;
        ReleaseEngineeringPlugin.getMsgStream().println("Got manifest document for " + manifestFile.getLocation().toPortableString());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        this.fManifestDoc = docBuilder.parse(new File(manifestFile.getLocation().toOSString()));
        Node siteNode = this.fManifestDoc.getChildNodes().item(0);
        for (int i = 0; i < siteNode.getChildNodes().getLength(); ++i) {
            Node child = siteNode.getChildNodes().item(i);
            String childName = child.getNodeName();
            if (childName.equals("description")) {
                this.fURL = child.getAttributes().getNamedItem("url").getNodeValue();
                this.fDescription = child.getFirstChild().getNodeValue();
                continue;
            }
            if (childName.equals("category-def")) {
                String catName = child.getAttributes().getNamedItem("name").getNodeValue();
                String catLabel = child.getAttributes().getNamedItem("label").getNodeValue();
                CategoryDef catDef = new CategoryDef(catName, catLabel);
                this.fCategories.add(catDef);
                continue;
            }
            if (!childName.equals("feature")) continue;
            String featID = child.getAttributes().getNamedItem("id").getNodeValue();
            String featVers = child.getAttributes().getNamedItem("version").getNodeValue();
            String featURL = child.getAttributes().getNamedItem("url").getNodeValue();
            String featCat = null;
            NodeList featChildren = child.getChildNodes();
            for (int j = 0; j < featChildren.getLength(); ++j) {
                Node featChild = featChildren.item(j);
                if (!featChild.getNodeName().equals("category")) continue;
                featCat = featChild.getAttributes().getNamedItem("name").getNodeValue();
            }
            this.fFeatureRefs.add(new FeatureRef(featID, featVers, featURL, featCat));
        }
    }

    public String findCategoryForFeature(FeatureInfo featInfo) {
        for (FeatureRef fr : this.fFeatureRefs) {
            if (!fr.getID().equals(featInfo.fFeatureID)) continue;
            return fr.getCategory();
        }
        return this.fCategories.get(0).fName;
    }

    public boolean addFeatureIfMissing(FeatureInfo feature) {
        for (FeatureRef featRef : this.fFeatureRefs) {
            if (!featRef.getID().equals(feature.fFeatureID) || !featRef.getVersion().equals(feature.fFeatureVersion)) continue;
            return false;
        }
        String newURL = "features/" + feature.fFeatureID + "_" + feature.fFeatureVersion + ".jar";
        this.fFeatureRefs.add(new FeatureRef(feature.fFeatureID, feature.fFeatureVersion, newURL, this.findCategoryForFeature(feature)));
        return true;
    }

    public void rewriteManifest(List<TextFileChange> changes, List<IFile> changedFiles) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.nl(sb);
        sb.append("<site>");
        this.nl(sb);
        if (this.fURL != null) {
            sb.append("  <description url=\"" + this.fURL + "\">");
            this.nl(sb);
            if (this.fDescription != null) {
                sb.append("    " + this.fDescription.trim());
                this.nl(sb);
            }
            sb.append("  </description>");
            this.nl(sb);
            this.nl(sb);
        }
        for (CategoryDef cat : this.fCategories) {
            sb.append("  <category-def name=\"" + cat.getName() + "\" label=\"" + cat.getLabel() + "\"/>");
            this.nl(sb);
        }
        this.nl(sb);
        for (FeatureRef featRef : this.fFeatureRefs) {
            sb.append("  <feature url=\"" + featRef.getURL() + "\" id=\"" + featRef.getID() + "\" version=\"" + featRef.getVersion() + "\">");
            this.nl(sb);
            if (featRef.getCategory() != null) {
                sb.append("    <category name=\"" + featRef.getCategory() + "\"/>");
                this.nl(sb);
            }
            sb.append("  </feature>");
            this.nl(sb);
            this.nl(sb);
        }
        sb.append("</site>");
        this.nl(sb);
        TextFileChange tfc = new TextFileChange("Update site update for " + this.fManifestFile.getFullPath().toPortableString(), this.fManifestFile);
        long curFileLength = new File(this.fManifestFile.getLocation().toOSString()).length();
        tfc.setEdit((TextEdit)new MultiTextEdit());
        tfc.addEdit((TextEdit)new ReplaceEdit(0, (int)curFileLength, sb.toString()));
        changedFiles.add(this.fManifestFile);
        changes.add(tfc);
    }

    protected void nl(StringBuilder sb) {
        sb.append("\n");
    }

    public String toString() {
        return "<update site " + this.fManifestFile.getFullPath().toPortableString() + ">";
    }

    public static class FeatureRef {
        private final String fID;
        private final String fVersion;
        private final String fURL;
        private final String fCategory;

        public FeatureRef(String id, String vers, String url, String cat) {
            this.fID = id;
            this.fVersion = vers;
            this.fURL = url;
            this.fCategory = cat;
        }

        public String getCategory() {
            return this.fCategory;
        }

        public String getID() {
            return this.fID;
        }

        public String getURL() {
            return this.fURL;
        }

        public String getVersion() {
            return this.fVersion;
        }

        public IProject findProject() {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(this.fID + ".feature");
        }

        public String toString() {
            return "<feature " + this.getID() + " " + this.getVersion() + ">";
        }
    }

    public static class CategoryDef {
        private final String fName;
        private final String fLabel;

        public CategoryDef(String name, String label) {
            this.fName = name;
            this.fLabel = label;
        }

        public String getLabel() {
            return this.fLabel;
        }

        public String getName() {
            return this.fName;
        }

        public String toString() {
            return "<category " + this.getName() + ">";
        }
    }
}

