/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.releng.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.imp.releng.ReleaseEngineeringPlugin;
import org.eclipse.imp.releng.metadata.FileVersionMap;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSWorkspaceSubscriber;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileHistoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionScanner {
    private final IWorkspaceRoot fWSRoot = ResourcesPlugin.getWorkspace().getRoot();
    private Comparator<IFile> fFileComparator = new Comparator<IFile>(){

        @Override
        public int compare(IFile o1, IFile o2) {
            return o1.getLocation().toPortableString().compareTo(o2.getLocation().toPortableString());
        }
    };

    public Set<IFile> checkFile(String projRelFilePath, IProject pluginProject, IFileHistoryProvider histProvider, FileVersionMap fileVersionMap) {
        IFile file = pluginProject.getFile(projRelFilePath);
        if (file.exists()) {
            return this.checkFile(file, histProvider, fileVersionMap);
        }
        fileVersionMap.setVersion(file, "1.1");
        return Collections.EMPTY_SET;
    }

    private Set<IFile> checkFile(IFile file, IFileHistoryProvider histProvider, FileVersionMap fileVersionMap) {
        IFileRevision fileRev = histProvider.getWorkspaceFileRevision((IResource)file);
        if (fileRev == null) {
            return Collections.EMPTY_SET;
        }
        fileVersionMap.setVersion(file, fileRev.getContentIdentifier());
        if (this.isDirty(file, histProvider)) {
            ReleaseEngineeringPlugin.getMsgStream().println("File " + file.getFullPath() + " is out of sync w/ CVS HEAD!");
            return Collections.singleton(file);
        }
        return Collections.EMPTY_SET;
    }

    protected boolean isDirty(IFile file, IFileHistoryProvider histProvider) {
        if (histProvider instanceof CVSFileHistoryProvider) {
            try {
                return VersionScanner.getCVSSubscriber().isDirty((IResource)file, null);
            }
            catch (CVSException e) {
                return false;
            }
        }
        return false;
    }

    private static CVSWorkspaceSubscriber getCVSSubscriber() {
        return CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber();
    }

    public Set<IFile> scanSrcFolders(IProject pluginProject, IFileHistoryProvider histProvider, FileVersionMap fileVersionMap) {
        IJavaProject pluginJavaProject = JavaCore.create((IProject)pluginProject);
        List<IPath> srcFolderPaths = this.collectSrcFolders(pluginJavaProject);
        TreeSet<IFile> result = new TreeSet<IFile>(this.fFileComparator);
        for (IPath srcFolderPath : srcFolderPaths) {
            IFolder srcFolder = this.fWSRoot.getFolder(srcFolderPath);
            result.addAll(this.scanFolder(srcFolder, histProvider, fileVersionMap));
        }
        return result;
    }

    private List<IPath> collectSrcFolders(IJavaProject javaProject) {
        ArrayList<IPath> srcFolders = new ArrayList<IPath>();
        try {
            IClasspathEntry[] cpEntries;
            block5: for (IClasspathEntry entry : cpEntries = javaProject.getResolvedClasspath(true)) {
                switch (entry.getEntryKind()) {
                    case 3: {
                        if (entry.getPath().equals(javaProject.getProject().getFullPath())) continue block5;
                        srcFolders.add(entry.getPath());
                    }
                }
            }
        }
        catch (CoreException e) {
            ReleaseEngineeringPlugin.logError((Exception)((Object)e));
        }
        return srcFolders;
    }

    public Set<IFile> scanFolder(String projRelPath, IProject project, IFileHistoryProvider histProvider, FileVersionMap fileVersionMap) {
        IFolder folder = project.getFolder(projRelPath);
        if (folder.exists()) {
            return this.scanFolder(folder, histProvider, fileVersionMap);
        }
        return Collections.EMPTY_SET;
    }

    private Set<IFile> scanFolder(IFolder folder, final IFileHistoryProvider histProvider, final FileVersionMap fileVersionMap) {
        final TreeSet<IFile> result = new TreeSet<IFile>(this.fFileComparator);
        try {
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IFile) {
                        IFile file = (IFile)resource;
                        if (!file.isDerived()) {
                            result.addAll(VersionScanner.this.checkFile(file, histProvider, fileVersionMap));
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            ReleaseEngineeringPlugin.logError((Exception)((Object)e));
        }
        return result;
    }
}

