/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.releng.dialogs;

import java.util.Set;
import org.eclipse.imp.releng.dialogs.DetailsDialog;
import org.eclipse.imp.releng.metadata.PluginInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfirmChangedPluginsDialog
extends Dialog {
    private final Set<PluginInfo> fChangedPlugins;
    private final Set<PluginInfo> fUnchangedPlugins2;

    public ConfirmChangedPluginsDialog(Shell shell, Set<PluginInfo> changedPlugins, Set<PluginInfo> unchangedPlugins) {
        super(shell);
        this.fChangedPlugins = changedPlugins;
        this.fUnchangedPlugins2 = unchangedPlugins;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Plugin states for selected features");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Proceed", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Label changeReason;
        Label pluginVersion;
        Label pluginID;
        Composite area = (Composite)super.createDialogArea(parent);
        GridLayout grid = new GridLayout(3, true);
        area.setLayout((Layout)grid);
        for (PluginInfo pi : this.fChangedPlugins) {
            pluginID = new Label(area, 0);
            pluginVersion = new Label(area, 0);
            pluginID.setText(pi.fPluginID);
            pluginVersion.setText(pi.fPluginNewVersion);
            if (pi.getChangeState().isChange()) {
                Button detailsButton = new Button(area, 8);
                detailsButton.setText("details...");
                detailsButton.addSelectionListener((SelectionListener)new DetailsButtonListener(pi));
                continue;
            }
            changeReason = new Label(area, 0);
            changeReason.setText(pi.getChangeState().toString());
        }
        for (PluginInfo pi : this.fUnchangedPlugins2) {
            pluginID = new Label(area, 0);
            pluginVersion = new Label(area, 0);
            changeReason = new Label(area, 0);
            pluginID.setText(pi.fPluginID);
            pluginVersion.setText("");
            changeReason.setText("<unchanged>");
        }
        return area;
    }

    static class DetailsButtonListener
    implements SelectionListener {
        private final PluginInfo fPi;

        private DetailsButtonListener(PluginInfo pi) {
            this.fPi = pi;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            DetailsDialog d = new DetailsDialog(shell, this.fPi);
            d.open();
        }
    }
}

