/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.releng.dialogs;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.imp.releng.ReleaseEngineeringPlugin;
import org.eclipse.imp.releng.WorkbenchReleaseTool;
import org.eclipse.imp.releng.metadata.PluginInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.ui.console.MessageConsoleStream;

public class DetailsDialog
extends Dialog {
    private final PluginInfo fPi;
    private final int PATH_COL = 0;
    private final int FILE_COL = 1;
    private final int CHANGE_COL = 2;

    DetailsDialog(Shell shell, PluginInfo pi) {
        super(shell);
        this.fPi = pi;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Change details for " + this.fPi.fPluginID);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        final Table table = new Table(area, 0);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn pathCol = new TableColumn(table, 2048);
        pathCol.setText("Path");
        pathCol.setResizable(true);
        TableColumn fileCol = new TableColumn(table, 2048);
        fileCol.setText("File");
        fileCol.setResizable(true);
        TableColumn changeCol = new TableColumn(table, 2048);
        changeCol.setText("Change");
        changeCol.setResizable(true);
        TableViewer viewer = new TableViewer(table);
        List<PluginInfo.ChangeReason> changes = this.fPi.getAllChanges();
        for (PluginInfo.ChangeReason change : changes) {
            if (change instanceof PluginInfo.ResourceChange) {
                PluginInfo.ResourceChange rc = (PluginInfo.ResourceChange)change;
                TableItem ti = new TableItem(table, 0);
                IPath path = rc.getPath();
                ti.setText(0, path.removeLastSegments(1).toPortableString());
                ti.setText(1, path.lastSegment());
                ti.setText(2, rc.getType());
                ti.setData((Object)rc);
                continue;
            }
            if (!(change instanceof PluginInfo.NewPluginChange)) continue;
            TableItem ti = new TableItem(table, 0);
            ti.setText(0, "");
            ti.setText(1, "");
            ti.setText(2, "new plugin (or no history provider available -- SVN)");
            ti.setData((Object)change);
        }
        table.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                TableItem ti = table.getItem(new Point(event.x, event.y));
                if (ti != null) {
                    PluginInfo.ResourceChange rc = (PluginInfo.ResourceChange)ti.getData();
                    MessageConsoleStream mcs = ReleaseEngineeringPlugin.getMsgStream();
                    IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
                    IProject proj = wsRoot.getProject(((DetailsDialog)DetailsDialog.this).fPi.fPluginID);
                    IFileHistoryProvider histProvider = RepositoryProvider.getProvider((IProject)proj).getFileHistoryProvider();
                    WorkbenchReleaseTool.dumpRecentRevisionsInfo(DetailsDialog.this.fPi, mcs, histProvider, rc, (IFile)wsRoot.findMember(rc.getPath()));
                    try {
                        mcs.flush();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
        });
        pathCol.pack();
        fileCol.pack();
        changeCol.pack();
        return area;
    }
}

