/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.releng.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.imp.releng.WorkbenchReleaseTool;
import org.eclipse.imp.releng.metadata.FeatureInfo;
import org.eclipse.imp.releng.metadata.UpdateSiteInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RetrieveUpdateSiteDialog
extends Dialog {
    private Combo fProviderCombo;
    private Text fRepoServerText;
    private Text fRepoPathText;
    private Text fProjectNameText;
    private Button fAnonButton;
    private String fProvider;
    private String fRepoServer;
    private String fRepoPath;
    private String fUpdateSiteProjectName;
    private boolean fAnonAccess;
    private boolean fRetrieveFeatures;
    private boolean fRetrievePlugins;
    private static final Map<String, String> sProviderMap = new HashMap<String, String>();
    private static final Map<String, PrefabDescriptor> sUpdateSiteMap;

    public RetrieveUpdateSiteDialog(Shell shell) {
        super(shell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select update site");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button proceedButton = this.createButton(parent, 0, "Proceed", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        proceedButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                this.retrieveProjects();
            }

            private void retrieveProjects() {
                String providerRef = (String)sProviderMap.get(RetrieveUpdateSiteDialog.this.fProvider);
                String updateSiteProjectRef = this.buildProjectRef(RetrieveUpdateSiteDialog.this.fProvider, RetrieveUpdateSiteDialog.this.fRepoServer, RetrieveUpdateSiteDialog.this.fRepoPath, RetrieveUpdateSiteDialog.this.fUpdateSiteProjectName, RetrieveUpdateSiteDialog.this.fAnonAccess);
                WorkbenchReleaseTool releaseTool = new WorkbenchReleaseTool();
                releaseTool.retrieveProject(updateSiteProjectRef, providerRef);
                releaseTool.collectMetaData(true);
                if (RetrieveUpdateSiteDialog.this.fRetrieveFeatures) {
                    ArrayList<UpdateSiteInfo> siteInfos = new ArrayList<UpdateSiteInfo>();
                    UpdateSiteInfo siteInfo = releaseTool.findSiteByName(RetrieveUpdateSiteDialog.this.fUpdateSiteProjectName);
                    if (siteInfo == null) {
                        MessageDialog.openError((Shell)RetrieveUpdateSiteDialog.this.getParentShell(), (String)"Update site project missing", (String)"The update site project cannot be found. Presumably the download failed. Please make sure you have the appropriate repository client plugins (CVS, SVN).");
                        return;
                    }
                    siteInfos.add(siteInfo);
                    if (!releaseTool.retrieveFeatures(siteInfos, RetrieveUpdateSiteDialog.this.fAnonAccess)) {
                        return;
                    }
                    releaseTool.collectMetaData(true);
                    if (RetrieveUpdateSiteDialog.this.fRetrievePlugins) {
                        ArrayList<FeatureInfo> featureInfos = new ArrayList<FeatureInfo>();
                        for (UpdateSiteInfo.FeatureRef featureRef : siteInfo.fFeatureRefs) {
                            featureInfos.add(releaseTool.findFeatureInfo(featureRef.getID()));
                        }
                        releaseTool.retrievePlugins(featureInfos, RetrieveUpdateSiteDialog.this.fAnonAccess);
                    }
                }
            }

            private String buildProjectRef(String providerType, String repoServer, String repoPath, String projectName, boolean anonAccess) {
                if (providerType.equals("CVS")) {
                    if (anonAccess) {
                        return "1.0,:pserver:anonymous@" + repoServer + ":" + repoPath + "," + projectName + "," + projectName;
                    }
                    return "1.0,:extssh:" + repoServer + ":" + repoPath + "," + projectName + "," + projectName;
                }
                if (providerType.equals("SVN")) {
                    String projRefSuffix = repoServer + repoPath + "/trunk/" + projectName + "/," + projectName;
                    if (anonAccess) {
                        return "0.9.3,http://" + projRefSuffix;
                    }
                    return "0.9.3,https://" + projRefSuffix;
                }
                throw new IllegalArgumentException("huh?");
            }
        });
    }

    private void fillPrefabValues(String updateSite) {
        PrefabDescriptor pfd = sUpdateSiteMap.get(updateSite);
        this.fProviderCombo.select(this.fProviderCombo.indexOf(pfd.providerType));
        this.fProvider = pfd.providerType;
        this.fRepoServerText.setText(pfd.repoServer);
        this.fRepoPathText.setText(pfd.repoPath);
        this.fProjectNameText.setText(pfd.updateSiteProject);
    }

    protected Control createDialogArea(Composite parent) {
        final Composite area = (Composite)super.createDialogArea(parent);
        GridLayout grid = new GridLayout(2, true);
        area.setLayout((Layout)grid);
        Label prefabLabel = new Label(area, 0);
        final Combo prefabCombo = new Combo(area, 4);
        prefabLabel.setText("Update site:");
        prefabCombo.add("IMP");
        prefabCombo.add("LPG");
        prefabCombo.add("X10DT");
        prefabCombo.add("RelEng");
        prefabCombo.add("Custom");
        prefabCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                RetrieveUpdateSiteDialog.this.fillPrefabValues(prefabCombo.getItem(prefabCombo.getSelectionIndex()));
                area.pack();
            }
        });
        Label providerLabel = new Label(area, 0);
        this.fProviderCombo = new Combo(area, 4);
        providerLabel.setText("Provider type:");
        this.fProviderCombo.add("CVS");
        this.fProviderCombo.add("SVN");
        this.fProviderCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                RetrieveUpdateSiteDialog.this.fProvider = RetrieveUpdateSiteDialog.this.fProviderCombo.getItem(RetrieveUpdateSiteDialog.this.fProviderCombo.getSelectionIndex());
            }
        });
        Label repoURLLabel = new Label(area, 0);
        repoURLLabel.setText("Repository server:");
        this.fRepoServerText = new Text(area, 0);
        this.fRepoServerText.setText("dev.eclipse.org");
        this.fRepoServerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RetrieveUpdateSiteDialog.this.fRepoServer = RetrieveUpdateSiteDialog.this.fRepoServerText.getText();
            }
        });
        Label repoPathLabel = new Label(area, 0);
        repoPathLabel.setText("Repository path:");
        this.fRepoPathText = new Text(area, 0);
        this.fRepoPathText.setText("/svnroot/technology/org.eclipse.imp");
        this.fRepoPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RetrieveUpdateSiteDialog.this.fRepoPath = RetrieveUpdateSiteDialog.this.fRepoPathText.getText();
            }
        });
        Label updateProjectLabel = new Label(area, 0);
        updateProjectLabel.setText("Update site project:");
        this.fProjectNameText = new Text(area, 0);
        this.fProjectNameText.setText("org.eclipse.imp.update");
        this.fProjectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RetrieveUpdateSiteDialog.this.fUpdateSiteProjectName = RetrieveUpdateSiteDialog.this.fProjectNameText.getText();
            }
        });
        final Button anonAccessCkbox = new Button(area, 32);
        anonAccessCkbox.setText("Use anonymous repository access");
        anonAccessCkbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                RetrieveUpdateSiteDialog.this.setAnonAccess(anonAccessCkbox.getSelection());
            }
        });
        anonAccessCkbox.setSelection(true);
        new Label(area, 0);
        final Button retrieveFeaturesCkbox = new Button(area, 32);
        retrieveFeaturesCkbox.setText("Also retrieve feature projects");
        retrieveFeaturesCkbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                RetrieveUpdateSiteDialog.this.setRetrieveFeatures(retrieveFeaturesCkbox.getSelection());
            }
        });
        this.fRetrieveFeatures = true;
        retrieveFeaturesCkbox.setSelection(true);
        new Label(area, 0);
        final Button retrievePluginsCkbox = new Button(area, 32);
        retrievePluginsCkbox.setText("Also retrieve plugin projects");
        retrievePluginsCkbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                RetrieveUpdateSiteDialog.this.setRetrievePlugins(retrievePluginsCkbox.getSelection());
            }
        });
        this.fRetrievePlugins = true;
        retrievePluginsCkbox.setSelection(true);
        prefabCombo.select(0);
        this.fillPrefabValues("IMP");
        area.pack();
        return area;
    }

    protected void setAnonAccess(boolean yesNo) {
        this.fAnonAccess = yesNo;
    }

    protected void setRetrieveFeatures(boolean yesNo) {
        this.fRetrieveFeatures = yesNo;
    }

    protected void setRetrievePlugins(boolean yesNo) {
        this.fRetrievePlugins = yesNo;
    }

    static {
        sProviderMap.put("CVS", "org.eclipse.team.cvs.core.cvsnature");
        sProviderMap.put("SVN", "org.tigris.subversion.subclipse.core.svnnature");
        sUpdateSiteMap = new HashMap<String, PrefabDescriptor>();
        sUpdateSiteMap.put("IMP", new PrefabDescriptor("SVN", "dev.eclipse.org", "/svnroot/technology/org.eclipse.imp", "org.eclipse.imp.update"));
        sUpdateSiteMap.put("LPG", new PrefabDescriptor("CVS", "lpg.cvs.sourceforge.net", "/cvsroot/lpg", "lpg.update"));
        sUpdateSiteMap.put("X10DT", new PrefabDescriptor("CVS", "eclipse-imp.cvs.sourceforge.net", "/cvsroot/eclipse-imp", "org.eclipse.imp.x10dt.update"));
        sUpdateSiteMap.put("RelEng", new PrefabDescriptor("SVN", "dev.eclipse.org", "/svnroot/technology/org.eclipse.imp", "org.eclipse.imp.releng.update"));
        sUpdateSiteMap.put("Custom", new PrefabDescriptor("CVS", "my.cvs.server.org", "/cvsroot/myrepo", "my.update.project"));
    }

    private static class PrefabDescriptor {
        public String providerType;
        public String repoServer;
        public String repoPath;
        public String updateSiteProject;

        public PrefabDescriptor(String pt, String rs, String rp, String usp) {
            this.providerType = pt;
            this.repoServer = rs;
            this.repoPath = rp;
            this.updateSiteProject = usp;
        }
    }
}

