/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.releng.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.imp.releng.metadata.FeatureInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectFeatureInfosDialog
extends Dialog {
    private final List<FeatureInfo> fAllFeatureInfos = new ArrayList<FeatureInfo>();
    private final List<FeatureInfo> fFeatures = new ArrayList<FeatureInfo>();

    public SelectFeatureInfosDialog(Shell shell, Collection<FeatureInfo> features) {
        super(shell);
        this.fAllFeatureInfos.addAll(features);
        Collections.sort(this.fAllFeatureInfos, new Comparator<FeatureInfo>(){

            @Override
            public int compare(FeatureInfo f1, FeatureInfo f2) {
                return f1.fFeatureID.compareTo(f2.fFeatureID);
            }
        });
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select features");
    }

    public List<FeatureInfo> getSelectedFeatures() {
        return this.fFeatures;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Label header = new Label(area, 0);
        header.setText("Select features to process:");
        for (final FeatureInfo fi : this.fAllFeatureInfos) {
            Button featureCheckBox = new Button(area, 32);
            featureCheckBox.setText(fi.fFeatureID);
            featureCheckBox.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (((Button)e.widget).getSelection()) {
                        SelectFeatureInfosDialog.this.fFeatures.add(fi);
                    } else {
                        SelectFeatureInfosDialog.this.fFeatures.remove(fi);
                    }
                }
            });
        }
        return area;
    }
}

