/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.releng.metadata;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.imp.releng.ReleaseEngineeringPlugin;
import org.eclipse.imp.releng.ReleaseTool;
import org.eclipse.imp.releng.metadata.PluginInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class FeatureInfo {
    public final String fFeatureID;
    public final IProject fProject;
    public final IFile fManifestFile;
    public Document fManifestDoc;
    public Set<Node> fRequiredFeatures = new HashSet<Node>();
    public Set<Node> fPlugins = new HashSet<Node>();
    public Set<PluginInfo> fPluginInfos = new HashSet<PluginInfo>();
    public String fFeatureVersion;
    private Node fDescriptionNode;

    public FeatureInfo(IProject project, IFile manifestFile) throws ParserConfigurationException, SAXException, IOException {
        this.fProject = project;
        this.fManifestFile = manifestFile;
        ReleaseEngineeringPlugin.getMsgStream().println("Got manifest document for " + manifestFile.getLocation().toPortableString());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        this.fManifestDoc = docBuilder.parse(new File(manifestFile.getLocation().toOSString()));
        this.fFeatureID = this.getFeatureNode().getAttributes().getNamedItem("id").getNodeValue();
        Node featureNode = this.getFeatureNode();
        Node versionNode = featureNode.getAttributes().getNamedItem("version");
        this.fDescriptionNode = featureNode.getChildNodes().item(1);
        this.fFeatureVersion = versionNode.getNodeValue();
    }

    private Node getFeatureVersionNode() {
        return this.getFeatureNode().getAttributes().getNamedItem("version");
    }

    private Node getFeatureNode() {
        return this.fManifestDoc.getChildNodes().item(0);
    }

    public void collectPlugins(ReleaseTool incrementer) {
        Node featureNode = this.getFeatureNode();
        String featureVersion = featureNode.getAttributes().getNamedItem("version").getNodeValue();
        ReleaseEngineeringPlugin.getMsgStream().println("Processing feature " + featureNode.getAttributes().getNamedItem("id") + " version " + featureVersion + " from " + this.fManifestFile.getLocation().toPortableString());
        Set<Node> featureRequires = ReleaseTool.getChildNodesNamed("requires", featureNode);
        Set<Node> featurePlugins = ReleaseTool.getChildNodesNamed("plugin", featureNode);
        for (Node required : featureRequires) {
            Set<Node> imports = ReleaseTool.getChildNodesNamed("import", required);
            for (Node imprt : imports) {
                if (imprt.getAttributes().getNamedItem("feature") != null) {
                    ReleaseEngineeringPlugin.getMsgStream().println("   requires " + imprt.getAttributes().getNamedItem("feature") + " version " + imprt.getAttributes().getNamedItem("version"));
                    this.fRequiredFeatures.add(imprt);
                    continue;
                }
                if (imprt.getAttributes().getNamedItem("plugin") == null) continue;
            }
        }
        for (Node plugin : featurePlugins) {
            String pluginID = plugin.getAttributes().getNamedItem("id").getNodeValue();
            String pluginVersion = plugin.getAttributes().getNamedItem("version").getNodeValue();
            ReleaseEngineeringPlugin.getMsgStream().println("   contains " + pluginID + " version " + pluginVersion);
            this.fPlugins.add(plugin);
            PluginInfo pluginInfo = new PluginInfo(pluginID, pluginVersion);
            this.fPluginInfos.add(pluginInfo);
            incrementer.addPlugin(pluginInfo);
        }
    }

    public void setNewVersion(String newVersion) {
        this.getFeatureVersionNode().setNodeValue(newVersion);
    }

    public String getURL() {
        return this.fDescriptionNode.getAttributes().getNamedItem("url").getNodeValue();
    }

    public int hashCode() {
        return 3847 + 5779 * this.fFeatureID.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FeatureInfo)) {
            return false;
        }
        FeatureInfo other = (FeatureInfo)obj;
        return this.fFeatureID.equals(other.fFeatureID);
    }

    public String toString() {
        return "<feature " + this.fFeatureID + " version " + this.fFeatureVersion + ">";
    }
}

