/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.releng.metadata;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.imp.releng.ReleaseEngineeringPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileVersionMap {
    private IProject fProject;
    private String fPluginID;
    private String fVersion;
    private Map<IFile, String> fMap = new HashMap<IFile, String>();
    private final String lineTerm = "\n";

    public FileVersionMap(IProject project, String pluginID, String version) {
        this.fProject = project;
        this.fPluginID = pluginID;
        this.fVersion = version;
        IFile mapFile = this.fProject.getFile(this.pathToMap());
        if (mapFile.exists()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = factory.newDocumentBuilder();
                Document mapDoc = docBuilder.parse(new File(mapFile.getLocation().toOSString()));
                Element mapDocElem = mapDoc.getDocumentElement();
                NodeList childNodes = mapDocElem.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node child = childNodes.item(i);
                    if (!child.getNodeName().equals("file")) continue;
                    String filePath = child.getAttributes().getNamedItem("path").getNodeValue();
                    String fileVersion = child.getAttributes().getNamedItem("version").getNodeValue();
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
                    this.setVersion(file, fileVersion);
                }
            }
            catch (IOException e) {
                ReleaseEngineeringPlugin.logError(e);
            }
            catch (SAXException e) {
                ReleaseEngineeringPlugin.logError(e);
            }
            catch (ParserConfigurationException e) {
                ReleaseEngineeringPlugin.logError(e);
            }
        }
    }

    public void setVersion(IFile f, String version) {
        this.fMap.put(f, version);
    }

    public String getVersion(IFile f) {
        return this.fMap.get(f);
    }

    public Set<IFile> getAllFiles() {
        return this.fMap.keySet();
    }

    public Set<IFile> getAllFilesSorted() {
        TreeSet<IFile> allFiles = new TreeSet<IFile>(new Comparator<IFile>(){

            @Override
            public int compare(IFile arg0, IFile arg1) {
                return arg0.getLocation().toPortableString().compareTo(arg1.getLocation().toPortableString());
            }
        });
        allFiles.addAll(this.fMap.keySet());
        return allFiles;
    }

    public boolean isEmpty() {
        return this.fMap.isEmpty();
    }

    private IPath pathToMap() {
        String vers = this.fVersion.endsWith(".qualifier") ? this.fVersion.substring(0, this.fVersion.indexOf(".qualifier")) : this.fVersion;
        return this.pathToMap(vers);
    }

    private IPath pathToMap(String version) {
        return new Path("releng/versionMap-" + version + ".txt");
    }

    public IFile writeMap() {
        IFile file = this.fProject.getFile(this.pathToMap());
        this.writeMapToFile(file);
        return file;
    }

    private void writeMapToFile(IFile file) {
        if (!file.getParent().exists()) {
            IFolder parent = (IFolder)file.getParent();
            try {
                parent.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                ReleaseEngineeringPlugin.logError((Exception)((Object)e));
            }
        }
        File f = new File(file.getLocation().toOSString());
        try {
            FileWriter fw = new FileWriter(f, false);
            fw.append(this.toString());
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            ReleaseEngineeringPlugin.logError(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<version pluginID=\"" + this.fPluginID + "\"" + "\n" + "         versionID=\"" + this.fVersion + "\">" + "\n");
        Set<IFile> allFiles = this.getAllFilesSorted();
        for (IFile file : allFiles) {
            sb.append("    <file path=\"" + file.getFullPath().toPortableString() + "\"" + "\n" + "          version=\"" + this.fMap.get(file) + "\"/>" + "\n");
        }
        sb.append("</version>\n");
        return sb.toString();
    }
}

