/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.releng.metadata;

import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.imp.releng.ReleaseEngineeringPlugin;
import org.eclipse.imp.releng.ReleaseTool;
import org.eclipse.imp.releng.metadata.FileVersionMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginInfo {
    public IFile fManifest;
    public String fPluginID;
    public String fProjectName;
    public String fPluginVersion;
    public String fPluginNewVersion;
    public FileVersionMap fCurMap;
    public FileVersionMap fNewMap;
    private boolean fPluginOk = true;
    private ChangeReason fChanged = NoChange.getInstance();
    private List<ChangeReason> fAllChanges = new ArrayList<ChangeReason>();
    private static final Pattern BUNDLE_ID_PATTERN = Pattern.compile("Bundle-SymbolicName: *([a-zA-Z0-9_]+(\\.[a-zA-Z0-9_]+)*)");

    public PluginInfo(String pluginID, String newVersion) {
        this.fPluginID = pluginID;
        this.fPluginVersion = newVersion;
        this.fProjectName = this.fPluginID;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(pluginID);
        if (project == null || !project.exists()) {
            project = this.findProjectByPluginID(wsRoot);
        }
        if (project != null) {
            this.fManifest = project.getFile((IPath)new Path("META-INF/MANIFEST.MF"));
            if (!this.fManifest.exists()) {
                ReleaseEngineeringPlugin.getErrorStream().println("     * Unable to find bundle manifest for plugin " + pluginID);
                this.fPluginOk = false;
            }
        } else {
            ReleaseEngineeringPlugin.getErrorStream().println("     * Unable to find workspace project for plugin " + pluginID);
            this.fPluginOk = false;
        }
    }

    private IProject findProjectByPluginID(IWorkspaceRoot wsRoot) {
        IProject project = null;
        IProject[] allProjects = wsRoot.getProjects();
        for (int i = 0; i < allProjects.length; ++i) {
            IProject aProject = allProjects[i];
            IFile manifestFile = aProject.getFile((IPath)new Path("META-INF/MANIFEST.MF"));
            if (!manifestFile.exists()) continue;
            try {
                String aPluginID;
                String manifestContents = ReleaseTool.getFileContents(new InputStreamReader(manifestFile.getContents()));
                Matcher matcher = BUNDLE_ID_PATTERN.matcher(manifestContents);
                if (!matcher.find() || !(aPluginID = matcher.group(1)).equals(this.fPluginID)) continue;
                project = allProjects[i];
                this.fProjectName = allProjects[i].getName();
                break;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return project;
    }

    public ChangeReason getChangeState() {
        return this.fChanged;
    }

    public List<ChangeReason> getAllChanges() {
        return this.fAllChanges;
    }

    public void updateReason(ChangeReason reason) {
        this.fAllChanges.add(reason);
        if (!(this.fChanged instanceof NewPluginChange)) {
            if (this.fChanged instanceof NoChange) {
                this.fChanged = reason;
            } else if (reason instanceof FileAdded) {
                this.fChanged = reason;
            } else if (reason instanceof FileChange && !(this.fChanged instanceof FileAdded)) {
                this.fChanged = reason;
            }
        }
    }

    public boolean pluginOk() {
        return this.fPluginOk;
    }

    public String toString() {
        return this.fPluginID;
    }

    public static class FileAdded
    extends ResourceChange {
        public FileAdded(IPath path) {
            super(path);
        }

        public String toString() {
            return "<file added: " + this.fPath.toPortableString() + ">";
        }

        public String getType() {
            return "<added>";
        }
    }

    public static class FileDeleted
    extends ResourceChange {
        public FileDeleted(IPath path) {
            super(path);
        }

        public String toString() {
            return "<file deleted: " + this.fPath.toPortableString() + ">";
        }

        public String getType() {
            return "<deleted>";
        }
    }

    public static class FileChange
    extends ResourceChange {
        public FileChange(IPath path) {
            super(path);
        }

        public String toString() {
            return "<file change: " + this.fPath.toPortableString() + ">";
        }

        public String getType() {
            return "<changed>";
        }
    }

    public static abstract class ResourceChange
    extends ChangeReason {
        protected final IPath fPath;

        public ResourceChange(IPath path) {
            this.fPath = path;
        }

        public IPath getPath() {
            return this.fPath;
        }

        public boolean isChange() {
            return true;
        }

        public abstract String getType();
    }

    public static class NewPluginChange
    extends ChangeReason {
        private static final NewPluginChange sInstance = new NewPluginChange();

        public static final NewPluginChange getInstance() {
            return sInstance;
        }

        private NewPluginChange() {
        }

        public String toString() {
            return "<new plugin>";
        }

        public boolean isChange() {
            return true;
        }
    }

    private static class NoChange
    extends ChangeReason {
        private static final NoChange sInstance = new NoChange();

        public static final NoChange getInstance() {
            return sInstance;
        }

        private NoChange() {
        }

        public String toString() {
            return "<unchanged>";
        }

        public boolean isChange() {
            return false;
        }
    }

    public static abstract class ChangeReason {
        public abstract boolean isChange();
    }
}

