/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFix;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.fix.NullAnnotationsFix;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullAnnotationsRewriteOperations {
    public static SignatureAnnotationRewriteOperation createAddAnnotationOperation(CompilationUnit compilationUnit, IProblemLocation problem, String annotationToAdd, String annotationToRemove, Set<String> handledPositions, boolean thisUnitOnly, boolean allowRemove, boolean modifyOverridden) {
        SignatureAnnotationRewriteOperation result;
        SignatureAnnotationRewriteOperation signatureAnnotationRewriteOperation = result = modifyOverridden ? NullAnnotationsRewriteOperations.createAddAnnotationToOverriddenOperation(compilationUnit, problem, annotationToAdd, annotationToRemove, handledPositions, thisUnitOnly, allowRemove) : NullAnnotationsRewriteOperations.createAddAnnotationOperation(compilationUnit, problem, annotationToAdd, annotationToRemove, handledPositions, thisUnitOnly, allowRemove);
        if (handledPositions != null && result != null) {
            if (handledPositions.contains(result.getKey())) {
                return null;
            }
            handledPositions.add(result.getKey());
        }
        return result;
    }

    private static SignatureAnnotationRewriteOperation createAddAnnotationOperation(CompilationUnit compilationUnit, IProblemLocation problem, String annotationToAdd, String annotationToRemove, Set<String> handledPositions, boolean thisUnitOnly, boolean allowRemove) {
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        if (!JavaModelUtil.is50OrHigher(cu.getJavaProject())) {
            return null;
        }
        ASTNode selectedNode = problem.getCoveringNode(compilationUnit);
        if (selectedNode == null) {
            return null;
        }
        ASTNode declaringNode = NullAnnotationsRewriteOperations.getDeclaringNode(selectedNode);
        switch (problem.getProblemId()) {
            case 67109780: {
                break;
            }
            case 67109778: {
                if (declaringNode != null) break;
                declaringNode = selectedNode;
                break;
            }
            default: {
                if (!NullAnnotationsFix.hasExplicitNullAnnotation(cu, problem.getOffset())) break;
                return null;
            }
        }
        String annotationNameLabel = annotationToAdd;
        int lastDot = annotationToAdd.lastIndexOf(46);
        if (lastDot != -1) {
            annotationNameLabel = annotationToAdd.substring(lastDot + 1);
        }
        annotationNameLabel = BasicElementLabels.getJavaElementName(annotationNameLabel);
        if (selectedNode.getParent() instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)selectedNode.getParent();
            int paramIdx = methodInvocation.arguments().indexOf(selectedNode);
            IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
            if ((compilationUnit = NullAnnotationsRewriteOperations.findCUForMethod(compilationUnit, cu, methodBinding)) == null) {
                return null;
            }
            if (thisUnitOnly && !compilationUnit.getJavaElement().equals(cu)) {
                return null;
            }
            ASTNode methodDecl = compilationUnit.findDeclaringNode(methodBinding.getKey());
            if (methodDecl == null) {
                return null;
            }
            String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_method_parameter_nullness, annotationNameLabel);
            return new ParameterAnnotationRewriteOperation(compilationUnit, (MethodDeclaration)methodDecl, annotationToAdd, annotationToRemove, paramIdx, allowRemove, message);
        }
        if (declaringNode instanceof MethodDeclaration) {
            MethodDeclaration declaration = (MethodDeclaration)declaringNode;
            switch (problem.getProblemId()) {
                case 67109779: 
                case 67109780: 
                case 67109781: 
                case 67109782: 
                case 536871369: 
                case 536871370: {
                    String paramName;
                    if (declaration.getNodeType() != 31 || (paramName = NullAnnotationsRewriteOperations.findAffectedParameterName(selectedNode)) == null) break;
                    String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_method_parameter_nullness, annotationNameLabel);
                    return new ParameterAnnotationRewriteOperation(compilationUnit, declaration, annotationToAdd, annotationToRemove, paramName, allowRemove, message);
                }
                case 16778126: 
                case 16778127: 
                case 16778128: 
                case 536871845: {
                    if (NullAnnotationsFix.isComplainingAboutArgument(selectedNode)) {
                        String paramName;
                        if (declaration.getNodeType() != 31 || (paramName = NullAnnotationsRewriteOperations.findAffectedParameterName(selectedNode)) == null) break;
                        String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_method_parameter_nullness, annotationNameLabel);
                        return new ParameterAnnotationRewriteOperation(compilationUnit, declaration, annotationToAdd, annotationToRemove, paramName, allowRemove, message);
                    }
                }
                case 67109778: {
                    String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_method_return_nullness, new String[]{declaration.getName().getIdentifier(), annotationNameLabel});
                    return new ReturnAnnotationRewriteOperation(compilationUnit, declaration, annotationToAdd, annotationToRemove, allowRemove, message);
                }
            }
        }
        return null;
    }

    private static SignatureAnnotationRewriteOperation createAddAnnotationToOverriddenOperation(CompilationUnit compilationUnit, IProblemLocation problem, String annotationToAdd, String annotationToRemove, Set<String> handledPositions, boolean thisUnitOnly, boolean allowRemove) {
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        if (!JavaModelUtil.is50OrHigher(cu.getJavaProject())) {
            return null;
        }
        ASTNode selectedNode = problem.getCoveringNode(compilationUnit);
        if (selectedNode == null) {
            return null;
        }
        ASTNode declaringNode = NullAnnotationsRewriteOperations.getDeclaringNode(selectedNode);
        switch (problem.getProblemId()) {
            case 67109779: 
            case 67109780: {
                break;
            }
            case 67109778: {
                if (declaringNode != null) break;
                declaringNode = selectedNode;
                break;
            }
            default: {
                return null;
            }
        }
        String annotationNameLabel = annotationToAdd;
        int lastDot = annotationToAdd.lastIndexOf(46);
        if (lastDot != -1) {
            annotationNameLabel = annotationToAdd.substring(lastDot + 1);
        }
        annotationNameLabel = BasicElementLabels.getJavaElementName(annotationNameLabel);
        if (declaringNode instanceof MethodDeclaration) {
            MethodDeclaration declaration = (MethodDeclaration)declaringNode;
            switch (problem.getProblemId()) {
                case 67109779: 
                case 67109780: {
                    return NullAnnotationsRewriteOperations.createChangeOverriddenParameterOperation(compilationUnit, cu, declaration, selectedNode, allowRemove, annotationToAdd, annotationToRemove, annotationNameLabel);
                }
                case 67109778: {
                    if (!NullAnnotationsRewriteOperations.hasNullAnnotation(declaration)) break;
                    return NullAnnotationsRewriteOperations.createChangeOverriddenReturnOperation(compilationUnit, cu, declaration, allowRemove, annotationToAdd, annotationToRemove, annotationNameLabel);
                }
            }
        }
        return null;
    }

    private static SignatureAnnotationRewriteOperation createChangeOverriddenParameterOperation(CompilationUnit compilationUnit, ICompilationUnit cu, MethodDeclaration declaration, ASTNode selectedNode, boolean allowRemove, String annotationToAdd, String annotationToRemove, String annotationNameLabel) {
        IMethodBinding methodDeclBinding = declaration.resolveBinding();
        if (methodDeclBinding == null) {
            return null;
        }
        IMethodBinding overridden = Bindings.findOverriddenMethod(methodDeclBinding, false);
        if (overridden == null) {
            return null;
        }
        if ((compilationUnit = NullAnnotationsRewriteOperations.findCUForMethod(compilationUnit, cu, overridden)) == null) {
            return null;
        }
        ASTNode methodDecl = compilationUnit.findDeclaringNode(overridden.getKey());
        if (methodDecl == null) {
            return null;
        }
        declaration = (MethodDeclaration)methodDecl;
        String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_overridden_parameter_nullness, new String[]{overridden.getName(), annotationNameLabel});
        String paramName = NullAnnotationsRewriteOperations.findAffectedParameterName(selectedNode);
        return new ParameterAnnotationRewriteOperation(compilationUnit, declaration, annotationToAdd, annotationToRemove, paramName, allowRemove, message);
    }

    private static String findAffectedParameterName(ASTNode selectedNode) {
        IBinding binding;
        VariableDeclaration argDecl;
        VariableDeclaration variableDeclaration = argDecl = selectedNode instanceof VariableDeclaration ? (VariableDeclaration)selectedNode : (VariableDeclaration)ASTNodes.getParent(selectedNode, VariableDeclaration.class);
        if (argDecl != null) {
            return argDecl.getName().getIdentifier();
        }
        if (selectedNode.getNodeType() == 42 && (binding = ((SimpleName)selectedNode).resolveBinding()).getKind() == 3 && ((IVariableBinding)binding).isParameter()) {
            return ((SimpleName)selectedNode).getIdentifier();
        }
        return null;
    }

    private static boolean hasNullAnnotation(MethodDeclaration decl) {
        List modifiers = decl.modifiers();
        String nonnull = NullAnnotationsFix.getNonNullAnnotationName(decl.resolveBinding().getJavaElement(), false);
        String nullable = NullAnnotationsFix.getNullableAnnotationName(decl.resolveBinding().getJavaElement(), false);
        for (Object mod : modifiers) {
            if (!(mod instanceof Annotation)) continue;
            Name annotationName = ((Annotation)mod).getTypeName();
            String fullyQualifiedName = annotationName.getFullyQualifiedName();
            if (annotationName.isSimpleName() ? nonnull.endsWith(fullyQualifiedName) : fullyQualifiedName.equals(nonnull)) {
                return true;
            }
            if (!(annotationName.isSimpleName() ? nullable.endsWith(fullyQualifiedName) : fullyQualifiedName.equals(nullable))) continue;
            return true;
        }
        return false;
    }

    private static SignatureAnnotationRewriteOperation createChangeOverriddenReturnOperation(CompilationUnit compilationUnit, ICompilationUnit cu, MethodDeclaration declaration, boolean allowRemove, String annotationToAdd, String annotationToRemove, String annotationNameLabel) {
        IMethodBinding methodDeclBinding = declaration.resolveBinding();
        if (methodDeclBinding == null) {
            return null;
        }
        IMethodBinding overridden = Bindings.findOverriddenMethod(methodDeclBinding, false);
        if (overridden == null) {
            return null;
        }
        if ((compilationUnit = NullAnnotationsRewriteOperations.findCUForMethod(compilationUnit, cu, overridden)) == null) {
            return null;
        }
        ASTNode methodDecl = compilationUnit.findDeclaringNode(overridden.getKey());
        if (methodDecl == null) {
            return null;
        }
        declaration = (MethodDeclaration)methodDecl;
        String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_overridden_return_nullness, new String[]{overridden.getName(), annotationNameLabel});
        return new ReturnAnnotationRewriteOperation(compilationUnit, declaration, annotationToAdd, annotationToRemove, allowRemove, message);
    }

    private static CompilationUnit findCUForMethod(CompilationUnit compilationUnit, ICompilationUnit cu, IMethodBinding methodBinding) {
        ASTNode methodDecl = compilationUnit.findDeclaringNode((IBinding)methodBinding.getMethodDeclaration());
        if (methodDecl == null) {
            ITypeBinding declaringTypeDecl = methodBinding.getDeclaringClass().getTypeDeclaration();
            if (declaringTypeDecl.isFromSource()) {
                ICompilationUnit targetCU = null;
                try {
                    targetCU = ASTResolving.findCompilationUnitForBinding(cu, compilationUnit, declaringTypeDecl);
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                if (targetCU != null) {
                    return ASTResolving.createQuickFixAST(targetCU, null);
                }
            }
            return null;
        }
        return compilationUnit;
    }

    private static ASTNode getDeclaringNode(ASTNode selectedNode) {
        return ASTNodes.getParent(selectedNode, 31);
    }

    static class ParameterAnnotationRewriteOperation
    extends SignatureAnnotationRewriteOperation {
        private SingleVariableDeclaration fArgument;

        ParameterAnnotationRewriteOperation(CompilationUnit unit, MethodDeclaration method, String annotationToAdd, String annotationToRemove, String paramName, boolean allowRemove, String message) {
            this.fUnit = unit;
            this.fKey = method.resolveBinding().getKey();
            this.fAnnotationToAdd = annotationToAdd;
            this.fAnnotationToRemove = annotationToRemove;
            this.fAllowRemove = allowRemove;
            this.fMessage = message;
            for (Object param : method.parameters()) {
                SingleVariableDeclaration argument = (SingleVariableDeclaration)param;
                if (!argument.getName().getIdentifier().equals(paramName)) continue;
                this.fArgument = argument;
                this.fKey = String.valueOf(this.fKey) + argument.getName().getIdentifier();
                return;
            }
            throw new RuntimeException("Argument " + paramName + " not found in method " + method.getName().getIdentifier());
        }

        ParameterAnnotationRewriteOperation(CompilationUnit unit, MethodDeclaration method, String annotationToAdd, String annotationToRemove, int paramIdx, boolean allowRemove, String message) {
            this.fUnit = unit;
            this.fKey = method.resolveBinding().getKey();
            this.fAnnotationToAdd = annotationToAdd;
            this.fAnnotationToRemove = annotationToRemove;
            this.fAllowRemove = allowRemove;
            this.fArgument = (SingleVariableDeclaration)method.parameters().get(paramIdx);
            this.fKey = String.valueOf(this.fKey) + this.fArgument.getName().getIdentifier();
            this.fMessage = message;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel linkedModel) throws CoreException {
            AST ast = cuRewrite.getRoot().getAST();
            ListRewrite listRewrite = cuRewrite.getASTRewrite().getListRewrite((ASTNode)this.fArgument, SingleVariableDeclaration.MODIFIERS2_PROPERTY);
            TextEditGroup group = this.createTextEditGroup(this.fMessage, cuRewrite);
            if (!this.checkExisting(this.fArgument.modifiers(), listRewrite, group)) {
                return;
            }
            MarkerAnnotation newAnnotation = ast.newMarkerAnnotation();
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            String resolvableName = importRewrite.addImport(this.fAnnotationToAdd);
            newAnnotation.setTypeName(ast.newName(resolvableName));
            listRewrite.insertLast((ASTNode)newAnnotation, group);
        }
    }

    static class RemoveRedundantAnnotationRewriteOperation
    extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
        private IProblemLocation fProblem;
        private CompilationUnit fCompilationUnit;

        public RemoveRedundantAnnotationRewriteOperation(CompilationUnit compilationUnit, IProblemLocation problem) {
            this.fCompilationUnit = compilationUnit;
            this.fProblem = problem;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel linkedModel) throws CoreException {
            TextEditGroup group = this.createTextEditGroup(FixMessages.NullAnnotationsRewriteOperations_remove_redundant_nullness_annotation, cuRewrite);
            ASTRewrite astRewrite = cuRewrite.getASTRewrite();
            CompilationUnit astRoot = this.fCompilationUnit;
            ASTNode selectedNode = this.fProblem.getCoveringNode(astRoot);
            if (this.fProblem.getProblemId() == 67109786) {
                List modifiers;
                if (selectedNode instanceof SingleVariableDeclaration) {
                    SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)selectedNode;
                    modifiers = singleVariableDeclaration.modifiers();
                } else if (selectedNode instanceof MethodDeclaration) {
                    MethodDeclaration methodDeclaration = (MethodDeclaration)selectedNode;
                    modifiers = methodDeclaration.modifiers();
                } else {
                    return;
                }
                for (IExtendedModifier modifier : modifiers) {
                    MarkerAnnotation annotation;
                    IAnnotationBinding annotationBinding;
                    String name;
                    if (!(modifier instanceof MarkerAnnotation) || !(name = (annotationBinding = (annotation = (MarkerAnnotation)modifier).resolveAnnotationBinding()).getName()).equals(NullAnnotationsFix.getNonNullAnnotationName(this.fCompilationUnit.getJavaElement(), true))) continue;
                    astRewrite.remove((ASTNode)annotation, group);
                }
            } else {
                if (!(selectedNode instanceof MarkerAnnotation)) {
                    return;
                }
                MarkerAnnotation annotation = (MarkerAnnotation)selectedNode;
                IAnnotationBinding annotationBinding = annotation.resolveAnnotationBinding();
                String name = annotationBinding.getName();
                if (name.equals(NullAnnotationsFix.getNonNullByDefaultAnnotationName(this.fCompilationUnit.getJavaElement(), true))) {
                    astRewrite.remove((ASTNode)annotation, group);
                }
            }
        }
    }

    static class ReturnAnnotationRewriteOperation
    extends SignatureAnnotationRewriteOperation {
        private final BodyDeclaration fBodyDeclaration;

        ReturnAnnotationRewriteOperation(CompilationUnit unit, MethodDeclaration method, String annotationToAdd, String annotationToRemove, boolean allowRemove, String message) {
            this.fUnit = unit;
            this.fKey = String.valueOf(method.resolveBinding().getKey()) + "<return>";
            this.fBodyDeclaration = method;
            this.fAnnotationToAdd = annotationToAdd;
            this.fAnnotationToRemove = annotationToRemove;
            this.fAllowRemove = allowRemove;
            this.fMessage = message;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel model) throws CoreException {
            AST ast = cuRewrite.getRoot().getAST();
            ListRewrite listRewrite = cuRewrite.getASTRewrite().getListRewrite((ASTNode)this.fBodyDeclaration, this.fBodyDeclaration.getModifiersProperty());
            TextEditGroup group = this.createTextEditGroup(this.fMessage, cuRewrite);
            if (!this.checkExisting(this.fBodyDeclaration.modifiers(), listRewrite, group)) {
                return;
            }
            MarkerAnnotation newAnnotation = ast.newMarkerAnnotation();
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            String resolvableName = importRewrite.addImport(this.fAnnotationToAdd);
            newAnnotation.setTypeName(ast.newName(resolvableName));
            listRewrite.insertLast((ASTNode)newAnnotation, group);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class SignatureAnnotationRewriteOperation
    extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
        String fAnnotationToAdd;
        String fAnnotationToRemove;
        boolean fAllowRemove;
        CompilationUnit fUnit;
        protected String fKey;
        protected String fMessage;

        SignatureAnnotationRewriteOperation() {
        }

        public String getKey() {
            return this.fKey;
        }

        public CompilationUnit getCompilationUnit() {
            return this.fUnit;
        }

        boolean checkExisting(List<IExtendedModifier> existingModifiers, ListRewrite listRewrite, TextEditGroup editGroup) {
            for (IExtendedModifier mod : existingModifiers) {
                if (!(mod instanceof MarkerAnnotation)) continue;
                MarkerAnnotation annotation = (MarkerAnnotation)mod;
                String existingName = annotation.getTypeName().getFullyQualifiedName();
                int lastDot = this.fAnnotationToRemove.lastIndexOf(46);
                if (existingName.equals(this.fAnnotationToRemove) || lastDot != -1 && this.fAnnotationToRemove.substring(lastDot + 1).equals(existingName)) {
                    if (!this.fAllowRemove) {
                        return false;
                    }
                    listRewrite.remove((ASTNode)annotation, editGroup);
                    return true;
                }
                lastDot = this.fAnnotationToAdd.lastIndexOf(46);
                if (!existingName.equals(this.fAnnotationToAdd) && (lastDot == -1 || !this.fAnnotationToAdd.substring(lastDot + 1).equals(existingName))) continue;
                return false;
            }
            return true;
        }

        public String getMessage() {
            return this.fMessage;
        }
    }
}

