/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.javadoc;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.CorextMessages;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIException;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaDocLocations {
    private static final String JAR_PROTOCOL = "jar";
    public static final String ARCHIVE_PREFIX = "jar:";
    private static final String PREF_JAVADOCLOCATIONS = "org.eclipse.jdt.ui.javadoclocations";
    public static final String PREF_JAVADOCLOCATIONS_MIGRATED = "org.eclipse.jdt.ui.javadoclocations.migrated";
    private static final String NODE_ROOT = "javadoclocation";
    private static final String NODE_ENTRY = "location_01";
    private static final String NODE_PATH = "path";
    private static final String NODE_URL = "url";
    private static final QualifiedName PROJECT_JAVADOC = new QualifiedName("org.eclipse.jdt.ui", "project_javadoc_location");

    public static void migrateToClasspathAttributes() {
        final Map<IPath, String> oldLocations = JavaDocLocations.loadOldForCompatibility();
        if (oldLocations.isEmpty()) {
            IPreferenceStore preferenceStore = PreferenceConstants.getPreferenceStore();
            preferenceStore.setValue(PREF_JAVADOCLOCATIONS, "");
            preferenceStore.setValue(PREF_JAVADOCLOCATIONS_MIGRATED, true);
            return;
        }
        Job job = new Job(CorextMessages.JavaDocLocations_migratejob_name){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor pm) throws CoreException {
                            JavaDocLocations.updateClasspathEntries(oldLocations, pm);
                            IPreferenceStore preferenceStore = PreferenceConstants.getPreferenceStore();
                            preferenceStore.setValue(JavaDocLocations.PREF_JAVADOCLOCATIONS, "");
                            preferenceStore.setValue(JavaDocLocations.PREF_JAVADOCLOCATIONS_MIGRATED, true);
                        }
                    };
                    new WorkbenchRunnableAdapter(runnable).run(monitor);
                }
                catch (InvocationTargetException e) {
                    JavaPlugin.log(e);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    static final void updateClasspathEntries(Map<IPath, String> oldLocationMap, IProgressMonitor monitor) throws JavaModelException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IJavaProject[] javaProjects = JavaCore.create((IWorkspaceRoot)root).getJavaProjects();
        try {
            monitor.beginTask(CorextMessages.JavaDocLocations_migrate_operation, javaProjects.length);
            int i = 0;
            while (i < javaProjects.length) {
                IJavaProject project = javaProjects[i];
                String projectJavadoc = oldLocationMap.get(project.getPath());
                if (projectJavadoc != null) {
                    try {
                        JavaDocLocations.setProjectJavadocLocation(project, projectJavadoc);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                IClasspathEntry[] rawClasspath = project.getRawClasspath();
                boolean hasChange = false;
                int k = 0;
                while (k < rawClasspath.length) {
                    IClasspathEntry updated = JavaDocLocations.getConvertedEntry(rawClasspath[k], project, oldLocationMap);
                    if (updated != null) {
                        rawClasspath[k] = updated;
                        hasChange = true;
                    }
                    ++k;
                }
                if (hasChange) {
                    project.setRawClasspath(rawClasspath, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    private static IClasspathEntry getConvertedEntry(IClasspathEntry entry, IJavaProject project, Map<IPath, String> oldLocationMap) {
        IPath path = null;
        switch (entry.getEntryKind()) {
            case 2: 
            case 3: {
                return null;
            }
            case 5: {
                JavaDocLocations.convertContainer(entry, project, oldLocationMap);
                return null;
            }
            case 1: {
                path = entry.getPath();
                break;
            }
            case 4: {
                path = JavaCore.getResolvedVariablePath((IPath)entry.getPath());
                break;
            }
            default: {
                return null;
            }
        }
        if (path == null) {
            return null;
        }
        IClasspathAttribute[] extraAttributes = entry.getExtraAttributes();
        int i = 0;
        while (i < extraAttributes.length) {
            if ("javadoc_location".equals(extraAttributes[i].getName())) {
                return null;
            }
            ++i;
        }
        String libraryJavadocLocation = oldLocationMap.get(path);
        if (libraryJavadocLocation != null) {
            CPListElement element = CPListElement.createFromExisting(entry, project);
            element.setAttribute("javadoc_location", libraryJavadocLocation);
            return element.getClasspathEntry();
        }
        return null;
    }

    private static void convertContainer(IClasspathEntry entry, IJavaProject project, Map<IPath, String> oldLocationMap) {
        try {
            IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
            if (container == null) {
                return;
            }
            IClasspathEntry[] entries = container.getClasspathEntries();
            boolean hasChange = false;
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry curr = entries[i];
                IClasspathEntry updatedEntry = JavaDocLocations.getConvertedEntry(curr, project, oldLocationMap);
                if (updatedEntry != null) {
                    entries[i] = updatedEntry;
                    hasChange = true;
                }
                ++i;
            }
            if (hasChange) {
                BuildPathSupport.requestContainerUpdate(project, container, entries);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static void setProjectJavadocLocation(IJavaProject project, URL url) {
        try {
            String location = url != null ? url.toExternalForm() : null;
            JavaDocLocations.setProjectJavadocLocation(project, location);
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
    }

    private static void setProjectJavadocLocation(IJavaProject project, String url) throws CoreException {
        project.getProject().setPersistentProperty(PROJECT_JAVADOC, url);
    }

    public static URL getProjectJavadocLocation(IJavaProject project) {
        String prop;
        block4: {
            if (!project.getProject().isAccessible()) {
                return null;
            }
            try {
                prop = project.getProject().getPersistentProperty(PROJECT_JAVADOC);
                if (prop != null) break block4;
                return null;
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
                return null;
            }
        }
        return JavaDocLocations.parseURL(prop);
    }

    public static URL getLibraryJavadocLocation(IClasspathEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Entry must not be null");
        }
        int kind = entry.getEntryKind();
        if (kind != 1 && kind != 4) {
            throw new IllegalArgumentException("Entry must be of kind CPE_LIBRARY or CPE_VARIABLE");
        }
        IClasspathAttribute[] extraAttributes = entry.getExtraAttributes();
        int i = 0;
        while (i < extraAttributes.length) {
            IClasspathAttribute attrib = extraAttributes[i];
            if ("javadoc_location".equals(attrib.getName())) {
                return JavaDocLocations.parseURL(attrib.getValue());
            }
            ++i;
        }
        return null;
    }

    public static URL getJavadocBaseLocation(IJavaElement element) throws JavaModelException {
        if (element.getElementType() == 2) {
            return JavaDocLocations.getProjectJavadocLocation((IJavaProject)element);
        }
        IPackageFragmentRoot root = JavaModelUtil.getPackageFragmentRoot(element);
        if (root == null) {
            return null;
        }
        if (root.getKind() == 2) {
            IClasspathEntry entry = root.getResolvedClasspathEntry();
            URL javadocLocation = JavaDocLocations.getLibraryJavadocLocation(entry);
            if (javadocLocation != null) {
                return JavaDocLocations.getLibraryJavadocLocation(entry);
            }
            entry = root.getRawClasspathEntry();
            switch (entry.getEntryKind()) {
                case 1: 
                case 4: {
                    return JavaDocLocations.getLibraryJavadocLocation(entry);
                }
            }
            return null;
        }
        return JavaDocLocations.getProjectJavadocLocation(root.getJavaProject());
    }

    private static JavaUIException createException(Throwable t, String message) {
        return new JavaUIException(JavaUIStatus.createError(4, message, t));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<IPath, String> loadOldForCompatibility() {
        HashMap<IPath, String> resultingOldLocations;
        block38: {
            resultingOldLocations = new HashMap<IPath, String>();
            String string = PreferenceConstants.getPreferenceStore().getString(PREF_JAVADOCLOCATIONS);
            if (string != null && string.length() > 0) {
                byte[] bytes;
                try {
                    bytes = string.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    bytes = string.getBytes();
                }
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                try {
                    JavaDocLocations.loadFromStream(new InputSource(is), resultingOldLocations);
                    PreferenceConstants.getPreferenceStore().setValue(PREF_JAVADOCLOCATIONS, "");
                    HashMap<IPath, String> hashMap = resultingOldLocations;
                    return hashMap;
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                }
                finally {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            try {
                String STORE_FILE = "javadoclocations.xml";
                File file = JavaPlugin.getDefault().getStateLocation().append("javadoclocations.xml").toFile();
                if (!file.exists()) break block38;
                FileReader reader = null;
                try {
                    reader = new FileReader(file);
                    JavaDocLocations.loadFromStream(new InputSource(reader), resultingOldLocations);
                    file.delete();
                    HashMap<IPath, String> hashMap = resultingOldLocations;
                    return hashMap;
                }
                catch (IOException e) {
                    JavaPlugin.log(e);
                }
                finally {
                    try {
                        if (reader != null) {
                            ((Reader)reader).close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (CoreException e2) {
                JavaPlugin.log(e2);
            }
        }
        try {
            QualifiedName QUALIFIED_NAME = new QualifiedName("org.eclipse.jdt.ui", "jdoclocation");
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            String xmlString = root.getPersistentProperty(QUALIFIED_NAME);
            if (xmlString == null) return resultingOldLocations;
            StringReader reader = new StringReader(xmlString);
            try {
                JavaDocLocations.loadFromStream(new InputSource(reader), resultingOldLocations);
                root.setPersistentProperty(QUALIFIED_NAME, null);
                HashMap<IPath, String> hashMap = resultingOldLocations;
                return hashMap;
            }
            finally {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        return resultingOldLocations;
    }

    private static void loadFromStream(InputSource inputSource, Map<IPath, String> oldLocations) throws CoreException {
        Element cpElement;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            cpElement = parser.parse(inputSource).getDocumentElement();
        }
        catch (SAXException e) {
            throw JavaDocLocations.createException(e, CorextMessages.JavaDocLocations_error_readXML);
        }
        catch (ParserConfigurationException e) {
            throw JavaDocLocations.createException(e, CorextMessages.JavaDocLocations_error_readXML);
        }
        catch (IOException e) {
            throw JavaDocLocations.createException(e, CorextMessages.JavaDocLocations_error_readXML);
        }
        if (cpElement == null) {
            return;
        }
        if (!cpElement.getNodeName().equalsIgnoreCase(NODE_ROOT)) {
            return;
        }
        NodeList list = cpElement.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Element element;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (element = (Element)node).getNodeName().equalsIgnoreCase(NODE_ENTRY)) {
                String varPath = element.getAttribute(NODE_PATH);
                String varURL = JavaDocLocations.parseURL(element.getAttribute(NODE_URL)).toExternalForm();
                oldLocations.put(Path.fromPortableString((String)varPath), varURL);
            }
            ++i;
        }
    }

    public static URL getJavadocLocation(IJavaElement element, boolean includeMemberReference) throws JavaModelException {
        URL baseLocation = JavaDocLocations.getJavadocBaseLocation(element);
        if (baseLocation == null) {
            return null;
        }
        String urlString = baseLocation.toExternalForm();
        StringBuffer pathBuffer = new StringBuffer(urlString);
        if (!urlString.endsWith("/")) {
            pathBuffer.append('/');
        }
        switch (element.getElementType()) {
            case 4: {
                JavaDocLocations.appendPackageSummaryPath((IPackageFragment)element, pathBuffer);
                break;
            }
            case 2: 
            case 3: {
                JavaDocLocations.appendIndexPath(pathBuffer);
                break;
            }
            case 12: {
                element = element.getParent();
            }
            case 5: {
                IType mainType = ((ICompilationUnit)element).findPrimaryType();
                if (mainType == null) {
                    return null;
                }
                JavaDocLocations.appendTypePath(mainType, pathBuffer);
                break;
            }
            case 6: {
                JavaDocLocations.appendTypePath(((IClassFile)element).getType(), pathBuffer);
                break;
            }
            case 7: {
                JavaDocLocations.appendTypePath((IType)element, pathBuffer);
                break;
            }
            case 8: {
                IField field = (IField)element;
                JavaDocLocations.appendTypePath(field.getDeclaringType(), pathBuffer);
                if (!includeMemberReference) break;
                JavaDocLocations.appendFieldReference(field, pathBuffer);
                break;
            }
            case 9: {
                IMethod method = (IMethod)element;
                JavaDocLocations.appendTypePath(method.getDeclaringType(), pathBuffer);
                if (!includeMemberReference) break;
                JavaDocLocations.appendMethodReference(method, pathBuffer);
                break;
            }
            case 10: {
                JavaDocLocations.appendTypePath(((IMember)element).getDeclaringType(), pathBuffer);
                break;
            }
            case 13: {
                IImportDeclaration decl = (IImportDeclaration)element;
                if (decl.isOnDemand()) {
                    IJavaElement cont = JavaModelUtil.findTypeContainer(element.getJavaProject(), Signature.getQualifier((String)decl.getElementName()));
                    if (cont instanceof IType) {
                        JavaDocLocations.appendTypePath((IType)cont, pathBuffer);
                        break;
                    }
                    if (!(cont instanceof IPackageFragment)) break;
                    JavaDocLocations.appendPackageSummaryPath((IPackageFragment)cont, pathBuffer);
                    break;
                }
                IType imp = element.getJavaProject().findType(decl.getElementName());
                JavaDocLocations.appendTypePath(imp, pathBuffer);
                break;
            }
            case 11: {
                IJavaElement pack = element.getAncestor(4);
                if (pack != null) {
                    JavaDocLocations.appendPackageSummaryPath((IPackageFragment)pack, pathBuffer);
                    break;
                }
                return null;
            }
            default: {
                return null;
            }
        }
        try {
            return new URL(pathBuffer.toString());
        }
        catch (MalformedURLException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    private static void appendPackageSummaryPath(IPackageFragment pack, StringBuffer buf) {
        String packPath = pack.getElementName().replace('.', '/');
        buf.append(packPath);
        buf.append("/package-summary.html");
    }

    private static void appendIndexPath(StringBuffer buf) {
        buf.append("index.html");
    }

    private static void appendTypePath(IType type, StringBuffer buf) {
        IPackageFragment pack = type.getPackageFragment();
        String packPath = pack.getElementName().replace('.', '/');
        String typePath = type.getTypeQualifiedName('.');
        if (packPath.length() > 0) {
            buf.append(packPath);
            buf.append('/');
        }
        buf.append(typePath);
        buf.append(".html");
    }

    private static void appendFieldReference(IField field, StringBuffer buf) {
        buf.append('#');
        buf.append(field.getElementName());
    }

    private static void appendMethodReference(IMethod meth, StringBuffer buf) throws JavaModelException {
        buf.append('#');
        buf.append(meth.getElementName());
        buf.append('(');
        String[] params = meth.getParameterTypes();
        IType declaringType = meth.getDeclaringType();
        boolean isVararg = Flags.isVarargs((int)meth.getFlags());
        int lastParam = params.length - 1;
        int i = 0;
        while (i <= lastParam) {
            String curr;
            String fullName;
            if (i != 0) {
                buf.append(", ");
            }
            if ((fullName = JavaModelUtil.getResolvedTypeName(curr = Signature.getTypeErasure((String)params[i]), declaringType)) != null) {
                buf.append(fullName);
                int dim = Signature.getArrayCount((String)curr);
                if (i == lastParam && isVararg) {
                    --dim;
                }
                while (dim > 0) {
                    buf.append("[]");
                    --dim;
                }
                if (i == lastParam && isVararg) {
                    buf.append("...");
                }
            }
            ++i;
        }
        buf.append(')');
    }

    public static String getBaseURL(IMember member) throws JavaModelException {
        if (member.isBinary()) {
            URL baseURL = JavaUI.getJavadocLocation((IJavaElement)member, false);
            if (baseURL != null) {
                URL baseURL2;
                if (baseURL.getProtocol().equals(JAR_PROTOCOL) && (baseURL2 = PlatformUI.getWorkbench().getHelpSystem().resolve(baseURL.toExternalForm(), true)) != null) {
                    baseURL = baseURL2;
                }
                return baseURL.toExternalForm();
            }
        } else {
            IPath location;
            IResource resource = member.getResource();
            if (resource != null && (location = resource.getLocation()) != null) {
                return location.toFile().toURI().toString();
            }
        }
        return null;
    }

    public static URL parseURL(String url) {
        try {
            try {
                return new URI(url).toURL();
            }
            catch (URISyntaxException e) {
                try {
                    if (url.startsWith("file:/")) {
                        return new URI("file", null, url.substring(5), null).toURL();
                    }
                    return URIUtil.fromString((String)url).toURL();
                }
                catch (URISyntaxException e1) {
                    JavaPlugin.log(e);
                    return new URL(url);
                }
            }
        }
        catch (MalformedURLException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    public static File toFile(URL url) {
        try {
            return URIUtil.toFile((URI)url.toURI());
        }
        catch (URISyntaxException e) {
            JavaPlugin.log(e);
            return new File(url.getFile());
        }
    }
}

