/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringActions;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkingSet;

public final class RefactoringAvailabilityTester {
    public static IType getDeclaringType(IJavaElement element) {
        if (element == null) {
            return null;
        }
        if (!(element instanceof IType)) {
            element = element.getAncestor(7);
        }
        return (IType)element;
    }

    public static IJavaElement[] getJavaElements(Object[] elements) {
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>();
        int index = 0;
        while (index < elements.length) {
            if (elements[index] instanceof IJavaElement) {
                result.add((IJavaElement)elements[index]);
            }
            ++index;
        }
        return result.toArray(new IJavaElement[result.size()]);
    }

    public static IMember[] getPullUpMembers(IType type) throws JavaModelException {
        ArrayList<IField> list = new ArrayList<IField>(3);
        if (type.exists()) {
            IField[] members = type.getFields();
            int index = 0;
            while (index < members.length) {
                if (RefactoringAvailabilityTester.isPullUpAvailable((IMember)members[index])) {
                    list.add(members[index]);
                }
                ++index;
            }
            members = type.getMethods();
            index = 0;
            while (index < members.length) {
                if (RefactoringAvailabilityTester.isPullUpAvailable((IMember)members[index])) {
                    list.add(members[index]);
                }
                ++index;
            }
            members = type.getTypes();
            index = 0;
            while (index < members.length) {
                if (RefactoringAvailabilityTester.isPullUpAvailable((IMember)members[index])) {
                    list.add(members[index]);
                }
                ++index;
            }
        }
        return list.toArray(new IMember[list.size()]);
    }

    public static IMember[] getPushDownMembers(IType type) throws JavaModelException {
        ArrayList<IField> list = new ArrayList<IField>(3);
        if (type.exists()) {
            IField[] members = type.getFields();
            int index = 0;
            while (index < members.length) {
                if (RefactoringAvailabilityTester.isPushDownAvailable((IMember)members[index])) {
                    list.add(members[index]);
                }
                ++index;
            }
            members = type.getMethods();
            index = 0;
            while (index < members.length) {
                if (RefactoringAvailabilityTester.isPushDownAvailable((IMember)members[index])) {
                    list.add(members[index]);
                }
                ++index;
            }
        }
        return list.toArray(new IMember[list.size()]);
    }

    public static IResource[] getResources(Object[] elements) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        int index = 0;
        while (index < elements.length) {
            if (elements[index] instanceof IResource) {
                result.add((IResource)elements[index]);
            }
            ++index;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public static IType getSingleSelectedType(IStructuredSelection selection) throws JavaModelException {
        ICompilationUnit unit;
        Object first = selection.getFirstElement();
        if (first instanceof IType) {
            return (IType)first;
        }
        if (first instanceof ICompilationUnit && (unit = (ICompilationUnit)first).exists()) {
            return JavaElementUtil.getMainType(unit);
        }
        return null;
    }

    public static IType getTopLevelType(IMember[] members) {
        if (members != null && members.length == 1 && Checks.isTopLevelType(members[0])) {
            return (IType)members[0];
        }
        return null;
    }

    public static boolean isChangeSignatureAvailable(IMethod method) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)method) && !Flags.isAnnotation((int)method.getDeclaringType().getFlags());
    }

    public static boolean isChangeSignatureAvailable(IStructuredSelection selection) throws JavaModelException {
        if (selection.size() == 1 && selection.getFirstElement() instanceof IMethod) {
            IMethod method = (IMethod)selection.getFirstElement();
            return RefactoringAvailabilityTester.isChangeSignatureAvailable(method);
        }
        return false;
    }

    public static boolean isChangeSignatureAvailable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement[] elements = selection.resolveElementAtOffset();
        if (elements.length == 1 && elements[0] instanceof IMethod) {
            return RefactoringAvailabilityTester.isChangeSignatureAvailable((IMethod)elements[0]);
        }
        IJavaElement element = selection.resolveEnclosingElement();
        return element instanceof IMethod && RefactoringAvailabilityTester.isChangeSignatureAvailable((IMethod)element);
    }

    public static boolean isCommonDeclaringType(IMember[] members) {
        if (members.length == 0) {
            return false;
        }
        IType type = members[0].getDeclaringType();
        if (type == null) {
            return false;
        }
        int index = 0;
        while (index < members.length) {
            if (!type.equals(members[index].getDeclaringType())) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static boolean isConvertAnonymousAvailable(IStructuredSelection selection) throws JavaModelException {
        if (selection.size() == 1 && selection.getFirstElement() instanceof IType) {
            return RefactoringAvailabilityTester.isConvertAnonymousAvailable((IType)selection.getFirstElement());
        }
        return false;
    }

    public static boolean isConvertAnonymousAvailable(IType type) throws JavaModelException {
        if (Checks.isAvailable((IJavaElement)type)) {
            IJavaElement element = type.getParent();
            if (element instanceof IField && JdtFlags.isEnum((IMember)element)) {
                return false;
            }
            return type.isAnonymous();
        }
        return false;
    }

    public static boolean isConvertAnonymousAvailable(JavaTextSelection selection) throws JavaModelException {
        IType type = RefactoringActions.getEnclosingType(selection);
        if (type != null) {
            return RefactoringAvailabilityTester.isConvertAnonymousAvailable(type);
        }
        return false;
    }

    public static boolean isCopyAvailable(IResource[] resources, IJavaElement[] elements) throws JavaModelException {
        return ReorgPolicyFactory.createCopyPolicy(resources, elements).canEnable();
    }

    public static boolean isDelegateCreationAvailable(IField field) throws JavaModelException {
        return field.exists() && Flags.isStatic((int)field.getFlags()) && Flags.isFinal((int)field.getFlags());
    }

    public static boolean isDeleteAvailable(IJavaElement element) {
        if (!element.exists()) {
            return false;
        }
        if (element instanceof IJavaModel || element instanceof IJavaProject) {
            return false;
        }
        if (element.getParent() != null && element.getParent().isReadOnly()) {
            return false;
        }
        if (element instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)element;
            if (root.isExternal() || Checks.isClasspathDelete(root)) {
                return false;
            }
            if (root.getResource().equals((Object)root.getJavaProject().getProject())) {
                return false;
            }
        }
        if (element.getResource() == null && !RefactoringAvailabilityTester.isWorkingCopyElement(element)) {
            return false;
        }
        return !(element instanceof IMember) || !((IMember)element).isBinary();
    }

    public static boolean isDeleteAvailable(IResource resource) {
        if (!resource.exists() || resource.isPhantom()) {
            return false;
        }
        return resource.getType() != 8 && resource.getType() != 4;
    }

    public static boolean isDeleteAvailable(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            return RefactoringAvailabilityTester.isDeleteAvailable(selection.toArray());
        }
        return false;
    }

    public static boolean isDeleteAvailable(Object[] objects) {
        if (objects.length != 0) {
            IJavaElement[] elements;
            if (ReorgUtils.containsOnlyWorkingSets(Arrays.asList(objects))) {
                return true;
            }
            IResource[] resources = RefactoringAvailabilityTester.getResources(objects);
            if (objects.length != resources.length + (elements = RefactoringAvailabilityTester.getJavaElements(objects)).length) {
                return false;
            }
            int index = 0;
            while (index < resources.length) {
                if (!RefactoringAvailabilityTester.isDeleteAvailable(resources[index])) {
                    return false;
                }
                ++index;
            }
            index = 0;
            while (index < elements.length) {
                if (!RefactoringAvailabilityTester.isDeleteAvailable(elements[index])) {
                    return false;
                }
                ++index;
            }
            return true;
        }
        return false;
    }

    public static boolean isExternalizeStringsAvailable(IStructuredSelection selection) throws JavaModelException {
        for (Object element : selection) {
            if (element instanceof IJavaElement) {
                IJavaElement parent;
                ICompilationUnit cu;
                IJavaElement javaElement = (IJavaElement)element;
                if (!javaElement.exists() || javaElement.isReadOnly()) continue;
                int elementType = javaElement.getElementType();
                if (elementType == 4) {
                    return true;
                }
                if (elementType == 3) {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)javaElement;
                    if (root.isExternal() || ReorgUtils.isClassFolder((IJavaElement)root)) continue;
                    return true;
                }
                if (elementType == 2) {
                    return true;
                }
                if (!(elementType == 5 ? (cu = (ICompilationUnit)javaElement).exists() : elementType == 7 && (parent = ((IType)element).getParent()) instanceof ICompilationUnit && parent.exists())) continue;
                return true;
            }
            if (!(element instanceof IWorkingSet)) continue;
            IWorkingSet workingSet = (IWorkingSet)element;
            return "org.eclipse.jdt.ui.JavaWorkingSetPage".equals(workingSet.getId());
        }
        return false;
    }

    public static boolean isExtractConstantAvailable(JavaTextSelection selection) {
        return (selection.resolveInClassInitializer() || selection.resolveInMethodBody() || selection.resolveInVariableInitializer() || selection.resolveInAnnotation()) && Checks.isExtractableExpression(selection.resolveSelectedNodes(), selection.resolveCoveringNode());
    }

    public static boolean isExtractInterfaceAvailable(IStructuredSelection selection) throws JavaModelException {
        if (selection.size() == 1) {
            Object first = selection.getFirstElement();
            if (first instanceof IType) {
                return RefactoringAvailabilityTester.isExtractInterfaceAvailable((IType)first);
            }
            if (first instanceof ICompilationUnit) {
                ICompilationUnit unit = (ICompilationUnit)first;
                return unit.exists() && !unit.isReadOnly();
            }
        }
        return false;
    }

    public static boolean isExtractInterfaceAvailable(IType type) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)type) && !type.isBinary() && !type.isReadOnly() && !type.isAnnotation() && !type.isAnonymous();
    }

    public static boolean isExtractInterfaceAvailable(JavaTextSelection selection) throws JavaModelException {
        return RefactoringAvailabilityTester.isExtractInterfaceAvailable(RefactoringActions.getEnclosingOrPrimaryType(selection));
    }

    public static boolean isExtractMethodAvailable(ASTNode[] nodes) {
        if (nodes != null && nodes.length != 0) {
            if (nodes.length == 1) {
                return nodes[0] instanceof Statement || Checks.isExtractableExpression(nodes[0]);
            }
            int index = 0;
            while (index < nodes.length) {
                if (!(nodes[index] instanceof Statement)) {
                    return false;
                }
                ++index;
            }
            return true;
        }
        return false;
    }

    public static boolean isExtractMethodAvailable(JavaTextSelection selection) {
        return (selection.resolveInMethodBody() || selection.resolveInClassInitializer() || selection.resolveInVariableInitializer()) && !selection.resolveInAnnotation() && RefactoringAvailabilityTester.isExtractMethodAvailable(selection.resolveSelectedNodes());
    }

    public static boolean isExtractSupertypeAvailable(IMember member) throws JavaModelException {
        if (!member.exists()) {
            return false;
        }
        int type = member.getElementType();
        if (type != 9 && type != 8 && type != 7) {
            return false;
        }
        if (JdtFlags.isEnum(member) && type != 7) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)member)) {
            return false;
        }
        if (member instanceof IMethod) {
            IMethod method = (IMethod)member;
            if (method.isConstructor()) {
                return false;
            }
            if (JdtFlags.isNative((IMember)method)) {
                return false;
            }
            member = method.getDeclaringType();
        } else if (member instanceof IField) {
            member = member.getDeclaringType();
        }
        if (member instanceof IType) {
            if (JdtFlags.isEnum(member) || JdtFlags.isAnnotation(member)) {
                return false;
            }
            if (member.getDeclaringType() != null && !JdtFlags.isStatic(member)) {
                return false;
            }
            if (((IType)member).isAnonymous()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isExtractSupertypeAvailable(IMember[] members) throws JavaModelException {
        if (members != null && members.length != 0) {
            IType type = RefactoringAvailabilityTester.getTopLevelType(members);
            if (type != null && !type.isClass()) {
                return false;
            }
            int index = 0;
            while (index < members.length) {
                if (!RefactoringAvailabilityTester.isExtractSupertypeAvailable(members[index])) {
                    return false;
                }
                ++index;
            }
            return members.length == 1 || RefactoringAvailabilityTester.isCommonDeclaringType(members);
        }
        return false;
    }

    public static boolean isExtractSupertypeAvailable(IStructuredSelection selection) throws JavaModelException {
        if (!selection.isEmpty()) {
            if (selection.size() == 1) {
                if (selection.getFirstElement() instanceof ICompilationUnit) {
                    return true;
                }
                IType type = RefactoringAvailabilityTester.getSingleSelectedType(selection);
                if (type != null) {
                    return Checks.isAvailable((IJavaElement)type) && RefactoringAvailabilityTester.isExtractSupertypeAvailable((IMember[])new IType[]{type});
                }
            }
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() instanceof IMember) continue;
                return false;
            }
            HashSet<Object> members = new HashSet<Object>();
            List<Object> selectionList = Arrays.asList(selection.toArray());
            members.addAll(selectionList);
            return RefactoringAvailabilityTester.isExtractSupertypeAvailable(members.toArray(new IMember[members.size()]));
        }
        return false;
    }

    public static boolean isExtractSupertypeAvailable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement element = selection.resolveEnclosingElement();
        if (!(element instanceof IMember)) {
            return false;
        }
        return RefactoringAvailabilityTester.isExtractSupertypeAvailable(new IMember[]{(IMember)element});
    }

    public static boolean isExtractTempAvailable(JavaTextSelection selection) {
        ASTNode[] nodes = selection.resolveSelectedNodes();
        return (selection.resolveInMethodBody() || selection.resolveInClassInitializer()) && !selection.resolveInAnnotation() && (Checks.isExtractableExpression(nodes, selection.resolveCoveringNode()) || nodes != null && nodes.length == 1 && nodes[0] instanceof ExpressionStatement);
    }

    public static boolean isGeneralizeTypeAvailable(IJavaElement element) throws JavaModelException {
        if (element != null && element.exists()) {
            String type = null;
            if (element instanceof IMethod) {
                type = ((IMethod)element).getReturnType();
            } else if (element instanceof IField) {
                IField field = (IField)element;
                if (JdtFlags.isEnum((IMember)field)) {
                    return false;
                }
                type = field.getTypeSignature();
            } else {
                if (element instanceof ILocalVariable) {
                    return true;
                }
                if (element instanceof IType) {
                    IType clazz = (IType)element;
                    return !JdtFlags.isEnum((IMember)clazz);
                }
            }
            return type != null && PrimitiveType.toCode((String)Signature.toString((String)type)) == null;
        }
        return false;
    }

    public static boolean isGeneralizeTypeAvailable(IStructuredSelection selection) throws JavaModelException {
        if (selection.size() == 1) {
            Object element = selection.getFirstElement();
            if (element instanceof IMethod) {
                IMethod method = (IMethod)element;
                if (!method.exists()) {
                    return false;
                }
                String type = method.getReturnType();
                if (PrimitiveType.toCode((String)Signature.toString((String)type)) == null) {
                    return Checks.isAvailable((IJavaElement)method);
                }
            } else if (element instanceof IField) {
                IField field = (IField)element;
                if (!field.exists()) {
                    return false;
                }
                if (!JdtFlags.isEnum((IMember)field)) {
                    return Checks.isAvailable((IJavaElement)field);
                }
            }
        }
        return false;
    }

    public static boolean isGeneralizeTypeAvailable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement[] elements = selection.resolveElementAtOffset();
        if (elements.length != 1) {
            return false;
        }
        return RefactoringAvailabilityTester.isGeneralizeTypeAvailable(elements[0]);
    }

    public static boolean isInferTypeArgumentsAvailable(IJavaElement element) throws JavaModelException {
        if (!Checks.isAvailable(element)) {
            return false;
        }
        if (element instanceof IJavaProject) {
            IJavaProject project = (IJavaProject)element;
            IClasspathEntry[] classpathEntries = project.getRawClasspath();
            int i = 0;
            while (i < classpathEntries.length) {
                if (classpathEntries[i].getEntryKind() == 3) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (element instanceof IPackageFragmentRoot) {
            return ((IPackageFragmentRoot)element).getKind() == 1;
        }
        if (element instanceof IPackageFragment) {
            return ((IPackageFragment)element).getKind() == 1;
        }
        if (element instanceof ICompilationUnit) {
            return true;
        }
        return element.getAncestor(5) != null;
    }

    public static boolean isInferTypeArgumentsAvailable(IJavaElement[] elements) throws JavaModelException {
        if (elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (!RefactoringAvailabilityTester.isInferTypeArgumentsAvailable(elements[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isInferTypeArgumentsAvailable(IStructuredSelection selection) throws JavaModelException {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object element : selection) {
            if (!(element instanceof IJavaElement)) {
                return false;
            }
            if (element instanceof ICompilationUnit) {
                ICompilationUnit unit = (ICompilationUnit)element;
                return unit.exists() && !unit.isReadOnly();
            }
            if (RefactoringAvailabilityTester.isInferTypeArgumentsAvailable((IJavaElement)element)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInlineConstantAvailable(IField field) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)field) && JdtFlags.isStatic((IMember)field) && JdtFlags.isFinal((IMember)field) && !JdtFlags.isEnum((IMember)field);
    }

    public static boolean isInlineConstantAvailable(IStructuredSelection selection) throws JavaModelException {
        if (selection.isEmpty() || selection.size() != 1) {
            return false;
        }
        Object first = selection.getFirstElement();
        return first instanceof IField && RefactoringAvailabilityTester.isInlineConstantAvailable((IField)first);
    }

    public static boolean isInlineConstantAvailable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement[] elements = selection.resolveElementAtOffset();
        if (elements.length != 1) {
            return false;
        }
        return elements[0] instanceof IField && RefactoringAvailabilityTester.isInlineConstantAvailable((IField)elements[0]);
    }

    public static boolean isInlineMethodAvailable(IMethod method) throws JavaModelException {
        if (method == null) {
            return false;
        }
        if (!method.exists()) {
            return false;
        }
        if (!method.isStructureKnown()) {
            return false;
        }
        if (!method.isBinary()) {
            return true;
        }
        if (method.isConstructor()) {
            return false;
        }
        return SourceRange.isAvailable((ISourceRange)method.getNameRange());
    }

    public static boolean isInlineMethodAvailable(IStructuredSelection selection) throws JavaModelException {
        if (selection.isEmpty() || selection.size() != 1) {
            return false;
        }
        Object first = selection.getFirstElement();
        return first instanceof IMethod && RefactoringAvailabilityTester.isInlineMethodAvailable((IMethod)first);
    }

    public static boolean isInlineMethodAvailable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement[] elements = selection.resolveElementAtOffset();
        if (elements.length != 1) {
            IJavaElement enclosingElement = selection.resolveEnclosingElement();
            if (!(enclosingElement instanceof IMember)) {
                return false;
            }
            ITypeRoot typeRoot = ((IMember)enclosingElement).getTypeRoot();
            CompilationUnit compilationUnit = selection.resolvePartialAstAtOffset();
            if (compilationUnit == null) {
                return false;
            }
            return RefactoringAvailabilityTester.getInlineableMethodNode(typeRoot, compilationUnit, selection.getOffset(), selection.getLength()) != null;
        }
        IJavaElement element = elements[0];
        if (!(element instanceof IMethod)) {
            return false;
        }
        IMethod method = (IMethod)element;
        if (!RefactoringAvailabilityTester.isInlineMethodAvailable(method)) {
            return false;
        }
        IJavaElement enclosingElement = selection.resolveEnclosingElement();
        if (enclosingElement == null || enclosingElement.getAncestor(6) == null) {
            return true;
        }
        if (!(enclosingElement instanceof IMethod)) {
            return false;
        }
        IMethod enclosingMethod = (IMethod)enclosingElement;
        if (enclosingMethod.isConstructor()) {
            return false;
        }
        int nameOffset = enclosingMethod.getNameRange().getOffset();
        int nameLength = enclosingMethod.getNameRange().getLength();
        return nameOffset <= selection.getOffset() && selection.getOffset() + selection.getLength() <= nameOffset + nameLength;
    }

    public static ASTNode getInlineableMethodNode(ITypeRoot typeRoot, CompilationUnit root, int offset, int length) {
        ASTNode node = null;
        try {
            node = RefactoringAvailabilityTester.getInlineableMethodNode(NodeFinder.perform((ASTNode)root, (int)offset, (int)length, (ITypeRoot)typeRoot), (IJavaElement)typeRoot);
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (node != null) {
            return node;
        }
        return RefactoringAvailabilityTester.getInlineableMethodNode(NodeFinder.perform((ASTNode)root, (int)offset, (int)length), (IJavaElement)typeRoot);
    }

    private static ASTNode getInlineableMethodNode(ASTNode node, IJavaElement unit) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 42: {
                StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
                if (locationInParent == MethodDeclaration.NAME_PROPERTY) {
                    return node.getParent();
                }
                if (locationInParent == MethodInvocation.NAME_PROPERTY || locationInParent == SuperMethodInvocation.NAME_PROPERTY) {
                    return unit instanceof ICompilationUnit ? node.getParent() : null;
                }
                return null;
            }
            case 21: {
                node = ((ExpressionStatement)node).getExpression();
            }
        }
        switch (node.getNodeType()) {
            case 31: {
                return node;
            }
            case 17: 
            case 32: 
            case 48: {
                return unit instanceof ICompilationUnit ? node : null;
            }
        }
        return null;
    }

    public static boolean isInlineTempAvailable(ILocalVariable variable) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)variable);
    }

    public static boolean isInlineTempAvailable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement[] elements = selection.resolveElementAtOffset();
        if (elements.length != 1) {
            return false;
        }
        return elements[0] instanceof ILocalVariable && RefactoringAvailabilityTester.isInlineTempAvailable((ILocalVariable)elements[0]);
    }

    public static boolean isIntroduceFactoryAvailable(IMethod method) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)method) && method.isConstructor();
    }

    public static boolean isIntroduceFactoryAvailable(IStructuredSelection selection) throws JavaModelException {
        if (selection.size() == 1 && selection.getFirstElement() instanceof IMethod) {
            return RefactoringAvailabilityTester.isIntroduceFactoryAvailable((IMethod)selection.getFirstElement());
        }
        return false;
    }

    public static boolean isIntroduceFactoryAvailable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement[] elements = selection.resolveElementAtOffset();
        if (elements.length == 1 && elements[0] instanceof IMethod) {
            return RefactoringAvailabilityTester.isIntroduceFactoryAvailable((IMethod)elements[0]);
        }
        if (!Checks.isAvailable(selection.resolveEnclosingElement())) {
            return false;
        }
        ASTNode node = selection.resolveCoveringNode();
        if (node == null) {
            ASTNode[] selectedNodes = selection.resolveSelectedNodes();
            if (selectedNodes != null && selectedNodes.length == 1) {
                node = selectedNodes[0];
                if (node == null) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (node.getNodeType() == 14) {
            return true;
        }
        return (node = ASTNodes.getNormalizedNode(node)).getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY;
    }

    public static boolean isIntroduceIndirectionAvailable(IMethod method) throws JavaModelException {
        if (method == null) {
            return false;
        }
        if (!method.exists()) {
            return false;
        }
        if (!method.isStructureKnown()) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        if (method.getDeclaringType().isAnnotation()) {
            return false;
        }
        return !JavaModelUtil.isPolymorphicSignature(method);
    }

    public static boolean isIntroduceIndirectionAvailable(IStructuredSelection selection) throws JavaModelException {
        if (selection.isEmpty() || selection.size() != 1) {
            return false;
        }
        Object first = selection.getFirstElement();
        return first instanceof IMethod && RefactoringAvailabilityTester.isIntroduceIndirectionAvailable((IMethod)first);
    }

    public static boolean isIntroduceIndirectionAvailable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement[] elements = selection.resolveElementAtOffset();
        if (elements.length == 1) {
            return elements[0] instanceof IMethod && RefactoringAvailabilityTester.isIntroduceIndirectionAvailable((IMethod)elements[0]);
        }
        ASTNode[] selectedNodes = selection.resolveSelectedNodes();
        if (selectedNodes == null || selectedNodes.length != 1) {
            return false;
        }
        switch (selectedNodes[0].getNodeType()) {
            case 31: 
            case 32: 
            case 48: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIntroduceParameterAvailable(ASTNode[] selectedNodes, ASTNode coveringNode) {
        return Checks.isExtractableExpression(selectedNodes, coveringNode);
    }

    public static boolean isIntroduceParameterAvailable(JavaTextSelection selection) {
        return selection.resolveInMethodBody() && !selection.resolveInAnnotation() && RefactoringAvailabilityTester.isIntroduceParameterAvailable(selection.resolveSelectedNodes(), selection.resolveCoveringNode());
    }

    public static boolean isMoveAvailable(IResource[] resources, IJavaElement[] elements) throws JavaModelException {
        if (elements != null) {
            int index = 0;
            while (index < elements.length) {
                IJavaElement element = elements[index];
                if (element == null || !element.exists()) {
                    return false;
                }
                if (element instanceof IType && ((IType)element).isLocal()) {
                    return false;
                }
                if (element instanceof IPackageDeclaration) {
                    return false;
                }
                if (element instanceof IField && JdtFlags.isEnum((IMember)element)) {
                    return false;
                }
                ++index;
            }
        }
        return ReorgPolicyFactory.createMovePolicy(resources, elements).canEnable();
    }

    public static boolean isMoveAvailable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement element = selection.resolveEnclosingElement();
        if (element == null) {
            return false;
        }
        return RefactoringAvailabilityTester.isMoveAvailable(new IResource[0], new IJavaElement[]{element});
    }

    public static boolean isMoveInnerAvailable(IStructuredSelection selection) throws JavaModelException {
        Object first;
        if (selection.size() == 1 && (first = selection.getFirstElement()) instanceof IType) {
            return RefactoringAvailabilityTester.isMoveInnerAvailable((IType)first);
        }
        return false;
    }

    public static boolean isMoveInnerAvailable(IType type) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)type) && !Checks.isAnonymous(type) && !JavaElementUtil.isMainType(type) && !Checks.isInsideLocalType(type);
    }

    public static boolean isMoveInnerAvailable(JavaTextSelection selection) throws JavaModelException {
        IType type = RefactoringAvailabilityTester.getDeclaringType(selection.resolveEnclosingElement());
        if (type == null) {
            return false;
        }
        return RefactoringAvailabilityTester.isMoveInnerAvailable(type);
    }

    public static boolean isMoveMethodAvailable(IMethod method) throws JavaModelException {
        return method.exists() && !method.isConstructor() && !method.isBinary() && !method.getDeclaringType().isInterface() && !method.isReadOnly() && !JdtFlags.isStatic((IMember)method);
    }

    public static boolean isMoveMethodAvailable(IStructuredSelection selection) throws JavaModelException {
        if (selection.size() == 1) {
            Object first = selection.getFirstElement();
            return first instanceof IMethod && RefactoringAvailabilityTester.isMoveMethodAvailable((IMethod)first);
        }
        return false;
    }

    public static boolean isMoveMethodAvailable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement method = selection.resolveEnclosingElement();
        if (!(method instanceof IMethod)) {
            return false;
        }
        return RefactoringAvailabilityTester.isMoveMethodAvailable((IMethod)method);
    }

    public static boolean isMoveStaticAvailable(IMember member) throws JavaModelException {
        if (!member.exists()) {
            return false;
        }
        int type = member.getElementType();
        if (type != 9 && type != 8 && type != 7) {
            return false;
        }
        if (JdtFlags.isEnum(member) && type != 7) {
            return false;
        }
        IType declaring = member.getDeclaringType();
        if (declaring == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)member)) {
            return false;
        }
        if (type == 9 && declaring.isInterface()) {
            return false;
        }
        if (type == 9 && !JdtFlags.isStatic(member)) {
            return false;
        }
        if (type == 9 && ((IMethod)member).isConstructor()) {
            return false;
        }
        if (type == 7 && !JdtFlags.isStatic(member)) {
            return false;
        }
        return declaring.isInterface() || JdtFlags.isStatic(member);
    }

    public static boolean isMoveStaticAvailable(IMember[] members) throws JavaModelException {
        int index = 0;
        while (index < members.length) {
            if (!RefactoringAvailabilityTester.isMoveStaticAvailable(members[index])) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static boolean isMoveStaticAvailable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement element = selection.resolveEnclosingElement();
        if (!(element instanceof IMember)) {
            return false;
        }
        return RefactoringAvailabilityTester.isMoveStaticMembersAvailable(new IMember[]{(IMember)element});
    }

    public static boolean isMoveStaticMembersAvailable(IMember[] members) throws JavaModelException {
        if (members == null) {
            return false;
        }
        if (members.length == 0) {
            return false;
        }
        if (!RefactoringAvailabilityTester.isMoveStaticAvailable(members)) {
            return false;
        }
        return RefactoringAvailabilityTester.isCommonDeclaringType(members);
    }

    public static boolean isPromoteTempAvailable(ILocalVariable variable) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)variable);
    }

    public static boolean isPromoteTempAvailable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement[] elements = selection.resolveElementAtOffset();
        if (elements.length != 1) {
            return false;
        }
        return elements[0] instanceof ILocalVariable && RefactoringAvailabilityTester.isPromoteTempAvailable((ILocalVariable)elements[0]);
    }

    public static boolean isPullUpAvailable(IMember member) throws JavaModelException {
        if (!member.exists()) {
            return false;
        }
        int type = member.getElementType();
        if (type != 9 && type != 8 && type != 7) {
            return false;
        }
        if (JdtFlags.isEnum(member) && type != 7) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)member)) {
            return false;
        }
        if (member instanceof IType && !JdtFlags.isStatic(member) && !JdtFlags.isEnum(member) && !JdtFlags.isAnnotation(member)) {
            return false;
        }
        if (member instanceof IMethod) {
            IMethod method = (IMethod)member;
            if (method.isConstructor()) {
                return false;
            }
            if (JdtFlags.isNative((IMember)method)) {
                return false;
            }
            IType declaring = method.getDeclaringType();
            if (declaring != null && declaring.isAnnotation()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isPullUpAvailable(IMember[] members) throws JavaModelException {
        if (members != null && members.length != 0) {
            IType type = RefactoringAvailabilityTester.getTopLevelType(members);
            if (type != null && RefactoringAvailabilityTester.getPullUpMembers(type).length != 0) {
                return true;
            }
            int index = 0;
            while (index < members.length) {
                if (!RefactoringAvailabilityTester.isPullUpAvailable(members[index])) {
                    return false;
                }
                ++index;
            }
            return RefactoringAvailabilityTester.isCommonDeclaringType(members);
        }
        return false;
    }

    public static boolean isPullUpAvailable(IStructuredSelection selection) throws JavaModelException {
        if (!selection.isEmpty()) {
            if (selection.size() == 1) {
                if (selection.getFirstElement() instanceof ICompilationUnit) {
                    return true;
                }
                IType type = RefactoringAvailabilityTester.getSingleSelectedType(selection);
                if (type != null) {
                    return Checks.isAvailable((IJavaElement)type) && RefactoringAvailabilityTester.isPullUpAvailable((IMember[])new IType[]{type});
                }
            }
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() instanceof IMember) continue;
                return false;
            }
            HashSet<Object> members = new HashSet<Object>();
            List<Object> selectionList = Arrays.asList(selection.toArray());
            members.addAll(selectionList);
            return RefactoringAvailabilityTester.isPullUpAvailable(members.toArray(new IMember[members.size()]));
        }
        return false;
    }

    public static boolean isPullUpAvailable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement element = selection.resolveEnclosingElement();
        if (!(element instanceof IMember)) {
            return false;
        }
        return RefactoringAvailabilityTester.isPullUpAvailable(new IMember[]{(IMember)element});
    }

    public static boolean isPushDownAvailable(IMember member) throws JavaModelException {
        if (!member.exists()) {
            return false;
        }
        int type = member.getElementType();
        if (type != 9 && type != 8) {
            return false;
        }
        if (JdtFlags.isEnum(member)) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)member)) {
            return false;
        }
        if (JdtFlags.isStatic(member)) {
            return false;
        }
        if (type == 9) {
            IMethod method = (IMethod)member;
            if (method.isConstructor()) {
                return false;
            }
            if (JdtFlags.isNative((IMember)method)) {
                return false;
            }
            IType declaring = method.getDeclaringType();
            if (declaring != null && declaring.isAnnotation()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isPushDownAvailable(IMember[] members) throws JavaModelException {
        if (members != null && members.length != 0) {
            IType type = RefactoringAvailabilityTester.getTopLevelType(members);
            if (type != null && RefactoringAvailabilityTester.getPushDownMembers(type).length != 0) {
                return true;
            }
            if (type != null && JdtFlags.isEnum((IMember)type)) {
                return false;
            }
            int index = 0;
            while (index < members.length) {
                if (!RefactoringAvailabilityTester.isPushDownAvailable(members[index])) {
                    return false;
                }
                ++index;
            }
            return RefactoringAvailabilityTester.isCommonDeclaringType(members);
        }
        return false;
    }

    public static boolean isPushDownAvailable(IStructuredSelection selection) throws JavaModelException {
        if (!selection.isEmpty()) {
            if (selection.size() == 1) {
                if (selection.getFirstElement() instanceof ICompilationUnit) {
                    return true;
                }
                IType type = RefactoringAvailabilityTester.getSingleSelectedType(selection);
                if (type != null) {
                    return RefactoringAvailabilityTester.isPushDownAvailable((IMember[])new IType[]{type});
                }
            }
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() instanceof IMember) continue;
                return false;
            }
            HashSet<Object> members = new HashSet<Object>();
            List<Object> selectionList = Arrays.asList(selection.toArray());
            members.addAll(selectionList);
            return RefactoringAvailabilityTester.isPushDownAvailable(members.toArray(new IMember[members.size()]));
        }
        return false;
    }

    public static boolean isPushDownAvailable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement element = selection.resolveEnclosingElement();
        if (!(element instanceof IMember)) {
            return false;
        }
        return RefactoringAvailabilityTester.isPullUpAvailable(new IMember[]{(IMember)element});
    }

    public static boolean isRenameAvailable(ICompilationUnit unit) {
        if (unit == null) {
            return false;
        }
        if (!unit.exists()) {
            return false;
        }
        if (!JavaModelUtil.isPrimary(unit)) {
            return false;
        }
        return !unit.isReadOnly();
    }

    public static boolean isRenameAvailable(IJavaProject project) throws JavaModelException {
        if (project == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)project)) {
            return false;
        }
        return project.isConsistent();
    }

    public static boolean isRenameAvailable(ILocalVariable variable) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)variable);
    }

    public static boolean isRenameAvailable(IMethod method) throws CoreException {
        if (method == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)method)) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        return !RefactoringAvailabilityTester.isRenameProhibited(method);
    }

    public static boolean isRenameAvailable(IPackageFragment fragment) throws JavaModelException {
        if (fragment == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)fragment)) {
            return false;
        }
        return !fragment.isDefaultPackage();
    }

    public static boolean isRenameAvailable(IPackageFragmentRoot root) throws JavaModelException {
        if (root == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)root)) {
            return false;
        }
        if (root.isArchive()) {
            return false;
        }
        if (root.isExternal()) {
            return false;
        }
        if (!root.isConsistent()) {
            return false;
        }
        return !(root.getResource() instanceof IProject);
    }

    public static boolean isRenameAvailable(IResource resource) {
        if (resource == null) {
            return false;
        }
        if (!resource.exists()) {
            return false;
        }
        return resource.isAccessible();
    }

    public static boolean isRenameAvailable(IType type) throws JavaModelException {
        if (type == null) {
            return false;
        }
        if (type.isAnonymous()) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)type)) {
            return false;
        }
        return !RefactoringAvailabilityTester.isRenameProhibited(type);
    }

    public static boolean isRenameAvailable(ITypeParameter parameter) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)parameter);
    }

    public static boolean isRenameEnumConstAvailable(IField field) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)field) && field.getDeclaringType().isEnum();
    }

    public static boolean isRenameFieldAvailable(IField field) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)field) && !JdtFlags.isEnum((IMember)field);
    }

    public static boolean isRenameNonVirtualMethodAvailable(IMethod method) throws JavaModelException, CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(method) && !MethodChecks.isVirtual(method);
    }

    public static boolean isRenameProhibited(IMethod method) throws CoreException {
        return method.getElementName().equals("toString") && method.getNumberOfParameters() == 0 && (method.getReturnType().equals("Ljava.lang.String;") || method.getReturnType().equals("QString;") || method.getReturnType().equals("Qjava.lang.String;"));
    }

    public static boolean isRenameProhibited(IType type) {
        return type.getPackageFragment().getElementName().equals("java.lang");
    }

    public static boolean isRenameVirtualMethodAvailable(IMethod method) throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(method) && MethodChecks.isVirtual(method);
    }

    public static boolean isRenameElementAvailable(IJavaElement element) throws CoreException {
        switch (element.getElementType()) {
            case 2: {
                return RefactoringAvailabilityTester.isRenameAvailable((IJavaProject)element);
            }
            case 3: {
                return RefactoringAvailabilityTester.isRenameAvailable((IPackageFragmentRoot)element);
            }
            case 4: {
                return RefactoringAvailabilityTester.isRenameAvailable((IPackageFragment)element);
            }
            case 5: {
                return RefactoringAvailabilityTester.isRenameAvailable((ICompilationUnit)element);
            }
            case 7: {
                return RefactoringAvailabilityTester.isRenameAvailable((IType)element);
            }
            case 9: {
                IMethod method = (IMethod)element;
                if (method.isConstructor()) {
                    return RefactoringAvailabilityTester.isRenameAvailable(method.getDeclaringType());
                }
                return RefactoringAvailabilityTester.isRenameAvailable(method);
            }
            case 8: {
                IField field = (IField)element;
                if (Flags.isEnum((int)field.getFlags())) {
                    return RefactoringAvailabilityTester.isRenameEnumConstAvailable(field);
                }
                return RefactoringAvailabilityTester.isRenameFieldAvailable(field);
            }
            case 15: {
                return RefactoringAvailabilityTester.isRenameAvailable((ITypeParameter)element);
            }
            case 14: {
                return RefactoringAvailabilityTester.isRenameAvailable((ILocalVariable)element);
            }
        }
        return false;
    }

    public static boolean isReplaceInvocationsAvailable(IMethod method) throws JavaModelException {
        if (method == null) {
            return false;
        }
        if (!method.exists()) {
            return false;
        }
        return !method.isConstructor();
    }

    public static boolean isReplaceInvocationsAvailable(IStructuredSelection selection) throws JavaModelException {
        if (selection.isEmpty() || selection.size() != 1) {
            return false;
        }
        Object first = selection.getFirstElement();
        return first instanceof IMethod && RefactoringAvailabilityTester.isReplaceInvocationsAvailable((IMethod)first);
    }

    public static boolean isReplaceInvocationsAvailable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement[] elements = selection.resolveElementAtOffset();
        if (elements.length != 1) {
            return false;
        }
        IJavaElement element = elements[0];
        return element instanceof IMethod && RefactoringAvailabilityTester.isReplaceInvocationsAvailable((IMethod)element);
    }

    public static boolean isSelfEncapsulateAvailable(IField field) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)field) && !JdtFlags.isEnum((IMember)field) && !field.getDeclaringType().isInterface();
    }

    public static boolean isSelfEncapsulateAvailable(IStructuredSelection selection) throws JavaModelException {
        if (selection.size() == 1 && selection.getFirstElement() instanceof IField) {
            IField field = (IField)selection.getFirstElement();
            return RefactoringAvailabilityTester.isSelfEncapsulateAvailable(field);
        }
        return false;
    }

    public static boolean isSelfEncapsulateAvailable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement[] elements = selection.resolveElementAtOffset();
        if (elements.length != 1) {
            return false;
        }
        return elements[0] instanceof IField && RefactoringAvailabilityTester.isSelfEncapsulateAvailable((IField)elements[0]);
    }

    public static boolean isUseSuperTypeAvailable(IStructuredSelection selection) throws JavaModelException {
        if (selection.size() == 1) {
            Object first = selection.getFirstElement();
            if (first instanceof IType) {
                return RefactoringAvailabilityTester.isUseSuperTypeAvailable((IType)first);
            }
            if (first instanceof ICompilationUnit) {
                ICompilationUnit unit = (ICompilationUnit)first;
                return unit.exists() && !unit.isReadOnly();
            }
        }
        return false;
    }

    public static boolean isUseSuperTypeAvailable(IType type) throws JavaModelException {
        return type != null && type.exists() && !type.isAnnotation() && !type.isAnonymous();
    }

    public static boolean isUseSuperTypeAvailable(JavaTextSelection selection) throws JavaModelException {
        return RefactoringAvailabilityTester.isUseSuperTypeAvailable(RefactoringActions.getEnclosingOrPrimaryType(selection));
    }

    public static boolean isWorkingCopyElement(IJavaElement element) {
        if (element instanceof ICompilationUnit) {
            return ((ICompilationUnit)element).isWorkingCopy();
        }
        if (ReorgUtils.isInsideCompilationUnit(element)) {
            return ReorgUtils.getCompilationUnit(element).isWorkingCopy();
        }
        return false;
    }

    private RefactoringAvailabilityTester() {
    }

    public static boolean isIntroduceParameterObjectAvailable(IStructuredSelection selection) throws JavaModelException {
        return RefactoringAvailabilityTester.isChangeSignatureAvailable(selection);
    }

    public static boolean isIntroduceParameterObjectAvailable(JavaTextSelection selection) throws JavaModelException {
        return RefactoringAvailabilityTester.isChangeSignatureAvailable(selection);
    }

    public static boolean isExtractClassAvailable(IType type) throws JavaModelException {
        if (type == null) {
            return false;
        }
        if (!type.exists()) {
            return false;
        }
        return ReorgUtils.isInsideCompilationUnit((IJavaElement)type) && type.isClass() && !type.isAnonymous();
    }
}

