/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Corext;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.AbstractDeleteChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.UndoDeleteResourceChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IPackageFragmentRootManipulationQuery;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.ide.undo.ResourceDescription;

public class DeletePackageFragmentRootChange
extends AbstractDeleteChange {
    private final String fHandle;
    private final IPackageFragmentRootManipulationQuery fUpdateClasspathQuery;

    public DeletePackageFragmentRootChange(IPackageFragmentRoot root, boolean isExecuteChange, IPackageFragmentRootManipulationQuery updateClasspathQuery) {
        Assert.isNotNull((Object)root);
        Assert.isTrue((!root.isExternal() ? 1 : 0) != 0);
        this.fHandle = root.getHandleIdentifier();
        this.fUpdateClasspathQuery = updateClasspathQuery;
        if (isExecuteChange) {
            this.setValidationMethod(2);
        } else {
            this.setValidationMethod(3);
        }
    }

    public String getName() {
        String rootName = JavaElementLabels.getElementLabel((IJavaElement)this.getRoot(), JavaElementLabels.ALL_DEFAULT);
        return Messages.format(RefactoringCoreMessages.DeletePackageFragmentRootChange_delete, rootName);
    }

    public Object getModifiedElement() {
        return this.getRoot();
    }

    protected IResource getModifiedResource() {
        return this.getRoot().getResource();
    }

    private IPackageFragmentRoot getRoot() {
        return (IPackageFragmentRoot)JavaCore.create((String)this.fHandle);
    }

    protected Change doDelete(IProgressMonitor pm) throws CoreException {
        if (!this.confirmDeleteIfReferenced()) {
            return new NullChange();
        }
        int resourceUpdateFlags = 2;
        int jCoreUpdateFlags = 6;
        pm.beginTask("", 2);
        IPackageFragmentRoot root = this.getRoot();
        IResource rootResource = root.getResource();
        CompositeChange result = new CompositeChange(this.getName());
        ResourceDescription rootDescription = ResourceDescription.fromResource((IResource)rootResource);
        IJavaProject[] referencingProjects = JavaElementUtil.getReferencingProjects(root);
        HashMap<IFile, String> classpathFilesContents = new HashMap<IFile, String>();
        int i = 0;
        while (i < referencingProjects.length) {
            IJavaProject javaProject = referencingProjects[i];
            IFile classpathFile = javaProject.getProject().getFile(".classpath");
            if (classpathFile.exists()) {
                classpathFilesContents.put(classpathFile, DeletePackageFragmentRootChange.getFileContents(classpathFile));
            }
            ++i;
        }
        root.delete(resourceUpdateFlags, jCoreUpdateFlags, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        rootDescription.recordStateFromHistory(rootResource, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        for (Map.Entry entry : classpathFilesContents.entrySet()) {
            IFile file = (IFile)entry.getKey();
            String contents = (String)entry.getValue();
            TextFileChange classpathUndo = new TextFileChange(Messages.format(RefactoringCoreMessages.DeletePackageFragmentRootChange_restore_file, BasicElementLabels.getPathLabel(file.getFullPath(), true)), file);
            classpathUndo.setEdit((TextEdit)new ReplaceEdit(0, DeletePackageFragmentRootChange.getFileLength(file), contents));
            result.add((Change)classpathUndo);
        }
        result.add((Change)new UndoDeleteResourceChange(rootDescription));
        pm.done();
        return result;
    }

    private static String getFileContents(IFile file) throws CoreException {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = file.getFullPath();
        manager.connect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        try {
            String string = manager.getTextFileBuffer(path, LocationKind.IFILE).getDocument().get();
            return string;
        }
        finally {
            manager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private static int getFileLength(IFile file) throws CoreException {
        InputStreamReader reader;
        InputStream contents = file.getContents();
        try {
            reader = new InputStreamReader(contents, file.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            JavaPlugin.log(e);
            reader = new InputStreamReader(contents);
        }
        try {
            int n = (int)reader.skip(Integer.MAX_VALUE);
            return n;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, Corext.getPluginId(), e.getMessage(), (Throwable)e));
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean confirmDeleteIfReferenced() throws JavaModelException {
        IPackageFragmentRoot root = this.getRoot();
        if (!root.isArchive() && !root.isExternal()) {
            return true;
        }
        if (this.fUpdateClasspathQuery == null) {
            return true;
        }
        IJavaProject[] referencingProjects = JavaElementUtil.getReferencingProjects(this.getRoot());
        if (referencingProjects.length <= 1) {
            return true;
        }
        return this.fUpdateClasspathQuery.confirmManipulation(this.getRoot(), referencingProjects);
    }
}

