/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure.constraints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.BindingKey;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsCreator;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsModel;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsSolver;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.CompilationUnitRange;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.CastVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ITypeConstraintVariable;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.TextEditBasedChangeManager;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SuperTypeRefactoringProcessor
extends RefactoringProcessor {
    protected static final String ATTRIBUTE_INSTANCEOF = "instanceof";
    protected static final String ATTRIBUTE_REPLACE = "replace";
    protected static final GroupCategorySet SET_SUPER_TYPE = new GroupCategorySet(new GroupCategory("org.eclipse.jdt.internal.corext.superType", RefactoringCoreMessages.SuperTypeRefactoringProcessor_category_name, RefactoringCoreMessages.SuperTypeRefactoringProcessor_category_description));
    private static final int SIZE_BATCH = 500;
    protected boolean fInstanceOf = false;
    protected Map<ICompilationUnit, Collection<CastVariable2>> fObsoleteCasts = null;
    protected final WorkingCopyOwner fOwner = new WorkingCopyOwner(){};
    protected boolean fReplace = false;
    protected CodeGenerationSettings fSettings;
    protected final Set<IBinding> fStaticBindings = new HashSet<IBinding>();
    protected final Set<ITypeBinding> fTypeBindings = new HashSet<ITypeBinding>();
    protected Map<ICompilationUnit, Collection<ITypeConstraintVariable>> fTypeOccurrences = null;

    protected static ASTNode createCorrespondingNode(CompilationUnitRewrite rewrite, TType type) {
        return rewrite.getImportRewrite().addImportFromSignature(new BindingKey(type.getBindingKey()).toSignature(), rewrite.getAST());
    }

    protected SuperTypeRefactoringProcessor(CodeGenerationSettings settings) {
        this.fSettings = settings;
    }

    protected void addSuperTypeSettings(JDTRefactoringDescriptorComment comment, boolean addUseSupertype) {
        Assert.isNotNull((Object)comment);
        if (this.fReplace) {
            if (addUseSupertype) {
                comment.addSetting(RefactoringCoreMessages.SuperTypeRefactoringProcessor_user_supertype_setting);
            }
            if (this.fInstanceOf) {
                comment.addSetting(RefactoringCoreMessages.SuperTypeRefactoringProcessor_use_in_instanceof_setting);
            }
        }
    }

    protected abstract SuperTypeConstraintsSolver createContraintSolver(SuperTypeConstraintsModel var1);

    protected void createMemberDeclarations(CompilationUnitRewrite sourceRewrite, ASTRewrite targetRewrite, AbstractTypeDeclaration targetDeclaration) throws CoreException {
    }

    protected final void createTypeDeclaration(CompilationUnitRewrite sourceRewrite, IType subType, String superName, AbstractTypeDeclaration sourceDeclaration, StringBuffer buffer, boolean isInterface, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)sourceRewrite);
        Assert.isNotNull((Object)subType);
        Assert.isNotNull((Object)superName);
        Assert.isNotNull((Object)sourceDeclaration);
        Assert.isNotNull((Object)buffer);
        Assert.isNotNull((Object)status);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask("", 100);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
            String delimiter = StubUtility.getLineDelimiterUsed(subType.getJavaProject());
            if (JdtFlags.isPublic((IMember)subType)) {
                buffer.append("public");
                buffer.append(" ");
            }
            if (isInterface) {
                buffer.append("interface ");
            } else {
                buffer.append("class ");
            }
            buffer.append(superName);
            buffer.append(" {");
            buffer.append(delimiter);
            buffer.append(delimiter);
            buffer.append('}');
            Document document = new Document(buffer.toString());
            ASTParser parser = ASTParser.newParser((int)4);
            parser.setSource(document.get().toCharArray());
            CompilationUnit unit = (CompilationUnit)parser.createAST((IProgressMonitor)new SubProgressMonitor(monitor, 100));
            ASTRewrite targetRewrite = ASTRewrite.create((AST)unit.getAST());
            AbstractTypeDeclaration targetDeclaration = (AbstractTypeDeclaration)unit.types().get(0);
            this.createTypeParameters(targetRewrite, subType, sourceDeclaration, targetDeclaration);
            this.createMemberDeclarations(sourceRewrite, targetRewrite, targetDeclaration);
            TextEdit edit = targetRewrite.rewriteAST((IDocument)document, subType.getJavaProject().getOptions(true));
            try {
                edit.apply((IDocument)document, 2);
            }
            catch (MalformedTreeException exception) {
                JavaPlugin.log(exception);
            }
            catch (BadLocationException exception) {
                JavaPlugin.log(exception);
            }
            buffer.setLength(0);
            buffer.append(document.get());
        }
        finally {
            monitor.done();
        }
    }

    protected final String createTypeImports(ICompilationUnit unit, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask("", 100);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
            ImportRewrite rewrite = StubUtility.createImportRewrite(unit, true);
            ITypeBinding type2 = null;
            for (ITypeBinding type2 : this.fTypeBindings) {
                if (type2.isTypeVariable()) {
                    ITypeBinding[] bounds = type2.getTypeBounds();
                    int index = 0;
                    while (index < bounds.length) {
                        rewrite.addImport(bounds[index]);
                        ++index;
                    }
                }
                rewrite.addImport(type2);
            }
            IBinding binding2 = null;
            for (IBinding binding2 : this.fStaticBindings) {
                rewrite.addStaticImport(binding2);
            }
            Document document = new Document();
            try {
                rewrite.rewriteImports((IProgressMonitor)new SubProgressMonitor(monitor, 100)).apply((IDocument)document);
            }
            catch (MalformedTreeException exception) {
                JavaPlugin.log(exception);
            }
            catch (BadLocationException exception) {
                JavaPlugin.log(exception);
            }
            catch (CoreException exception) {
                JavaPlugin.log(exception);
            }
            this.fTypeBindings.clear();
            this.fStaticBindings.clear();
            String string = document.get();
            return string;
        }
        finally {
            monitor.done();
        }
    }

    protected final void createTypeParameters(ASTRewrite targetRewrite, IType subType, AbstractTypeDeclaration sourceDeclaration, AbstractTypeDeclaration targetDeclaration) {
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)sourceDeclaration);
        Assert.isNotNull((Object)targetDeclaration);
        if (sourceDeclaration instanceof TypeDeclaration) {
            TypeParameter parameter2 = null;
            ListRewrite rewrite = targetRewrite.getListRewrite((ASTNode)targetDeclaration, TypeDeclaration.TYPE_PARAMETERS_PROPERTY);
            for (TypeParameter parameter2 : ((TypeDeclaration)sourceDeclaration).typeParameters()) {
                rewrite.insertLast(ASTNode.copySubtree((AST)targetRewrite.getAST(), (ASTNode)parameter2), null);
                ImportRewriteUtil.collectImports(subType.getJavaProject(), (ASTNode)sourceDeclaration, this.fTypeBindings, this.fStaticBindings, false);
            }
        }
    }

    protected final String createTypeSource(ICompilationUnit copy, IType subType, String superName, CompilationUnitRewrite sourceRewrite, AbstractTypeDeclaration declaration, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        String source;
        block11: {
            Assert.isNotNull((Object)copy);
            Assert.isNotNull((Object)subType);
            Assert.isNotNull((Object)superName);
            Assert.isNotNull((Object)sourceRewrite);
            Assert.isNotNull((Object)declaration);
            Assert.isNotNull((Object)status);
            Assert.isNotNull((Object)monitor);
            source = null;
            try {
                monitor.beginTask("", 100);
                monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
                String delimiter = StubUtility.getLineDelimiterUsed(subType.getJavaProject());
                String typeComment = null;
                String fileComment = null;
                if (this.fSettings.createComments) {
                    ITypeParameter[] parameters = subType.getTypeParameters();
                    String[] names = new String[parameters.length];
                    int index = 0;
                    while (index < parameters.length) {
                        names[index] = parameters[index].getElementName();
                        ++index;
                    }
                    typeComment = CodeGeneration.getTypeComment(copy, superName, names, delimiter);
                    fileComment = CodeGeneration.getFileComment(copy, delimiter);
                }
                StringBuffer buffer = new StringBuffer(64);
                this.createTypeDeclaration(sourceRewrite, subType, superName, declaration, buffer, true, status, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                String imports = this.createTypeImports(copy, (IProgressMonitor)new SubProgressMonitor(monitor, 60));
                source = this.createTypeTemplate(copy, imports, fileComment, typeComment, buffer.toString());
                if (source == null) {
                    if (!subType.getPackageFragment().isDefaultPackage()) {
                        if (imports.length() > 0) {
                            buffer.insert(0, imports);
                        }
                        buffer.insert(0, "package " + subType.getPackageFragment().getElementName() + ";");
                    }
                    source = buffer.toString();
                }
                Document document = new Document(source);
                TextEdit edit = CodeFormatterUtil.format2(8, source, 0, delimiter, (Map<String, String>)copy.getJavaProject().getOptions(true));
                if (edit == null) break block11;
                try {
                    edit.apply((IDocument)document, 2);
                }
                catch (MalformedTreeException exception) {
                    JavaPlugin.log(exception);
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error));
                }
                catch (BadLocationException exception) {
                    JavaPlugin.log(exception);
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error));
                }
                source = document.get();
            }
            finally {
                monitor.done();
            }
        }
        return source;
    }

    protected final String createTypeTemplate(ICompilationUnit unit, String imports, String fileComment, String comment, String content) throws CoreException {
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)imports);
        Assert.isNotNull((Object)content);
        IPackageFragment fragment = (IPackageFragment)unit.getParent();
        StringBuffer buffer = new StringBuffer();
        String delimiter = StubUtility.getLineDelimiterUsed(unit.getJavaProject());
        if (!fragment.isDefaultPackage()) {
            buffer.append("package " + fragment.getElementName() + ";");
            buffer.append(delimiter);
            buffer.append(delimiter);
        }
        if (imports.length() > 0) {
            buffer.append(imports);
        }
        return StubUtility.getCompilationUnitContent(unit, buffer.toString(), fileComment, comment, content, delimiter);
    }

    protected void finalize() throws Throwable {
        this.resetWorkingCopies();
    }

    protected final IField getCorrespondingField(VariableDeclarationFragment fragment) throws JavaModelException {
        ICompilationUnit unit;
        IJavaElement element;
        IVariableBinding variable;
        IBinding binding = fragment.getName().resolveBinding();
        if (binding instanceof IVariableBinding && (variable = (IVariableBinding)binding).isField() && (element = (unit = RefactoringASTParser.getCompilationUnit((ASTNode)fragment)).getElementAt(fragment.getStartPosition())) instanceof IField) {
            return (IField)element;
        }
        return null;
    }

    protected final void getFieldReferencingCompilationUnits(Map<IJavaProject, Set<ICompilationUnit>> units, ASTNode[] nodes) throws JavaModelException {
        ASTNode node = null;
        IField field = null;
        IJavaProject project = null;
        int index = 0;
        while (index < nodes.length) {
            node = nodes[index];
            project = RefactoringASTParser.getCompilationUnit(node).getJavaProject();
            if (project != null) {
                List<IField> fields = this.getReferencingFields(node, project);
                int offset = 0;
                while (offset < fields.size()) {
                    ICompilationUnit unit;
                    field = fields.get(offset);
                    Set<ICompilationUnit> set = units.get(project);
                    if (set == null) {
                        set = new HashSet<ICompilationUnit>();
                        units.put(project, set);
                    }
                    if ((unit = field.getCompilationUnit()) != null) {
                        set.add(unit);
                    }
                    ++offset;
                }
            }
            ++index;
        }
    }

    protected final void getMethodReferencingCompilationUnits(Map<IJavaProject, Set<ICompilationUnit>> units, ASTNode[] nodes) throws JavaModelException {
        ASTNode node = null;
        IMethod method = null;
        IJavaProject project = null;
        int index = 0;
        while (index < nodes.length) {
            node = nodes[index];
            project = RefactoringASTParser.getCompilationUnit(node).getJavaProject();
            if (project != null && (method = this.getReferencingMethod(node)) != null) {
                ICompilationUnit unit;
                Set<ICompilationUnit> set = units.get(project);
                if (set == null) {
                    set = new HashSet<ICompilationUnit>();
                    units.put(project, set);
                }
                if ((unit = method.getCompilationUnit()) != null) {
                    set.add(unit);
                }
            }
            ++index;
        }
    }

    protected final Map<IJavaProject, Set<SearchResultGroup>> getReferencingCompilationUnits(IType type, IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        try {
            monitor.beginTask("", 100);
            monitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
            RefactoringSearchEngine2 engine = new RefactoringSearchEngine2();
            engine.setOwner(this.fOwner);
            engine.setFiltering(true, true);
            engine.setStatus(status);
            engine.setScope(RefactoringScopeFactory.create((IJavaElement)type));
            engine.setPattern(SearchPattern.createPattern((IJavaElement)type, (int)2, (int)24));
            engine.searchPattern((IProgressMonitor)new SubProgressMonitor(monitor, 100));
            Map<IJavaProject, Set<SearchResultGroup>> map = engine.getAffectedProjects();
            return map;
        }
        finally {
            monitor.done();
        }
    }

    protected final List<IField> getReferencingFields(ASTNode node, IJavaProject project) throws JavaModelException {
        BodyDeclaration parent;
        List<IField> result = Collections.emptyList();
        if (node instanceof Type && (parent = (BodyDeclaration)ASTNodes.getParent(node, BodyDeclaration.class)) instanceof FieldDeclaration) {
            List fragments = ((FieldDeclaration)parent).fragments();
            result = new ArrayList<IField>(fragments.size());
            VariableDeclarationFragment fragment2 = null;
            for (VariableDeclarationFragment fragment2 : fragments) {
                IField field = this.getCorrespondingField(fragment2);
                if (field == null) continue;
                result.add(field);
            }
        }
        return result;
    }

    protected final IMethod getReferencingMethod(ASTNode node) throws JavaModelException {
        ICompilationUnit unit;
        IJavaElement element;
        IMethodBinding binding;
        BodyDeclaration parent;
        if (node instanceof Type && (parent = (BodyDeclaration)ASTNodes.getParent(node, BodyDeclaration.class)) instanceof MethodDeclaration && (binding = ((MethodDeclaration)parent).resolveBinding()) != null && (element = (unit = RefactoringASTParser.getCompilationUnit(node)).getElementAt(node.getStartPosition())) instanceof IMethod) {
            return (IMethod)element;
        }
        return null;
    }

    protected ICompilationUnit getSharedWorkingCopy(ICompilationUnit unit, IProgressMonitor monitor) throws JavaModelException {
        try {
            ICompilationUnit copy = unit.findWorkingCopy(this.fOwner);
            if (copy == null) {
                copy = unit.getWorkingCopy(this.fOwner, monitor);
            }
            ICompilationUnit iCompilationUnit = copy;
            return iCompilationUnit;
        }
        finally {
            monitor.done();
        }
    }

    public final boolean isInstanceOf() {
        return this.fInstanceOf;
    }

    public final boolean isReplace() {
        return this.fReplace;
    }

    protected final void performFirstPass(SuperTypeConstraintsCreator creator, Map<IJavaProject, Set<ICompilationUnit>> units, Map<ICompilationUnit, SearchResultGroup> groups, ICompilationUnit unit, CompilationUnit node, IProgressMonitor monitor) {
        try {
            monitor.beginTask("", 100);
            monitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
            node.accept((ASTVisitor)creator);
            monitor.worked(20);
            SearchResultGroup group = groups.get(unit);
            if (group != null) {
                ASTNode[] nodes = ASTNodeSearchUtil.getAstNodes(group.getSearchResults(), node);
                try {
                    this.getMethodReferencingCompilationUnits(units, nodes);
                    monitor.worked(40);
                    this.getFieldReferencingCompilationUnits(units, nodes);
                    monitor.worked(40);
                }
                catch (JavaModelException exception) {
                    JavaPlugin.log(exception);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected final void performSecondPass(SuperTypeConstraintsCreator creator, ICompilationUnit unit, CompilationUnit node, IProgressMonitor monitor) {
        try {
            monitor.beginTask("", 20);
            monitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
            node.accept((ASTVisitor)creator);
            monitor.worked(20);
        }
        finally {
            monitor.done();
        }
    }

    protected void resetWorkingCopies() {
        ICompilationUnit[] units = JavaCore.getWorkingCopies((WorkingCopyOwner)this.fOwner);
        int index = 0;
        while (index < units.length) {
            ICompilationUnit unit = units[index];
            try {
                unit.discardWorkingCopy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++index;
        }
    }

    protected void resetWorkingCopies(ICompilationUnit unit) {
        ICompilationUnit[] units = JavaCore.getWorkingCopies((WorkingCopyOwner)this.fOwner);
        int index = 0;
        while (index < units.length) {
            if (!units[index].equals(unit)) {
                try {
                    units[index].discardWorkingCopy();
                }
                catch (Exception exception) {}
            } else {
                try {
                    units[index].getBuffer().setContents(unit.getPrimary().getBuffer().getContents());
                    JavaModelUtil.reconcile(units[index]);
                }
                catch (JavaModelException exception) {
                    JavaPlugin.log(exception);
                }
            }
            ++index;
        }
    }

    protected final void rewriteTypeOccurrence(CompilationUnitRange range, TType estimate, ASTRequestor requestor, CompilationUnitRewrite rewrite, CompilationUnit copy, Set<String> replacements, TextEditGroup group) {
        ASTNode node = null;
        IVariableBinding binding = null;
        CompilationUnit target = rewrite.getRoot();
        node = NodeFinder.perform((ASTNode)copy, (ISourceRange)range.getSourceRange());
        if (node != null) {
            if ((node = ASTNodes.getNormalizedNode(node).getParent()) instanceof VariableDeclaration) {
                binding = ((VariableDeclaration)node).resolveBinding();
                if ((node = target.findDeclaringNode(binding.getKey())) instanceof SingleVariableDeclaration) {
                    this.rewriteTypeOccurrence(estimate, rewrite, (ASTNode)((SingleVariableDeclaration)node).getType(), group);
                    if (node.getParent() instanceof MethodDeclaration && (binding = ((VariableDeclaration)node).resolveBinding()) != null) {
                        replacements.add(binding.getKey());
                    }
                }
            } else if (node instanceof VariableDeclarationStatement) {
                binding = ((VariableDeclaration)((VariableDeclarationStatement)node).fragments().get(0)).resolveBinding();
                if ((node = target.findDeclaringNode(binding.getKey())) instanceof VariableDeclarationFragment) {
                    this.rewriteTypeOccurrence(estimate, rewrite, (ASTNode)((VariableDeclarationStatement)((VariableDeclarationFragment)node).getParent()).getType(), group);
                }
            } else if (node instanceof MethodDeclaration) {
                binding = ((MethodDeclaration)node).resolveBinding();
                if ((node = target.findDeclaringNode(binding.getKey())) instanceof MethodDeclaration) {
                    this.rewriteTypeOccurrence(estimate, rewrite, (ASTNode)((MethodDeclaration)node).getReturnType2(), group);
                }
            } else if (node instanceof FieldDeclaration) {
                binding = ((VariableDeclaration)((FieldDeclaration)node).fragments().get(0)).resolveBinding();
                if ((node = target.findDeclaringNode(binding.getKey())) instanceof VariableDeclarationFragment && (node = node.getParent()) instanceof FieldDeclaration) {
                    this.rewriteTypeOccurrence(estimate, rewrite, (ASTNode)((FieldDeclaration)node).getType(), group);
                }
            } else if (node instanceof ArrayType) {
                ASTNode type = node;
                while (node != null && !(node instanceof MethodDeclaration) && !(node instanceof VariableDeclarationFragment)) {
                    node = node.getParent();
                }
                if (node != null) {
                    int delta = node.getStartPosition() + node.getLength() - type.getStartPosition();
                    if (node instanceof MethodDeclaration) {
                        binding = ((MethodDeclaration)node).resolveBinding();
                    } else if (node instanceof VariableDeclarationFragment) {
                        binding = ((VariableDeclarationFragment)node).resolveBinding();
                    }
                    if (binding != null && ((node = target.findDeclaringNode(binding.getKey())) instanceof MethodDeclaration || node instanceof VariableDeclarationFragment) && (node = NodeFinder.perform((ASTNode)target, (int)(node.getStartPosition() + node.getLength() - delta), (int)0)) instanceof SimpleName) {
                        this.rewriteTypeOccurrence(estimate, rewrite, node, group);
                    }
                }
            } else if (node instanceof QualifiedName) {
                ASTNode name = node;
                while (node != null && !(node instanceof MethodDeclaration) && !(node instanceof VariableDeclarationFragment)) {
                    node = node.getParent();
                }
                if (node != null) {
                    int delta = node.getStartPosition() + node.getLength() - name.getStartPosition();
                    if (node instanceof MethodDeclaration) {
                        binding = ((MethodDeclaration)node).resolveBinding();
                    } else if (node instanceof VariableDeclarationFragment) {
                        binding = ((VariableDeclarationFragment)node).resolveBinding();
                    }
                    if (binding != null && ((node = target.findDeclaringNode(binding.getKey())) instanceof SimpleName || node instanceof MethodDeclaration || node instanceof VariableDeclarationFragment) && (node = NodeFinder.perform((ASTNode)target, (int)(node.getStartPosition() + node.getLength() - delta), (int)0)) instanceof SimpleName) {
                        this.rewriteTypeOccurrence(estimate, rewrite, node, group);
                    }
                }
            } else if (node instanceof CastExpression) {
                ASTNode expression = node;
                while (node != null && !(node instanceof MethodDeclaration)) {
                    node = node.getParent();
                }
                if (node != null) {
                    int delta = node.getStartPosition() + node.getLength() - expression.getStartPosition();
                    binding = ((MethodDeclaration)node).resolveBinding();
                    if ((node = target.findDeclaringNode(binding.getKey())) instanceof MethodDeclaration && (node = NodeFinder.perform((ASTNode)target, (int)(node.getStartPosition() + node.getLength() - delta), (int)0)) instanceof CastExpression) {
                        this.rewriteTypeOccurrence(estimate, rewrite, (ASTNode)((CastExpression)node).getType(), group);
                    }
                }
            }
        }
    }

    protected final void rewriteTypeOccurrence(TType estimate, CompilationUnitRewrite rewrite, ASTNode node, TextEditGroup group) {
        rewrite.getImportRemover().registerRemovedNode(node);
        rewrite.getASTRewrite().replace(node, SuperTypeRefactoringProcessor.createCorrespondingNode(rewrite, estimate), group);
    }

    protected abstract void rewriteTypeOccurrences(TextEditBasedChangeManager var1, ASTRequestor var2, CompilationUnitRewrite var3, ICompilationUnit var4, CompilationUnit var5, Set<String> var6, IProgressMonitor var7) throws CoreException;

    protected final void rewriteTypeOccurrences(TextEditBasedChangeManager manager, ASTRequestor sourceRequestor, CompilationUnitRewrite sourceRewrite, ICompilationUnit subUnit, CompilationUnit subNode, Set<String> replacements, RefactoringStatus status, IProgressMonitor monitor) {
        block16: {
            try {
                monitor.beginTask("", 300);
                monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
                if (this.fTypeOccurrences == null) break block16;
                HashSet<ICompilationUnit> units = new HashSet<ICompilationUnit>(this.fTypeOccurrences.keySet());
                if (subUnit != null) {
                    units.remove(subUnit);
                }
                HashMap<IJavaProject, ArrayList<ICompilationUnit>> projects = new HashMap<IJavaProject, ArrayList<ICompilationUnit>>();
                Collection collection = null;
                IJavaProject project2 = null;
                ICompilationUnit current2 = null;
                for (ICompilationUnit current2 : units) {
                    project2 = current2.getJavaProject();
                    collection = (ArrayList<ICompilationUnit>)projects.get(project2);
                    if (collection == null) {
                        collection = new ArrayList<ICompilationUnit>();
                        projects.put(project2, (ArrayList<ICompilationUnit>)collection);
                    }
                    collection.add(current2);
                }
                ASTParser parser = ASTParser.newParser((int)4);
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 320);
                try {
                    Set keySet = projects.keySet();
                    subMonitor.beginTask("", keySet.size() * 100);
                    subMonitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
                    for (IJavaProject project2 : keySet) {
                        collection = (Collection)projects.get(project2);
                        parser.setWorkingCopyOwner(this.fOwner);
                        parser.setResolveBindings(true);
                        parser.setProject(project2);
                        parser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)project2));
                        SubProgressMonitor subsubMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 100);
                        try {
                            subsubMonitor.beginTask("", collection.size() * 100 + 200);
                            subsubMonitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
                            parser.createASTs(collection.toArray(new ICompilationUnit[collection.size()]), new String[0], new ASTRequestor((IProgressMonitor)subsubMonitor, sourceRewrite, manager, replacements, status){
                                private final /* synthetic */ IProgressMonitor val$subsubMonitor;
                                private final /* synthetic */ CompilationUnitRewrite val$sourceRewrite;
                                private final /* synthetic */ TextEditBasedChangeManager val$manager;
                                private final /* synthetic */ Set val$replacements;
                                private final /* synthetic */ RefactoringStatus val$status;
                                {
                                    this.val$subsubMonitor = iProgressMonitor;
                                    this.val$sourceRewrite = compilationUnitRewrite;
                                    this.val$manager = textEditBasedChangeManager;
                                    this.val$replacements = set;
                                    this.val$status = refactoringStatus;
                                }

                                public final void acceptAST(ICompilationUnit unit, CompilationUnit node) {
                                    SubProgressMonitor subsubsubMonitor = new SubProgressMonitor(this.val$subsubMonitor, 100);
                                    try {
                                        try {
                                            subsubsubMonitor.beginTask("", 100);
                                            subsubsubMonitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
                                            if (this.val$sourceRewrite != null) {
                                                SuperTypeRefactoringProcessor.this.rewriteTypeOccurrences(this.val$manager, this, this.val$sourceRewrite, unit, node, this.val$replacements, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subsubsubMonitor, 100));
                                            }
                                        }
                                        catch (CoreException exception) {
                                            this.val$status.merge(RefactoringStatus.createFatalErrorStatus((String)exception.getLocalizedMessage()));
                                            subsubsubMonitor.done();
                                        }
                                    }
                                    finally {
                                        subsubsubMonitor.done();
                                    }
                                }

                                public final void acceptBinding(String key, IBinding binding) {
                                }
                            }, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subsubMonitor, 200));
                        }
                        finally {
                            subsubMonitor.done();
                        }
                    }
                    try {
                        if (subUnit != null && subNode != null && sourceRewrite != null && sourceRequestor != null) {
                            this.rewriteTypeOccurrences(manager, sourceRequestor, sourceRewrite, subUnit, subNode, replacements, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 20));
                        }
                    }
                    catch (CoreException exception) {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)exception.getLocalizedMessage()));
                    }
                }
                finally {
                    subMonitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    public final void setInstanceOf(boolean rewrite) {
        this.fInstanceOf = rewrite;
    }

    public final void setReplace(boolean replace) {
        this.fReplace = replace;
    }

    protected final void solveSuperTypeConstraints(ICompilationUnit subUnit, CompilationUnit subNode, IType subType, ITypeBinding subBinding, ITypeBinding superBinding, IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        Assert.isNotNull((Object)subType);
        Assert.isNotNull((Object)subBinding);
        Assert.isNotNull((Object)superBinding);
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)status);
        int level = 3;
        TypeEnvironment environment = new TypeEnvironment();
        SuperTypeConstraintsModel model = new SuperTypeConstraintsModel(environment, environment.create(subBinding), environment.create(superBinding));
        final SuperTypeConstraintsCreator creator = new SuperTypeConstraintsCreator(model, this.fInstanceOf);
        try {
            monitor.beginTask("", 300);
            monitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
            Map<IJavaProject, Set<SearchResultGroup>> firstPass = this.getReferencingCompilationUnits(subType, (IProgressMonitor)new SubProgressMonitor(monitor, 100), status);
            final HashMap<IJavaProject, Set<ICompilationUnit>> secondPass = new HashMap<IJavaProject, Set<ICompilationUnit>>();
            Object var14_14 = null;
            Collection collection = null;
            try {
                Set<Object> keySet;
                ASTParser parser = ASTParser.newParser((int)4);
                Object element = null;
                ICompilationUnit current = null;
                SearchResultGroup group22 = null;
                SearchMatch[] matches = null;
                final HashMap<ICompilationUnit, SearchResultGroup> groups = new HashMap<ICompilationUnit, SearchResultGroup>();
                for (IJavaProject iJavaProject : firstPass.keySet()) {
                    if (level == 3 && !JavaModelUtil.is50OrHigher(iJavaProject)) {
                        level = 2;
                    }
                    if ((collection = (Collection)firstPass.get(iJavaProject)) == null) continue;
                    for (SearchResultGroup group22 : collection) {
                        matches = group22.getSearchResults();
                        int index = 0;
                        while (index < matches.length) {
                            element = matches[index].getElement();
                            if (element instanceof IMember && (current = ((IMember)element).getCompilationUnit()) != null) {
                                groups.put(current, group22);
                            }
                            ++index;
                        }
                    }
                }
                HashSet<ICompilationUnit> units = null;
                final HashSet<ICompilationUnit> processed = new HashSet<ICompilationUnit>();
                if (subUnit != null) {
                    processed.add(subUnit);
                }
                model.beginCreation();
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 120);
                try {
                    keySet = firstPass.keySet();
                    subMonitor.beginTask("", keySet.size() * 100);
                    subMonitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
                    for (IJavaProject iJavaProject : keySet) {
                        collection = firstPass.get(iJavaProject);
                        if (collection == null) continue;
                        units = new HashSet<ICompilationUnit>(collection.size());
                        for (SearchResultGroup group22 : collection) {
                            matches = group22.getSearchResults();
                            int index = 0;
                            while (index < matches.length) {
                                element = matches[index].getElement();
                                if (element instanceof IMember && (current = ((IMember)element).getCompilationUnit()) != null) {
                                    units.add(current);
                                }
                                ++index;
                            }
                        }
                        ArrayList batches = new ArrayList(units);
                        int size = batches.size();
                        int iterations = (size - 1) / 500 + 1;
                        SubProgressMonitor subsubMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 100);
                        try {
                            subsubMonitor.beginTask("", iterations * 100);
                            subsubMonitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
                            Map<String, String> options = RefactoringASTParser.getCompilerOptions((IJavaElement)iJavaProject);
                            int index = 0;
                            while (index < iterations) {
                                List iteration = batches.subList(index * 500, Math.min(size, (index + 1) * 500));
                                parser.setWorkingCopyOwner(this.fOwner);
                                parser.setResolveBindings(true);
                                parser.setProject(iJavaProject);
                                parser.setCompilerOptions(options);
                                SubProgressMonitor subsubsubMonitor = new SubProgressMonitor((IProgressMonitor)subsubMonitor, 100);
                                try {
                                    int count = iteration.size();
                                    subsubsubMonitor.beginTask("", count * 100);
                                    subsubsubMonitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
                                    parser.createASTs(iteration.toArray(new ICompilationUnit[count]), new String[0], new ASTRequestor((IProgressMonitor)subsubsubMonitor){
                                        private final /* synthetic */ IProgressMonitor val$subsubsubMonitor;
                                        {
                                            this.val$subsubsubMonitor = iProgressMonitor;
                                        }

                                        public final void acceptAST(ICompilationUnit unit, CompilationUnit node) {
                                            if (!processed.contains(unit)) {
                                                SuperTypeRefactoringProcessor.this.performFirstPass(creator, secondPass, groups, unit, node, (IProgressMonitor)new SubProgressMonitor(this.val$subsubsubMonitor, 100));
                                                processed.add(unit);
                                            } else {
                                                this.val$subsubsubMonitor.worked(100);
                                            }
                                        }

                                        public final void acceptBinding(String key, IBinding binding) {
                                        }
                                    }, (IProgressMonitor)new NullProgressMonitor());
                                }
                                finally {
                                    subsubsubMonitor.done();
                                }
                                ++index;
                            }
                        }
                        finally {
                            subsubMonitor.done();
                        }
                    }
                }
                finally {
                    firstPass.clear();
                    subMonitor.done();
                }
                if (subUnit != null && subNode != null) {
                    this.performFirstPass(creator, secondPass, groups, subUnit, subNode, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 20));
                }
                subMonitor = new SubProgressMonitor(monitor, 100);
                try {
                    keySet = secondPass.keySet();
                    subMonitor.beginTask("", keySet.size() * 100);
                    subMonitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
                    for (IJavaProject iJavaProject : keySet) {
                        if (level == 3 && !JavaModelUtil.is50OrHigher(iJavaProject)) {
                            level = 2;
                        }
                        Collection cuCollection = null;
                        cuCollection = (Collection)secondPass.get(iJavaProject);
                        if (cuCollection == null) continue;
                        parser.setWorkingCopyOwner(this.fOwner);
                        parser.setResolveBindings(true);
                        parser.setProject(iJavaProject);
                        parser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)iJavaProject));
                        SubProgressMonitor subsubMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 100);
                        try {
                            subsubMonitor.beginTask("", cuCollection.size() * 100);
                            subsubMonitor.setTaskName(RefactoringCoreMessages.SuperTypeRefactoringProcessor_creating);
                            parser.createASTs(cuCollection.toArray(new ICompilationUnit[cuCollection.size()]), new String[0], new ASTRequestor((IProgressMonitor)subsubMonitor){
                                private final /* synthetic */ IProgressMonitor val$subsubMonitor;
                                {
                                    this.val$subsubMonitor = iProgressMonitor;
                                }

                                public final void acceptAST(ICompilationUnit unit, CompilationUnit node) {
                                    if (!processed.contains(unit)) {
                                        SuperTypeRefactoringProcessor.this.performSecondPass(creator, unit, node, (IProgressMonitor)new SubProgressMonitor(this.val$subsubMonitor, 100));
                                    } else {
                                        this.val$subsubMonitor.worked(100);
                                    }
                                }

                                public final void acceptBinding(String key, IBinding binding) {
                                }
                            }, (IProgressMonitor)new NullProgressMonitor());
                        }
                        finally {
                            subsubMonitor.done();
                        }
                    }
                }
                finally {
                    secondPass.clear();
                    subMonitor.done();
                }
            }
            finally {
                model.endCreation();
                model.setCompliance(level);
            }
            SuperTypeConstraintsSolver solver = this.createContraintSolver(model);
            solver.solveConstraints();
            this.fTypeOccurrences = solver.getTypeOccurrences();
            this.fObsoleteCasts = solver.getObsoleteCasts();
        }
        finally {
            monitor.done();
        }
    }
}

