/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class CommentAnalyzer {
    private CommentAnalyzer() {
    }

    public static RefactoringStatus perform(Selection selection, IScanner scanner, int start, int length) {
        RefactoringStatus result = new RefactoringStatus();
        if (length <= 0) {
            return result;
        }
        new CommentAnalyzer().check(result, selection, scanner, start, start + length - 1);
        return result;
    }

    private void check(RefactoringStatus result, Selection selection, IScanner scanner, int start, int end) {
        char[] characters = scanner.getSource();
        selection = this.adjustSelection(characters, selection, end);
        scanner.resetTo(start, end);
        int token = 0;
        try {
            block5: while (token != 158) {
                token = scanner.getNextToken();
                switch (token) {
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        if (this.checkStart(scanner, selection.getOffset())) {
                            result.addFatalError(RefactoringCoreMessages.CommentAnalyzer_starts_inside_comment);
                            break;
                        }
                        if (this.checkEnd(scanner, selection.getInclusiveEnd())) {
                            result.addFatalError(RefactoringCoreMessages.CommentAnalyzer_ends_inside_comment);
                            break;
                        }
                    }
                    default: {
                        continue block5;
                    }
                }
                break;
            }
        }
        catch (InvalidInputException e) {
            result.addFatalError(RefactoringCoreMessages.CommentAnalyzer_internal_error);
        }
    }

    private boolean checkStart(IScanner scanner, int position) {
        return scanner.getCurrentTokenStartPosition() < position && position <= scanner.getCurrentTokenEndPosition();
    }

    private boolean checkEnd(IScanner scanner, int position) {
        return scanner.getCurrentTokenStartPosition() <= position && position < scanner.getCurrentTokenEndPosition();
    }

    private Selection adjustSelection(char[] characters, Selection selection, int end) {
        int newEnd = selection.getInclusiveEnd();
        int i = selection.getExclusiveEnd();
        while (i <= end) {
            char ch = characters[i];
            if (ch != '\n' && ch != '\r') break;
            ++newEnd;
            ++i;
        }
        return Selection.createFromStartEnd(selection.getOffset(), newEnd);
    }

    public static String normalizeReference(String reference) {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(reference.toCharArray());
        StringBuffer sb = new StringBuffer();
        try {
            int tokenType = scanner.getNextToken();
            while (tokenType != 158) {
                sb.append(scanner.getRawTokenSource());
                tokenType = scanner.getNextToken();
            }
        }
        catch (InvalidInputException e) {
            Assert.isTrue((boolean)false, (String)reference);
        }
        reference = sb.toString();
        return reference;
    }
}

