/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.compare.CompareMessages;
import org.eclipse.jdt.internal.ui.compare.EclipsePreferencesAdapter;
import org.eclipse.jdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.jdt.internal.ui.compare.JavaNode;
import org.eclipse.jdt.internal.ui.compare.JavaTokenComparator;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.text.PreferencesAdapter;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.PartEventAction;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.ITextEditorExtension3;

public class JavaMergeViewer
extends TextMergeViewer {
    private IPropertyChangeListener fPreferenceChangeListener;
    private IPreferenceStore fPreferenceStore;
    private Map<SourceViewer, JavaSourceViewerConfiguration> fSourceViewerConfiguration;
    private Map<SourceViewer, CompilationUnitEditorAdapter> fEditor;
    private ArrayList<SourceViewer> fSourceViewer;
    private IWorkbenchPartSite fSite;

    public JavaMergeViewer(Composite parent, int styles, CompareConfiguration mp) {
        super(parent, styles | 0x2000000, mp);
    }

    private IPreferenceStore getPreferenceStore() {
        if (this.fPreferenceStore == null) {
            this.setPreferenceStore((IPreferenceStore)this.createChainedPreferenceStore(null));
        }
        return this.fPreferenceStore;
    }

    protected void handleDispose(DisposeEvent event) {
        this.setPreferenceStore(null);
        this.fSourceViewer = null;
        if (this.fEditor != null) {
            for (CompilationUnitEditorAdapter editor : this.fEditor.values()) {
                editor.dispose();
            }
            this.fEditor = null;
        }
        this.fSite = null;
        super.handleDispose(event);
    }

    public IJavaProject getJavaProject(ICompareInput input) {
        IJavaElement element;
        IResource resource;
        if (input == null) {
            return null;
        }
        IResourceProvider rp = null;
        ITypedElement te = input.getLeft();
        if (te instanceof IResourceProvider) {
            rp = (IResourceProvider)te;
        }
        if (rp == null && (te = input.getRight()) instanceof IResourceProvider) {
            rp = (IResourceProvider)te;
        }
        if (rp == null && (te = input.getAncestor()) instanceof IResourceProvider) {
            rp = (IResourceProvider)te;
        }
        if (rp != null && (resource = rp.getResource()) != null && (element = JavaCore.create((IResource)resource)) != null) {
            return element.getJavaProject();
        }
        return null;
    }

    public void setInput(Object input) {
        IJavaProject project;
        if (input instanceof ICompareInput && (project = this.getJavaProject((ICompareInput)input)) != null) {
            this.setPreferenceStore((IPreferenceStore)this.createChainedPreferenceStore(project));
        }
        super.setInput(input);
    }

    private ChainedPreferenceStore createChainedPreferenceStore(IJavaProject project) {
        ArrayList<IPreferenceStore> stores = new ArrayList<IPreferenceStore>(4);
        if (project != null) {
            stores.add(new EclipsePreferencesAdapter((IScopeContext)new ProjectScope(project.getProject()), "org.eclipse.jdt.core"));
        }
        stores.add(JavaPlugin.getDefault().getPreferenceStore());
        stores.add(new PreferencesAdapter(JavaPlugin.getJavaCorePluginPreferences()));
        stores.add(EditorsUI.getPreferenceStore());
        return new ChainedPreferenceStore(stores.toArray(new IPreferenceStore[stores.size()]));
    }

    private void handlePropertyChange(PropertyChangeEvent event) {
        if (this.fSourceViewerConfiguration != null) {
            for (Map.Entry<SourceViewer, JavaSourceViewerConfiguration> entry : this.fSourceViewerConfiguration.entrySet()) {
                JavaSourceViewerConfiguration configuration = entry.getValue();
                if (!configuration.affectsTextPresentation(event)) continue;
                configuration.handlePropertyChangeEvent(event);
                ITextViewer viewer = (ITextViewer)entry.getKey();
                viewer.invalidateTextPresentation();
            }
        }
    }

    public String getTitle() {
        return CompareMessages.JavaMergeViewer_title;
    }

    public ITokenComparator createTokenComparator(String s) {
        return new JavaTokenComparator(s);
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return JavaCompareUtilities.createJavaPartitioner();
    }

    protected String getDocumentPartitioning() {
        return "___java_partitioning";
    }

    protected void configureTextViewer(TextViewer viewer) {
        if (viewer instanceof SourceViewer) {
            JavaTextTools tools;
            SourceViewer sourceViewer = (SourceViewer)viewer;
            if (this.fSourceViewer == null) {
                this.fSourceViewer = new ArrayList();
            }
            if (!this.fSourceViewer.contains(sourceViewer)) {
                this.fSourceViewer.add(sourceViewer);
            }
            if ((tools = JavaCompareUtilities.getJavaTextTools()) != null) {
                IEditorInput editorInput = this.getEditorInput((ISourceViewer)sourceViewer);
                sourceViewer.unconfigure();
                if (editorInput == null) {
                    sourceViewer.configure((SourceViewerConfiguration)this.getSourceViewerConfiguration(sourceViewer, null));
                    return;
                }
                this.getSourceViewerConfiguration(sourceViewer, editorInput);
            }
        }
    }

    protected void setEditable(ISourceViewer sourceViewer, boolean state) {
        CompilationUnitEditorAdapter editor;
        super.setEditable(sourceViewer, state);
        if (this.fEditor != null && (editor = this.fEditor.get(sourceViewer)) instanceof CompilationUnitEditorAdapter) {
            editor.setEditable(state);
        }
    }

    protected boolean isEditorBacked(ITextViewer textViewer) {
        return this.getSite() != null;
    }

    protected IEditorInput getEditorInput(ISourceViewer sourceViewer) {
        IEditorInput editorInput = super.getEditorInput(sourceViewer);
        if (editorInput == null) {
            return null;
        }
        if (this.getSite() == null) {
            return null;
        }
        if (!(editorInput instanceof IStorageEditorInput)) {
            return null;
        }
        return editorInput;
    }

    private IWorkbenchPartSite getSite() {
        if (this.fSite == null) {
            IWorkbenchPart workbenchPart = this.getCompareConfiguration().getContainer().getWorkbenchPart();
            this.fSite = workbenchPart != null ? workbenchPart.getSite() : null;
        }
        return this.fSite;
    }

    private JavaSourceViewerConfiguration getSourceViewerConfiguration(SourceViewer sourceViewer, IEditorInput editorInput) {
        if (this.fSourceViewerConfiguration == null) {
            this.fSourceViewerConfiguration = new HashMap<SourceViewer, JavaSourceViewerConfiguration>(3);
        }
        if (this.fPreferenceStore == null) {
            this.getPreferenceStore();
        }
        JavaTextTools tools = JavaCompareUtilities.getJavaTextTools();
        JavaSourceViewerConfiguration configuration = new JavaSourceViewerConfiguration(tools.getColorManager(), this.fPreferenceStore, null, this.getDocumentPartitioning());
        if (editorInput != null) {
            CompilationUnitEditorAdapter editor = this.fEditor.get(sourceViewer);
            try {
                editor.init((IEditorSite)editor.getSite(), editorInput);
                editor.createActions();
                configuration = new JavaSourceViewerConfiguration(tools.getColorManager(), this.fPreferenceStore, (ITextEditor)editor, this.getDocumentPartitioning());
            }
            catch (PartInitException e) {
                JavaPlugin.log(e);
            }
        }
        this.fSourceViewerConfiguration.put(sourceViewer, configuration);
        return this.fSourceViewerConfiguration.get(sourceViewer);
    }

    protected int findInsertionPosition(char type, ICompareInput input) {
        int pos = super.findInsertionPosition(type, input);
        if (pos != 0) {
            return pos;
        }
        if (input instanceof IDiffElement) {
            JavaNode otherJavaElement = null;
            ITypedElement otherElement = null;
            switch (type) {
                case 'L': {
                    otherElement = input.getRight();
                    break;
                }
                case 'R': {
                    otherElement = input.getLeft();
                }
            }
            if (otherElement instanceof JavaNode) {
                otherJavaElement = (JavaNode)otherElement;
            }
            JavaNode javaContainer = null;
            IDiffElement diffElement = (IDiffElement)input;
            IDiffContainer container = diffElement.getParent();
            if (container instanceof ICompareInput) {
                ICompareInput parent = (ICompareInput)container;
                ITypedElement element = null;
                switch (type) {
                    case 'L': {
                        element = parent.getLeft();
                        break;
                    }
                    case 'R': {
                        element = parent.getRight();
                    }
                }
                if (element instanceof JavaNode) {
                    javaContainer = (JavaNode)element;
                }
            }
            if (otherJavaElement != null && javaContainer != null) {
                switch (otherJavaElement.getTypeCode()) {
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        Position p;
                        Object[] children = javaContainer.getChildren();
                        if (children.length > 0) {
                            JavaNode packageDecl = null;
                            int i = 0;
                            while (i < children.length) {
                                JavaNode child = (JavaNode)((Object)children[i]);
                                switch (child.getTypeCode()) {
                                    case 1: {
                                        packageDecl = child;
                                        break;
                                    }
                                    case 5: {
                                        return child.getRange().getOffset();
                                    }
                                }
                                ++i;
                            }
                            if (packageDecl != null) {
                                p = packageDecl.getRange();
                                return p.getOffset() + p.getLength();
                            }
                        }
                        return javaContainer.getRange().getOffset();
                    }
                    case 3: {
                        Position p = javaContainer.getRange();
                        return p.getOffset() + p.getLength();
                    }
                    case 5: {
                        Position p;
                        Object[] children = javaContainer.getChildren();
                        if (children.length > 0) {
                            int i = children.length - 1;
                            while (i >= 0) {
                                JavaNode child = (JavaNode)((Object)children[i]);
                                switch (child.getTypeCode()) {
                                    case 1: 
                                    case 2: 
                                    case 5: 
                                    case 8: {
                                        p = child.getRange();
                                        return p.getOffset() + p.getLength();
                                    }
                                }
                                --i;
                            }
                        }
                        return javaContainer.getAppendPosition().getOffset();
                    }
                    case 11: {
                        Position p;
                        Object[] children = javaContainer.getChildren();
                        if (children.length > 0) {
                            JavaNode child = (JavaNode)((Object)children[children.length - 1]);
                            p = child.getRange();
                            return this.findEndOfLine(javaContainer, p.getOffset() + p.getLength());
                        }
                        return javaContainer.getAppendPosition().getOffset();
                    }
                    case 8: {
                        Position p;
                        Object[] children = javaContainer.getChildren();
                        if (children.length > 0) {
                            JavaNode method = null;
                            int i = children.length - 1;
                            while (i >= 0) {
                                JavaNode child = (JavaNode)((Object)children[i]);
                                switch (child.getTypeCode()) {
                                    case 11: {
                                        method = child;
                                        break;
                                    }
                                    case 8: {
                                        p = child.getRange();
                                        return p.getOffset() + p.getLength();
                                    }
                                }
                                --i;
                            }
                            if (method != null) {
                                return method.getRange().getOffset();
                            }
                        }
                        return javaContainer.getAppendPosition().getOffset();
                    }
                }
            }
            if (javaContainer != null) {
                Position p = javaContainer.getRange();
                return p.getOffset() + p.getLength();
            }
        }
        return 0;
    }

    private int findEndOfLine(JavaNode container, int pos) {
        IDocument doc = container.getDocument();
        try {
            int line = doc.getLineOfOffset(pos);
            pos = doc.getLineOffset(line + 1);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        Position containerRange = container.getRange();
        int start = containerRange.getOffset();
        int end = containerRange.getOffset() + containerRange.getLength();
        if (pos < start) {
            return start;
        }
        if (pos >= end) {
            return end - 1;
        }
        return pos;
    }

    private void setPreferenceStore(IPreferenceStore ps) {
        if (this.fPreferenceChangeListener != null) {
            if (this.fPreferenceStore != null) {
                this.fPreferenceStore.removePropertyChangeListener(this.fPreferenceChangeListener);
            }
            this.fPreferenceChangeListener = null;
        }
        this.fPreferenceStore = ps;
        if (this.fPreferenceStore != null) {
            this.fPreferenceChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    JavaMergeViewer.this.handlePropertyChange(event);
                }
            };
            this.fPreferenceStore.addPropertyChangeListener(this.fPreferenceChangeListener);
        }
    }

    protected SourceViewer createSourceViewer(Composite parent, int textOrientation) {
        SourceViewer sourceViewer;
        if (this.getSite() != null) {
            CompilationUnitEditorAdapter editor = new CompilationUnitEditorAdapter(textOrientation);
            editor.createPartControl(parent);
            ISourceViewer iSourceViewer = editor.getViewer();
            Assert.isTrue((boolean)(iSourceViewer instanceof SourceViewer));
            sourceViewer = (SourceViewer)iSourceViewer;
            if (this.fEditor == null) {
                this.fEditor = new HashMap<SourceViewer, CompilationUnitEditorAdapter>(3);
            }
            this.fEditor.put(sourceViewer, editor);
        } else {
            sourceViewer = super.createSourceViewer(parent, textOrientation);
        }
        if (this.fSourceViewer == null) {
            this.fSourceViewer = new ArrayList();
        }
        this.fSourceViewer.add(sourceViewer);
        return sourceViewer;
    }

    protected void setActionsActivated(SourceViewer sourceViewer, boolean state) {
        CompilationUnitEditorAdapter editor;
        if (this.fEditor != null && (editor = this.fEditor.get(sourceViewer)) instanceof CompilationUnitEditorAdapter) {
            CompilationUnitEditorAdapter cuea = editor;
            cuea.setActionsActivated(state);
            IAction saveAction = cuea.getAction(ITextEditorActionConstants.SAVE);
            if (saveAction instanceof IPageListener) {
                PartEventAction partEventAction = (PartEventAction)saveAction;
                IWorkbenchPart compareEditorPart = this.getCompareConfiguration().getContainer().getWorkbenchPart();
                if (state) {
                    partEventAction.partActivated(compareEditorPart);
                } else {
                    partEventAction.partDeactivated(compareEditorPart);
                }
            }
        }
    }

    protected void createControls(Composite composite) {
        IContextService service;
        super.createControls(composite);
        IWorkbenchPart workbenchPart = this.getCompareConfiguration().getContainer().getWorkbenchPart();
        if (workbenchPart != null && (service = (IContextService)workbenchPart.getSite().getService(IContextService.class)) != null) {
            service.activateContext("org.eclipse.jdt.ui.javaEditorScope");
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ITextEditorExtension3.class) {
            IEditorInput activeInput = (IEditorInput)super.getAdapter(IEditorInput.class);
            if (activeInput != null) {
                for (CompilationUnitEditorAdapter editor : this.fEditor.values()) {
                    if (!activeInput.equals(editor.getEditorInput())) continue;
                    return editor;
                }
            }
            return null;
        }
        return super.getAdapter(adapter);
    }

    private void setSourceViewer(ITextEditor editor, SourceViewer viewer) {
        Field field = null;
        try {
            field = AbstractTextEditor.class.getDeclaredField("fSourceViewer");
        }
        catch (SecurityException ex) {
            JavaPlugin.log(ex);
        }
        catch (NoSuchFieldException ex) {
            JavaPlugin.log(ex);
        }
        field.setAccessible(true);
        try {
            field.set(editor, viewer);
        }
        catch (IllegalArgumentException ex) {
            JavaPlugin.log(ex);
        }
        catch (IllegalAccessException ex) {
            JavaPlugin.log(ex);
        }
    }

    private class CompilationUnitEditorAdapter
    extends CompilationUnitEditor {
        private boolean fInputSet = false;
        private int fTextOrientation;
        private boolean fEditable;

        CompilationUnitEditorAdapter(int textOrientation) {
            this.fTextOrientation = textOrientation;
            this.setPreferenceStore((IPreferenceStore)JavaMergeViewer.this.createChainedPreferenceStore(null));
        }

        private void setEditable(boolean editable) {
            this.fEditable = editable;
        }

        public IWorkbenchPartSite getSite() {
            return JavaMergeViewer.this.getSite();
        }

        public void createActions() {
            if (this.fInputSet) {
                super.createActions();
                this.getCorrectionCommands().deregisterCommands();
                this.getRefactorActionGroup().dispose();
                this.getGenerateActionGroup().dispose();
            }
        }

        public void createPartControl(Composite composite) {
            SourceViewer sourceViewer = (SourceViewer)this.createJavaSourceViewer(composite, (IVerticalRuler)new CompositeRuler(), null, false, this.fTextOrientation | 0x100 | 0x200, (IPreferenceStore)JavaMergeViewer.this.createChainedPreferenceStore(null));
            JavaMergeViewer.this.setSourceViewer((ITextEditor)this, sourceViewer);
            this.createNavigationActions();
            this.getSelectionProvider().addSelectionChangedListener(this.getSelectionChangedListener());
        }

        protected void doSetInput(IEditorInput input) throws CoreException {
            super.doSetInput(input);
            this.fInputSet = true;
        }

        public boolean isEditable() {
            return this.fEditable;
        }

        public boolean isEditorInputModifiable() {
            return this.fEditable;
        }

        public boolean isEditorInputReadOnly() {
            return !this.fEditable;
        }

        protected void setActionsActivated(boolean state) {
            super.setActionsActivated(state);
        }

        public void close(boolean save) {
            this.getDocumentProvider().disconnect((Object)this.getEditorInput());
        }
    }
}

