/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.filters;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.team.core.RepositoryProvider;

public class NonSharedProjectFilter
extends ViewerFilter {
    private static final String PDE_NATURE_ID = "org.eclipse.pde.PluginNature";
    private static final QualifiedName EXTERNAL_PDE_PROJECT_PROPERTY = new QualifiedName("org.eclipse.pde.core", "imported");

    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IProject) {
            return NonSharedProjectFilter.isSharedProject((IProject)element);
        }
        if (element instanceof IJavaProject) {
            return NonSharedProjectFilter.isSharedProject(((IJavaProject)element).getProject());
        }
        return true;
    }

    private static boolean isSharedProject(IProject project) {
        return !project.isAccessible() || RepositoryProvider.isShared((IProject)project) && !NonSharedProjectFilter.isBinaryPDEProject(project);
    }

    private static boolean isBinaryPDEProject(IProject project) {
        try {
            return project.hasNature(PDE_NATURE_ID) && project.getPersistentProperty(EXTERNAL_PDE_PROJECT_PROPERTY) != null;
        }
        catch (CoreException e) {
            return false;
        }
    }
}

