/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.NullAnnotationsFix;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullAnnotationsCleanUp
extends AbstractMultiFix {
    private int handledProblemID;

    public NullAnnotationsCleanUp(Map<String, String> options, int handledProblemID) {
        super(options);
        this.handledProblemID = handledProblemID;
    }

    @Override
    public CleanUpRequirements getRequirements() {
        Map<String, String> requiredOptions = this.getRequiredOptions();
        return new CleanUpRequirements(true, false, false, requiredOptions);
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit compilationUnit) throws CoreException {
        return this.createFix(compilationUnit, null);
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        IProblemLocation[] locations = null;
        ArrayList<IProblemLocation> filteredLocations = new ArrayList<IProblemLocation>();
        if (problems != null) {
            int i = 0;
            while (i < problems.length) {
                if (problems[i].getProblemId() == this.handledProblemID) {
                    filteredLocations.add(problems[i]);
                }
                ++i;
            }
            locations = filteredLocations.toArray(new IProblemLocation[filteredLocations.size()]);
        }
        return NullAnnotationsFix.createCleanUp(compilationUnit, locations, this.handledProblemID);
    }

    private Map<String, String> getRequiredOptions() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        result.put("org.eclipse.jdt.core.compiler.problem.nullSpecViolation", "warning");
        result.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "warning");
        result.put("org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation", "warning");
        result.put("org.eclipse.jdt.core.compiler.problem.nullAnnotationInferenceConflict", "warning");
        result.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "warning");
        result.put("org.eclipse.jdt.core.compiler.annotation.missingNonNullByDefaultAnnotation", "warning");
        return result;
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        switch (this.handledProblemID) {
            case 16778126: 
            case 16778127: 
            case 16778128: 
            case 67109779: 
            case 67109780: 
            case 67109782: 
            case 536871369: 
            case 536871370: 
            case 536871845: {
                result.add(MultiFixMessages.NullAnnotationsCleanUp_add_nullable_annotation);
                break;
            }
            case 67109781: {
                result.add(MultiFixMessages.NullAnnotationsCleanUp_add_nonnull_annotation);
                break;
            }
            case 67109786: 
            case 536871838: 
            case 536871839: 
            case 536871840: {
                result.add(MultiFixMessages.NullAnnotationsCleanUp_remove_redundant_nullness_annotation);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getPreview() {
        return "No preview available";
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        int id = problem.getProblemId();
        return id == this.handledProblemID;
    }

    @Override
    public int computeNumberOfFixes(CompilationUnit compilationUnit) {
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        int i = 0;
        while (i < problems.length) {
            int id = problems[i].getID();
            if (id == this.handledProblemID) {
                ++result;
            }
            ++i;
        }
        return result;
    }
}

