/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarimport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.jarimport.JarImportData;
import org.eclipse.jdt.internal.ui.jarimport.JarImportMessages;
import org.eclipse.jdt.internal.ui.jarimport.JarImportWizardPage;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.jdt.internal.ui.refactoring.binary.BinaryRefactoringHistoryWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public final class JarImportWizard
extends BinaryRefactoringHistoryWizard
implements IImportWizard {
    private static String DIALOG_SETTINGS_KEY = "JarImportWizard";
    private final RefactoringHistoryProxy fHistoryProxy;
    private final JarImportData fImportData = new JarImportData();
    private JarImportWizardPage fImportPage = null;
    private boolean fImportWizard = true;
    private boolean fNewSettings;

    public static boolean isValidClassPathEntry(IClasspathEntry entry) {
        Assert.isNotNull((Object)entry);
        int kind = entry.getEntryKind();
        if (kind == 1) {
            return entry.getContentKind() == 2;
        }
        return kind == 4;
    }

    public static boolean isValidJavaProject(IJavaProject project) throws JavaModelException {
        Assert.isNotNull((Object)project);
        return project.getProject().isAccessible();
    }

    public JarImportWizard() {
        super(JarImportMessages.JarImportWizard_window_title, JarImportMessages.RefactoringImportPreviewPage_title, JarImportMessages.RefactoringImportPreviewPage_description);
        this.fImportData.setRefactoringAware(true);
        this.fImportData.setIncludeDirectoryEntries(true);
        this.fHistoryProxy = new RefactoringHistoryProxy();
        this.setInput(this.fHistoryProxy);
        IDialogSettings section = JavaPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            this.fNewSettings = true;
        } else {
            this.fNewSettings = false;
            this.setDialogSettings(section);
        }
        this.setConfiguration(new RefactoringHistoryControlConfiguration(null, false, false){

            public String getProjectPattern() {
                return JarImportMessages.JarImportWizard_project_pattern;
            }

            public String getWorkspaceCaption() {
                return JarImportMessages.JarImportWizard_workspace_caption;
            }
        });
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_REPLACE_JAR);
    }

    public JarImportWizard(boolean wizard) {
        this();
        this.fImportWizard = wizard;
        this.setWindowTitle(JarImportMessages.JarImportWizard_replace_title);
    }

    protected void addUserDefinedPages() {
        this.fImportPage = new JarImportWizardPage(this, this.fImportWizard);
        this.addPage((IWizardPage)this.fImportPage);
    }

    public boolean canFinish() {
        return super.canFinish() && this.fImportData.getPackageFragmentRoot() != null && this.fImportData.getRefactoringFileLocation() != null;
    }

    protected boolean deconfigureClasspath(IClasspathEntry[] entries, IProgressMonitor monitor) throws CoreException {
        IPackageFragmentRoot root;
        boolean rename = this.fImportData.isRenameJarFile();
        if (rename && !this.fCancelled && (root = this.getPackageFragmentRoot()) != null) {
            IClasspathEntry entry = root.getRawClasspathEntry();
            int index = 0;
            while (index < entries.length) {
                IPath path;
                if (entries[index].equals(entry) && (path = this.getTargetPath(entries[index])) != null) {
                    entries[index] = JavaCore.newLibraryEntry((IPath)path, (IPath)entries[index].getSourceAttachmentPath(), (IPath)entries[index].getSourceAttachmentRootPath(), (IAccessRule[])entries[index].getAccessRules(), (IClasspathAttribute[])entries[index].getExtraAttributes(), (boolean)entries[index].isExported());
                }
                ++index;
            }
        }
        if (!this.fCancelled) {
            this.replaceJarFile((IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
        }
        return rename;
    }

    public JarImportData getImportData() {
        return this.fImportData;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fImportPage && this.fImportData.getRefactoringHistory() == null) {
            return null;
        }
        return super.getNextPage(page);
    }

    protected IPackageFragmentRoot getPackageFragmentRoot() {
        return this.fImportData.getPackageFragmentRoot();
    }

    protected RefactoringHistory getRefactoringHistory() {
        return this.fHistoryProxy;
    }

    private IPath getTargetPath(IClasspathEntry entry) throws CoreException {
        URI target;
        URI location = JarImportWizard.getLocationURI(entry);
        if (location != null && (target = this.getTargetURI(location)) != null) {
            IPath workspace;
            IPath path = URIUtil.toPath((URI)target);
            if (path != null && (workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation()).isPrefixOf(path)) {
                path = path.removeFirstSegments(workspace.segmentCount());
                path = path.setDevice(null);
                path = path.makeAbsolute();
            }
            return path;
        }
        return null;
    }

    private URI getTargetURI(URI uri) throws CoreException {
        URI location;
        IFileStore parent = EFS.getStore((URI)uri).getParent();
        if (parent != null && (location = this.fImportData.getRefactoringFileLocation()) != null) {
            return parent.getChild(EFS.getStore((URI)location).getName()).toURI();
        }
        return uri;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object element;
        if (selection != null && selection.size() == 1 && (element = selection.getFirstElement()) instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)element;
            try {
                IClasspathEntry entry = root.getRawClasspathEntry();
                if (JarImportWizard.isValidClassPathEntry(entry) && root.getResolvedClasspathEntry().getReferencingEntry() == null) {
                    this.fImportData.setPackageFragmentRoot(root);
                }
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
        }
    }

    public boolean performFinish() {
        if (this.fNewSettings) {
            IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection(DIALOG_SETTINGS_KEY);
            section = settings.addNewSection(DIALOG_SETTINGS_KEY);
            this.setDialogSettings(section);
        }
        this.fImportPage.performFinish();
        return super.performFinish();
    }

    private void replaceJarFile(IProgressMonitor monitor) throws CoreException {
        try {
            URI uri;
            IPackageFragmentRoot root;
            monitor.beginTask(JarImportMessages.JarImportWizard_cleanup_import, 250);
            URI location = this.fImportData.getRefactoringFileLocation();
            if (location != null && (root = this.fImportData.getPackageFragmentRoot()) != null && (uri = JarImportWizard.getLocationURI(root.getRawClasspathEntry())) != null) {
                IFileStore store = EFS.getStore((URI)location);
                if (this.fImportData.isRenameJarFile()) {
                    URI target = this.getTargetURI(uri);
                    store.copy(EFS.getStore((URI)target), 2, (IProgressMonitor)new SubProgressMonitor(monitor, 50, 2));
                    if (!uri.equals(target)) {
                        EFS.getStore((URI)uri).delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 50, 2));
                    }
                } else {
                    store.copy(EFS.getStore((URI)uri), 2, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                }
                if (this.fJavaProject != null) {
                    this.fJavaProject.getResource().refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 50, 2));
                }
                return;
            }
            throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, JarImportMessages.JarImportWizard_error_copying_jar, null));
        }
        finally {
            monitor.done();
        }
    }

    private final class RefactoringHistoryProxy
    extends RefactoringHistory {
        private RefactoringDescriptorProxy[] fHistoryDelta = null;

        private RefactoringHistoryProxy() {
        }

        public RefactoringDescriptorProxy[] getDescriptors() {
            if (this.fHistoryDelta != null) {
                return this.fHistoryDelta;
            }
            RefactoringHistory incoming = JarImportWizard.this.fImportData.getRefactoringHistory();
            if (incoming != null) {
                block18: {
                    this.fHistoryDelta = incoming.getDescriptors();
                    IPackageFragmentRoot root = JarImportWizard.this.fImportData.getPackageFragmentRoot();
                    if (root != null) {
                        try {
                            File file;
                            URI uri = JarImportWizard.getLocationURI(root.getRawClasspathEntry());
                            if (uri == null || !(file = new File(uri)).exists()) break block18;
                            ZipFile zip = null;
                            try {
                                zip = new ZipFile(file, 1);
                                ZipEntry entry = zip.getEntry(JarPackagerUtil.getRefactoringsEntry());
                                if (entry == null) break block18;
                                InputStream stream = null;
                                try {
                                    stream = zip.getInputStream(entry);
                                    RefactoringHistory existing = RefactoringCore.getHistoryService().readRefactoringHistory(stream, 589824);
                                    if (existing != null) {
                                        this.fHistoryDelta = incoming.removeAll(existing).getDescriptors();
                                    }
                                }
                                finally {
                                    if (stream != null) {
                                        try {
                                            stream.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                }
                            }
                            catch (IOException exception) {
                                try {
                                    zip.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        catch (CoreException exception) {
                            JavaPlugin.log(exception);
                        }
                    }
                }
                return this.fHistoryDelta;
            }
            return new RefactoringDescriptorProxy[0];
        }

        public boolean isEmpty() {
            RefactoringDescriptorProxy[] proxies = this.getDescriptors();
            if (proxies != null) {
                return proxies.length == 0;
            }
            return true;
        }

        public RefactoringHistory removeAll(RefactoringHistory history) {
            throw new UnsupportedOperationException();
        }
    }
}

