/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor.selectionactions;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.SelectionActionMessages;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.SelectionHistory;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public abstract class StructureSelectionAction
extends Action {
    public static final String NEXT = "SelectNextElement";
    public static final String PREVIOUS = "SelectPreviousElement";
    public static final String ENCLOSING = "SelectEnclosingElement";
    public static final String HISTORY = "RestoreLastSelection";
    private JavaEditor fEditor;
    private SelectionHistory fSelectionHistory;

    protected StructureSelectionAction(String text, JavaEditor editor, SelectionHistory history) {
        super(text);
        Assert.isNotNull((Object)editor);
        Assert.isNotNull((Object)history);
        this.fEditor = editor;
        this.fSelectionHistory = history;
    }

    protected StructureSelectionAction() {
        super("");
    }

    public final void run() {
        ITypeRoot inputElement = EditorUtility.getEditorInputJavaElement((IEditorPart)this.fEditor, false);
        if (!(inputElement instanceof ITypeRoot) || !inputElement.exists()) {
            return;
        }
        ITypeRoot typeRoot = inputElement;
        try {
            ISourceRange sourceRange = typeRoot.getSourceRange();
            if (sourceRange == null || sourceRange.getLength() == 0) {
                MessageDialog.openInformation((Shell)this.fEditor.getEditorSite().getShell(), (String)SelectionActionMessages.StructureSelect_error_title, (String)SelectionActionMessages.StructureSelect_error_message);
                return;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        ITextSelection selection = this.getTextSelection();
        ISourceRange newRange = this.getNewSelectionRange(StructureSelectionAction.createSourceRange(selection), typeRoot);
        if (selection.getOffset() == newRange.getOffset() && selection.getLength() == newRange.getLength()) {
            return;
        }
        this.fSelectionHistory.remember((ISourceRange)new SourceRange(selection.getOffset(), selection.getLength()));
        try {
            this.fSelectionHistory.ignoreSelectionChanges();
            this.fEditor.selectAndReveal(newRange.getOffset(), newRange.getLength());
        }
        finally {
            this.fSelectionHistory.listenToSelectionChanges();
        }
    }

    public final ISourceRange getNewSelectionRange(ISourceRange oldSourceRange, ITypeRoot typeRoot) {
        try {
            CompilationUnit root = StructureSelectionAction.getAST(typeRoot);
            if (root == null) {
                return oldSourceRange;
            }
            Selection selection = Selection.createFromStartLength(oldSourceRange.getOffset(), oldSourceRange.getLength());
            SelectionAnalyzer selAnalyzer = new SelectionAnalyzer(selection, true);
            root.accept((ASTVisitor)selAnalyzer);
            return this.internalGetNewSelectionRange(oldSourceRange, (ISourceReference)typeRoot, selAnalyzer);
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return new SourceRange(oldSourceRange.getOffset(), oldSourceRange.getLength());
        }
    }

    abstract ISourceRange internalGetNewSelectionRange(ISourceRange var1, ISourceReference var2, SelectionAnalyzer var3) throws JavaModelException;

    protected final ITextSelection getTextSelection() {
        return (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
    }

    protected static ISourceRange getLastCoveringNodeRange(ISourceRange oldSourceRange, ISourceReference sr, SelectionAnalyzer selAnalyzer) throws JavaModelException {
        if (selAnalyzer.getLastCoveringNode() == null) {
            return oldSourceRange;
        }
        return StructureSelectionAction.getSelectedNodeSourceRange(sr, selAnalyzer.getLastCoveringNode());
    }

    protected static ISourceRange getSelectedNodeSourceRange(ISourceReference sr, ASTNode nodeToSelect) throws JavaModelException {
        int offset = nodeToSelect.getStartPosition();
        int end = Math.min(sr.getSourceRange().getLength(), nodeToSelect.getStartPosition() + nodeToSelect.getLength() - 1);
        return StructureSelectionAction.createSourceRange(offset, end);
    }

    private static ISourceRange createSourceRange(ITextSelection ts) {
        return new SourceRange(ts.getOffset(), ts.getLength());
    }

    private static CompilationUnit getAST(ITypeRoot sr) {
        return SharedASTProvider.getAST(sr, SharedASTProvider.WAIT_YES, null);
    }

    static ISourceRange createSourceRange(int offset, int end) {
        int length = end - offset + 1;
        if (length == 0) {
            length = 1;
        }
        return new SourceRange(Math.max(0, offset), length);
    }

    static ASTNode[] getSiblingNodes(ASTNode node) {
        ASTNode parent = node.getParent();
        StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
        if (locationInParent.isChildListProperty()) {
            List siblings = (List)parent.getStructuralProperty(locationInParent);
            return siblings.toArray(new ASTNode[siblings.size()]);
        }
        return null;
    }

    static int findIndex(Object[] array, Object o) {
        int i = 0;
        while (i < array.length) {
            Object object = array[i];
            if (object == o) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

