/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaElementResourceMapping;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.model.JavaModelContentProvider;
import org.eclipse.jdt.internal.ui.model.JavaModelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.ui.refactoring.model.AbstractSynchronizationContentProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.diff.IDiffVisitor;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaSynchronizationContentProvider
extends AbstractSynchronizationContentProvider
implements IPipelinedTreeContentProvider {
    private ITreeContentProvider fContentProvider = null;
    private Object fModelRoot = null;

    static IDiff[] getDiffs(ISynchronizationContext context, Object element) {
        return context.getDiffTree().getDiffs(JavaSynchronizationContentProvider.getResourceTraversals(element));
    }

    static ResourceMapping getResourceMapping(Object element) {
        IAdaptable adaptable;
        Object adapted;
        if (element instanceof IJavaElement) {
            return JavaElementResourceMapping.create((IJavaElement)element);
        }
        if (element instanceof IAdaptable && (adapted = (adaptable = (IAdaptable)element).getAdapter(ResourceMapping.class)) instanceof ResourceMapping) {
            return (ResourceMapping)adapted;
        }
        return null;
    }

    static ResourceTraversal[] getResourceTraversals(Object element) {
        ResourceMapping mapping = JavaSynchronizationContentProvider.getResourceMapping(element);
        if (mapping != null) {
            try {
                return mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException exception) {
                JavaPlugin.log(exception);
            }
        }
        return new ResourceTraversal[0];
    }

    private IJavaProject asJavaProject(IProject project) {
        block4: {
            if (project == null) {
                return null;
            }
            try {
                if (project.getDescription().hasNature("org.eclipse.jdt.core.javanature")) {
                    return JavaCore.create((IProject)project);
                }
            }
            catch (CoreException exception) {
                if (!project.isAccessible()) break block4;
                JavaPlugin.log(exception);
            }
        }
        return null;
    }

    private void convertToJavaElements(PipelinedShapeModification modification) {
        IJavaProject project;
        Object parent = modification.getParent();
        if (parent instanceof IResource && (project = this.asJavaProject(((IResource)parent).getProject())) != null) {
            modification.getChildren().clear();
            return;
        }
        if (parent instanceof ISynchronizationContext) {
            HashSet<IJavaProject> result = new HashSet<IJavaProject>();
            Iterator iterator = modification.getChildren().iterator();
            while (iterator.hasNext()) {
                IJavaProject project2;
                Object element = iterator.next();
                if (!(element instanceof IProject) || (project2 = this.asJavaProject((IProject)element)) == null) continue;
                iterator.remove();
                result.add(project2);
            }
            modification.getChildren().addAll(result);
        }
    }

    private boolean convertToJavaElements(PipelinedViewerUpdate update) {
        HashSet<IJavaProject> result = new HashSet<IJavaProject>();
        Iterator iterator = update.getRefreshTargets().iterator();
        while (iterator.hasNext()) {
            IJavaProject project;
            Object element = iterator.next();
            if (!(element instanceof IProject) || (project = this.asJavaProject((IProject)element)) == null) continue;
            iterator.remove();
            result.add(project);
        }
        update.getRefreshTargets().addAll(result);
        return !result.isEmpty();
    }

    public void diffsChanged(final IDiffChangeEvent event, IProgressMonitor monitor) {
        this.syncExec(new Runnable(){

            public void run() {
                JavaSynchronizationContentProvider.this.handleChange(event);
            }
        }, this.getViewer().getControl());
    }

    private IJavaProject[] getChangedProjects(IDiffChangeEvent event) {
        HashSet<IJavaProject> result = new HashSet<IJavaProject>();
        IDiff[] changes = event.getChanges();
        int index = 0;
        while (index < changes.length) {
            IJavaProject project;
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)changes[index]);
            if (resource != null && (project = this.asJavaProject(resource.getProject())) != null) {
                result.add(project);
            }
            ++index;
        }
        IDiff[] additions = event.getAdditions();
        int index2 = 0;
        while (index2 < additions.length) {
            IJavaProject project;
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)additions[index2]);
            if (resource != null && (project = this.asJavaProject(resource.getProject())) != null) {
                result.add(project);
            }
            ++index2;
        }
        IPath[] removals = event.getRemovals();
        int i = 0;
        while (i < removals.length) {
            IJavaProject javaProject;
            IProject project;
            IPath path = removals[i];
            if (path.segmentCount() > 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0))).exists() && (javaProject = this.asJavaProject(project.getProject())) != null) {
                result.add(javaProject);
            }
            ++i;
        }
        return result.toArray(new IJavaProject[result.size()]);
    }

    protected Object[] getChildrenInContext(ISynchronizationContext context, Object parent, Object[] children) {
        Object[] elements = super.getChildrenInContext(context, parent, children);
        if (parent instanceof IPackageFragment) {
            return this.getPackageFragmentChildren(context, parent, elements);
        }
        if (parent instanceof IPackageFragmentRoot) {
            return this.getPackageFragmentRootChildren(context, parent, elements);
        }
        if (parent instanceof IJavaProject) {
            return this.getJavaProjectChildren(context, parent, elements);
        }
        if (parent instanceof RefactoringHistory) {
            return ((RefactoringHistory)parent).getDescriptors();
        }
        return this.getFilteredElements(parent, elements);
    }

    private Object[] getFilteredElements(Object parent, Object[] children) {
        ArrayList<Object> result = new ArrayList<Object>(children.length);
        int index = 0;
        while (index < children.length) {
            if (children[index] instanceof IFolder) {
                if (!(JavaCore.create((IFolder)((IFolder)children[index])) instanceof IPackageFragmentRoot)) {
                    result.add(children[index]);
                }
            } else {
                result.add(children[index]);
            }
            ++index;
        }
        return result.toArray();
    }

    protected ITreeContentProvider getDelegateContentProvider() {
        if (this.fContentProvider == null) {
            this.fContentProvider = new JavaModelContentProvider();
        }
        return this.fContentProvider;
    }

    private Set<IProject> getDeletedProjects(IDiffChangeEvent event) {
        HashSet<IProject> result = new HashSet<IProject>();
        IPath[] deletions = event.getRemovals();
        int index = 0;
        while (index < deletions.length) {
            IProject project;
            IPath path = deletions[index];
            if (path.segmentCount() > 0 && !(project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0))).isAccessible()) {
                result.add(project);
            }
            ++index;
        }
        return result;
    }

    public Object[] getElements(Object parent) {
        if (parent instanceof ISynchronizationContext) {
            parent = this.getModelRoot();
        }
        return super.getElements(parent);
    }

    private Object[] getJavaProjectChildren(ISynchronizationContext context, Object parent, Object[] children) {
        LinkedList<Object> list = new LinkedList<Object>();
        int index = 0;
        while (index < children.length) {
            IFolder folder;
            IPackageFragment fragment;
            if (!(children[index] instanceof IPackageFragment && this.getChildren(fragment = (IPackageFragment)children[index]).length == 0 || children[index] instanceof IFolder && this.getChildren(folder = (IFolder)children[index]).length == 0)) {
                list.add(children[index]);
            }
            ++index;
        }
        IResource resource = JavaModelProvider.getResource(parent);
        if (resource != null) {
            IResourceDiffTree tree = context.getDiffTree();
            IResource[] members = tree.members(resource);
            int index2 = 0;
            while (index2 < members.length) {
                IResource child = members[index2];
                if (this.isVisible(context, child) && this.hasPhantomFolder(tree, child) && !this.containsAsResource(list, child)) {
                    list.add(child);
                }
                ++index2;
            }
        }
        return list.toArray(new Object[list.size()]);
    }

    private boolean containsAsResource(List<Object> list, IResource child) {
        for (Object element : list) {
            if (child.equals(element)) {
                return true;
            }
            if (!(element instanceof IJavaElement)) continue;
            IJavaElement javaChild = (IJavaElement)element;
            try {
                if (!child.equals((Object)javaChild.getCorrespondingResource())) continue;
                return true;
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean hasPhantomFolder(IResourceDiffTree tree, IResource child) {
        if (!child.exists()) {
            return true;
        }
        final boolean[] found = new boolean[1];
        tree.accept(child.getFullPath(), new IDiffVisitor(){

            public boolean visit(IDiff delta) {
                IResource treeResource = ResourceDiffTree.getResourceFor((IDiff)delta);
                if (treeResource.getType() == 1 && !treeResource.getParent().exists()) {
                    found[0] = true;
                    return false;
                }
                return true;
            }
        }, 2);
        return found[0];
    }

    protected String getModelProviderId() {
        return "org.eclipse.jdt.ui.modelProvider";
    }

    protected Object getModelRoot() {
        if (this.fModelRoot == null) {
            this.fModelRoot = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        }
        return this.fModelRoot;
    }

    private Object[] getPackageFragmentChildren(ISynchronizationContext context, Object parent, Object[] children) {
        HashSet<Object> set = new HashSet<Object>();
        int index = 0;
        while (index < children.length) {
            set.add(children[index]);
            ++index;
        }
        IPackageFragment packageFragment = (IPackageFragment)parent;
        IResource resource = packageFragment.getResource();
        if (resource != null) {
            IResourceDiffTree tree = context.getDiffTree();
            IResource[] members = tree.members(resource);
            int index2 = 0;
            while (index2 < members.length) {
                IDiff diff;
                int type = members[index2].getType();
                if (type == 1 && (diff = tree.getDiff(members[index2])) != null && this.isVisible(diff) && this.isInScope(context.getScope(), parent, members[index2])) {
                    IJavaElement element = JavaCore.create((IResource)members[index2]);
                    if (element == null) {
                        if (!packageFragment.isDefaultPackage()) {
                            set.add(members[index2]);
                        }
                    } else {
                        set.add(element);
                    }
                }
                ++index2;
            }
        }
        return set.toArray(new Object[set.size()]);
    }

    private Object[] getPackageFragmentRootChildren(ISynchronizationContext context, Object parent, Object[] children) {
        final HashSet<Object> set = new HashSet<Object>();
        int index = 0;
        while (index < children.length) {
            IPackageFragment fragment;
            if (!(children[index] instanceof IPackageFragment) || !(fragment = (IPackageFragment)children[index]).isOpen() || this.getChildren(fragment).length != 0) {
                set.add(children[index]);
            }
            ++index;
        }
        IResource resource = JavaModelProvider.getResource(parent);
        if (resource != null) {
            final IResourceDiffTree tree = context.getDiffTree();
            IResource[] members = tree.members(resource);
            int index2 = 0;
            while (index2 < members.length) {
                IJavaElement element;
                int type = members[index2].getType();
                boolean contained = this.isInScope(context.getScope(), parent, members[index2]);
                boolean visible = this.isVisible(context, members[index2]);
                if (type == 1 && contained && visible) {
                    element = JavaCore.create((IFile)((IFile)members[index2]));
                    if (element == null) {
                        set.add(members[index2]);
                    }
                } else if (type == 2 && contained && visible && tree.getDiff(members[index2]) != null && (element = JavaCore.create((IResource)members[index2])) != null) {
                    set.add(element);
                }
                if (type == 2) {
                    IFolder folder = (IFolder)members[index2];
                    tree.accept(folder.getFullPath(), new IDiffVisitor(){

                        public final boolean visit(IDiff diff) {
                            IResource current;
                            if (JavaSynchronizationContentProvider.this.isVisible(diff) && (current = tree.getResource(diff)) != null) {
                                int kind = current.getType();
                                if (kind == 1) {
                                    IJavaElement element = JavaCore.create((IResource)current.getParent());
                                    if (element != null) {
                                        set.add(element);
                                    }
                                } else {
                                    IJavaElement element = JavaCore.create((IResource)current);
                                    if (element != null) {
                                        set.add(element);
                                    }
                                }
                            }
                            return true;
                        }
                    }, 2);
                }
                ++index2;
            }
            return set.toArray(new Object[set.size()]);
        }
        return children;
    }

    public void getPipelinedChildren(Object parent, Set children) {
        if (parent instanceof ISynchronizationContext) {
            HashSet<IJavaProject> result = new HashSet<IJavaProject>(children.size());
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                IFolder folder;
                IJavaElement javaElement;
                IJavaProject java;
                Object element = iterator.next();
                if (element instanceof IProject && (java = this.asJavaProject((IProject)element)) != null) {
                    iterator.remove();
                    result.add(java);
                }
                if (!(element instanceof IFolder) || !((javaElement = JavaCore.create((IFolder)(folder = (IFolder)element))) instanceof IPackageFragmentRoot)) continue;
                iterator.remove();
            }
            children.addAll(result);
        } else if (parent instanceof ISynchronizationScope) {
            children.add(this.getModelProvider());
        } else if (parent instanceof IFolder) {
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                IFolder folder;
                IJavaElement javaElement;
                Object element = iterator.next();
                if (!(element instanceof IFolder) || !((javaElement = JavaCore.create((IFolder)(folder = (IFolder)element))) instanceof IPackageFragmentRoot)) continue;
                iterator.remove();
            }
        }
    }

    public void getPipelinedElements(Object element, Set elements) {
        this.getPipelinedChildren(element, elements);
    }

    public Object getPipelinedParent(Object element, Object parent) {
        if (element instanceof IJavaElement) {
            return this.getParent(element);
        }
        return parent;
    }

    protected ResourceTraversal[] getTraversals(ISynchronizationContext context, Object object) {
        return JavaSynchronizationContentProvider.getResourceTraversals(object);
    }

    private Set<IJavaProject> getVisibleProjects() {
        TreeItem[] children = ((TreeViewer)this.getViewer()).getTree().getItems();
        HashSet<IJavaProject> result = new HashSet<IJavaProject>();
        int index = 0;
        while (index < children.length) {
            Object data = children[index].getData();
            if (data instanceof IJavaProject) {
                result.add((IJavaProject)data);
            }
            ++index;
        }
        return result;
    }

    private void handleChange(IDiffChangeEvent event) {
        Set<IJavaProject> existing = this.getVisibleProjects();
        IJavaProject[] changed = this.getChangedProjects(event);
        ArrayList<IJavaProject> refreshes = new ArrayList<IJavaProject>(changed.length);
        ArrayList<IJavaProject> additions = new ArrayList<IJavaProject>(changed.length);
        ArrayList<IJavaProject> removals = new ArrayList<IJavaProject>(changed.length);
        int index = 0;
        while (index < changed.length) {
            IJavaProject project = changed[index];
            if (this.hasVisibleChanges(event.getTree(), project)) {
                if (existing.contains(project)) {
                    refreshes.add(project);
                } else {
                    additions.add(project);
                }
            } else {
                removals.add(project);
            }
            ++index;
        }
        Set<IProject> removed = this.getDeletedProjects(event);
        for (IJavaProject element : existing) {
            if (!removed.contains(element.getResource())) continue;
            removals.add(element);
        }
        if (!(removals.isEmpty() && additions.isEmpty() && refreshes.isEmpty())) {
            TreeViewer viewer = (TreeViewer)this.getViewer();
            Tree tree = viewer.getTree();
            try {
                tree.setRedraw(false);
                if (!additions.isEmpty()) {
                    viewer.add(viewer.getInput(), additions.toArray());
                }
                if (!removals.isEmpty()) {
                    viewer.remove(viewer.getInput(), removals.toArray());
                }
                if (!refreshes.isEmpty()) {
                    Iterator iter = refreshes.iterator();
                    while (iter.hasNext()) {
                        viewer.refresh(iter.next());
                    }
                }
            }
            finally {
                tree.setRedraw(true);
            }
        }
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ICompilationUnit || element instanceof IFile || element instanceof RefactoringDescriptorProxy || element instanceof RefactoringDescriptor) {
            return false;
        }
        return super.hasChildren(element);
    }

    private boolean hasChildrenInScope(ISynchronizationScope scope, Object element, IResource resource) {
        IResource[] roots = scope.getRoots();
        IPath path = resource.getFullPath();
        if (element instanceof IPackageFragment) {
            int index = 0;
            while (index < roots.length) {
                if (path.equals((Object)roots[index].getFullPath().removeLastSegments(1))) {
                    return true;
                }
                ++index;
            }
            return false;
        }
        int index = 0;
        while (index < roots.length) {
            if (path.isPrefixOf(roots[index].getFullPath())) {
                return true;
            }
            ++index;
        }
        return false;
    }

    private boolean hasVisibleChanges(IDiffTree tree, IJavaProject project) {
        return tree.hasMatchingDiffs(project.getResource().getFullPath(), new FastDiffFilter(){

            public boolean select(IDiff diff) {
                return JavaSynchronizationContentProvider.this.isVisible(diff);
            }
        });
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification modification) {
        this.convertToJavaElements(modification);
        return modification;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate update) {
        return this.convertToJavaElements(update);
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification modification) {
        this.convertToJavaElements(modification);
        return modification;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate anUpdateSynchronization) {
        return this.convertToJavaElements(anUpdateSynchronization);
    }

    protected boolean isInScope(ISynchronizationScope scope, Object parent, Object element) {
        IResource resource = JavaModelProvider.getResource(element);
        if (resource == null) {
            return false;
        }
        if (scope.contains(resource)) {
            return true;
        }
        return this.hasChildrenInScope(scope, element, resource);
    }

    private void syncExec(final Runnable runnable, final Control control) {
        if (control != null && !control.isDisposed()) {
            control.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!control.isDisposed()) {
                        BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)runnable);
                    }
                }
            });
        }
    }
}

