/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;

public class JavaCompilerPropertyPage
extends PropertyPage {
    public static final String PROP_ID = "org.eclipse.jdt.ui.propertyPages.JavaCompilerPropertyPage";
    private IJavaProject fProject;
    private CPListElement fElement;
    private boolean fIsValidElement;
    private SelectionButtonDialogField fIgnoreOptionalProblemsField;

    public void createControl(Composite parent) {
        IAdaptable adaptable = this.getElement();
        IJavaElement elem = (IJavaElement)adaptable.getAdapter(IJavaElement.class);
        try {
            if (elem instanceof IPackageFragmentRoot) {
                this.fProject = elem.getJavaProject();
                this.fElement = CPListElement.createFromExisting(((IPackageFragmentRoot)elem).getRawClasspathEntry(), this.fProject);
                this.fIsValidElement = this.fElement != null;
            } else {
                this.fIsValidElement = false;
                this.setDescription(PreferencesMessages.JavaCompilerPropertyPage_invalid_element_selection);
            }
        }
        catch (JavaModelException e) {
            this.fIsValidElement = false;
            this.setDescription(PreferencesMessages.JavaCompilerPropertyPage_invalid_element_selection);
        }
        super.createControl(parent);
    }

    protected Control createContents(Composite parent) {
        if (!this.fIsValidElement) {
            return new Composite(parent, 0);
        }
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout topLayout = new GridLayout();
        topLayout.marginWidth = 0;
        topLayout.marginHeight = 0;
        composite.setLayout((Layout)topLayout);
        this.fIgnoreOptionalProblemsField = new SelectionButtonDialogField(32);
        this.fIgnoreOptionalProblemsField.setLabelText(PreferencesMessages.JavaCompilerPropertyPage_ignore_optional_problems_label);
        this.fIgnoreOptionalProblemsField.setSelection(this.isIgnoringOptionalProblems());
        this.fIgnoreOptionalProblemsField.doFillIntoGrid(composite, 1);
        return composite;
    }

    protected void performDefaults() {
        this.fIgnoreOptionalProblemsField.setSelection(false);
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.fIsValidElement && this.fIgnoreOptionalProblemsField.isSelected() != this.isIgnoringOptionalProblems()) {
            String newValue = this.fIgnoreOptionalProblemsField.isSelected() ? "true" : null;
            this.fElement.setAttribute("ignore_optional_problems", newValue);
            IWorkspaceRunnable runnable = JavaCompilerPropertyPage.getRunnable(this.getShell(), this.fProject, this.fElement.getClasspathEntry());
            WorkbenchRunnableAdapter op = new WorkbenchRunnableAdapter(runnable);
            op.runAsUserJob(PreferencesMessages.BuildPathsPropertyPage_job_title, null);
        }
        return true;
    }

    private static IWorkspaceRunnable getRunnable(final Shell shell, final IJavaProject project, final IClasspathEntry entry) {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                String[] changedAttributes = new String[]{"ignore_optional_problems"};
                BuildPathSupport.modifyClasspathEntry(shell, entry, changedAttributes, project, null, entry.getReferencingEntry() != null, monitor);
            }
        };
    }

    private boolean isIgnoringOptionalProblems() {
        return "true".equals(this.fElement.getAttribute("ignore_optional_problems"));
    }
}

