/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.FilteredElementTreeSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class JavadocConfigurationBlock {
    private StringDialogField fURLField;
    private StringDialogField fArchiveField;
    private StringDialogField fArchivePathField;
    private URL fInitialURL;
    private SelectionButtonDialogField fValidateURLButton;
    private SelectionButtonDialogField fValidateArchiveButton;
    private SelectionButtonDialogField fBrowseFolder;
    private SelectionButtonDialogField fURLRadioButton;
    private SelectionButtonDialogField fArchiveRadioButton;
    private SelectionButtonDialogField fBrowseArchive;
    private SelectionButtonDialogField fExternalRadio;
    private SelectionButtonDialogField fWorkspaceRadio;
    private SelectionButtonDialogField fBrowseArchivePath;
    private Shell fShell;
    private IStatusChangeListener fContext;
    private IStatus fURLStatus;
    private IStatus fArchiveStatus;
    private IStatus fArchivePathStatus;
    private URL fURLResult;
    private URL fArchiveURLResult;
    boolean fIsForSource;

    public JavadocConfigurationBlock(Shell shell, IStatusChangeListener context, URL initURL, boolean forSource) {
        this.fShell = shell;
        this.fContext = context;
        this.fInitialURL = initURL;
        this.fIsForSource = forSource;
        JDocConfigurationAdapter adapter = new JDocConfigurationAdapter();
        if (!forSource) {
            this.fURLRadioButton = new SelectionButtonDialogField(16);
            this.fURLRadioButton.setDialogFieldListener(adapter);
            this.fURLRadioButton.setLabelText(PreferencesMessages.JavadocConfigurationBlock_location_type_path_label);
        }
        this.fURLField = new StringDialogField();
        this.fURLField.setDialogFieldListener(adapter);
        this.fURLField.setLabelText(PreferencesMessages.JavadocConfigurationBlock_location_path_label);
        this.fBrowseFolder = new SelectionButtonDialogField(8);
        this.fBrowseFolder.setDialogFieldListener(adapter);
        this.fBrowseFolder.setLabelText(PreferencesMessages.JavadocConfigurationBlock_browse_folder_button);
        this.fValidateURLButton = new SelectionButtonDialogField(8);
        this.fValidateURLButton.setDialogFieldListener(adapter);
        this.fValidateURLButton.setLabelText(PreferencesMessages.JavadocConfigurationBlock_validate_button);
        if (!forSource) {
            this.fArchiveRadioButton = new SelectionButtonDialogField(16);
            this.fArchiveRadioButton.setDialogFieldListener(adapter);
            this.fArchiveRadioButton.setLabelText(PreferencesMessages.JavadocConfigurationBlock_location_type_jar_label);
            this.fExternalRadio = new SelectionButtonDialogField(16);
            this.fExternalRadio.setDialogFieldListener(adapter);
            this.fExternalRadio.setLabelText(PreferencesMessages.JavadocConfigurationBlock_external_radio);
            this.fWorkspaceRadio = new SelectionButtonDialogField(16);
            this.fWorkspaceRadio.setDialogFieldListener(adapter);
            this.fWorkspaceRadio.setLabelText(PreferencesMessages.JavadocConfigurationBlock_workspace_radio);
            this.fArchiveField = new StringDialogField();
            this.fArchiveField.setDialogFieldListener(adapter);
            this.fArchiveField.setLabelText(PreferencesMessages.JavadocConfigurationBlock_location_jar_label);
            this.fBrowseArchive = new SelectionButtonDialogField(8);
            this.fBrowseArchive.setDialogFieldListener(adapter);
            this.fBrowseArchive.setLabelText(PreferencesMessages.JavadocConfigurationBlock_browse_archive_button);
            this.fArchivePathField = new StringDialogField();
            this.fArchivePathField.setDialogFieldListener(adapter);
            this.fArchivePathField.setLabelText(PreferencesMessages.JavadocConfigurationBlock_jar_path_label);
            this.fBrowseArchivePath = new SelectionButtonDialogField(8);
            this.fBrowseArchivePath.setDialogFieldListener(adapter);
            this.fBrowseArchivePath.setLabelText(PreferencesMessages.JavadocConfigurationBlock_browse_archive_path_button);
            this.fValidateArchiveButton = new SelectionButtonDialogField(8);
            this.fValidateArchiveButton.setDialogFieldListener(adapter);
            this.fValidateArchiveButton.setLabelText(PreferencesMessages.JavadocConfigurationBlock_validate_button);
        }
        this.fURLStatus = new StatusInfo();
        this.fArchiveStatus = new StatusInfo();
        this.fArchivePathStatus = new StatusInfo();
        this.initializeSelections();
    }

    public Control createContents(Composite parent) {
        this.fShell = parent.getShell();
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite topComp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 3;
        topLayout.marginWidth = 0;
        topLayout.marginHeight = 0;
        topComp.setLayout((Layout)topLayout);
        if (!this.fIsForSource) {
            this.fURLRadioButton.doFillIntoGrid(topComp, 3);
        }
        this.fURLField.doFillIntoGrid(topComp, 2);
        LayoutUtil.setWidthHint((Control)this.fURLField.getTextControl(null), converter.convertWidthInCharsToPixels(43));
        LayoutUtil.setHorizontalGrabbing((Control)this.fURLField.getTextControl(null));
        this.fBrowseFolder.doFillIntoGrid(topComp, 1);
        DialogField.createEmptySpace(topComp, 2);
        this.fValidateURLButton.doFillIntoGrid(topComp, 1);
        if (!this.fIsForSource) {
            this.fArchiveRadioButton.doFillIntoGrid(topComp, 3);
            DialogField.createEmptySpace(topComp, 1);
            Composite radioComposite = new Composite(topComp, 0);
            radioComposite.setLayoutData((Object)new GridData(4, 4, false, false));
            GridLayout layout = new GridLayout(2, true);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            radioComposite.setLayout((Layout)layout);
            this.fExternalRadio.doFillIntoGrid(radioComposite, 1);
            this.fWorkspaceRadio.doFillIntoGrid(radioComposite, 1);
            DialogField.createEmptySpace(topComp, 1);
            this.fArchiveField.doFillIntoGrid(topComp, 2);
            LayoutUtil.setWidthHint((Control)this.fArchiveField.getTextControl(null), converter.convertWidthInCharsToPixels(43));
            LayoutUtil.setHorizontalGrabbing((Control)this.fArchiveField.getTextControl(null));
            this.fBrowseArchive.doFillIntoGrid(topComp, 1);
            this.fArchivePathField.doFillIntoGrid(topComp, 2);
            LayoutUtil.setWidthHint((Control)this.fArchivePathField.getTextControl(null), converter.convertWidthInCharsToPixels(43));
            LayoutUtil.setHorizontalGrabbing((Control)this.fArchivePathField.getTextControl(null));
            this.fBrowseArchivePath.doFillIntoGrid(topComp, 1);
            DialogField.createEmptySpace(topComp, 2);
            this.fValidateArchiveButton.doFillIntoGrid(topComp, 1);
            int indent = converter.convertWidthInCharsToPixels(2);
            LayoutUtil.setHorizontalIndent((Control)this.fArchiveField.getLabelControl(null), indent);
            LayoutUtil.setHorizontalIndent((Control)this.fArchivePathField.getLabelControl(null), indent);
            LayoutUtil.setHorizontalIndent((Control)this.fURLField.getLabelControl(null), indent);
            this.fURLRadioButton.attachDialogFields(new DialogField[]{this.fURLField, this.fBrowseFolder, this.fValidateURLButton});
            this.fArchiveRadioButton.attachDialogFields(new DialogField[]{this.fArchiveField, this.fBrowseArchive, this.fExternalRadio, this.fWorkspaceRadio, this.fArchivePathField, this.fBrowseArchivePath, this.fValidateArchiveButton});
        }
        return topComp;
    }

    private void initializeSelections() {
        String initialValue;
        String string = initialValue = this.fInitialURL != null ? this.fInitialURL.toExternalForm() : "";
        if (this.fIsForSource) {
            this.fURLField.setText(initialValue);
            return;
        }
        String prefix = "jar:";
        boolean isArchive = initialValue.startsWith(prefix);
        boolean isWorkspaceArchive = false;
        this.fURLRadioButton.setSelection(!isArchive);
        this.fArchiveRadioButton.setSelection(isArchive);
        if (isArchive) {
            String jarPathStr;
            String insidePathStr = "";
            int excIndex = initialValue.indexOf("!/");
            if (excIndex == -1) {
                jarPathStr = initialValue.substring(prefix.length());
            } else {
                jarPathStr = initialValue.substring(prefix.length(), excIndex);
                insidePathStr = initialValue.substring(excIndex + 2);
            }
            String fileProtocol = "file:/";
            String resourceProtocol = "platform:/resource/";
            if (jarPathStr.startsWith("file:/")) {
                jarPathStr = jarPathStr.substring("file:/".length());
            } else if (jarPathStr.startsWith("platform:/resource/")) {
                jarPathStr = jarPathStr.substring("platform:/resource/".length());
                isWorkspaceArchive = true;
            } else {
                this.fURLField.setText(initialValue);
                return;
            }
            try {
                URI jarPathUri = new URI(jarPathStr);
                Path jarPath = new Path(jarPathUri.getSchemeSpecificPart());
                URI insidePathUri = new URI(insidePathStr);
                String insidePath = insidePathUri.getSchemeSpecificPart();
                this.fArchivePathField.setText(insidePath);
                if (isWorkspaceArchive) {
                    this.fArchiveField.setText(jarPath.makeRelative().toString());
                }
                this.fArchiveField.setText(jarPath.makeAbsolute().toOSString());
            }
            catch (URISyntaxException e) {
                JavaPlugin.log(e);
                this.fURLField.setText(initialValue);
                return;
            }
        } else {
            this.fURLField.setText(initialValue);
        }
        this.fExternalRadio.setSelection(!isWorkspaceArchive);
        this.fWorkspaceRadio.setSelection(isWorkspaceArchive);
    }

    public void setFocus() {
        this.fURLField.postSetFocusOnDialogField(this.fShell.getDisplay());
    }

    public void performDefaults() {
        this.initializeSelections();
    }

    public URL getJavadocLocation() {
        if (this.fIsForSource || this.fURLRadioButton.isSelected()) {
            return this.fURLResult;
        }
        return this.fArchiveURLResult;
    }

    private boolean checkURLConnection(URL url) {
        int res = 0;
        URLConnection connection = null;
        try {
            connection = url.openConnection();
            if (connection instanceof HttpURLConnection) {
                connection.connect();
                res = ((HttpURLConnection)connection).getResponseCode();
            }
            InputStream is = null;
            try {
                is = connection.getInputStream();
                byte[] buffer = new byte[256];
                while (is.read(buffer) != -1) {
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return res < 400;
    }

    private void jdocDialogFieldChanged(DialogField field) {
        if (field == this.fURLField) {
            this.fURLStatus = this.updateURLStatus();
            this.statusChanged();
        } else if (field == this.fArchiveField) {
            this.fArchiveStatus = this.updateArchiveStatus();
            this.statusChanged();
        } else if (field == this.fArchivePathField) {
            this.fArchivePathStatus = this.updateArchivePathStatus();
            this.statusChanged();
        } else if (field == this.fValidateURLButton || field == this.fValidateArchiveButton) {
            EntryValidator validator = new EntryValidator();
            BusyIndicator.showWhile((Display)this.fShell.getDisplay(), (Runnable)validator);
        } else if (field == this.fBrowseFolder) {
            String url = this.chooseJavaDocFolder();
            if (url != null) {
                this.fURLField.setText(url);
            }
        } else if (field == this.fBrowseArchive) {
            String jarPath = this.chooseArchive();
            if (jarPath != null) {
                this.fArchiveField.setText(jarPath);
            }
        } else if (field == this.fExternalRadio || field == this.fWorkspaceRadio) {
            this.fArchiveStatus = this.updateArchiveStatus();
            this.statusChanged();
        } else if (field == this.fBrowseArchivePath) {
            String archivePath = this.chooseArchivePath();
            if (archivePath != null) {
                this.fArchivePathField.setText(archivePath);
            }
        } else if (field == this.fURLRadioButton || field == this.fArchiveRadioButton) {
            this.statusChanged();
        }
    }

    private void statusChanged() {
        boolean isURL = this.fIsForSource || this.fURLRadioButton.isSelected();
        IStatus status = isURL ? this.fURLStatus : StatusUtil.getMoreSevere(this.fArchiveStatus, this.fArchivePathStatus);
        if (!this.fIsForSource) {
            boolean canBrowseArchivePath;
            boolean bl = canBrowseArchivePath = !isURL && this.fArchiveStatus.isOK() && this.fArchiveField.getText().length() > 0;
            if (canBrowseArchivePath && this.fWorkspaceRadio.isSelected()) {
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.fArchiveField.getText()));
                canBrowseArchivePath = resource != null && resource.getLocation() != null;
            }
            this.fBrowseArchivePath.setEnabled(canBrowseArchivePath);
        }
        this.fContext.statusChanged(status);
    }

    private String chooseArchivePath() {
        final String[] res = new String[1];
        BusyIndicator.showWhile((Display)this.fShell.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                res[0] = JavadocConfigurationBlock.this.internalChooseArchivePath();
            }
        });
        return res[0];
    }

    private String encodeExclamationMarks(String str) {
        StringBuffer buf = new StringBuffer(str.length());
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch == '!') {
                buf.append("%21");
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    private String internalChooseArchivePath() {
        block22: {
            String string;
            ZipFile zipFile = null;
            try {
                if (this.fWorkspaceRadio.isSelected()) {
                    IPath location;
                    IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.fArchiveField.getText()));
                    if (resource != null && (location = resource.getLocation()) != null) {
                        zipFile = new ZipFile(location.toOSString());
                    }
                } else {
                    zipFile = new ZipFile(this.fArchiveField.getText());
                }
                if (zipFile == null) {
                    return null;
                }
                ZipFileStructureProvider provider = new ZipFileStructureProvider(zipFile);
                ZipDialogLabelProvider lp = new ZipDialogLabelProvider(provider);
                ZipDialogContentProvider cp = new ZipDialogContentProvider(provider);
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.fShell, (ILabelProvider)lp, (ITreeContentProvider)cp);
                dialog.setAllowMultiple(false);
                dialog.setValidator((ISelectionStatusValidator)new ZipDialogValidator());
                dialog.setTitle(PreferencesMessages.JavadocConfigurationBlock_browse_jarorzip_path_title);
                dialog.setMessage(PreferencesMessages.JavadocConfigurationBlock_location_in_jarorzip_message);
                dialog.setComparator(new ViewerComparator());
                String init = this.fArchivePathField.getText();
                if (init.length() == 0) {
                    init = "docs/api";
                }
                dialog.setInitialSelection(cp.findElement((IPath)new Path(init)));
                dialog.setInput((Object)this);
                if (dialog.open() != 0) break block22;
                String name = provider.getFullPath(dialog.getFirstResult());
                string = new Path(name).removeTrailingSeparator().toString();
            }
            catch (IOException e) {
                JavaPlugin.log(e);
                break block22;
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return string;
        }
        return null;
    }

    private String chooseArchive() {
        if (this.fWorkspaceRadio.isSelected()) {
            return this.chooseWorkspaceArchive();
        }
        Path currPath = new Path(this.fArchiveField.getText());
        if (ArchiveFileFilter.isArchivePath((IPath)currPath, true)) {
            currPath = currPath.removeLastSegments(1);
        }
        FileDialog dialog = new FileDialog(this.fShell, 4096);
        dialog.setFilterExtensions(ArchiveFileFilter.JAR_ZIP_FILTER_EXTENSIONS);
        dialog.setText(PreferencesMessages.JavadocConfigurationBlock_zipImportSource_title);
        dialog.setFilterPath(currPath.toOSString());
        return dialog.open();
    }

    private String chooseWorkspaceArchive() {
        String initSelection = this.fArchiveField.getText();
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        Class[] acceptedClasses = new Class[]{IFile.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
        IResource initSel = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (initSelection.length() > 0) {
            initSel = root.findMember((IPath)new Path(initSelection));
        }
        FilteredElementTreeSelectionDialog dialog = new FilteredElementTreeSelectionDialog(this.fShell, (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setInitialFilter("*.jar,*.zip");
        dialog.setAllowMultiple(false);
        dialog.setValidator(validator);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setTitle(PreferencesMessages.JavadocConfigurationBlock_workspace_archive_selection_dialog_title);
        dialog.setMessage(PreferencesMessages.JavadocConfigurationBlock_workspace_archive_selection_dialog_description);
        dialog.setInput(root);
        dialog.setInitialSelection(initSel);
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            IResource res = (IResource)dialog.getFirstResult();
            return res.getFullPath().makeRelative().toString();
        }
        return null;
    }

    protected void displayErrorDialog(String message) {
        MessageDialog.openError((Shell)this.fShell, (String)PreferencesMessages.JavadocConfigurationBlock_error_dialog_title, (String)message);
    }

    private String chooseJavaDocFolder() {
        String initPath = "";
        if (this.fURLResult != null && "file".equals(this.fURLResult.getProtocol())) {
            initPath = JavaDocLocations.toFile(this.fURLResult).getPath();
        }
        DirectoryDialog dialog = new DirectoryDialog(this.fShell);
        dialog.setText(PreferencesMessages.JavadocConfigurationBlock_javadocFolderDialog_label);
        dialog.setMessage(PreferencesMessages.JavadocConfigurationBlock_javadocFolderDialog_message);
        dialog.setFilterPath(initPath);
        String result = dialog.open();
        if (result != null) {
            try {
                URL url = new File(result).toURI().toURL();
                return url.toExternalForm();
            }
            catch (MalformedURLException e) {
                JavaPlugin.log(e);
            }
        }
        return null;
    }

    private IStatus updateURLStatus() {
        StatusInfo status = new StatusInfo();
        this.fURLResult = null;
        try {
            String jdocLocation = this.fURLField.getText();
            if (jdocLocation.length() == 0) {
                return status;
            }
            URL url = new URL(jdocLocation);
            if ("file".equals(url.getProtocol()) && url.getFile() == null) {
                status.setError(PreferencesMessages.JavadocConfigurationBlock_error_notafolder);
                return status;
            }
            this.fURLResult = url;
        }
        catch (MalformedURLException e) {
            status.setError(PreferencesMessages.JavadocConfigurationBlock_MalformedURL_error);
            return status;
        }
        return status;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus updateArchiveStatus() {
        try {
            this.fArchiveURLResult = null;
            StatusInfo status = new StatusInfo();
            String jdocLocation = this.fArchiveField.getText();
            if (jdocLocation.length() > 0) {
                if (!Path.ROOT.isValidPath(jdocLocation)) {
                    status.setError(PreferencesMessages.JavadocConfigurationBlock_error_invalidarchivepath);
                    return status;
                }
                if (this.fWorkspaceRadio.isSelected()) {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IResource res = root.findMember((IPath)new Path(jdocLocation));
                    if (res == null) {
                        status.setError(PreferencesMessages.JavadocConfigurationBlock_error_archive_not_found_in_workspace);
                        return status;
                    }
                    if (!(res instanceof IFile)) {
                        status.setError(PreferencesMessages.JavadocConfigurationBlock_error_archive_not_found_in_workspace);
                        return status;
                    }
                } else {
                    IPath path = Path.fromOSString((String)jdocLocation);
                    if (!path.isAbsolute()) {
                        status.setError(PreferencesMessages.JavadocConfigurationBlock_error_archivepathnotabsolute);
                        return status;
                    }
                    File jarFile = new File(jdocLocation);
                    if (jarFile.isDirectory()) {
                        status.setError(PreferencesMessages.JavadocConfigurationBlock_error_notafile);
                        return status;
                    }
                    if (!jarFile.exists()) {
                        status.setWarning(PreferencesMessages.JavadocConfigurationBlock_error_notafile);
                    }
                }
                this.fArchiveURLResult = this.getArchiveURL();
            }
            return status;
        }
        catch (MalformedURLException e) {
            StatusInfo status = new StatusInfo();
            status.setError(e.getMessage());
            return status;
        }
    }

    private IStatus updateArchivePathStatus() {
        try {
            this.fArchiveURLResult = this.getArchiveURL();
        }
        catch (MalformedURLException e) {
            this.fArchiveURLResult = null;
            StatusInfo status = new StatusInfo();
            status.setError(e.getMessage());
            return status;
        }
        return new StatusInfo();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private URL getArchiveURL() throws MalformedURLException {
        String jarLoc = this.fArchiveField.getText();
        String innerPath = this.fArchivePathField.getText().trim();
        try {
            URI baseUri;
            if (this.fWorkspaceRadio.isSelected()) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IResource res = root.findMember((IPath)new Path(jarLoc));
                if (res == null) throw new URISyntaxException(jarLoc, "");
                baseUri = new URI("platform", null, "/resource" + res.getFullPath().toString(), null, null);
            } else {
                baseUri = new File(jarLoc).toURI();
            }
            if (innerPath.length() == 0 || innerPath.charAt(0) != '/') {
                innerPath = String.valueOf('/') + innerPath;
            }
            String encodedInnerPath = new URI(null, null, innerPath, null, null).getRawSchemeSpecificPart();
            return new URI("jar:" + this.encodeExclamationMarks(baseUri.toString()) + '!' + this.encodeExclamationMarks(encodedInnerPath)).toURL();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    private class EntryValidator
    implements Runnable {
        private String fInvalidMessage = PreferencesMessages.JavadocConfigurationBlock_InvalidLocation_message;
        private String fTitle = PreferencesMessages.JavadocConfigurationBlock_MessageDialog_title;
        private String fUnable = PreferencesMessages.JavadocConfigurationBlock_UnableToValidateLocation_message;

        private EntryValidator() {
        }

        public void run() {
            URL location = JavadocConfigurationBlock.this.getJavadocLocation();
            if (location == null) {
                MessageDialog.openWarning((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fInvalidMessage);
                return;
            }
            try {
                String protocol = location.getProtocol();
                if (protocol.startsWith("http") || protocol.equals("jar")) {
                    this.validateURL(location);
                } else if (protocol.equals("file")) {
                    this.validateFile(location);
                } else {
                    MessageDialog.openWarning((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fUnable);
                }
            }
            catch (MalformedURLException e) {
                MessageDialog.openWarning((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fUnable);
            }
            catch (URISyntaxException e) {
                MessageDialog.openWarning((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fUnable);
            }
        }

        public void spawnInBrowser(URL url) {
            OpenBrowserUtil.openExternal(url, JavadocConfigurationBlock.this.fShell.getDisplay());
        }

        private void validateFile(URL location) throws MalformedURLException {
            File packageList;
            File indexFile;
            File folder = JavaDocLocations.toFile(location);
            if (folder.isDirectory() && (indexFile = new File(folder, "index.html")).isFile() && (packageList = new File(folder, "package-list")).exists()) {
                this.showConfirmValidationDialog(indexFile.toURI().toURL());
                return;
            }
            MessageDialog.openWarning((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fInvalidMessage);
        }

        private void validateURL(URL location) throws MalformedURLException, URISyntaxException {
            boolean suc;
            URI path = URIUtil.toURI((URL)location);
            URI index = URIUtil.append((URI)path, (String)"index.html");
            URI packagelist = URIUtil.append((URI)path, (String)"package-list");
            URL indexURL = URIUtil.toURL((URI)index);
            URL packagelistURL = URIUtil.toURL((URI)packagelist);
            boolean bl = suc = JavadocConfigurationBlock.this.checkURLConnection(indexURL) && JavadocConfigurationBlock.this.checkURLConnection(packagelistURL);
            if (suc) {
                this.showConfirmValidationDialog(indexURL);
            } else {
                MessageDialog.openWarning((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fInvalidMessage);
            }
        }

        private void showConfirmValidationDialog(URL url) {
            String message = PreferencesMessages.JavadocConfigurationBlock_ValidLocation_message;
            String okLabel = PreferencesMessages.JavadocConfigurationBlock_OK_label;
            String openLabel = PreferencesMessages.JavadocConfigurationBlock_Open_label;
            MessageDialog dialog = new MessageDialog(JavadocConfigurationBlock.this.fShell, this.fTitle, null, message, 2, new String[]{okLabel, openLabel}, 0);
            if (dialog.open() == 1) {
                this.spawnInBrowser(url);
            }
        }
    }

    private class JDocConfigurationAdapter
    implements IDialogFieldListener {
        private JDocConfigurationAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            JavadocConfigurationBlock.this.jdocDialogFieldChanged(field);
        }
    }

    private static class ZipDialogContentProvider
    implements ITreeContentProvider {
        private ZipFileStructureProvider fProvider;

        public ZipDialogContentProvider(ZipFileStructureProvider provider) {
            this.fProvider = provider;
        }

        public Object findElement(IPath path) {
            String[] segments = path.segments();
            ZipEntry elem = this.fProvider.getRoot();
            int i = 0;
            while (i < segments.length && elem != null) {
                List list = this.fProvider.getChildren((Object)elem);
                String name = segments[i];
                elem = null;
                int k = 0;
                while (k < list.size()) {
                    Object curr = list.get(k);
                    if (this.fProvider.isFolder(curr) && name.equals(this.fProvider.getLabel(curr))) {
                        elem = curr;
                        break;
                    }
                    ++k;
                }
                ++i;
            }
            return elem;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object getParent(Object element) {
            if (element.equals(this.fProvider.getRoot())) {
                return null;
            }
            Path path = new Path(this.fProvider.getFullPath(element));
            if (path.segmentCount() > 0) {
                return this.findElement(path.removeLastSegments(1));
            }
            return this.fProvider.getRoot();
        }

        public boolean hasChildren(Object element) {
            List list = this.fProvider.getChildren(element);
            if (list != null) {
                int i = 0;
                while (i < list.size()) {
                    if (this.fProvider.isFolder(list.get(i))) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public Object[] getChildren(Object element) {
            List list = this.fProvider.getChildren(element);
            ArrayList res = new ArrayList();
            if (list != null) {
                int i = 0;
                while (i < list.size()) {
                    Object curr = list.get(i);
                    if (this.fProvider.isFolder(curr)) {
                        res.add(curr);
                    }
                    ++i;
                }
            }
            return res.toArray();
        }

        public Object[] getElements(Object element) {
            return new Object[]{this.fProvider.getRoot()};
        }

        public void dispose() {
        }
    }

    private static class ZipDialogLabelProvider
    extends LabelProvider {
        private final Image IMG_JAR = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jar_obj.gif");
        private final Image IMG_FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        private ZipFileStructureProvider fProvider;

        public ZipDialogLabelProvider(ZipFileStructureProvider provider) {
            this.fProvider = provider;
        }

        public Image getImage(Object element) {
            if (element == this.fProvider.getRoot()) {
                return this.IMG_JAR;
            }
            return this.IMG_FOLDER;
        }

        public String getText(Object element) {
            if (element == this.fProvider.getRoot()) {
                return BasicElementLabels.getResourceName(this.fProvider.getZipFile().getName());
            }
            return BasicElementLabels.getResourceName(this.fProvider.getLabel(element));
        }
    }

    private static class ZipDialogValidator
    implements ISelectionStatusValidator {
        public IStatus validate(Object[] selection) {
            String message = "";
            return new StatusInfo(1, message);
        }
    }
}

