/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameConventionConfigurationBlock
extends OptionsConfigurationBlock {
    private static final int FIELD = 1;
    private static final int STATIC = 2;
    private static final int ARGUMENT = 3;
    private static final int LOCAL = 4;
    private static final int STATIC_FINAL = 5;
    private static final OptionsConfigurationBlock.Key PREF_FIELD_PREFIXES = NameConventionConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.codeComplete.fieldPrefixes");
    private static final OptionsConfigurationBlock.Key PREF_FIELD_SUFFIXES = NameConventionConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.codeComplete.fieldSuffixes");
    private static final OptionsConfigurationBlock.Key PREF_STATIC_FIELD_PREFIXES = NameConventionConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.codeComplete.staticFieldPrefixes");
    private static final OptionsConfigurationBlock.Key PREF_STATIC_FIELD_SUFFIXES = NameConventionConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.codeComplete.staticFieldSuffixes");
    private static final OptionsConfigurationBlock.Key PREF_STATIC_FINAL_FIELD_PREFIXES = NameConventionConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.codeComplete.staticFinalFieldPrefixes");
    private static final OptionsConfigurationBlock.Key PREF_STATIC_FINAL_FIELD_SUFFIXES = NameConventionConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.codeComplete.staticFinalFieldSuffixes");
    private static final OptionsConfigurationBlock.Key PREF_ARGUMENT_PREFIXES = NameConventionConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.codeComplete.argumentPrefixes");
    private static final OptionsConfigurationBlock.Key PREF_ARGUMENT_SUFFIXES = NameConventionConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.codeComplete.argumentSuffixes");
    private static final OptionsConfigurationBlock.Key PREF_LOCAL_PREFIXES = NameConventionConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.codeComplete.localPrefixes");
    private static final OptionsConfigurationBlock.Key PREF_LOCAL_SUFFIXES = NameConventionConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.codeComplete.localSuffixes");
    private static final OptionsConfigurationBlock.Key PREF_KEYWORD_THIS = NameConventionConfigurationBlock.getJDTUIKey("org.eclipse.jdt.ui.keywordthis");
    private static final OptionsConfigurationBlock.Key PREF_IS_FOR_GETTERS = NameConventionConfigurationBlock.getJDTUIKey("org.eclipse.jdt.ui.gettersetter.use.is");
    private static final OptionsConfigurationBlock.Key PREF_EXCEPTION_NAME = NameConventionConfigurationBlock.getJDTUIKey("org.eclipse.jdt.ui.exception.name");
    private static final OptionsConfigurationBlock.Key PREF_USE_OVERRIDE_ANNOT = NameConventionConfigurationBlock.getJDTUIKey("org.eclipse.jdt.ui.overrideannotation");
    private ListDialogField<NameConventionEntry> fNameConventionList;
    private SelectionButtonDialogField fUseKeywordThisBox;
    private SelectionButtonDialogField fUseIsForBooleanGettersBox;
    private StringDialogField fExceptionName;
    private SelectionButtonDialogField fUseOverrideAnnotation;

    public NameConventionConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, NameConventionConfigurationBlock.getAllKeys(), container);
        NameConventionAdapter adapter = new NameConventionAdapter();
        String[] buttons = new String[]{PreferencesMessages.NameConventionConfigurationBlock_list_edit_button};
        this.fNameConventionList = new ListDialogField<NameConventionEntry>((IListAdapter)adapter, buttons, (ILabelProvider)new NameConventionLabelProvider()){

            @Override
            protected int getListStyle() {
                return super.getListStyle() & 0xFFFFFFFD | 4;
            }
        };
        this.fNameConventionList.setDialogFieldListener(adapter);
        this.fNameConventionList.setLabelText(PreferencesMessages.NameConventionConfigurationBlock_list_label);
        String[] columnsHeaders = new String[]{PreferencesMessages.NameConventionConfigurationBlock_list_name_column, PreferencesMessages.NameConventionConfigurationBlock_list_prefix_column, PreferencesMessages.NameConventionConfigurationBlock_list_suffix_column};
        ColumnLayoutData[] data = new ColumnLayoutData[]{new ColumnWeightData(3), new ColumnWeightData(2), new ColumnWeightData(2)};
        this.fNameConventionList.setTableColumns(new ListDialogField.ColumnsDescription(data, columnsHeaders, true));
        if (this.fNameConventionList.getSize() > 0) {
            this.fNameConventionList.selectFirstElement();
        } else {
            this.fNameConventionList.enableButton(0, false);
        }
        this.fExceptionName = new StringDialogField();
        this.fExceptionName.setDialogFieldListener(adapter);
        this.fExceptionName.setLabelText(PreferencesMessages.NameConventionConfigurationBlock_exceptionname_label);
        this.fUseKeywordThisBox = new SelectionButtonDialogField(96);
        this.fUseKeywordThisBox.setDialogFieldListener(adapter);
        this.fUseKeywordThisBox.setLabelText(PreferencesMessages.NameConventionConfigurationBlock_keywordthis_label);
        this.fUseIsForBooleanGettersBox = new SelectionButtonDialogField(96);
        this.fUseIsForBooleanGettersBox.setDialogFieldListener(adapter);
        this.fUseIsForBooleanGettersBox.setLabelText(PreferencesMessages.NameConventionConfigurationBlock_isforbooleangetters_label);
        this.fUseOverrideAnnotation = new SelectionButtonDialogField(96);
        this.fUseOverrideAnnotation.setDialogFieldListener(adapter);
        this.fUseOverrideAnnotation.setLabelText(PreferencesMessages.NameConventionConfigurationBlock_use_override_annotation_label);
        this.updateControls();
    }

    private static OptionsConfigurationBlock.Key[] getAllKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_FIELD_PREFIXES, PREF_FIELD_SUFFIXES, PREF_STATIC_FIELD_PREFIXES, PREF_STATIC_FIELD_SUFFIXES, PREF_STATIC_FINAL_FIELD_PREFIXES, PREF_STATIC_FINAL_FIELD_SUFFIXES, PREF_ARGUMENT_PREFIXES, PREF_ARGUMENT_SUFFIXES, PREF_LOCAL_PREFIXES, PREF_LOCAL_SUFFIXES, PREF_EXCEPTION_NAME, PREF_KEYWORD_THIS, PREF_IS_FOR_GETTERS, PREF_USE_OVERRIDE_ANNOT};
    }

    @Override
    protected Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)layout);
        this.fNameConventionList.doFillIntoGrid(composite, 4);
        LayoutUtil.setHorizontalSpan((Control)this.fNameConventionList.getLabelControl(null), 2);
        Table table = this.fNameConventionList.getTableViewer().getTable();
        GridData data = (GridData)this.fNameConventionList.getListControl(null).getLayoutData();
        data.heightHint = SWTUtil.getTableHeightHint(table, 5);
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 1;
        data.grabExcessVerticalSpace = false;
        data = (GridData)this.fNameConventionList.getButtonBox(null).getLayoutData();
        data.grabExcessVerticalSpace = false;
        data.verticalAlignment = 1;
        this.fUseKeywordThisBox.doFillIntoGrid(composite, 3);
        this.fUseIsForBooleanGettersBox.doFillIntoGrid(composite, 3);
        this.fUseOverrideAnnotation.doFillIntoGrid(composite, 3);
        Link seeProblemSeverity = new Link(composite, 64);
        data = new GridData(1, 0x1000000, true, false, 3, 1);
        seeProblemSeverity.setLayoutData((Object)data);
        LayoutUtil.setHorizontalIndent((Control)seeProblemSeverity, new PixelConverter((Control)composite).convertWidthInCharsToPixels(1) * 3);
        seeProblemSeverity.setText(PreferencesMessages.NameConventionConfigurationBlock_override_link_label);
        seeProblemSeverity.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkbenchPreferenceContainer preferenceContainer = NameConventionConfigurationBlock.this.getPreferenceContainer();
                if (preferenceContainer != null) {
                    HashMap<String, String> prefsData = new HashMap<String, String>();
                    prefsData.put("select_option_key", "org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation");
                    prefsData.put("select_option_qualifier", "org.eclipse.jdt.core");
                    String id = NameConventionConfigurationBlock.this.fProject == null ? "org.eclipse.jdt.ui.preferences.ProblemSeveritiesPreferencePage" : "org.eclipse.jdt.ui.propertyPages.ProblemSeveritiesPreferencePage";
                    preferenceContainer.openPage(id, prefsData);
                }
            }
        });
        DialogField.createEmptySpace(composite, 3);
        this.fExceptionName.doFillIntoGrid(composite, 2);
        return composite;
    }

    @Override
    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
    }

    protected final void updateModel(DialogField field) {
        if (field == this.fNameConventionList) {
            int i = 0;
            while (i < this.fNameConventionList.getSize()) {
                NameConventionEntry entry = this.fNameConventionList.getElement(i);
                this.setValue(entry.suffixkey, entry.suffix);
                this.setValue(entry.prefixkey, entry.prefix);
                ++i;
            }
        } else if (field == this.fExceptionName) {
            String name = this.fExceptionName.getText();
            this.setValue(PREF_EXCEPTION_NAME, name);
            IStatus status = JavaConventions.validateIdentifier((String)name, (String)"1.3", (String)"1.3");
            if (!status.isOK()) {
                this.fContext.statusChanged(status);
            } else {
                this.fContext.statusChanged(new StatusInfo());
            }
        } else if (field == this.fUseKeywordThisBox) {
            this.setValue(PREF_KEYWORD_THIS, this.fUseKeywordThisBox.isSelected());
        } else if (field == this.fUseIsForBooleanGettersBox) {
            this.setValue(PREF_IS_FOR_GETTERS, this.fUseIsForBooleanGettersBox.isSelected());
        } else if (field == this.fUseOverrideAnnotation) {
            this.setValue(PREF_USE_OVERRIDE_ANNOT, this.fUseOverrideAnnotation.isSelected());
        }
    }

    @Override
    protected void updateControls() {
        ArrayList<NameConventionEntry> list = new ArrayList<NameConventionEntry>(4);
        this.createEntry(list, PREF_FIELD_PREFIXES, PREF_FIELD_SUFFIXES, 1);
        this.createEntry(list, PREF_STATIC_FIELD_PREFIXES, PREF_STATIC_FIELD_SUFFIXES, 2);
        this.createEntry(list, PREF_STATIC_FINAL_FIELD_PREFIXES, PREF_STATIC_FINAL_FIELD_SUFFIXES, 5);
        this.createEntry(list, PREF_ARGUMENT_PREFIXES, PREF_ARGUMENT_SUFFIXES, 3);
        this.createEntry(list, PREF_LOCAL_PREFIXES, PREF_LOCAL_SUFFIXES, 4);
        this.fNameConventionList.setElements(list);
        this.fExceptionName.setText(this.getValue(PREF_EXCEPTION_NAME));
        this.fUseKeywordThisBox.setSelection(this.getBooleanValue(PREF_KEYWORD_THIS));
        this.fUseIsForBooleanGettersBox.setSelection(this.getBooleanValue(PREF_IS_FOR_GETTERS));
        this.fUseOverrideAnnotation.setSelection(this.getBooleanValue(PREF_USE_OVERRIDE_ANNOT));
    }

    @Override
    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return null;
    }

    private void createEntry(List<NameConventionEntry> list, OptionsConfigurationBlock.Key prefixKey, OptionsConfigurationBlock.Key suffixKey, int kind) {
        NameConventionEntry entry = new NameConventionEntry();
        entry.kind = kind;
        entry.suffixkey = suffixKey;
        entry.prefixkey = prefixKey;
        entry.suffix = this.getPreferenceValue(suffixKey);
        entry.prefix = this.getPreferenceValue(prefixKey);
        list.add(entry);
    }

    private String getPreferenceValue(OptionsConfigurationBlock.Key key) {
        String value = this.getValue(key);
        if (value == null) {
            value = "";
            JavaPlugin.logErrorMessage("JavaCore preference is null. Key:" + key);
        }
        return value;
    }

    private void doEditButtonPressed() {
        String message;
        String title;
        NameConventionEntry entry = this.fNameConventionList.getSelectedElements().get(0);
        switch (entry.kind) {
            case 1: {
                title = PreferencesMessages.NameConventionConfigurationBlock_field_dialog_title;
                message = PreferencesMessages.NameConventionConfigurationBlock_field_dialog_message;
                break;
            }
            case 2: {
                title = PreferencesMessages.NameConventionConfigurationBlock_static_dialog_title;
                message = PreferencesMessages.NameConventionConfigurationBlock_static_dialog_message;
                break;
            }
            case 5: {
                title = PreferencesMessages.NameConventionConfigurationBlock_static_final_dialog_title;
                message = PreferencesMessages.NameConventionConfigurationBlock_static_final_dialog_message;
                break;
            }
            case 3: {
                title = PreferencesMessages.NameConventionConfigurationBlock_arg_dialog_title;
                message = PreferencesMessages.NameConventionConfigurationBlock_arg_dialog_message;
                break;
            }
            default: {
                title = PreferencesMessages.NameConventionConfigurationBlock_local_dialog_title;
                message = PreferencesMessages.NameConventionConfigurationBlock_local_dialog_message;
            }
        }
        NameConventionInputDialog dialog = new NameConventionInputDialog(this.getShell(), title, message, entry);
        if (dialog.open() == 0) {
            this.fNameConventionList.replaceElement(entry, dialog.getResult());
            this.updateModel(this.fNameConventionList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NameConventionAdapter
    implements IListAdapter<NameConventionEntry>,
    IDialogFieldListener {
        private NameConventionAdapter() {
        }

        private boolean canEdit(ListDialogField<?> field) {
            return field.getSelectedElements().size() == 1;
        }

        @Override
        public void customButtonPressed(ListDialogField<NameConventionEntry> field, int index) {
            NameConventionConfigurationBlock.this.doEditButtonPressed();
        }

        @Override
        public void selectionChanged(ListDialogField<NameConventionEntry> field) {
            field.enableButton(0, this.canEdit(field));
        }

        @Override
        public void doubleClicked(ListDialogField<NameConventionEntry> field) {
            if (this.canEdit(field)) {
                NameConventionConfigurationBlock.this.doEditButtonPressed();
            }
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            NameConventionConfigurationBlock.this.updateModel(field);
        }
    }

    private static class NameConventionEntry {
        public int kind;
        public String prefix;
        public String suffix;
        public OptionsConfigurationBlock.Key prefixkey;
        public OptionsConfigurationBlock.Key suffixkey;

        private NameConventionEntry() {
        }
    }

    private class NameConventionInputDialog
    extends StatusDialog
    implements IDialogFieldListener {
        private StringDialogField fPrefixField;
        private StringDialogField fSuffixField;
        private NameConventionEntry fEntry;
        private DialogField fMessageField;

        public NameConventionInputDialog(Shell parent, String title, String message, NameConventionEntry entry) {
            super(parent);
            this.fEntry = entry;
            this.setTitle(title);
            this.fMessageField = new DialogField();
            this.fMessageField.setLabelText(message);
            this.fPrefixField = new StringDialogField();
            this.fPrefixField.setLabelText(PreferencesMessages.NameConventionConfigurationBlock_dialog_prefix);
            this.fPrefixField.setDialogFieldListener(this);
            this.fSuffixField = new StringDialogField();
            this.fSuffixField.setLabelText(PreferencesMessages.NameConventionConfigurationBlock_dialog_suffix);
            this.fSuffixField.setDialogFieldListener(this);
            this.fPrefixField.setText(entry.prefix);
            this.fSuffixField.setText(entry.suffix);
        }

        public NameConventionEntry getResult() {
            NameConventionEntry res = new NameConventionEntry();
            res.prefix = Strings.removeTrailingCharacters(this.fPrefixField.getText(), ',');
            res.suffix = Strings.removeTrailingCharacters(this.fSuffixField.getText(), ',');
            res.prefixkey = this.fEntry.prefixkey;
            res.suffixkey = this.fEntry.suffixkey;
            res.kind = this.fEntry.kind;
            return res;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite inner = new Composite(composite, 0);
            inner.setFont(composite.getFont());
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            inner.setLayout((Layout)layout);
            this.fMessageField.doFillIntoGrid(inner, 2);
            this.fPrefixField.doFillIntoGrid(inner, 2);
            this.fSuffixField.doFillIntoGrid(inner, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.fPrefixField.getTextControl(null));
            LayoutUtil.setWidthHint((Control)this.fPrefixField.getTextControl(null), this.convertWidthInCharsToPixels(45));
            LayoutUtil.setWidthHint((Control)this.fSuffixField.getTextControl(null), this.convertWidthInCharsToPixels(45));
            this.fPrefixField.postSetFocusOnDialogField(parent.getDisplay());
            NameConventionInputDialog.applyDialogFont((Control)composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.code_style_edit_prefix_suffix");
            return composite;
        }

        public void dialogFieldChanged(DialogField field) {
            IStatus prefixStatus = this.validateIdentifiers(NameConventionConfigurationBlock.this.getTokens(this.fPrefixField.getText(), ","), true);
            IStatus suffixStatus = this.validateIdentifiers(NameConventionConfigurationBlock.this.getTokens(this.fSuffixField.getText(), ","), false);
            this.updateStatus(StatusUtil.getMoreSevere(suffixStatus, prefixStatus));
        }

        private IStatus validateIdentifiers(String[] values, boolean prefix) {
            int i = 0;
            while (i < values.length) {
                String val = values[i];
                if (val.length() == 0) {
                    if (prefix) {
                        return new StatusInfo(4, PreferencesMessages.NameConventionConfigurationBlock_error_emptyprefix);
                    }
                    return new StatusInfo(4, PreferencesMessages.NameConventionConfigurationBlock_error_emptysuffix);
                }
                String name = prefix ? String.valueOf(val) + "x" : "x" + val;
                IStatus status = JavaConventions.validateIdentifier((String)name, (String)"1.3", (String)"1.3");
                if (status.matches(4)) {
                    if (prefix) {
                        return new StatusInfo(4, Messages.format(PreferencesMessages.NameConventionConfigurationBlock_error_invalidprefix, val));
                    }
                    return new StatusInfo(4, Messages.format(PreferencesMessages.NameConventionConfigurationBlock_error_invalidsuffix, val));
                }
                ++i;
            }
            return new StatusInfo();
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
        }
    }

    private static class NameConventionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private NameConventionLabelProvider() {
        }

        public Image getImage(Object element) {
            return this.getColumnImage(element, 0);
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex != 0) {
                return null;
            }
            NameConventionEntry entry = (NameConventionEntry)element;
            ImageDescriptorRegistry registry = JavaPlugin.getImageDescriptorRegistry();
            switch (entry.kind) {
                case 1: {
                    return registry.get(JavaPluginImages.DESC_FIELD_PUBLIC);
                }
                case 2: {
                    return registry.get((ImageDescriptor)new JavaElementImageDescriptor(JavaPluginImages.DESC_FIELD_PUBLIC, 8, JavaElementImageProvider.SMALL_SIZE));
                }
                case 5: {
                    return registry.get((ImageDescriptor)new JavaElementImageDescriptor(JavaPluginImages.DESC_FIELD_PUBLIC, 10, JavaElementImageProvider.SMALL_SIZE));
                }
                case 3: {
                    return registry.get(JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE);
                }
            }
            return registry.get(JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE);
        }

        public String getColumnText(Object element, int columnIndex) {
            NameConventionEntry entry = (NameConventionEntry)element;
            if (columnIndex == 0) {
                switch (entry.kind) {
                    case 1: {
                        return PreferencesMessages.NameConventionConfigurationBlock_field_label;
                    }
                    case 2: {
                        return PreferencesMessages.NameConventionConfigurationBlock_static_label;
                    }
                    case 5: {
                        return PreferencesMessages.NameConventionConfigurationBlock_static_final_label;
                    }
                    case 3: {
                        return PreferencesMessages.NameConventionConfigurationBlock_arg_label;
                    }
                }
                return PreferencesMessages.NameConventionConfigurationBlock_local_label;
            }
            if (columnIndex == 1) {
                return entry.prefix;
            }
            return entry.suffix;
        }
    }
}

