/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.formatter.CompilationUnitPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineWrappingTabPage
extends FormatterTabPage {
    private static final String PREF_CATEGORY_INDEX = "org.eclipse.jdt.uiformatter_page.line_wrapping_tab_page.last_category_index";
    protected static final String[] INDENT_NAMES = new String[]{FormatterMessages.LineWrappingTabPage_indentation_default, FormatterMessages.LineWrappingTabPage_indentation_on_column, FormatterMessages.LineWrappingTabPage_indentation_by_one};
    protected static final String[] WRAPPING_NAMES = new String[]{FormatterMessages.LineWrappingTabPage_splitting_do_not_split, FormatterMessages.LineWrappingTabPage_splitting_wrap_when_necessary, FormatterMessages.LineWrappingTabPage_splitting_always_wrap_first_others_when_necessary, FormatterMessages.LineWrappingTabPage_splitting_wrap_always, FormatterMessages.LineWrappingTabPage_splitting_wrap_always_indent_all_but_first, FormatterMessages.LineWrappingTabPage_splitting_wrap_always_except_first_only_if_necessary};
    private final Category fCompactIfCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_compact_if", "class Example {int foo(int argument) {  if (argument==0) return 0;  if (argument==1) return 42; else return 43;}}", FormatterMessages.LineWrappingTabPage_compact_if_else);
    private final Category fTryCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_resources_in_try", "class Example {void foo() {try (FileReader reader1 = new FileReader(\"file1\");   FileReader reader2 = new FileReader(\"file2\")) {}}}", FormatterMessages.LineWrappingTabPage_try);
    private final Category fCatchCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_union_type_in_multicatch", "class Example {void foo() {try {} catch (IllegalArgumentException | NullPointerException | ClassCastException e) {  e.printStackTrace();}}}", FormatterMessages.LineWrappingTabPage_catch);
    private final Category fTypeDeclarationSuperclassCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_superclass_in_type_declaration", "class Example extends OtherClass {}", FormatterMessages.LineWrappingTabPage_extends_clause);
    private final Category fTypeDeclarationSuperinterfacesCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_superinterfaces_in_type_declaration", "class Example implements I1, I2, I3 {}", FormatterMessages.LineWrappingTabPage_implements_clause);
    private final Category fConstructorDeclarationsParametersCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_parameters_in_constructor_declaration", "class Example {Example(int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) { this();}Example() {}}", FormatterMessages.LineWrappingTabPage_parameters);
    private final Category fMethodDeclarationsCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_method_declaration", "class Example {public final synchronized java.lang.String a_method_with_a_long_name() {}}", FormatterMessages.LineWrappingTabPage_declaration);
    private final Category fMethodDeclarationsParametersCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_parameters_in_method_declaration", "class Example {void foo(int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) {}}", FormatterMessages.LineWrappingTabPage_parameters);
    private final Category fMessageSendArgumentsCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_arguments_in_method_invocation", "class Example {void foo() {Other.bar( 100,\nnested(200,\n300,\n400,\n500,\n600,\n700,\n800,\n900 ));}}", FormatterMessages.LineWrappingTabPage_arguments);
    private final Category fMessageSendSelectorCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_selector_in_method_invocation", "class Example {int foo(Some a) {return a.getFirst();}}", FormatterMessages.LineWrappingTabPage_qualified_invocations);
    private final Category fMethodThrowsClauseCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_throws_clause_in_method_declaration", "class Example {int foo() throws FirstException, SecondException, ThirdException {  return Other.doSomething();}}", FormatterMessages.LineWrappingTabPage_throws_clause);
    private final Category fConstructorThrowsClauseCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_throws_clause_in_constructor_declaration", "class Example {Example() throws FirstException, SecondException, ThirdException {  return Other.doSomething();}}", FormatterMessages.LineWrappingTabPage_throws_clause);
    private final Category fAllocationExpressionArgumentsCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_arguments_in_allocation_expression", "class Example {SomeClass foo() {return new SomeClass(100,\n200,\n300,\n400,\n500,\n600,\n700,\n800,\n900 );}}", FormatterMessages.LineWrappingTabPage_object_allocation);
    private final Category fQualifiedAllocationExpressionCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_arguments_in_qualified_allocation_expression", "class Example {SomeClass foo() {return SomeOtherClass.new SomeClass(100,\n200,\n300,\n400,\n500 );}}", FormatterMessages.LineWrappingTabPage_qualified_object_allocation);
    private final Category fArrayInitializerExpressionsCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_expressions_in_array_initializer", "class Example {int [] fArray= {1,\n2,\n3,\n4,\n5,\n6,\n7,\n8,\n9,\n10,\n11,\n12};}", FormatterMessages.LineWrappingTabPage_array_init);
    private final Category fExplicitConstructorArgumentsCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_arguments_in_explicit_constructor_call", "class Example extends AnotherClass {Example() {super(100,\n200,\n300,\n400,\n500,\n600,\n700);}}", FormatterMessages.LineWrappingTabPage_explicit_constructor_invocations);
    private final Category fConditionalExpressionCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_conditional_expression", "class Example extends AnotherClass {int Example(boolean Argument) {return argument ? 100000 : 200000;}}", FormatterMessages.LineWrappingTabPage_conditionals);
    private final Category fBinaryExpressionCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_binary_expression", "class Example extends AnotherClass {int foo() {  int sum= 100\n + 200\n + 300\n + 400\n + 500\n + 600\n + 700\n + 800;  int product= 1\n * 2\n * 3\n * 4\n * 5\n * 6\n * 7\n * 8\n * 9\n * 10;  boolean val= true && false && true && false && true;  return product / sum;}}", FormatterMessages.LineWrappingTabPage_binary_exprs);
    private final Category fAnnotationArgumentsCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_arguments_in_annotation", "@MyAnnotation(value1 = \"this is an example\", value2 = \"of an annotation\", value3 = \"with several arguments\", value4 = \"which may need to be wrapped\")\nclass Example {}", FormatterMessages.LineWrappingTabPage_annotations_arguments);
    private final Category fEnumConstArgumentsCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_arguments_in_enum_constant", "enum Example {GREEN(0, 255, 0), RED(255, 0, 0)  }", FormatterMessages.LineWrappingTabPage_enum_constant_arguments);
    private final Category fEnumDeclInterfacesCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_superinterfaces_in_enum_declaration", "enum Example implements A, B, C {}", FormatterMessages.LineWrappingTabPage_enum_superinterfaces);
    private final Category fEnumConstantsCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_enum_constants", "enum Example {CANCELLED, RUNNING, WAITING, FINISHED }enum Example {GREEN(0, 255, 0), RED(255, 0, 0)  }", FormatterMessages.LineWrappingTabPage_enum_constants);
    private final Category fAssignmentCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_assignment", "class Example {private static final String string = \"TextTextText\";void foo() {for (int i = 0; i < 10; i++) {}String s;s = \"TextTextText\";}}", FormatterMessages.LineWrappingTabPage_assignment_alignment);
    private static int DEFAULT_PREVIEW_WINDOW_LINE_WIDTH = 40;
    private static final String PREF_PREVIEW_LINE_WIDTH = "org.eclipse.jdt.ui.codeformatter.line_wrapping_tab_page.preview_line_width";
    protected final IDialogSettings fDialogSettings = JavaPlugin.getDefault().getDialogSettings();
    protected TreeViewer fCategoriesViewer;
    protected Label fWrappingStylePolicy;
    protected Combo fWrappingStyleCombo;
    protected Label fIndentStylePolicy;
    protected Combo fIndentStyleCombo;
    protected Button fForceSplit;
    protected CompilationUnitPreview fPreview;
    protected Group fOptionsGroup;
    private final List<Category> fCategories;
    protected final CategoryListener fCategoryListener;
    protected IStructuredSelection fSelection;
    SelectionState fSelectionState;
    protected final Map<String, String> fPreviewPreferences;
    private final String LINE_SPLIT = "org.eclipse.jdt.core.formatter.lineSplit";
    private Composite fOptionsComposite;

    public LineWrappingTabPage(ModifyDialog modifyDialog, Map<String, String> workingValues) {
        super(modifyDialog, workingValues);
        String previewLineWidth = this.fDialogSettings.get(PREF_PREVIEW_LINE_WIDTH);
        this.fPreviewPreferences = new HashMap<String, String>();
        this.fPreviewPreferences.put("org.eclipse.jdt.core.formatter.lineSplit", previewLineWidth != null ? previewLineWidth : Integer.toString(DEFAULT_PREVIEW_WINDOW_LINE_WIDTH));
        this.fCategories = this.createCategories();
        this.fCategoryListener = new CategoryListener(this.fCategories);
    }

    protected List<Category> createCategories() {
        Category annotations = new Category(FormatterMessages.LineWrappingTabPage_annotations);
        annotations.children.add(this.fAnnotationArgumentsCategory);
        Category classDeclarations = new Category(FormatterMessages.LineWrappingTabPage_class_decls);
        classDeclarations.children.add(this.fTypeDeclarationSuperclassCategory);
        classDeclarations.children.add(this.fTypeDeclarationSuperinterfacesCategory);
        Category constructorDeclarations = new Category(null, null, FormatterMessages.LineWrappingTabPage_constructor_decls);
        constructorDeclarations.children.add(this.fConstructorDeclarationsParametersCategory);
        constructorDeclarations.children.add(this.fConstructorThrowsClauseCategory);
        Category methodDeclarations = new Category(null, null, FormatterMessages.LineWrappingTabPage_method_decls);
        methodDeclarations.children.add(this.fMethodDeclarationsCategory);
        methodDeclarations.children.add(this.fMethodDeclarationsParametersCategory);
        methodDeclarations.children.add(this.fMethodThrowsClauseCategory);
        Category enumDeclarations = new Category(FormatterMessages.LineWrappingTabPage_enum_decls);
        enumDeclarations.children.add(this.fEnumConstantsCategory);
        enumDeclarations.children.add(this.fEnumDeclInterfacesCategory);
        enumDeclarations.children.add(this.fEnumConstArgumentsCategory);
        Category functionCalls = new Category(FormatterMessages.LineWrappingTabPage_function_calls);
        functionCalls.children.add(this.fMessageSendArgumentsCategory);
        functionCalls.children.add(this.fMessageSendSelectorCategory);
        functionCalls.children.add(this.fExplicitConstructorArgumentsCategory);
        functionCalls.children.add(this.fAllocationExpressionArgumentsCategory);
        functionCalls.children.add(this.fQualifiedAllocationExpressionCategory);
        Category expressions = new Category(FormatterMessages.LineWrappingTabPage_expressions);
        expressions.children.add(this.fBinaryExpressionCategory);
        expressions.children.add(this.fConditionalExpressionCategory);
        expressions.children.add(this.fArrayInitializerExpressionsCategory);
        expressions.children.add(this.fAssignmentCategory);
        Category statements = new Category(FormatterMessages.LineWrappingTabPage_statements);
        statements.children.add(this.fCompactIfCategory);
        statements.children.add(this.fTryCategory);
        statements.children.add(this.fCatchCategory);
        ArrayList<Category> root = new ArrayList<Category>();
        root.add(annotations);
        root.add(classDeclarations);
        root.add(constructorDeclarations);
        root.add(methodDeclarations);
        root.add(enumDeclarations);
        root.add(functionCalls);
        root.add(expressions);
        root.add(statements);
        return root;
    }

    @Override
    protected void doCreatePreferences(Composite composite, int numColumns) {
        this.fOptionsComposite = composite;
        Group lineWidthGroup = this.createGroup(numColumns, composite, FormatterMessages.LineWrappingTabPage_general_settings);
        this.createNumberPref((Composite)lineWidthGroup, numColumns, FormatterMessages.LineWrappingTabPage_width_indent_option_max_line_width, "org.eclipse.jdt.core.formatter.lineSplit", 0, 9999);
        this.createNumberPref((Composite)lineWidthGroup, numColumns, FormatterMessages.LineWrappingTabPage_width_indent_option_default_indent_wrapped, "org.eclipse.jdt.core.formatter.continuation_indentation", 0, 9999);
        this.createNumberPref((Composite)lineWidthGroup, numColumns, FormatterMessages.LineWrappingTabPage_width_indent_option_default_indent_array, "org.eclipse.jdt.core.formatter.continuation_indentation_for_array_initializer", 0, 9999);
        this.createCheckboxPref((Composite)lineWidthGroup, numColumns, FormatterMessages.LineWrappingTabPage_do_not_join_lines, "org.eclipse.jdt.core.formatter.join_wrapped_lines", TRUE_FALSE);
        this.createCheckboxPref((Composite)lineWidthGroup, numColumns, FormatterMessages.LineWrappingTabPage_wrap_outer_expressions_when_nested, "org.eclipse.jdt.core.formatter.wrap_outer_expressions_when_nested", FALSE_TRUE);
        this.fCategoriesViewer = new TreeViewer(composite, 2570);
        this.fCategoriesViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((Collection)inputElement).toArray();
            }

            public Object[] getChildren(Object parentElement) {
                return ((Category)parentElement).children.toArray();
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return !((Category)element).children.isEmpty();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.fCategoriesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fCategoriesViewer.setInput(this.fCategories);
        this.fCategoriesViewer.setExpandedElements(this.fCategories.toArray());
        GridData gd = LineWrappingTabPage.createGridData(numColumns, 1808, -1);
        gd.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(5);
        this.fCategoriesViewer.getControl().setLayoutData((Object)gd);
        this.fOptionsGroup = this.createGroup(numColumns, composite, "");
        this.fWrappingStylePolicy = LineWrappingTabPage.createLabel(numColumns, (Composite)this.fOptionsGroup, FormatterMessages.LineWrappingTabPage_wrapping_policy_label_text);
        this.fWrappingStyleCombo = new Combo((Composite)this.fOptionsGroup, 12);
        SWTUtil.setDefaultVisibleItemCount(this.fWrappingStyleCombo);
        this.fWrappingStyleCombo.setItems(WRAPPING_NAMES);
        this.fWrappingStyleCombo.setLayoutData((Object)LineWrappingTabPage.createGridData(numColumns, 256, 0));
        this.fForceSplit = new Button((Composite)this.fOptionsGroup, 32);
        String label = FormatterMessages.LineWrappingTabPage_force_split_checkbox_text;
        this.fForceSplit.setLayoutData((Object)new GridData(4, 0x1000000, true, false, numColumns - 1, 1));
        this.fForceSplit.setText(label);
        ModifyDialogTabPage.CheckboxPreference expressionWrapPositionPreference = this.createCheckboxPref((Composite)this.fOptionsGroup, 1, FormatterMessages.LineWrappingTabPage_binary_expression_wrap_operator, "org.eclipse.jdt.core.formatter.wrap_before_binary_operator", FALSE_TRUE);
        Control control = ((ModifyDialogTabPage.Preference)expressionWrapPositionPreference).getControl();
        control.setVisible(false);
        GridData layoutData = (GridData)control.getLayoutData();
        layoutData.exclude = true;
        layoutData.horizontalAlignment = 1;
        layoutData.horizontalSpan = numColumns - 1;
        layoutData.grabExcessHorizontalSpace = false;
        this.fBinaryExpressionCategory.addPreference(expressionWrapPositionPreference);
        ModifyDialogTabPage.CheckboxPreference expressionWrapMulticatchPositionPreference = this.createCheckboxPref((Composite)this.fOptionsGroup, 1, FormatterMessages.LineWrappingTabPage_multicatch_wrap_operator, "org.eclipse.jdt.core.formatter.wrap_before_or_operator_multicatch", FALSE_TRUE);
        control = ((ModifyDialogTabPage.Preference)expressionWrapMulticatchPositionPreference).getControl();
        control.setVisible(false);
        layoutData = (GridData)control.getLayoutData();
        layoutData.exclude = true;
        layoutData.horizontalAlignment = 1;
        layoutData.horizontalSpan = numColumns - 1;
        layoutData.grabExcessHorizontalSpace = false;
        this.fCatchCategory.addPreference(expressionWrapMulticatchPositionPreference);
        this.fIndentStylePolicy = LineWrappingTabPage.createLabel(numColumns, (Composite)this.fOptionsGroup, FormatterMessages.LineWrappingTabPage_indentation_policy_label_text);
        this.fIndentStyleCombo = new Combo((Composite)this.fOptionsGroup, 12);
        SWTUtil.setDefaultVisibleItemCount(this.fIndentStyleCombo);
        this.fIndentStyleCombo.setItems(INDENT_NAMES);
        this.fIndentStyleCombo.setLayoutData((Object)LineWrappingTabPage.createGridData(numColumns, 256, 0));
        this.fSelectionState = new SelectionState();
    }

    @Override
    protected Composite doCreatePreviewPane(Composite composite, int numColumns) {
        super.doCreatePreviewPane(composite, numColumns);
        Composite previewLineWidthContainer = new Composite(composite, 0);
        previewLineWidthContainer.setLayout((Layout)this.createGridLayout(2, false));
        ModifyDialogTabPage.NumberPreference previewLineWidth = new ModifyDialogTabPage.NumberPreference(this, previewLineWidthContainer, 2, this.fPreviewPreferences, "org.eclipse.jdt.core.formatter.lineSplit", 0, 9999, FormatterMessages.LineWrappingTabPage_line_width_for_preview_label_text);
        this.fDefaultFocusManager.add(previewLineWidth);
        previewLineWidth.addObserver(this.fUpdater);
        previewLineWidth.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                LineWrappingTabPage.this.fDialogSettings.put(LineWrappingTabPage.PREF_PREVIEW_LINE_WIDTH, LineWrappingTabPage.this.fPreviewPreferences.get("org.eclipse.jdt.core.formatter.lineSplit"));
            }
        });
        return composite;
    }

    @Override
    protected JavaPreview doCreateJavaPreview(Composite parent) {
        this.fPreview = new CompilationUnitPreview(this.fWorkingValues, parent);
        return this.fPreview;
    }

    @Override
    protected void initializePage() {
        this.fCategoriesViewer.addSelectionChangedListener((ISelectionChangedListener)this.fCategoryListener);
        this.fCategoriesViewer.addDoubleClickListener((IDoubleClickListener)this.fCategoryListener);
        this.fForceSplit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LineWrappingTabPage.this.forceSplitChanged(LineWrappingTabPage.this.fForceSplit.getSelection());
            }
        });
        this.fIndentStyleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LineWrappingTabPage.this.indentStyleChanged(((Combo)e.widget).getSelectionIndex());
            }
        });
        this.fWrappingStyleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LineWrappingTabPage.this.wrappingStyleChanged(((Combo)e.widget).getSelectionIndex());
            }
        });
        this.fCategoryListener.restoreSelection();
        this.fDefaultFocusManager.add(this.fCategoriesViewer.getControl());
        this.fDefaultFocusManager.add((Control)this.fWrappingStyleCombo);
        this.fDefaultFocusManager.add((Control)this.fIndentStyleCombo);
        this.fDefaultFocusManager.add((Control)this.fForceSplit);
    }

    @Override
    protected void doUpdatePreview() {
        super.doUpdatePreview();
        String normalSetting = (String)this.fWorkingValues.get("org.eclipse.jdt.core.formatter.lineSplit");
        this.fWorkingValues.put("org.eclipse.jdt.core.formatter.lineSplit", this.fPreviewPreferences.get("org.eclipse.jdt.core.formatter.lineSplit"));
        this.fPreview.update();
        this.fWorkingValues.put("org.eclipse.jdt.core.formatter.lineSplit", normalSetting);
    }

    protected void setPreviewText(String text) {
        String normalSetting = (String)this.fWorkingValues.get("org.eclipse.jdt.core.formatter.lineSplit");
        this.fWorkingValues.put("org.eclipse.jdt.core.formatter.lineSplit", this.fPreviewPreferences.get("org.eclipse.jdt.core.formatter.lineSplit"));
        this.fPreview.setPreviewText(text);
        this.fWorkingValues.put("org.eclipse.jdt.core.formatter.lineSplit", normalSetting);
    }

    protected void forceSplitChanged(boolean forceSplit) {
        Iterator iterator = this.fSelectionState.fElements.iterator();
        while (iterator.hasNext()) {
            String currentKey = ((Category)iterator.next()).key;
            try {
                this.changeForceSplit(currentKey, forceSplit);
            }
            catch (IllegalArgumentException e) {
                this.fWorkingValues.put(currentKey, DefaultCodeFormatterConstants.createAlignmentValue((boolean)forceSplit, (int)0, (int)0));
                JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(FormatterMessages.LineWrappingTabPage_error_invalid_value, currentKey), (Throwable)e));
            }
        }
        this.fSelectionState.refreshState(this.fSelection);
    }

    private void changeForceSplit(String currentKey, boolean forceSplit) throws IllegalArgumentException {
        String value = (String)this.fWorkingValues.get(currentKey);
        if ((value = DefaultCodeFormatterConstants.setForceWrapping((String)value, (boolean)forceSplit)) == null) {
            throw new IllegalArgumentException();
        }
        this.fWorkingValues.put(currentKey, value);
    }

    protected void wrappingStyleChanged(int wrappingStyle) {
        Iterator iterator = this.fSelectionState.fElements.iterator();
        while (iterator.hasNext()) {
            String currentKey = ((Category)iterator.next()).key;
            try {
                this.changeWrappingStyle(currentKey, wrappingStyle);
            }
            catch (IllegalArgumentException e) {
                this.fWorkingValues.put(currentKey, DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)wrappingStyle, (int)0));
                JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(FormatterMessages.LineWrappingTabPage_error_invalid_value, currentKey), (Throwable)e));
            }
        }
        this.fSelectionState.refreshState(this.fSelection);
    }

    private void changeWrappingStyle(String currentKey, int wrappingStyle) throws IllegalArgumentException {
        String value = (String)this.fWorkingValues.get(currentKey);
        if ((value = DefaultCodeFormatterConstants.setWrappingStyle((String)value, (int)wrappingStyle)) == null) {
            throw new IllegalArgumentException();
        }
        this.fWorkingValues.put(currentKey, value);
    }

    protected void indentStyleChanged(int indentStyle) {
        Iterator iterator = this.fSelectionState.fElements.iterator();
        while (iterator.hasNext()) {
            String currentKey = ((Category)iterator.next()).key;
            try {
                this.changeIndentStyle(currentKey, indentStyle);
            }
            catch (IllegalArgumentException e) {
                this.fWorkingValues.put(currentKey, DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)0, (int)indentStyle));
                JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(FormatterMessages.LineWrappingTabPage_error_invalid_value, currentKey), (Throwable)e));
            }
        }
        this.fSelectionState.refreshState(this.fSelection);
    }

    private void changeIndentStyle(String currentKey, int indentStyle) throws IllegalArgumentException {
        String value = (String)this.fWorkingValues.get(currentKey);
        if ((value = DefaultCodeFormatterConstants.setIndentStyle((String)value, (int)indentStyle)) == null) {
            throw new IllegalArgumentException();
        }
        this.fWorkingValues.put(currentKey, value);
    }

    protected void updateControlEnablement(boolean inhomogenous, int wrappingStyle) {
        boolean doSplit = wrappingStyle != 0;
        this.fIndentStylePolicy.setEnabled(true);
        boolean isEnabled = inhomogenous || doSplit;
        this.fIndentStyleCombo.setEnabled(isEnabled);
        this.fForceSplit.setEnabled(isEnabled);
        this.fBinaryExpressionCategory.setEnabled(isEnabled);
        this.fCatchCategory.setEnabled(isEnabled);
    }

    private static final class Category {
        public final String key;
        public final String name;
        public final String previewText;
        public final List<Category> children;
        public final List<ModifyDialogTabPage.Preference> preferences;
        public int index;

        public Category(String _key, String _previewText, String _name) {
            this.key = _key;
            this.name = _name;
            this.previewText = _previewText != null ? String.valueOf(LineWrappingTabPage.createPreviewHeader(_name)) + _previewText : null;
            this.children = new ArrayList<Category>();
            this.preferences = new ArrayList<ModifyDialogTabPage.Preference>();
        }

        public Category(String _name) {
            this(null, null, _name);
        }

        public String toString() {
            return this.name;
        }

        public void addPreference(ModifyDialogTabPage.Preference specificPreference) {
            this.preferences.add(specificPreference);
        }

        public ModifyDialogTabPage.Preference[] getSpecificPreferences() {
            return this.preferences.toArray(new ModifyDialogTabPage.Preference[this.preferences.size()]);
        }

        public void setEnabled(boolean state) {
            for (ModifyDialogTabPage.Preference preference : this.preferences) {
                preference.setEnabled(state);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CategoryListener
    implements ISelectionChangedListener,
    IDoubleClickListener {
        private final List<Category> fCategoriesList = new ArrayList<Category>();
        private int fIndex = 0;

        public CategoryListener(List<Category> categoriesTree) {
            this.flatten(this.fCategoriesList, categoriesTree);
        }

        private void flatten(List<Category> categoriesList, List<Category> categoriesTree) {
            for (Category category : categoriesTree) {
                ++this.fIndex;
                category.index = category.index;
                categoriesList.add(category);
                this.flatten(categoriesList, category.children);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event != null) {
                LineWrappingTabPage.this.fSelection = (IStructuredSelection)event.getSelection();
            }
            if (LineWrappingTabPage.this.fSelection.size() == 0) {
                this.disableAll();
                return;
            }
            if (!LineWrappingTabPage.this.fOptionsGroup.isEnabled()) {
                this.enableDefaultComponents(true);
            }
            LineWrappingTabPage.this.fSelectionState.refreshState(LineWrappingTabPage.this.fSelection);
            Category category = (Category)LineWrappingTabPage.this.fSelection.getFirstElement();
            LineWrappingTabPage.this.fDialogSettings.put(LineWrappingTabPage.PREF_CATEGORY_INDEX, category.index);
            LineWrappingTabPage.this.fOptionsGroup.setText(this.getGroupLabel(category));
        }

        private String getGroupLabel(Category category) {
            if (LineWrappingTabPage.this.fSelection.size() == 1) {
                if (LineWrappingTabPage.this.fSelectionState.getElements().size() == 1) {
                    return Messages.format(FormatterMessages.LineWrappingTabPage_group, category.name.toLowerCase());
                }
                return Messages.format(FormatterMessages.LineWrappingTabPage_multi_group, new String[]{category.name.toLowerCase(), Integer.toString(LineWrappingTabPage.this.fSelectionState.getElements().size())});
            }
            return Messages.format(FormatterMessages.LineWrappingTabPage_multiple_selections, new String[]{Integer.toString(LineWrappingTabPage.this.fSelectionState.getElements().size())});
        }

        private void disableAll() {
            this.enableDefaultComponents(false);
            LineWrappingTabPage.this.fIndentStyleCombo.setEnabled(false);
            LineWrappingTabPage.this.fForceSplit.setEnabled(false);
        }

        private void enableDefaultComponents(boolean enabled) {
            LineWrappingTabPage.this.fOptionsGroup.setEnabled(enabled);
            LineWrappingTabPage.this.fWrappingStyleCombo.setEnabled(enabled);
            LineWrappingTabPage.this.fWrappingStylePolicy.setEnabled(enabled);
        }

        public void restoreSelection() {
            int index;
            try {
                index = LineWrappingTabPage.this.fDialogSettings.getInt(LineWrappingTabPage.PREF_CATEGORY_INDEX);
            }
            catch (NumberFormatException ex) {
                index = -1;
            }
            if (index < 0 || index > this.fCategoriesList.size() - 1) {
                index = 1;
            }
            Category category = this.fCategoriesList.get(index);
            LineWrappingTabPage.this.fCategoriesViewer.setSelection((ISelection)new StructuredSelection((Object[])new Category[]{category}));
        }

        public void doubleClick(DoubleClickEvent event) {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                Category node = (Category)((IStructuredSelection)selection).getFirstElement();
                LineWrappingTabPage.this.fCategoriesViewer.setExpandedState((Object)node, !LineWrappingTabPage.this.fCategoriesViewer.getExpandedState((Object)node));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelectionState {
        private List<Category> fElements = new ArrayList<Category>();
        private boolean fRequiresRelayout;

        private SelectionState() {
        }

        public void refreshState(IStructuredSelection selection) {
            HashMap<Object, Integer> wrappingStyleMap = new HashMap<Object, Integer>();
            HashMap<Object, Integer> indentStyleMap = new HashMap<Object, Integer>();
            HashMap<Object, Integer> forceWrappingMap = new HashMap<Object, Integer>();
            this.fRequiresRelayout = false;
            this.showSpecificControls(false);
            this.fElements.clear();
            this.evaluateElements(selection.iterator());
            this.evaluateMaps(wrappingStyleMap, indentStyleMap, forceWrappingMap);
            LineWrappingTabPage.this.setPreviewText(this.getPreviewText());
            this.refreshControls(wrappingStyleMap, indentStyleMap, forceWrappingMap);
        }

        public List<Category> getElements() {
            return this.fElements;
        }

        private void evaluateElements(Iterator<Category> iterator) {
            while (iterator.hasNext()) {
                Category category = iterator.next();
                String value = (String)LineWrappingTabPage.this.fWorkingValues.get(category.key);
                if (value != null) {
                    if (this.fElements.contains(category)) continue;
                    this.fElements.add(category);
                    continue;
                }
                this.evaluateElements(category.children.iterator());
            }
        }

        private void evaluateMaps(Map<Object, Integer> wrappingStyleMap, Map<Object, Integer> indentStyleMap, Map<Object, Integer> forceWrappingMap) {
            Iterator<Category> iterator = this.fElements.iterator();
            while (iterator.hasNext()) {
                this.insertIntoMap(wrappingStyleMap, indentStyleMap, forceWrappingMap, iterator.next());
            }
        }

        private String getPreviewText() {
            Iterator<Category> iterator = this.fElements.iterator();
            String previewText = "";
            while (iterator.hasNext()) {
                Category category = iterator.next();
                previewText = String.valueOf(previewText) + category.previewText + "\n\n";
            }
            return previewText;
        }

        private void insertIntoMap(Map<Object, Integer> wrappingMap, Map<Object, Integer> indentMap, Map<Object, Integer> forceMap, Category category) {
            Boolean forceWrapping;
            Integer indentStyle;
            Integer wrappingStyle;
            String value = (String)LineWrappingTabPage.this.fWorkingValues.get(category.key);
            try {
                wrappingStyle = new Integer(DefaultCodeFormatterConstants.getWrappingStyle((String)value));
                indentStyle = new Integer(DefaultCodeFormatterConstants.getIndentStyle((String)value));
                forceWrapping = new Boolean(DefaultCodeFormatterConstants.getForceWrapping((String)value));
            }
            catch (IllegalArgumentException e) {
                forceWrapping = new Boolean(false);
                indentStyle = new Integer(0);
                wrappingStyle = new Integer(0);
            }
            this.increaseMapEntry(wrappingMap, wrappingStyle);
            this.increaseMapEntry(indentMap, indentStyle);
            this.increaseMapEntry(forceMap, forceWrapping);
        }

        private void increaseMapEntry(Map<Object, Integer> map, Object type) {
            Integer count = map.get(type);
            if (count == null) {
                map.put(type, new Integer(1));
            } else {
                map.put(type, new Integer(count + 1));
            }
        }

        private void refreshControls(Map<Object, Integer> wrappingStyleMap, Map<Object, Integer> indentStyleMap, Map<Object, Integer> forceWrappingMap) {
            this.updateCombos(wrappingStyleMap, indentStyleMap);
            this.updateButton(forceWrappingMap);
            Integer wrappingStyleMax = this.getWrappingStyleMax(wrappingStyleMap);
            boolean isInhomogeneous = this.fElements.size() != wrappingStyleMap.get(wrappingStyleMax).intValue();
            LineWrappingTabPage.this.updateControlEnablement(isInhomogeneous, wrappingStyleMax);
            this.showSpecificControls(true);
            if (this.fRequiresRelayout) {
                LineWrappingTabPage.this.fOptionsComposite.layout(true, true);
            }
            LineWrappingTabPage.this.doUpdatePreview();
            LineWrappingTabPage.this.notifyValuesModified();
        }

        private void showSpecificControls(boolean show) {
            if (this.fElements.size() != 1) {
                return;
            }
            ModifyDialogTabPage.Preference[] preferences = this.fElements.get(0).getSpecificPreferences();
            if (preferences.length == 0) {
                return;
            }
            this.fRequiresRelayout = true;
            int i = 0;
            while (i < preferences.length) {
                ModifyDialogTabPage.Preference preference = preferences[i];
                Control control = preference.getControl();
                control.setVisible(show);
                ((GridData)control.getLayoutData()).exclude = !show;
                ++i;
            }
        }

        private Integer getWrappingStyleMax(Map<Object, Integer> wrappingStyleMap) {
            int maxCount = 0;
            int maxStyle = 0;
            int i = 0;
            while (i < WRAPPING_NAMES.length) {
                Integer count = wrappingStyleMap.get(new Integer(i));
                if (count != null && count > maxCount) {
                    maxCount = count;
                    maxStyle = i;
                }
                ++i;
            }
            return new Integer(maxStyle);
        }

        private void updateButton(Map<Object, Integer> forceWrappingMap) {
            Integer nrOfTrue = forceWrappingMap.get(Boolean.TRUE);
            Integer nrOfFalse = forceWrappingMap.get(Boolean.FALSE);
            if (nrOfTrue == null || nrOfFalse == null) {
                LineWrappingTabPage.this.fForceSplit.setSelection(nrOfTrue != null);
            } else {
                LineWrappingTabPage.this.fForceSplit.setSelection(nrOfTrue > nrOfFalse);
            }
            int max = this.getMax(nrOfTrue, nrOfFalse);
            String label = FormatterMessages.LineWrappingTabPage_force_split_checkbox_text;
            LineWrappingTabPage.this.fForceSplit.setText(this.getLabelText(label, max, this.fElements.size()));
        }

        private String getLabelText(String label, int count, int nElements) {
            if (nElements == 1 || count == 0) {
                return label;
            }
            return Messages.format(FormatterMessages.LineWrappingTabPage_occurences, new String[]{label, Integer.toString(count), Integer.toString(nElements)});
        }

        private int getMax(Integer nrOfTrue, Integer nrOfFalse) {
            if (nrOfTrue == null) {
                return nrOfFalse;
            }
            if (nrOfFalse == null) {
                return nrOfTrue;
            }
            if (nrOfTrue.compareTo(nrOfFalse) >= 0) {
                return nrOfTrue;
            }
            return nrOfFalse;
        }

        private void updateCombos(Map<Object, Integer> wrappingStyleMap, Map<Object, Integer> indentStyleMap) {
            this.updateCombo(LineWrappingTabPage.this.fWrappingStyleCombo, wrappingStyleMap, WRAPPING_NAMES);
            this.updateCombo(LineWrappingTabPage.this.fIndentStyleCombo, indentStyleMap, INDENT_NAMES);
        }

        private void updateCombo(Combo combo, Map<Object, Integer> map, String[] items) {
            String[] newItems = new String[items.length];
            int maxCount = 0;
            int maxStyle = 0;
            int i = 0;
            while (i < items.length) {
                int val;
                Integer count = map.get(new Integer(i));
                int n = val = count == null ? 0 : count;
                if (val > maxCount) {
                    maxCount = val;
                    maxStyle = i;
                }
                newItems[i] = this.getLabelText(items[i], val, this.fElements.size());
                ++i;
            }
            combo.setItems(newItems);
            combo.setText(newItems[maxStyle]);
        }
    }
}

