/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import com.ibm.icu.text.Collator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.search.AbstractJavaSearchResult;
import org.eclipse.jdt.internal.ui.search.NewSearchResultCollector;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.ui.refactoring.IStatusContextViewer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ReferencesInBinaryStatusContextViewer
implements IStatusContextViewer {
    private ViewForm fForm;
    private CLabel fLabel;
    private TreeViewer fTreeViewer;
    private ReferencesInBinaryContext fInput;
    private Button fButton;

    public void setInput(RefactoringStatusContext input) {
        ContentProvider contentProvider = new ContentProvider();
        ReferencesInBinaryContext binariesContext = (ReferencesInBinaryContext)input;
        List<SearchMatch> matches = binariesContext.getMatches();
        for (SearchMatch match : matches) {
            Object element = match.getElement();
            if (element == null) continue;
            contentProvider.add(element);
        }
        this.fTreeViewer.setContentProvider((IContentProvider)contentProvider);
        this.fTreeViewer.setInput((Object)contentProvider);
        this.fLabel.setText(binariesContext.getDescription());
        this.fInput = binariesContext;
        this.fButton.setEnabled(!matches.isEmpty());
    }

    public void createControl(Composite parent) {
        this.fForm = new ViewForm(parent, 0x800800);
        this.fForm.marginWidth = 0;
        this.fForm.marginHeight = 0;
        this.fLabel = new CLabel((Composite)this.fForm, 0);
        this.fLabel.setText(RefactoringMessages.ReferencesInBinaryStatusContextViewer_title);
        this.fForm.setTopLeft((Control)this.fLabel);
        Composite composite = new Composite((Composite)this.fForm, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.fTreeViewer = new TreeViewer(composite, 770);
        final AppearanceAwareLabelProvider labelProvider = new AppearanceAwareLabelProvider();
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider));
        this.fTreeViewer.setComparator(new ViewerComparator(){
            private Collator fCollator = Collator.getInstance();

            public int compare(Viewer viewer, Object e1, Object e2) {
                String l1 = labelProvider.getText(e1);
                String l2 = labelProvider.getText(e2);
                return this.fCollator.compare(l1, l2);
            }
        });
        this.fTreeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fButton = new Button(composite, 8);
        this.fButton.setText(RefactoringMessages.ReferencesInBinaryStatusContextViewer_show_as_search_button);
        GridData layoutData = new GridData(1, 0x1000000, false, false);
        layoutData.widthHint = SWTUtil.getButtonWidthHint(this.fButton);
        this.fButton.setLayoutData((Object)layoutData);
        this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferencesInBinaryStatusContextViewer.this.fillInSearchView();
            }
        });
        this.fButton.setEnabled(false);
        this.fForm.setContent((Control)composite);
        Dialog.applyDialogFont((Control)parent);
    }

    protected void fillInSearchView() {
        NewSearchUI.runQueryInBackground((ISearchQuery)new ReferencesInBinarySearchQuery(this.fInput), null);
        this.fButton.setEnabled(false);
    }

    public Control getControl() {
        return this.fForm;
    }

    private static class ContentProvider
    extends StandardJavaElementContentProvider {
        private Map<Object, Object> fChildren = new HashMap<Object, Object>();
        private Set<Object> fRoots = new HashSet<Object>();

        private ContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            Object children = this.fChildren.get(parentElement);
            if (children == null) {
                return new Object[0];
            }
            if (children instanceof Set) {
                return ((Set)children).toArray();
            }
            return new Object[]{children};
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.fRoots.toArray();
        }

        public void add(Object element) {
            Object parent = this.getParent(element);
            while (parent != null) {
                if (parent instanceof IJavaModel) {
                    this.fRoots.add(element);
                } else if (parent instanceof IWorkspaceRoot) {
                    this.fRoots.add(element);
                } else {
                    Object oldChildren = this.fChildren.get(parent);
                    if (element.equals(oldChildren)) {
                        return;
                    }
                    if (oldChildren instanceof Set) {
                        Set oldChildrenSet = (Set)oldChildren;
                        oldChildrenSet.add(element);
                        return;
                    }
                    if (oldChildren != null) {
                        HashSet<Object> newChildren = new HashSet<Object>(4);
                        newChildren.add(oldChildren);
                        newChildren.add(element);
                        this.fChildren.put(parent, newChildren);
                        return;
                    }
                    this.fChildren.put(parent, element);
                }
                element = parent;
                parent = this.getParent(element);
            }
        }
    }

    static class ReferencesInBinarySearchQuery
    implements ISearchQuery {
        private final ReferencesInBinaryContext fContext;
        private ReferencesInBinarySearchResult fResult;

        public ReferencesInBinarySearchQuery(ReferencesInBinaryContext context) {
            this.fContext = context;
            this.fResult = new ReferencesInBinarySearchResult(this);
        }

        public boolean canRerun() {
            return false;
        }

        public boolean canRunInBackground() {
            return true;
        }

        public String getLabel() {
            return this.fContext.getDescription();
        }

        public ISearchResult getSearchResult() {
            return this.fResult;
        }

        public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
            this.fResult.removeAll();
            List<SearchMatch> matches = this.fContext.getMatches();
            NewSearchResultCollector collector = new NewSearchResultCollector(this.fResult, false);
            collector.beginReporting();
            Iterator<SearchMatch> iter = matches.iterator();
            while (iter.hasNext()) {
                try {
                    collector.acceptSearchMatch(iter.next());
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            collector.endReporting();
            return Status.OK_STATUS;
        }
    }

    public static class ReferencesInBinarySearchResult
    extends AbstractJavaSearchResult {
        private final ReferencesInBinarySearchQuery fQuery;

        public ReferencesInBinarySearchResult(ReferencesInBinarySearchQuery query) {
            this.fQuery = query;
        }

        public ImageDescriptor getImageDescriptor() {
            return JavaPluginImages.DESC_OBJS_SEARCH_REF;
        }

        public String getLabel() {
            return this.fQuery.getLabel();
        }

        public String getTooltip() {
            return this.getLabel();
        }

        public ISearchQuery getQuery() {
            return this.fQuery;
        }
    }
}

