/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Collection;
import java.util.Hashtable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.NullAnnotationsFix;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.fix.NullAnnotationsCleanUp;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ExtractToNullCheckedLocalProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.FixCorrectionProposal;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.correction.ICommandAccess;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullAnnotationsCorrectionProcessor {
    public static void addReturnAndArgumentTypeProposal(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) {
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        boolean isArgumentProblem = NullAnnotationsFix.isComplainingAboutArgument(selectedNode);
        if (isArgumentProblem || NullAnnotationsFix.isComplainingAboutReturn(selectedNode)) {
            NullAnnotationsCorrectionProcessor.addNullAnnotationInSignatureProposal(context, problem, proposals, false, isArgumentProblem);
        }
    }

    public static void addNullAnnotationInSignatureProposal(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals, boolean modifyOverridden, boolean isArgumentProblem) {
        NullAnnotationsFix fix = NullAnnotationsFix.createNullAnnotationInSignatureFix(context.getASTRoot(), problem, modifyOverridden, isArgumentProblem);
        if (fix != null) {
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            Hashtable<String, String> options = new Hashtable<String, String>();
            if (fix.getCu() != context.getASTRoot()) {
                final CompilationUnit cu = fix.getCu();
                final IInvocationContext originalContext = context;
                context = new IInvocationContext(){

                    public int getSelectionOffset() {
                        return originalContext.getSelectionOffset();
                    }

                    public int getSelectionLength() {
                        return originalContext.getSelectionLength();
                    }

                    public ASTNode getCoveringNode() {
                        return originalContext.getCoveringNode();
                    }

                    public ASTNode getCoveredNode() {
                        return originalContext.getCoveredNode();
                    }

                    public ICompilationUnit getCompilationUnit() {
                        return (ICompilationUnit)cu.getJavaElement();
                    }

                    public CompilationUnit getASTRoot() {
                        return cu;
                    }
                };
            }
            int relevance = modifyOverridden ? 9 : 10;
            FixCorrectionProposal proposal = new FixCorrectionProposal(fix, new NullAnnotationsCleanUp(options, problem.getProblemId()), relevance, image, context);
            proposals.add(proposal);
        }
    }

    public static void addRemoveRedundantAnnotationProposal(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) {
        NullAnnotationsFix fix = NullAnnotationsFix.createRemoveRedundantNullAnnotationsFix(context.getASTRoot(), problem);
        if (fix == null) {
            return;
        }
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        Hashtable<String, String> options = new Hashtable<String, String>();
        FixCorrectionProposal proposal = new FixCorrectionProposal(fix, new NullAnnotationsCleanUp(options, problem.getProblemId()), 5, image, context);
        proposals.add(proposal);
    }

    public static void addExtractCheckedLocalProposal(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) {
        CompilationUnit compilationUnit = context.getASTRoot();
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        ASTNode selectedNode = problem.getCoveringNode(compilationUnit);
        if (selectedNode instanceof SimpleName) {
            ASTNode method = ASTNodes.getParent(selectedNode, MethodDeclaration.class);
            if (method == null) {
                method = ASTNodes.getParent(selectedNode, Initializer.class);
            }
            if (method != null) {
                proposals.add(new ExtractToNullCheckedLocalProposal(cu, compilationUnit, (SimpleName)selectedNode, method));
            }
        }
    }
}

