/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.JavaHeuristicScanner;
import org.eclipse.jdt.internal.ui.text.java.AnonymousTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.FillArgumentNamesCompletionProposalCollector;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private static final long JAVA_CODE_ASSIST_TIMEOUT = Long.getLong("org.eclipse.jdt.ui.codeAssistTimeout", 5000L);
    private String fErrorMessage;
    private final IProgressMonitor fTimeoutProgressMonitor = this.createTimeoutProgressMonitor(JAVA_CODE_ASSIST_TIMEOUT);

    protected int guessContextInformationPosition(ContentAssistInvocationContext context) {
        return context.getInvocationOffset();
    }

    protected final int guessMethodContextInformationPosition(ContentAssistInvocationContext context) {
        int paren;
        int contextPosition = context.getInvocationOffset();
        IDocument document = context.getDocument();
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
        int bound = Math.max(-1, contextPosition - 200);
        int pos = contextPosition - 1;
        while ((paren = scanner.findOpeningPeer(pos, bound, '(', ')')) != -1) {
            int token = scanner.previousToken(paren - 1, bound);
            if (token == 2000 || token == 14) {
                return paren + 1;
            }
            pos = paren - 1;
        }
        return contextPosition;
    }

    private List<IContextInformation> addContextInformations(JavaContentAssistInvocationContext context, int offset) {
        List<ICompletionProposal> proposals = this.internalComputeCompletionProposals(offset, context);
        ArrayList<IContextInformation> result = new ArrayList<IContextInformation>(proposals.size());
        ArrayList<IContextInformation> anonymousResult = new ArrayList<IContextInformation>(proposals.size());
        for (ICompletionProposal proposal : proposals) {
            IContextInformation contextInformation = proposal.getContextInformation();
            if (contextInformation == null) continue;
            ContextInformationWrapper wrapper = new ContextInformationWrapper(contextInformation);
            wrapper.setContextInformationPosition(offset);
            if (proposal instanceof AnonymousTypeCompletionProposal) {
                anonymousResult.add(wrapper);
                continue;
            }
            result.add(wrapper);
        }
        if (result.size() == 0) {
            return anonymousResult;
        }
        return result;
    }

    @Override
    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (context instanceof JavaContentAssistInvocationContext) {
            JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
            int contextInformationPosition = this.guessContextInformationPosition(javaContext);
            List<IContextInformation> result = this.addContextInformations(javaContext, contextInformationPosition);
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (context instanceof JavaContentAssistInvocationContext) {
            JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
            return this.internalComputeCompletionProposals(context.getInvocationOffset(), javaContext);
        }
        return Collections.emptyList();
    }

    private List<ICompletionProposal> internalComputeCompletionProposals(int offset, JavaContentAssistInvocationContext context) {
        String error;
        ArrayList<ICompletionProposal> proposals;
        ICompilationUnit unit = context.getCompilationUnit();
        if (unit == null) {
            return Collections.emptyList();
        }
        ITextViewer viewer = context.getViewer();
        CompletionProposalCollector collector = this.createCollector(context);
        collector.setInvocationContext(context);
        collector.setAllowsRequiredProposals(2, 9, true);
        collector.setAllowsRequiredProposals(2, 23, true);
        collector.setAllowsRequiredProposals(2, 21, true);
        collector.setAllowsRequiredProposals(6, 9, true);
        collector.setAllowsRequiredProposals(6, 23, true);
        collector.setAllowsRequiredProposals(6, 22, true);
        collector.setAllowsRequiredProposals(26, 9, true);
        collector.setAllowsRequiredProposals(27, 9, true);
        collector.setAllowsRequiredProposals(1, 9, true);
        collector.setAllowsRequiredProposals(9, 9, true);
        collector.setFavoriteReferences(this.getFavoriteStaticMembers());
        try {
            Point selection = viewer.getSelectedRange();
            if (selection.y > 0) {
                collector.setReplacementLength(selection.y);
            }
            unit.codeComplete(offset, (CompletionRequestor)collector, this.fTimeoutProgressMonitor);
        }
        catch (OperationCanceledException x) {
            IBindingService bindingSvc = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
            String keyBinding = bindingSvc.getBestActiveBindingFormattedFor("org.eclipse.ui.edit.text.contentAssist.proposals");
            this.fErrorMessage = Messages.format(JavaTextMessages.CompletionProcessor_error_javaCompletion_took_too_long_message, keyBinding);
        }
        catch (JavaModelException x) {
            Shell shell = viewer.getTextWidget().getShell();
            if (x.isDoesNotExist() && !unit.getJavaProject().isOnClasspath((IJavaElement)unit)) {
                MessageDialog.openInformation((Shell)shell, (String)JavaTextMessages.CompletionProcessor_error_notOnBuildPath_title, (String)JavaTextMessages.CompletionProcessor_error_notOnBuildPath_message);
            }
            ErrorDialog.openError((Shell)shell, (String)JavaTextMessages.CompletionProcessor_error_accessing_title, (String)JavaTextMessages.CompletionProcessor_error_accessing_message, (IStatus)x.getStatus());
        }
        IJavaCompletionProposal[] javaProposals = collector.getJavaCompletionProposals();
        int contextInformationOffset = this.guessMethodContextInformationPosition(context);
        if (contextInformationOffset != offset) {
            int i = 0;
            while (i < javaProposals.length) {
                if (javaProposals[i] instanceof JavaMethodCompletionProposal) {
                    JavaMethodCompletionProposal jmcp = (JavaMethodCompletionProposal)javaProposals[i];
                    jmcp.setContextInformationPosition(contextInformationOffset);
                }
                ++i;
            }
        }
        if ((proposals = new ArrayList<ICompletionProposal>(Arrays.asList(javaProposals))).size() == 0 && (error = collector.getErrorMessage()).length() > 0) {
            this.fErrorMessage = error;
        }
        return proposals;
    }

    private IProgressMonitor createTimeoutProgressMonitor(final long timeout) {
        return new IProgressMonitor(){
            private long fEndTime;

            public void beginTask(String name, int totalWork) {
                this.fEndTime = System.currentTimeMillis() + timeout;
            }

            public boolean isCanceled() {
                return this.fEndTime <= System.currentTimeMillis();
            }

            public void done() {
            }

            public void internalWorked(double work) {
            }

            public void setCanceled(boolean value) {
            }

            public void setTaskName(String name) {
            }

            public void subTask(String name) {
            }

            public void worked(int work) {
            }
        };
    }

    private String[] getFavoriteStaticMembers() {
        String serializedFavorites = PreferenceConstants.getPreferenceStore().getString("content_assist_favorite_static_members");
        if (serializedFavorites != null && serializedFavorites.length() > 0) {
            return serializedFavorites.split(";");
        }
        return new String[0];
    }

    protected CompletionProposalCollector createCollector(JavaContentAssistInvocationContext context) {
        if (PreferenceConstants.getPreferenceStore().getBoolean("content_assist_fill_method_arguments")) {
            return new FillArgumentNamesCompletionProposalCollector(context);
        }
        return new CompletionProposalCollector(context.getCompilationUnit(), true);
    }

    @Override
    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    @Override
    public void sessionStarted() {
    }

    @Override
    public void sessionEnded() {
        this.fErrorMessage = null;
    }

    private static final class ContextInformationWrapper
    implements IContextInformation,
    IContextInformationExtension {
        private final IContextInformation fContextInformation;
        private int fPosition;

        public ContextInformationWrapper(IContextInformation contextInformation) {
            this.fContextInformation = contextInformation;
        }

        public String getContextDisplayString() {
            return this.fContextInformation.getContextDisplayString();
        }

        public Image getImage() {
            return this.fContextInformation.getImage();
        }

        public String getInformationDisplayString() {
            return this.fContextInformation.getInformationDisplayString();
        }

        public int getContextInformationPosition() {
            return this.fPosition;
        }

        public void setContextInformationPosition(int position) {
            this.fPosition = position;
        }

        public boolean equals(Object object) {
            if (object instanceof ContextInformationWrapper) {
                return this.fContextInformation.equals((Object)((ContextInformationWrapper)object).fContextInformation);
            }
            return this.fContextInformation.equals(object);
        }

        public int hashCode() {
            return this.fContextInformation.hashCode();
        }
    }
}

