/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.AbstractTemplateCompletionProposalComputer;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateEngine;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;

public class SWTTemplateCompletionProposalComputer
extends AbstractTemplateCompletionProposalComputer {
    private static final String SWT_TYPE_NAME = "org.eclipse.swt.SWT";
    private final TemplateEngine fSWTTemplateEngine;
    private final TemplateEngine fSWTMembersTemplateEngine;
    private final TemplateEngine fSWTStatementsTemplateEngine;
    private IJavaProject fCachedJavaProject;
    private boolean fIsSWTOnClasspath;

    public SWTTemplateCompletionProposalComputer() {
        ContextTypeRegistry templateContextRegistry = JavaPlugin.getDefault().getTemplateContextRegistry();
        this.fSWTTemplateEngine = SWTTemplateCompletionProposalComputer.createTemplateEngine(templateContextRegistry, "swt");
        this.fSWTMembersTemplateEngine = SWTTemplateCompletionProposalComputer.createTemplateEngine(templateContextRegistry, "swt-members");
        this.fSWTStatementsTemplateEngine = SWTTemplateCompletionProposalComputer.createTemplateEngine(templateContextRegistry, "swt-statements");
        JavaCore.addElementChangedListener((IElementChangedListener)new BuildPathChangeListener());
    }

    private static TemplateEngine createTemplateEngine(ContextTypeRegistry templateContextRegistry, String contextTypeId) {
        TemplateContextType contextType = templateContextRegistry.getContextType(contextTypeId);
        Assert.isNotNull((Object)contextType);
        return new TemplateEngine(contextType);
    }

    protected TemplateEngine computeCompletionEngine(JavaContentAssistInvocationContext context) {
        ICompilationUnit unit = context.getCompilationUnit();
        if (unit == null) {
            return null;
        }
        IJavaProject javaProject = unit.getJavaProject();
        if (javaProject == null) {
            return null;
        }
        if (this.isSWTOnClasspath(javaProject)) {
            CompletionContext coreContext = context.getCoreContext();
            if (coreContext != null) {
                int tokenLocation = coreContext.getTokenLocation();
                if ((tokenLocation & 1) != 0) {
                    return this.fSWTMembersTemplateEngine;
                }
                if ((tokenLocation & 2) != 0) {
                    return this.fSWTStatementsTemplateEngine;
                }
            }
            return this.fSWTTemplateEngine;
        }
        return null;
    }

    private synchronized boolean isSWTOnClasspath(IJavaProject javaProject) {
        if (!javaProject.equals(this.fCachedJavaProject)) {
            this.fCachedJavaProject = javaProject;
            try {
                IType type = javaProject.findType(SWT_TYPE_NAME);
                this.fIsSWTOnClasspath = type != null;
            }
            catch (JavaModelException e) {
                this.fIsSWTOnClasspath = false;
            }
        }
        return this.fIsSWTOnClasspath;
    }

    private synchronized IJavaProject getCachedJavaProject() {
        return this.fCachedJavaProject;
    }

    private synchronized void setCachedJavaProject(IJavaProject project) {
        this.fCachedJavaProject = project;
    }

    private final class BuildPathChangeListener
    implements IElementChangedListener {
        private BuildPathChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            IJavaProject javaProject = SWTTemplateCompletionProposalComputer.this.getCachedJavaProject();
            if (javaProject == null) {
                return;
            }
            IJavaElementDelta[] children = event.getDelta().getChangedChildren();
            int i = 0;
            while (i < children.length) {
                IJavaElementDelta child = children[i];
                if (javaProject.equals(child.getElement()) && this.isClasspathChange(child)) {
                    SWTTemplateCompletionProposalComputer.this.setCachedJavaProject(null);
                }
                ++i;
            }
        }

        private boolean isClasspathChange(IJavaElementDelta delta) {
            int flags = delta.getFlags();
            if (this.isClasspathChangeFlag(flags)) {
                return true;
            }
            if ((flags & 8) != 0) {
                IJavaElementDelta[] children = delta.getAffectedChildren();
                int i = 0;
                while (i < children.length) {
                    if (this.isClasspathChangeFlag(children[i].getFlags())) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        private boolean isClasspathChangeFlag(int flags) {
            if ((flags & 0x200000) != 0) {
                return true;
            }
            if ((flags & 0x40) != 0) {
                return true;
            }
            if ((flags & 0x80) != 0) {
                return true;
            }
            return (flags & 0x8000) != 0;
        }
    }
}

