/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.javadoc;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditorExtension3;

public class JavaDocAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private final String fPartitioning;

    public JavaDocAutoIndentStrategy(String partitioning) {
        this.fPartitioning = partitioning;
    }

    private void indentAfterNewLine(IDocument d, DocumentCommand c) {
        int offset = c.offset;
        if (offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int p = offset == d.getLength() ? offset - 1 : offset;
            IRegion line = d.getLineInformationOfOffset(p);
            int lineOffset = line.getOffset();
            int firstNonWS = this.findEndOfWhiteSpace(d, lineOffset, offset);
            Assert.isTrue((firstNonWS >= lineOffset ? 1 : 0) != 0, (String)"indentation must not be negative");
            StringBuffer buf = new StringBuffer(c.text);
            IRegion prefix = this.findPrefixRange(d, line);
            String indentation = d.get(prefix.getOffset(), prefix.getLength());
            int lengthToAdd = Math.min(offset - prefix.getOffset(), prefix.getLength());
            buf.append(indentation.substring(0, lengthToAdd));
            if (firstNonWS < offset && d.getChar(firstNonWS) == '/') {
                buf.append(" * ");
                if (this.isPreferenceTrue("closeJavaDocs") && this.isNewComment(d, offset)) {
                    c.shiftsCaret = false;
                    c.caretOffset = c.offset + buf.length();
                    String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)d);
                    int eolOffset = lineOffset + line.getLength();
                    int replacementLength = eolOffset - p;
                    String restOfLine = d.get(p, replacementLength);
                    String endTag = String.valueOf(lineDelimiter) + indentation + " */";
                    if (this.isPreferenceTrue("addJavaDocTags")) {
                        d.replace(offset, replacementLength, endTag);
                        ICompilationUnit unit = JavaDocAutoIndentStrategy.getCompilationUnit();
                        if (unit != null) {
                            try {
                                JavaModelUtil.reconcile(unit);
                                String string = this.createJavaDocTags(d, c, indentation, lineDelimiter, unit);
                                buf.append(restOfLine);
                                if (string != null && !string.trim().equals("*")) {
                                    buf.append(string);
                                }
                            }
                            catch (CoreException coreException) {}
                        }
                    } else {
                        c.length = replacementLength;
                        buf.append(restOfLine);
                        buf.append(endTag);
                    }
                }
            }
            if (lengthToAdd < prefix.getLength()) {
                c.caretOffset = offset + prefix.getLength() - lengthToAdd;
            }
            c.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private boolean isPreferenceTrue(String preference) {
        return JavaPlugin.getDefault().getPreferenceStore().getBoolean(preference);
    }

    private IRegion findPrefixRange(IDocument document, IRegion line) throws BadLocationException {
        int lineEnd;
        int lineOffset = line.getOffset();
        int indentEnd = this.findEndOfWhiteSpace(document, lineOffset, lineEnd = lineOffset + line.getLength());
        if (indentEnd < lineEnd && document.getChar(indentEnd) == '*') {
            ++indentEnd;
            while (indentEnd < lineEnd && document.getChar(indentEnd) == ' ') {
                ++indentEnd;
            }
        }
        return new Region(lineOffset, indentEnd - lineOffset);
    }

    private String createJavaDocTags(IDocument document, DocumentCommand command, String indentation, String lineDelimiter, ICompilationUnit unit) throws CoreException, BadLocationException {
        IJavaElement element = unit.getElementAt(command.offset);
        if (element == null) {
            return null;
        }
        switch (element.getElementType()) {
            case 7: {
                return this.createTypeTags(document, command, indentation, lineDelimiter, (IType)element);
            }
            case 9: {
                return this.createMethodTags(document, command, indentation, lineDelimiter, (IMethod)element);
            }
        }
        return null;
    }

    private String prepareTemplateComment(String comment, String indentation, IJavaProject project, String lineDelimiter) {
        if (comment.endsWith("*/")) {
            comment = comment.substring(0, comment.length() - 2);
        }
        if ((comment = comment.trim()).startsWith("/*")) {
            comment = comment.length() > 2 && comment.charAt(2) == '*' ? comment.substring(3) : comment.substring(2);
        }
        int nonSpace = 0;
        int len = comment.length();
        while (nonSpace < len && Character.getType(comment.charAt(nonSpace)) == 12) {
            ++nonSpace;
        }
        comment = comment.substring(nonSpace);
        return Strings.changeIndent(comment, 0, project, indentation, lineDelimiter);
    }

    private String createTypeTags(IDocument document, DocumentCommand command, String indentation, String lineDelimiter, IType type) throws CoreException, BadLocationException {
        String[] typeParamNames = StubUtility.getTypeParameterNames(type.getTypeParameters());
        String comment = CodeGeneration.getTypeComment(type.getCompilationUnit(), type.getTypeQualifiedName('.'), typeParamNames, lineDelimiter);
        if (comment != null) {
            boolean javadocComment = comment.startsWith("/**");
            if (!this.isFirstComment(document, command, (IMember)type, javadocComment)) {
                return null;
            }
            return this.prepareTemplateComment(comment.trim(), indentation, type.getJavaProject(), lineDelimiter);
        }
        return null;
    }

    private String createMethodTags(IDocument document, DocumentCommand command, String indentation, String lineDelimiter, IMethod method) throws CoreException, BadLocationException {
        ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)this.fPartitioning, (int)command.offset, (boolean)false);
        IMethod inheritedMethod = JavaDocAutoIndentStrategy.getInheritedMethod(method);
        String comment = CodeGeneration.getMethodComment(method, inheritedMethod, lineDelimiter);
        if (comment != null) {
            boolean isJavaDoc;
            boolean javadocComment = (comment = comment.trim()).startsWith("/**");
            if (!this.isFirstComment(document, command, (IMember)method, javadocComment)) {
                return null;
            }
            boolean bl = isJavaDoc = partition.getLength() >= 3 && document.get(partition.getOffset(), 3).equals("/**");
            if (javadocComment == isJavaDoc) {
                return this.prepareTemplateComment(comment, indentation, method.getJavaProject(), lineDelimiter);
            }
        }
        return null;
    }

    private boolean isFirstComment(IDocument document, DocumentCommand command, IMember member, boolean ignoreNonJavadoc) throws BadLocationException, JavaModelException {
        String token;
        ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)this.fPartitioning, (int)command.offset, (boolean)false);
        ISourceRange sourceRange = member.getSourceRange();
        if (sourceRange == null) {
            return false;
        }
        int srcOffset = sourceRange.getOffset();
        int srcLength = sourceRange.getLength();
        int nameRelativeOffset = member.getNameRange().getOffset() - srcOffset;
        int partitionRelativeOffset = partition.getOffset() - srcOffset;
        String string = token = ignoreNonJavadoc ? "/**" : "/*";
        return document.get(srcOffset, srcLength).lastIndexOf(token, nameRelativeOffset) == partitionRelativeOffset;
    }

    private void indentAfterCommentEnd(IDocument d, DocumentCommand c) {
        if (c.offset < 2 || d.getLength() == 0) {
            return;
        }
        try {
            if ("* ".equals(d.get(c.offset - 2, 2))) {
                ++c.length;
                --c.offset;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private boolean isNewComment(IDocument document, int commandOffset) {
        ITypedRegion partition;
        block7: {
            int partitionEnd;
            block6: {
                int lineIndex;
                block5: {
                    try {
                        lineIndex = document.getLineOfOffset(commandOffset) + 1;
                        if (lineIndex < document.getNumberOfLines()) break block5;
                        return true;
                    }
                    catch (BadLocationException e) {
                        return false;
                    }
                }
                IRegion line = document.getLineInformation(lineIndex);
                partition = TextUtilities.getPartition((IDocument)document, (String)this.fPartitioning, (int)commandOffset, (boolean)false);
                partitionEnd = partition.getOffset() + partition.getLength();
                if (line.getOffset() < partitionEnd) break block6;
                return false;
            }
            if (document.getLength() != partitionEnd) break block7;
            return true;
        }
        String comment = document.get(partition.getOffset(), partition.getLength());
        return comment.indexOf("/*", 2) != -1;
    }

    private boolean isSmartMode() {
        IWorkbenchPage page = JavaPlugin.getActivePage();
        if (page != null) {
            ITextEditorExtension3 extension;
            IEditorPart part = page.getActiveEditor();
            if (part instanceof ITextEditorExtension3) {
                ITextEditorExtension3 extension2 = (ITextEditorExtension3)part;
                return extension2.getInsertMode() == ITextEditorExtension3.SMART_INSERT;
            }
            if (EditorUtility.isCompareEditorInput(part.getEditorInput()) && (extension = (ITextEditorExtension3)part.getAdapter(ITextEditorExtension3.class)) != null) {
                return extension.getInsertMode() == ITextEditorExtension3.SMART_INSERT;
            }
        }
        return false;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (!this.isSmartMode()) {
            return;
        }
        if (command.text != null) {
            String[] lineDelimiters;
            int index;
            if (command.length == 0 && (index = TextUtilities.endsWith((String[])(lineDelimiters = document.getLegalLineDelimiters()), (String)command.text)) > -1) {
                if (lineDelimiters[index].equals(command.text)) {
                    this.indentAfterNewLine(document, command);
                }
                return;
            }
            if (command.text.equals("/")) {
                this.indentAfterCommentEnd(document, command);
                return;
            }
        }
    }

    private static IMethod getInheritedMethod(IMethod method) throws JavaModelException {
        IType declaringType = method.getDeclaringType();
        MethodOverrideTester tester = SuperTypeHierarchyCache.getMethodOverrideTester(declaringType);
        return tester.findOverriddenMethod(method, true);
    }

    private static ICompilationUnit getCompilationUnit() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        WorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
        ICompilationUnit unit = manager.getWorkingCopy(editor.getEditorInput());
        if (unit == null) {
            return null;
        }
        return unit;
    }
}

